/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.tx.account;

import com.klaytn.caver.tx.account.AccountKey;
import com.klaytn.caver.tx.account.AccountKeyDecoder;
import com.klaytn.caver.utils.AccountKeyPublicUtils;
import com.klaytn.caver.utils.BytesUtils;
import java.math.BigInteger;
import java.util.Arrays;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

@Deprecated
public class AccountKeyPublic
implements AccountKey {
    private String x;
    private String y;

    public AccountKeyPublic() {
    }

    protected AccountKeyPublic(String x, String y) {
        this.x = x;
        this.y = y;
    }

    public static AccountKeyPublic create(BigInteger publicKey) {
        String hexStringPublicKey = Numeric.toHexStringNoPrefixZeroPadded((BigInteger)publicKey, (int)128);
        String publicKeyX = Numeric.prependHexPrefix((String)hexStringPublicKey.substring(0, 64));
        String publicKeyY = Numeric.prependHexPrefix((String)hexStringPublicKey.substring(64, 128));
        return new AccountKeyPublic(publicKeyX, publicKeyY);
    }

    public static AccountKeyPublic create(String publicKeyX, String publicKeyY) {
        return new AccountKeyPublic(Numeric.prependHexPrefix((String)publicKeyX), Numeric.prependHexPrefix((String)publicKeyY));
    }

    @Override
    public byte[] toRlp() {
        byte[] encodedTransaction = RlpEncoder.encode((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.toCompressedPublicKey())));
        byte[] type = new byte[]{this.getType().getValue()};
        return BytesUtils.concat(type, encodedTransaction);
    }

    public BigInteger getPublicKey() {
        return Numeric.toBigInt((String)(this.getX() + this.getY().substring(2)));
    }

    public String toCompressedPublicKey() {
        return AccountKeyPublicUtils.toCompressedPublicKey(this.getPublicKey());
    }

    public static AccountKeyPublic decodeFromRlp(byte[] rawTransaction) {
        byte[] transaction = AccountKeyDecoder.getRawTransactionNoType(rawTransaction);
        RlpList rlpList = RlpDecoder.decode((byte[])transaction);
        String compressedPublicKey = ((RlpString)rlpList.getValues().get(0)).asString();
        return AccountKeyPublicUtils.decompressKey(compressedPublicKey);
    }

    public static AccountKeyPublic decodeFromRlp(String hexString) {
        return AccountKeyPublic.decodeFromRlp(Numeric.hexStringToByteArray((String)hexString));
    }

    public String getX() {
        return Numeric.toHexStringWithPrefixZeroPadded((BigInteger)Numeric.toBigInt((String)this.x), (int)64);
    }

    public String getY() {
        return Numeric.toHexStringWithPrefixZeroPadded((BigInteger)Numeric.toBigInt((String)this.y), (int)64);
    }

    @Override
    public AccountKey.Type getType() {
        return AccountKey.Type.PUBLIC;
    }

    public String toString() {
        return "AccountKeyPublic x : " + this.getX() + " / y : " + this.getY();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountKeyPublic that = (AccountKeyPublic)o;
        return Arrays.equals(this.toRlp(), that.toRlp());
    }
}

