/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.transaction.type;

import com.klaytn.caver.rpc.Klay;
import com.klaytn.caver.transaction.AbstractTransaction;
import com.klaytn.caver.transaction.type.TransactionType;
import com.klaytn.caver.utils.Utils;
import com.klaytn.caver.wallet.keyring.SignatureData;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

public class LegacyTransaction
extends AbstractTransaction {
    String to = "0x";
    String input = "0x";
    String value;

    private LegacyTransaction(Builder builder) {
        super(builder);
        this.setTo(builder.to);
        this.setValue(builder.value);
        this.setInput(builder.input);
    }

    public LegacyTransaction(Klay klaytnCall, String from, String nonce, String gas, String gasPrice, String chainId, List<SignatureData> signatures, String to, String input, String value) {
        super(klaytnCall, TransactionType.TxTypeLegacyTransaction.toString(), from, nonce, gas, gasPrice, chainId, signatures);
        this.setTo(to);
        this.setValue(value);
        this.setInput(input);
    }

    public static LegacyTransaction decode(String rlpEncoded) {
        return LegacyTransaction.decode(Numeric.hexStringToByteArray((String)rlpEncoded));
    }

    public static LegacyTransaction decode(byte[] rlpEncoded) {
        try {
            RlpList rlpList = RlpDecoder.decode((byte[])rlpEncoded);
            List values = ((RlpList)rlpList.getValues().get(0)).getValues();
            String nonce = ((RlpString)values.get(0)).asString();
            String gasPrice = ((RlpString)values.get(1)).asString();
            String gas = ((RlpString)values.get(2)).asString();
            String to = ((RlpString)values.get(3)).asString();
            String value = ((RlpString)values.get(4)).asString();
            String input = ((RlpString)values.get(5)).asString();
            LegacyTransaction legacyTransaction = ((Builder)((Builder)((Builder)((Builder)new Builder().setInput(input).setValue(value).setNonce(nonce)).setGas(gas)).setGasPrice(gasPrice)).setNonce(nonce)).setTo(to).build();
            byte[] v = ((RlpString)values.get(6)).getBytes();
            byte[] r = ((RlpString)values.get(7)).getBytes();
            byte[] s = ((RlpString)values.get(8)).getBytes();
            SignatureData signatureData = new SignatureData(v, r, s);
            legacyTransaction.appendSignatures(signatureData);
            return legacyTransaction;
        }
        catch (Exception e) {
            throw new RuntimeException("There is an error while decoding process.");
        }
    }

    @Override
    public void appendSignatures(SignatureData signatureData) {
        if (this.getSignatures().size() != 0 && !Utils.isEmptySig(this.getSignatures().get(0))) {
            throw new RuntimeException("Signatures already defined." + TransactionType.TxTypeLegacyTransaction.toString() + " cannot include more than one signature.");
        }
        super.appendSignatures(signatureData);
    }

    @Override
    public void appendSignatures(List<SignatureData> signatureData) {
        if (this.getSignatures().size() != 0 && !Utils.isEmptySig(this.getSignatures())) {
            throw new RuntimeException("Signatures already defined." + TransactionType.TxTypeLegacyTransaction.toString() + " cannot include more than one signature.");
        }
        if (signatureData.size() != 1) {
            throw new RuntimeException("Signatures are too long " + TransactionType.TxTypeLegacyTransaction.toString() + " cannot include more than one signature.");
        }
        super.appendSignatures(signatureData);
    }

    @Override
    public String getRLPEncoding() {
        this.validateOptionalValues(false);
        ArrayList<RlpString> rlpTypeList = new ArrayList<RlpString>();
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getNonce())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGasPrice())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGas())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getTo())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getValue())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getInput())));
        SignatureData signatureData = this.getSignatures().get(0);
        rlpTypeList.addAll(signatureData.toRlpList().getValues());
        byte[] encoded = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        String encodedStr = Numeric.toHexString((byte[])encoded);
        return encodedStr;
    }

    @Override
    public String getCommonRLPEncodingForSignature() {
        return this.getRLPEncodingForSignature();
    }

    @Override
    public String getRLPEncodingForSignature() {
        this.validateOptionalValues(true);
        ArrayList<RlpString> rlpTypeList = new ArrayList<RlpString>();
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getNonce())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGasPrice())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGas())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getTo())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getValue())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getInput())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getChainId())));
        rlpTypeList.add(RlpString.create((long)0L));
        rlpTypeList.add(RlpString.create((long)0L));
        byte[] encoded = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        String encodedStr = Numeric.toHexString((byte[])encoded);
        return encodedStr;
    }

    @Override
    public boolean compareTxField(AbstractTransaction obj, boolean checkSig) {
        if (!super.compareTxField(obj, checkSig)) {
            return false;
        }
        if (!(obj instanceof LegacyTransaction)) {
            return false;
        }
        LegacyTransaction txObj = (LegacyTransaction)obj;
        if (!this.getTo().toLowerCase().equals(txObj.getTo().toLowerCase())) {
            return false;
        }
        if (!Numeric.toBigInt((String)this.getValue()).equals(Numeric.toBigInt((String)txObj.getValue()))) {
            return false;
        }
        return this.getInput().equals(txObj.getInput());
    }

    public String getTo() {
        return this.to;
    }

    public String getInput() {
        return this.input;
    }

    public String getValue() {
        return this.value;
    }

    public void setTo(String to) {
        if (to == null || to.isEmpty()) {
            to = "0x";
        }
        if (!to.equals("0x") && !Utils.isAddress(to)) {
            throw new IllegalArgumentException("Invalid address. : " + to);
        }
        this.to = to;
    }

    public void setInput(String input) {
        if (input == null) {
            throw new IllegalArgumentException("input is missing");
        }
        if (!Utils.isHex(input)) {
            throw new IllegalArgumentException("Invalid input : " + input);
        }
        this.input = input;
    }

    public void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is missing");
        }
        if (!Utils.isNumber(value)) {
            throw new IllegalArgumentException("Invalid value : " + value);
        }
        this.value = value;
    }

    public void setValue(BigInteger value) {
        this.setValue(Numeric.toHexStringWithPrefix((BigInteger)value));
    }

    public static class Builder
    extends AbstractTransaction.Builder<Builder> {
        private String to = "0x";
        private String value;
        private String input = "0x";

        public Builder() {
            super(TransactionType.TxTypeLegacyTransaction.toString());
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public Builder setValue(BigInteger value) {
            this.setValue(Numeric.toHexStringWithPrefix((BigInteger)value));
            return this;
        }

        public Builder setInput(String input) {
            this.input = input;
            return this;
        }

        public Builder setTo(String to) {
            this.to = to;
            return this;
        }

        public LegacyTransaction build() {
            return new LegacyTransaction(this);
        }
    }
}

