/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.transaction.type;

import com.klaytn.caver.rpc.Klay;
import com.klaytn.caver.transaction.AbstractFeeDelegatedTransaction;
import com.klaytn.caver.transaction.type.TransactionType;
import com.klaytn.caver.utils.BytesUtils;
import com.klaytn.caver.utils.Utils;
import com.klaytn.caver.wallet.keyring.SignatureData;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.web3j.crypto.Hash;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

public class FeeDelegatedChainDataAnchoring
extends AbstractFeeDelegatedTransaction {
    String input;

    public FeeDelegatedChainDataAnchoring(Builder builder) {
        super(builder);
        this.setInput(builder.input);
    }

    public FeeDelegatedChainDataAnchoring(Klay klaytnCall, String from, String nonce, String gas, String gasPrice, String chainId, List<SignatureData> signatures, String feePayer, List<SignatureData> feePayerSignatures, String input) {
        super(klaytnCall, TransactionType.TxTypeFeeDelegatedChainDataAnchoring.toString(), from, nonce, gas, gasPrice, chainId, signatures, feePayer, feePayerSignatures);
        this.setInput(input);
    }

    public static FeeDelegatedChainDataAnchoring decode(String rlpEncoded) {
        return FeeDelegatedChainDataAnchoring.decode(Numeric.hexStringToByteArray((String)rlpEncoded));
    }

    public static FeeDelegatedChainDataAnchoring decode(byte[] rlpEncoded) {
        if (rlpEncoded[0] != (byte)TransactionType.TxTypeFeeDelegatedChainDataAnchoring.getType()) {
            throw new IllegalArgumentException("Invalid RLP-encoded tag - " + TransactionType.TxTypeFeeDelegatedChainDataAnchoring.toString());
        }
        byte[] detachedType = Arrays.copyOfRange(rlpEncoded, 1, rlpEncoded.length);
        RlpList rlpList = RlpDecoder.decode((byte[])detachedType);
        List values = ((RlpList)rlpList.getValues().get(0)).getValues();
        BigInteger nonce = ((RlpString)values.get(0)).asPositiveBigInteger();
        BigInteger gasPrice = ((RlpString)values.get(1)).asPositiveBigInteger();
        BigInteger gas = ((RlpString)values.get(2)).asPositiveBigInteger();
        String from = ((RlpString)values.get(3)).asString();
        String input = ((RlpString)values.get(4)).asString();
        List senderSignatures = ((RlpList)values.get(5)).getValues();
        List<SignatureData> senderSignList = SignatureData.decodeSignatures(senderSignatures);
        String feePayer = ((RlpString)values.get(6)).asString();
        List feePayerSignatures = ((RlpList)values.get(7)).getValues();
        List<SignatureData> feePayerSignList = SignatureData.decodeSignatures(feePayerSignatures);
        FeeDelegatedChainDataAnchoring feeDelegatedChainDataAnchoring = ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().setNonce(nonce)).setGasPrice(gasPrice)).setGas(gas)).setFrom(from)).setInput(input).setSignatures(senderSignList)).setFeePayer(feePayer)).setFeePayerSignatures(feePayerSignList)).build();
        return feeDelegatedChainDataAnchoring;
    }

    @Override
    public String getRLPEncoding() {
        this.validateOptionalValues(false);
        ArrayList<RlpList> senderSignatureRLPList = new ArrayList<RlpList>();
        ArrayList<RlpList> feePayerSignatureRLPList = new ArrayList<RlpList>();
        for (SignatureData signatureData : this.getSignatures()) {
            senderSignatureRLPList.add(signatureData.toRlpList());
        }
        for (SignatureData signatureData : this.getFeePayerSignatures()) {
            feePayerSignatureRLPList.add(signatureData.toRlpList());
        }
        ArrayList<Object> rlpTypeList = new ArrayList<Object>();
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getNonce())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGasPrice())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGas())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getInput())));
        rlpTypeList.add(new RlpList(senderSignatureRLPList));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFeePayer())));
        rlpTypeList.add(new RlpList(feePayerSignatureRLPList));
        byte[] encodedTransaction = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        byte[] type = new byte[]{(byte)TransactionType.TxTypeFeeDelegatedChainDataAnchoring.getType()};
        byte[] rawTx = BytesUtils.concat(type, encodedTransaction);
        return Numeric.toHexString((byte[])rawTx);
    }

    @Override
    public String getCommonRLPEncodingForSignature() {
        this.validateOptionalValues(true);
        byte type = (byte)TransactionType.TxTypeFeeDelegatedChainDataAnchoring.getType();
        ArrayList<RlpString> rlpTypeList = new ArrayList<RlpString>();
        rlpTypeList.add(RlpString.create((byte)type));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getNonce())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGasPrice())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGas())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getInput())));
        byte[] encoded = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        String encodedStr = Numeric.toHexString((byte[])encoded);
        return encodedStr;
    }

    @Override
    public String getSenderTxHash() {
        this.validateOptionalValues(false);
        ArrayList<RlpList> senderSignatureRLPList = new ArrayList<RlpList>();
        for (SignatureData signatureData : this.getSignatures()) {
            senderSignatureRLPList.add(signatureData.toRlpList());
        }
        ArrayList<Object> rlpTypeList = new ArrayList<Object>();
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getNonce())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGasPrice())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getGas())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getInput())));
        rlpTypeList.add(new RlpList(senderSignatureRLPList));
        byte[] encodedTransaction = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        byte[] type = new byte[]{(byte)TransactionType.TxTypeFeeDelegatedChainDataAnchoring.getType()};
        byte[] rawTx = BytesUtils.concat(type, encodedTransaction);
        return Numeric.toHexString((byte[])Hash.sha3((byte[])rawTx));
    }

    @Override
    public boolean compareTxField(AbstractFeeDelegatedTransaction txObj, boolean checkSig) {
        if (!super.compareTxField(txObj, checkSig)) {
            return false;
        }
        if (!(txObj instanceof FeeDelegatedChainDataAnchoring)) {
            return false;
        }
        FeeDelegatedChainDataAnchoring feeDelegatedChainDataAnchoring = (FeeDelegatedChainDataAnchoring)txObj;
        return this.getInput().equals(feeDelegatedChainDataAnchoring.getInput());
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        if (input == null) {
            throw new IllegalArgumentException("input is missing.");
        }
        if (!Utils.isHex(input)) {
            throw new IllegalArgumentException("Invalid input : " + input);
        }
        this.input = Numeric.prependHexPrefix((String)input);
    }

    public static class Builder
    extends AbstractFeeDelegatedTransaction.Builder<Builder> {
        String input;

        public Builder() {
            super(TransactionType.TxTypeFeeDelegatedChainDataAnchoring.toString());
        }

        public Builder setInput(String input) {
            this.input = input;
            return this;
        }

        public FeeDelegatedChainDataAnchoring build() {
            return new FeeDelegatedChainDataAnchoring(this);
        }
    }
}

