/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.transaction;

import com.klaytn.caver.transaction.AbstractTransaction;
import com.klaytn.caver.transaction.type.AccountUpdate;
import com.klaytn.caver.transaction.type.Cancel;
import com.klaytn.caver.transaction.type.ChainDataAnchoring;
import com.klaytn.caver.transaction.type.FeeDelegatedAccountUpdate;
import com.klaytn.caver.transaction.type.FeeDelegatedAccountUpdateWithRatio;
import com.klaytn.caver.transaction.type.FeeDelegatedCancel;
import com.klaytn.caver.transaction.type.FeeDelegatedCancelWithRatio;
import com.klaytn.caver.transaction.type.FeeDelegatedChainDataAnchoring;
import com.klaytn.caver.transaction.type.FeeDelegatedChainDataAnchoringWithRatio;
import com.klaytn.caver.transaction.type.FeeDelegatedSmartContractDeploy;
import com.klaytn.caver.transaction.type.FeeDelegatedSmartContractDeployWithRatio;
import com.klaytn.caver.transaction.type.FeeDelegatedSmartContractExecution;
import com.klaytn.caver.transaction.type.FeeDelegatedSmartContractExecutionWithRatio;
import com.klaytn.caver.transaction.type.FeeDelegatedValueTransfer;
import com.klaytn.caver.transaction.type.FeeDelegatedValueTransferMemo;
import com.klaytn.caver.transaction.type.FeeDelegatedValueTransferMemoWithRatio;
import com.klaytn.caver.transaction.type.FeeDelegatedValueTransferWithRatio;
import com.klaytn.caver.transaction.type.LegacyTransaction;
import com.klaytn.caver.transaction.type.SmartContractDeploy;
import com.klaytn.caver.transaction.type.SmartContractExecution;
import com.klaytn.caver.transaction.type.TransactionType;
import com.klaytn.caver.transaction.type.ValueTransfer;
import com.klaytn.caver.transaction.type.ValueTransferMemo;
import org.web3j.utils.Numeric;

public class TransactionDecoder {
    public static AbstractTransaction decode(String rlpEncoded) {
        byte[] rlpBytes = Numeric.hexStringToByteArray((String)rlpEncoded);
        if (rlpBytes[0] == TransactionType.TxTypeValueTransfer.getType()) {
            return ValueTransfer.decode(rlpBytes);
        }
        if (rlpBytes[0] == TransactionType.TxTypeValueTransferMemo.getType()) {
            return ValueTransferMemo.decode(rlpBytes);
        }
        if (rlpBytes[0] == TransactionType.TxTypeSmartContractDeploy.getType()) {
            return SmartContractDeploy.decode(rlpBytes);
        }
        if (rlpBytes[0] == TransactionType.TxTypeSmartContractExecution.getType()) {
            return SmartContractExecution.decode(rlpBytes);
        }
        if (rlpBytes[0] == TransactionType.TxTypeAccountUpdate.getType()) {
            return AccountUpdate.decode(rlpBytes);
        }
        if (rlpBytes[0] == TransactionType.TxTypeCancel.getType()) {
            return Cancel.decode(rlpBytes);
        }
        if (rlpBytes[0] == TransactionType.TxTypeChainDataAnchoring.getType()) {
            return ChainDataAnchoring.decode(rlpBytes);
        }
        if (rlpBytes[0] == TransactionType.TxTypeFeeDelegatedValueTransfer.getType()) {
            return FeeDelegatedValueTransfer.decode(rlpBytes);
        }
        if (rlpBytes[0] == TransactionType.TxTypeFeeDelegatedValueTransferMemo.getType()) {
            return FeeDelegatedValueTransferMemo.decode(rlpBytes);
        }
        if (rlpBytes[0] == TransactionType.TxTypeFeeDelegatedSmartContractDeploy.getType()) {
            return FeeDelegatedSmartContractDeploy.decode(rlpBytes);
        }
        if (rlpBytes[0] == TransactionType.TxTypeFeeDelegatedSmartContractExecution.getType()) {
            return FeeDelegatedSmartContractExecution.decode(rlpBytes);
        }
        if (rlpBytes[0] == TransactionType.TxTypeFeeDelegatedAccountUpdate.getType()) {
            return FeeDelegatedAccountUpdate.decode(rlpBytes);
        }
        if (rlpBytes[0] == TransactionType.TxTypeFeeDelegatedCancel.getType()) {
            return FeeDelegatedCancel.decode(rlpBytes);
        }
        if (rlpBytes[0] == TransactionType.TxTypeFeeDelegatedChainDataAnchoring.getType()) {
            return FeeDelegatedChainDataAnchoring.decode(rlpBytes);
        }
        if (rlpBytes[0] == TransactionType.TxTypeFeeDelegatedCancelWithRatio.getType()) {
            return FeeDelegatedCancelWithRatio.decode(rlpBytes);
        }
        if (rlpBytes[0] == TransactionType.TxTypeFeeDelegatedChainDataAnchoringWithRatio.getType()) {
            return FeeDelegatedChainDataAnchoringWithRatio.decode(rlpBytes);
        }
        if (rlpBytes[0] == TransactionType.TxTypeFeeDelegatedAccountUpdateWithRatio.getType()) {
            return FeeDelegatedAccountUpdateWithRatio.decode(rlpBytes);
        }
        if (rlpBytes[0] == TransactionType.TxTypeFeeDelegatedValueTransferWithRatio.getType()) {
            return FeeDelegatedValueTransferWithRatio.decode(rlpBytes);
        }
        if (rlpBytes[0] == TransactionType.TxTypeFeeDelegatedSmartContractExecutionWithRatio.getType()) {
            return FeeDelegatedSmartContractExecutionWithRatio.decode(rlpBytes);
        }
        if (rlpBytes[0] == TransactionType.TxTypeFeeDelegatedValueTransferMemoWithRatio.getType()) {
            return FeeDelegatedValueTransferMemoWithRatio.decode(rlpBytes);
        }
        if (rlpBytes[0] == TransactionType.TxTypeFeeDelegatedSmartContractDeployWithRatio.getType()) {
            return FeeDelegatedSmartContractDeployWithRatio.decode(rlpBytes);
        }
        return LegacyTransaction.decode(rlpBytes);
    }
}

