/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.transaction;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.klaytn.caver.account.AccountKeyRoleBased;
import com.klaytn.caver.methods.response.Quantity;
import com.klaytn.caver.rpc.Klay;
import com.klaytn.caver.transaction.TransactionDecoder;
import com.klaytn.caver.transaction.TransactionHasher;
import com.klaytn.caver.transaction.type.LegacyTransaction;
import com.klaytn.caver.transaction.type.TransactionType;
import com.klaytn.caver.utils.Utils;
import com.klaytn.caver.wallet.keyring.AbstractKeyring;
import com.klaytn.caver.wallet.keyring.KeyringFactory;
import com.klaytn.caver.wallet.keyring.SignatureData;
import com.klaytn.caver.wallet.keyring.SingleKeyring;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.web3j.crypto.Hash;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public abstract class AbstractTransaction {
    @JsonIgnore
    private Klay klaytnCall = null;
    @JsonIgnore
    private String type;
    private String from;
    private String nonce = "0x";
    private String gas;
    private String gasPrice = "0x";
    private String chainId = "0x";
    private List<SignatureData> signatures = new ArrayList<SignatureData>();

    public AbstractTransaction(Builder builder) {
        this(builder.klaytnCall, builder.type, builder.from, builder.nonce, builder.gas, builder.gasPrice, builder.chainId, builder.signatures);
    }

    public AbstractTransaction(Klay klaytnCall, String type, String from, String nonce, String gas, String gasPrice, String chainId, List<SignatureData> signatures) {
        this.setKlaytnCall(klaytnCall);
        this.setType(type);
        this.setFrom(from);
        this.setNonce(nonce);
        this.setGasPrice(gasPrice);
        this.setGas(gas);
        this.setChainId(chainId);
        this.setSignatures(signatures);
    }

    @JsonIgnore
    public abstract String getRLPEncoding();

    @JsonIgnore
    public abstract String getCommonRLPEncodingForSignature();

    public AbstractTransaction sign(String keyString) throws IOException {
        SingleKeyring keyring = KeyringFactory.createFromPrivateKey(keyString);
        return this.sign((AbstractKeyring)keyring, TransactionHasher::getHashForSignature);
    }

    public AbstractTransaction sign(String keyString, Function<AbstractTransaction, String> signer) throws IOException {
        SingleKeyring keyring = KeyringFactory.createFromPrivateKey(keyString);
        return this.sign((AbstractKeyring)keyring, signer);
    }

    public AbstractTransaction sign(AbstractKeyring keyring) throws IOException {
        return this.sign(keyring, TransactionHasher::getHashForSignature);
    }

    public AbstractTransaction sign(AbstractKeyring keyring, Function<AbstractTransaction, String> signer) throws IOException {
        if (this.getType().equals(TransactionType.TxTypeLegacyTransaction.toString()) && keyring.isDecoupled()) {
            throw new IllegalArgumentException("A legacy transaction cannot be signed with a decoupled keyring.");
        }
        if (this.from.equals("0x") || this.from.equals("0x0000000000000000000000000000000000000000")) {
            this.from = keyring.getAddress();
        }
        if (!this.from.toLowerCase().equals(keyring.getAddress().toLowerCase())) {
            throw new IllegalArgumentException("The from address of the transaction is different with the address of the keyring to use");
        }
        this.fillTransaction();
        int role = this.type.contains("AccountUpdate") ? AccountKeyRoleBased.RoleGroup.ACCOUNT_UPDATE.getIndex() : AccountKeyRoleBased.RoleGroup.TRANSACTION.getIndex();
        String hash = signer.apply(this);
        List<SignatureData> sigList = keyring.sign(hash, Numeric.toBigInt((String)this.chainId).intValue(), role);
        this.appendSignatures(sigList);
        return this;
    }

    public AbstractTransaction sign(AbstractKeyring keyring, int index) throws IOException {
        return this.sign(keyring, index, TransactionHasher::getHashForSignature);
    }

    public AbstractTransaction sign(AbstractKeyring keyring, int index, Function<AbstractTransaction, String> signer) throws IOException {
        if (this.getType().equals(TransactionType.TxTypeLegacyTransaction.toString()) && keyring.isDecoupled()) {
            throw new IllegalArgumentException("A legacy transaction cannot be signed with a decoupled keyring.");
        }
        if (this.from.equals("0x") || this.from.equals("0x0000000000000000000000000000000000000000")) {
            this.from = keyring.getAddress();
        }
        if (!this.from.toLowerCase().equals(keyring.getAddress().toLowerCase())) {
            throw new IllegalArgumentException("The from address of the transaction is different with the address of the keyring to use");
        }
        this.fillTransaction();
        int role = this.type.contains("AccountUpdate") ? AccountKeyRoleBased.RoleGroup.ACCOUNT_UPDATE.getIndex() : AccountKeyRoleBased.RoleGroup.TRANSACTION.getIndex();
        String hash = signer.apply(this);
        SignatureData sig = keyring.sign(hash, Numeric.toBigInt((String)this.chainId).intValue(), role, index);
        this.appendSignatures(sig);
        return this;
    }

    public void appendSignatures(SignatureData signatureData) {
        ArrayList<SignatureData> signList = new ArrayList<SignatureData>();
        signList.add(signatureData);
        this.appendSignatures(signList);
    }

    public void appendSignatures(List<SignatureData> signatureData) {
        this.signatures.addAll(signatureData);
        this.signatures = this.refineSignature(this.getSignatures());
    }

    public String combineSignedRawTransactions(List<String> rlpEncoded) {
        boolean fillVariable = false;
        if (Utils.isEmptySig(this.getSignatures())) {
            fillVariable = true;
        }
        for (String encodedStr : rlpEncoded) {
            AbstractTransaction txObj = TransactionDecoder.decode(encodedStr);
            if (fillVariable) {
                if (this.getNonce().equals("0x")) {
                    this.setNonce(txObj.getNonce());
                }
                if (this.getGasPrice().equals("0x")) {
                    this.setGasPrice(txObj.getGasPrice());
                }
                fillVariable = false;
            }
            if (!this.compareTxField(txObj, false)) {
                throw new RuntimeException("Transactions containing different information cannot be combined.");
            }
            this.appendSignatures(txObj.getSignatures());
        }
        return this.getRLPEncoding();
    }

    @JsonIgnore
    public String getRawTransaction() {
        return this.getRLPEncoding();
    }

    @JsonIgnore
    public String getTransactionHash() {
        return Hash.sha3((String)this.getRLPEncoding());
    }

    @JsonIgnore
    public String getSenderTxHash() {
        return this.getTransactionHash();
    }

    @JsonIgnore
    public String getRLPEncodingForSignature() {
        byte[] txRLP = Numeric.hexStringToByteArray((String)this.getCommonRLPEncodingForSignature());
        ArrayList<RlpString> rlpTypeList = new ArrayList<RlpString>();
        rlpTypeList.add(RlpString.create((byte[])txRLP));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getChainId())));
        rlpTypeList.add(RlpString.create((long)0L));
        rlpTypeList.add(RlpString.create((long)0L));
        byte[] encoded = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        return Numeric.toHexString((byte[])encoded);
    }

    public void fillTransaction() throws IOException {
        if (this.klaytnCall != null) {
            if (this.nonce.equals("0x")) {
                this.nonce = (String)((Quantity)this.klaytnCall.getTransactionCount(this.from, (DefaultBlockParameter)DefaultBlockParameterName.PENDING).send()).getResult();
            }
            if (this.chainId.equals("0x")) {
                this.chainId = (String)((Quantity)this.klaytnCall.getChainID().send()).getResult();
            }
            if (this.gasPrice.equals("0x")) {
                this.gasPrice = (String)((Quantity)this.klaytnCall.getGasPrice().send()).getResult();
            }
        }
        if (this.nonce.equals("0x") || this.chainId.equals("0x") || this.gasPrice.equals("0x")) {
            throw new RuntimeException("Cannot fill transaction data.(nonce, chainId, gasPrice). `klaytnCall` must be set in Transaction instance to automatically fill the nonce, chainId or gasPrice. Please call the `setKlaytnCall` to set `klaytnCall` in the Transaction instance.");
        }
    }

    public boolean compareTxField(AbstractTransaction txObj, boolean checkSig) {
        if (!this.getType().equals(txObj.getType())) {
            return false;
        }
        if (!this.getFrom().toLowerCase().equals(txObj.getFrom().toLowerCase())) {
            return false;
        }
        if (!Numeric.toBigInt((String)this.getNonce()).equals(Numeric.toBigInt((String)txObj.getNonce()))) {
            return false;
        }
        if (!Numeric.toBigInt((String)this.getGas()).equals(Numeric.toBigInt((String)txObj.getGas()))) {
            return false;
        }
        if (!Numeric.toBigInt((String)this.getGasPrice()).equals(Numeric.toBigInt((String)txObj.getGasPrice()))) {
            return false;
        }
        if (checkSig) {
            List<SignatureData> dataList = this.getSignatures();
            if (dataList.size() != txObj.getSignatures().size()) {
                return false;
            }
            for (int i = 0; i < dataList.size(); ++i) {
                if (dataList.get(i).equals(txObj.getSignatures().get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public void validateOptionalValues(boolean checkChainID) {
        if (this.getNonce() == null || this.getNonce().isEmpty() || this.getNonce().equals("0x")) {
            throw new RuntimeException("nonce is undefined. Define nonce in transaction or use 'transaction.fillTransaction' to fill values.");
        }
        if (this.getGasPrice() == null || this.getGasPrice().isEmpty() || this.getGasPrice().equals("0x")) {
            throw new RuntimeException("gasPrice is undefined. Define gasPrice in transaction or use 'transaction.fillTransaction' to fill values.");
        }
        if (checkChainID && (this.getChainId() == null || this.getChainId().isEmpty() || this.getChainId().equals("0x"))) {
            throw new RuntimeException("chainId is undefined. Define chainId in transaction or use 'transaction.fillTransaction' to fill values.");
        }
    }

    public List<SignatureData> refineSignature(List<SignatureData> signatureDataList) {
        boolean isLegacy = this.getType().equals(TransactionType.TxTypeLegacyTransaction.toString());
        SignatureData emptySig = SignatureData.getEmptySignature();
        ArrayList<SignatureData> refinedList = new ArrayList<SignatureData>();
        for (SignatureData signData : signatureDataList) {
            if (Utils.isEmptySig(signData) || refinedList.contains(signData)) continue;
            refinedList.add(signData);
        }
        if (refinedList.size() == 0) {
            refinedList.add(emptySig);
        }
        if (isLegacy && refinedList.size() > 1) {
            throw new RuntimeException("LegacyTransaction cannot have multiple signature.");
        }
        return refinedList;
    }

    public Klay getKlaytnCall() {
        return this.klaytnCall;
    }

    public void setKlaytnCall(Klay klaytnCall) {
        this.klaytnCall = klaytnCall;
    }

    public String getType() {
        return this.type;
    }

    public String getFrom() {
        return this.from;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getGas() {
        return this.gas;
    }

    public String getGasPrice() {
        return this.gasPrice;
    }

    @JsonIgnore
    public String getChainId() {
        return this.chainId;
    }

    public List<SignatureData> getSignatures() {
        return this.signatures;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setFrom(String from) {
        if (this instanceof LegacyTransaction) {
            if (from == null || from.isEmpty() || from.equals("0x") || from.equals("0x0000000000000000000000000000000000000000")) {
                from = "0x0000000000000000000000000000000000000000";
            }
        } else {
            if (from == null) {
                throw new IllegalArgumentException("from is missing.");
            }
            if (!Utils.isAddress(from)) {
                throw new IllegalArgumentException("Invalid address. : " + from);
            }
        }
        this.from = from;
    }

    public void setGas(String gas) {
        if (gas == null || gas.isEmpty() || gas.equals("0x")) {
            throw new IllegalArgumentException("gas is missing.");
        }
        if (!Utils.isNumber(gas)) {
            throw new IllegalArgumentException("Invalid gas. : " + gas);
        }
        this.gas = gas;
    }

    public void setGas(BigInteger gas) {
        this.setGas(Numeric.toHexStringWithPrefix((BigInteger)gas));
    }

    public void setNonce(String nonce) {
        if (nonce == null || nonce.isEmpty() || nonce.equals("0x")) {
            nonce = "0x";
        }
        if (!nonce.equals("0x") && !Utils.isNumber(nonce)) {
            throw new IllegalArgumentException("Invalid nonce. : " + nonce);
        }
        this.nonce = nonce;
    }

    public void setNonce(BigInteger nonce) {
        this.setNonce(Numeric.toHexStringWithPrefix((BigInteger)nonce));
    }

    public void setGasPrice(String gasPrice) {
        if (gasPrice == null || gasPrice.isEmpty() || gasPrice.equals("0x")) {
            gasPrice = "0x";
        }
        if (!gasPrice.equals("0x") && !Utils.isNumber(gasPrice)) {
            throw new IllegalArgumentException("Invalid gasPrice. : " + gasPrice);
        }
        this.gasPrice = gasPrice;
    }

    public void setGasPrice(BigInteger gasPrice) {
        this.setGasPrice(Numeric.toHexStringWithPrefix((BigInteger)gasPrice));
    }

    public void setChainId(String chainId) {
        if (chainId == null || chainId.isEmpty() || chainId.equals("0x")) {
            chainId = "0x";
        }
        if (!chainId.equals("0x") && !Utils.isNumber(chainId)) {
            throw new IllegalArgumentException("Invalid chainId. : " + chainId);
        }
        this.chainId = chainId;
    }

    public void setChainId(BigInteger chainId) {
        this.setChainId(Numeric.toHexStringWithPrefix((BigInteger)chainId));
    }

    public void setSignatures(List<SignatureData> signatures) {
        if (signatures == null || signatures.size() == 0) {
            signatures = Arrays.asList(SignatureData.getEmptySignature());
        }
        this.appendSignatures(signatures);
    }

    @JsonProperty(value="typeInt")
    public int getKeyType() {
        return TransactionType.valueOf(this.getType()).getType();
    }

    public static class Builder<B extends Builder> {
        private String type;
        private String gas;
        private String from;
        private String nonce = "0x";
        private String gasPrice = "0x";
        private String chainId = "0x";
        private Klay klaytnCall = null;
        private List<SignatureData> signatures = new ArrayList<SignatureData>();

        public Builder(String type) {
            this.type = type;
        }

        public B setFrom(String from) {
            this.from = from;
            return (B)this;
        }

        public B setNonce(String nonce) {
            this.nonce = nonce;
            return (B)this;
        }

        public B setNonce(BigInteger nonce) {
            this.setNonce(Numeric.toHexStringWithPrefix((BigInteger)nonce));
            return (B)this;
        }

        public B setGas(String gas) {
            this.gas = gas;
            return (B)this;
        }

        public B setGas(BigInteger gas) {
            this.setGas(Numeric.toHexStringWithPrefix((BigInteger)gas));
            return (B)this;
        }

        public B setGasPrice(String gasPrice) {
            this.gasPrice = gasPrice;
            return (B)this;
        }

        public B setGasPrice(BigInteger gasPrice) {
            this.setGasPrice(Numeric.toHexStringWithPrefix((BigInteger)gasPrice));
            return (B)this;
        }

        public B setChainId(String chainId) {
            this.chainId = chainId;
            return (B)this;
        }

        public B setChainId(BigInteger chainId) {
            this.setChainId(Numeric.toHexStringWithPrefix((BigInteger)chainId));
            return (B)this;
        }

        public B setKlaytnCall(Klay klaytnCall) {
            this.klaytnCall = klaytnCall;
            return (B)this;
        }

        public B setSignatures(List<SignatureData> signatures) {
            this.signatures.addAll(signatures);
            return (B)this;
        }

        public B setSignatures(SignatureData sign) {
            if (sign == null) {
                sign = SignatureData.getEmptySignature();
            }
            this.signatures.add(sign);
            return (B)this;
        }
    }
}

