/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.transaction;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.klaytn.caver.account.AccountKeyRoleBased;
import com.klaytn.caver.rpc.Klay;
import com.klaytn.caver.transaction.AbstractTransaction;
import com.klaytn.caver.transaction.TransactionDecoder;
import com.klaytn.caver.transaction.TransactionHasher;
import com.klaytn.caver.utils.Utils;
import com.klaytn.caver.wallet.keyring.AbstractKeyring;
import com.klaytn.caver.wallet.keyring.KeyringFactory;
import com.klaytn.caver.wallet.keyring.SignatureData;
import com.klaytn.caver.wallet.keyring.SingleKeyring;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

public abstract class AbstractFeeDelegatedTransaction
extends AbstractTransaction {
    String feePayer;
    List<SignatureData> feePayerSignatures = new ArrayList<SignatureData>();

    public AbstractFeeDelegatedTransaction(Builder builder) {
        super(builder);
        this.setFeePayer(builder.feePayer);
        this.setFeePayerSignatures(builder.feePayerSignatures);
    }

    public AbstractFeeDelegatedTransaction(Klay klaytnCall, String type, String from, String nonce, String gas, String gasPrice, String chainId, List<SignatureData> signatures, String feePayer, List<SignatureData> feePayerSignatures) {
        super(klaytnCall, type, from, nonce, gas, gasPrice, chainId, signatures);
        this.setFeePayer(feePayer);
        this.setFeePayerSignatures(feePayerSignatures);
    }

    public AbstractFeeDelegatedTransaction signAsFeePayer(String keyString) throws IOException {
        SingleKeyring keyring = KeyringFactory.createFromPrivateKey(keyString);
        return this.signAsFeePayer((AbstractKeyring)keyring, TransactionHasher::getHashForFeePayerSignature);
    }

    public AbstractFeeDelegatedTransaction signAsFeePayer(String keyString, Function<AbstractFeeDelegatedTransaction, String> hasher) throws IOException {
        SingleKeyring keyring = KeyringFactory.createFromPrivateKey(keyString);
        return this.signAsFeePayer((AbstractKeyring)keyring, hasher);
    }

    public AbstractFeeDelegatedTransaction signAsFeePayer(AbstractKeyring keyring) throws IOException {
        return this.signAsFeePayer(keyring, TransactionHasher::getHashForFeePayerSignature);
    }

    public AbstractFeeDelegatedTransaction signAsFeePayer(AbstractKeyring keyring, int index) throws IOException {
        return this.signAsFeePayer(keyring, index, TransactionHasher::getHashForFeePayerSignature);
    }

    public AbstractFeeDelegatedTransaction signAsFeePayer(AbstractKeyring keyring, Function<AbstractFeeDelegatedTransaction, String> hasher) throws IOException {
        if (this.getFeePayer().equals("0x") || this.getFeePayer().equals("0x0000000000000000000000000000000000000000")) {
            this.setFeePayer(keyring.getAddress());
        }
        if (!this.getFeePayer().toLowerCase().equals(keyring.getAddress().toLowerCase())) {
            throw new IllegalArgumentException("The feePayer address of the transaction is different with the address of the keyring to use.");
        }
        this.fillTransaction();
        int role = AccountKeyRoleBased.RoleGroup.FEE_PAYER.getIndex();
        String hash = hasher.apply(this);
        List<SignatureData> sigList = keyring.sign(hash, Numeric.toBigInt((String)this.getChainId()).intValue(), role);
        this.appendFeePayerSignatures(sigList);
        return this;
    }

    public AbstractFeeDelegatedTransaction signAsFeePayer(AbstractKeyring keyring, int index, Function<AbstractFeeDelegatedTransaction, String> hasher) throws IOException {
        if (this.getFeePayer().equals("0x") || this.getFeePayer().equals("0x0000000000000000000000000000000000000000")) {
            this.setFeePayer(keyring.getAddress());
        }
        if (!this.getFeePayer().toLowerCase().equals(keyring.getAddress().toLowerCase())) {
            throw new IllegalArgumentException("The feePayer address of the transaction is different with the address of the keyring to use.");
        }
        this.fillTransaction();
        int role = AccountKeyRoleBased.RoleGroup.FEE_PAYER.getIndex();
        String hash = hasher.apply(this);
        SignatureData sigList = keyring.sign(hash, Numeric.toBigInt((String)this.getChainId()).intValue(), role, index);
        this.appendFeePayerSignatures(sigList);
        return this;
    }

    public void appendFeePayerSignatures(SignatureData signatureData) {
        ArrayList<SignatureData> feePayerSignatureList = new ArrayList<SignatureData>();
        feePayerSignatureList.add(signatureData);
        this.appendFeePayerSignatures(feePayerSignatureList);
    }

    public void appendFeePayerSignatures(List<SignatureData> signatureData) {
        this.setFeePayerSignatures(signatureData);
    }

    @Override
    public String combineSignedRawTransactions(List<String> rlpEncoded) {
        boolean fillVariable = false;
        if (Utils.isEmptySig(this.getFeePayerSignatures()) || Utils.isEmptySig(this.getSignatures())) {
            fillVariable = true;
        }
        for (String encodedStr : rlpEncoded) {
            AbstractFeeDelegatedTransaction txObj = (AbstractFeeDelegatedTransaction)TransactionDecoder.decode(encodedStr);
            if (fillVariable) {
                if (this.getNonce().equals("0x")) {
                    this.setNonce(txObj.getNonce());
                }
                if (this.getGasPrice().equals("0x")) {
                    this.setGasPrice(txObj.getGasPrice());
                }
                if ((this.getFeePayer().equals("0x") || this.getFeePayer().equals("0x0000000000000000000000000000000000000000")) && !txObj.getFeePayer().equals("0x") && !txObj.getFeePayer().equals("0x0000000000000000000000000000000000000000")) {
                    this.setFeePayer(txObj.getFeePayer());
                    fillVariable = false;
                }
            }
            if (!this.compareTxField(txObj, false)) {
                throw new RuntimeException("Transactions containing different information cannot be combined.");
            }
            this.appendSignatures(txObj.getSignatures());
            this.appendFeePayerSignatures(txObj.getFeePayerSignatures());
        }
        return this.getRLPEncoding();
    }

    @JsonIgnore
    public String getRLPEncodingForFeePayerSignature() {
        byte[] txRLP = Numeric.hexStringToByteArray((String)this.getCommonRLPEncodingForSignature());
        ArrayList<RlpString> rlpTypeList = new ArrayList<RlpString>();
        rlpTypeList.add(RlpString.create((byte[])txRLP));
        rlpTypeList.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFeePayer())));
        rlpTypeList.add(RlpString.create((BigInteger)Numeric.toBigInt((String)this.getChainId())));
        rlpTypeList.add(RlpString.create((long)0L));
        rlpTypeList.add(RlpString.create((long)0L));
        byte[] encoded = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        return Numeric.toHexString((byte[])encoded);
    }

    public boolean compareTxField(AbstractFeeDelegatedTransaction txObj, boolean checkSig) {
        if (!super.compareTxField(txObj, checkSig)) {
            return false;
        }
        if (!this.getFeePayer().toLowerCase().equals(txObj.getFeePayer().toLowerCase())) {
            return false;
        }
        if (checkSig) {
            List<SignatureData> dataList = this.getFeePayerSignatures();
            if (dataList.size() != txObj.getFeePayerSignatures().size()) {
                return false;
            }
            for (int i = 0; i < dataList.size(); ++i) {
                if (dataList.get(i).equals(txObj.getFeePayerSignatures().get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public String getFeePayer() {
        return this.feePayer;
    }

    public void setFeePayer(String feePayer) {
        if (feePayer == null || feePayer.equals("0x")) {
            feePayer = "0x0000000000000000000000000000000000000000";
        }
        if (!Utils.isAddress(feePayer)) {
            throw new IllegalArgumentException("Invalid address. : " + feePayer);
        }
        this.feePayer = feePayer;
    }

    @JsonIgnore
    public List<SignatureData> getFeePayerSignatures() {
        return this.feePayerSignatures;
    }

    public void setFeePayerSignatures(List<SignatureData> feePayerSignatures) {
        if (feePayerSignatures == null || feePayerSignatures.size() == 0) {
            feePayerSignatures = Arrays.asList(SignatureData.getEmptySignature());
        }
        if (!Utils.isEmptySig(feePayerSignatures) && (this.feePayer.equals("0x") || this.feePayer.equals("0x0000000000000000000000000000000000000000"))) {
            throw new IllegalArgumentException("feePayer is missing: feePayer must be defined with feePayerSignatures.");
        }
        this.feePayerSignatures.addAll(feePayerSignatures);
        this.feePayerSignatures = this.refineSignature(this.getFeePayerSignatures());
    }

    public static class Builder<B extends Builder>
    extends AbstractTransaction.Builder<B> {
        String feePayer;
        private List<SignatureData> feePayerSignatures = new ArrayList<SignatureData>();

        public Builder(String type) {
            super(type);
        }

        public B setFeePayer(String feePayer) {
            this.feePayer = feePayer;
            return (B)this;
        }

        public B setFeePayerSignatures(List<SignatureData> feePayerSignatures) {
            this.feePayerSignatures = feePayerSignatures;
            return (B)this;
        }

        public B setFeePayerSignatures(SignatureData data) {
            if (data == null) {
                data = SignatureData.getEmptySignature();
            }
            this.feePayerSignatures.add(data);
            return (B)this;
        }
    }
}

