/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.rpc;

import com.klaytn.caver.account.IAccountKey;
import com.klaytn.caver.methods.request.CallObject;
import com.klaytn.caver.methods.request.KlayFilter;
import com.klaytn.caver.methods.request.KlayLogFilter;
import com.klaytn.caver.methods.response.Account;
import com.klaytn.caver.methods.response.AccountKey;
import com.klaytn.caver.methods.response.Addresses;
import com.klaytn.caver.methods.response.Block;
import com.klaytn.caver.methods.response.BlockTransactionReceipts;
import com.klaytn.caver.methods.response.BlockWithConsensusInfo;
import com.klaytn.caver.methods.response.Boolean;
import com.klaytn.caver.methods.response.Bytes;
import com.klaytn.caver.methods.response.Bytes20;
import com.klaytn.caver.methods.response.Bytes32;
import com.klaytn.caver.methods.response.DecodeAnchoringTransaction;
import com.klaytn.caver.methods.response.KlayLogs;
import com.klaytn.caver.methods.response.KlaySyncing;
import com.klaytn.caver.methods.response.Quantity;
import com.klaytn.caver.methods.response.SignTransaction;
import com.klaytn.caver.methods.response.Transaction;
import com.klaytn.caver.methods.response.TransactionReceipt;
import com.klaytn.caver.transaction.AbstractFeeDelegatedTransaction;
import com.klaytn.caver.transaction.AbstractTransaction;
import com.klaytn.caver.utils.Utils;
import java.util.Arrays;
import java.util.Collections;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.DefaultBlockParameterNumber;
import org.web3j.protocol.core.Request;

public class Klay {
    protected final Web3jService web3jService;

    public Klay(Web3jService web3jService) {
        this.web3jService = web3jService;
    }

    public Request<?, Boolean> accountCreated(String address) {
        return this.accountCreated(address, (DefaultBlockParameter)DefaultBlockParameterName.LATEST);
    }

    public Request<?, Boolean> accountCreated(String address, long blockNumber) {
        DefaultBlockParameterNumber blockParameterNumber = new DefaultBlockParameterNumber(blockNumber);
        return this.accountCreated(address, (DefaultBlockParameter)blockParameterNumber);
    }

    public Request<?, Boolean> accountCreated(String address, DefaultBlockParameter blockTag) {
        return new Request("klay_accountCreated", Arrays.asList(address, blockTag), this.web3jService, Boolean.class);
    }

    public Request<?, Addresses> getAccounts() {
        return new Request("klay_accounts", Collections.emptyList(), this.web3jService, Addresses.class);
    }

    public Request<?, Bytes> encodeAccountKey(IAccountKey accountKey) {
        return new Request("klay_encodeAccountKey", Arrays.asList(accountKey), this.web3jService, Bytes.class);
    }

    public Request<?, AccountKey> decodeAccountKey(String encodedAccountKey) {
        return new Request("klay_decodeAccountKey", Arrays.asList(encodedAccountKey), this.web3jService, AccountKey.class);
    }

    public Request<?, Account> getAccount(String address) {
        return this.getAccount(address, (DefaultBlockParameter)DefaultBlockParameterName.LATEST);
    }

    public Request<?, Account> getAccount(String address, long blockNumber) {
        DefaultBlockParameterNumber blockParameterNumber = new DefaultBlockParameterNumber(blockNumber);
        return this.getAccount(address, (DefaultBlockParameter)blockParameterNumber);
    }

    public Request<?, Account> getAccount(String address, DefaultBlockParameter blockTag) {
        return new Request("klay_getAccount", Arrays.asList(address, blockTag), this.web3jService, Account.class);
    }

    public Request<?, AccountKey> getAccountKey(String address) {
        return this.getAccountKey(address, (DefaultBlockParameter)DefaultBlockParameterName.LATEST);
    }

    public Request<?, AccountKey> getAccountKey(String address, long blockNumber) {
        DefaultBlockParameterNumber blockParameterNumber = new DefaultBlockParameterNumber(blockNumber);
        return this.getAccountKey(address, (DefaultBlockParameter)blockParameterNumber);
    }

    public Request<?, AccountKey> getAccountKey(String address, DefaultBlockParameter blockTag) {
        return new Request("klay_getAccountKey", Arrays.asList(address, blockTag.getValue()), this.web3jService, AccountKey.class);
    }

    public Request<?, Quantity> getBalance(String address) {
        return this.getBalance(address, (DefaultBlockParameter)DefaultBlockParameterName.LATEST);
    }

    public Request<?, Quantity> getBalance(String address, long blockNumber) {
        DefaultBlockParameterNumber blockParameterNumber = new DefaultBlockParameterNumber(blockNumber);
        return this.getBalance(address, (DefaultBlockParameter)blockParameterNumber);
    }

    public Request<?, Quantity> getBalance(String address, DefaultBlockParameter blockTag) {
        return new Request("klay_getBalance", Arrays.asList(address, blockTag), this.web3jService, Quantity.class);
    }

    public Request<?, Bytes> getCode(String address) {
        return this.getCode(address, (DefaultBlockParameter)DefaultBlockParameterName.LATEST);
    }

    public Request<?, Bytes> getCode(String address, long blockNumber) {
        DefaultBlockParameterNumber blockParameterNumber = new DefaultBlockParameterNumber(blockNumber);
        return this.getCode(address, (DefaultBlockParameter)blockParameterNumber);
    }

    public Request<?, Bytes> getCode(String address, DefaultBlockParameter blockTag) {
        return new Request("klay_getCode", Arrays.asList(address, blockTag.getValue()), this.web3jService, Bytes.class);
    }

    public Request<?, Quantity> getTransactionCount(String address) {
        return this.getTransactionCount(address, (DefaultBlockParameter)DefaultBlockParameterName.LATEST);
    }

    public Request<?, Quantity> getTransactionCount(String address, long blockNumber) {
        DefaultBlockParameterNumber blockParameterNumber = new DefaultBlockParameterNumber(blockNumber);
        return this.getTransactionCount(address, (DefaultBlockParameter)blockParameterNumber);
    }

    public Request<?, Quantity> getTransactionCount(String address, DefaultBlockParameter blockTag) {
        return new Request("klay_getTransactionCount", Arrays.asList(address, blockTag.getValue()), this.web3jService, Quantity.class);
    }

    public Request<?, Boolean> isContractAccount(String address) {
        return this.isContractAccount(address, (DefaultBlockParameter)DefaultBlockParameterName.LATEST);
    }

    public Request<?, Boolean> isContractAccount(String address, long blockNumber) {
        DefaultBlockParameterNumber blockParameterNumber = new DefaultBlockParameterNumber(blockNumber);
        return this.isContractAccount(address, (DefaultBlockParameter)blockParameterNumber);
    }

    public Request<?, Boolean> isContractAccount(String address, DefaultBlockParameter blockTag) {
        return new Request("klay_isContractAccount", Arrays.asList(address, blockTag.getValue()), this.web3jService, Boolean.class);
    }

    public Request<?, Bytes> sign(String address, String message) {
        return new Request("klay_sign", Arrays.asList(address, message), this.web3jService, Bytes.class);
    }

    public Request<?, Quantity> getBlockNumber() {
        return new Request("klay_blockNumber", Collections.emptyList(), this.web3jService, Quantity.class);
    }

    public Request<?, Block> getBlockByNumber(long blockNumber) {
        return this.getBlockByNumber(blockNumber, true);
    }

    public Request<?, Block> getBlockByNumber(long blockNumber, boolean isFullTransaction) {
        DefaultBlockParameterNumber blockParameterNumber = new DefaultBlockParameterNumber(blockNumber);
        return this.getBlockByNumber((DefaultBlockParameter)blockParameterNumber, isFullTransaction);
    }

    public Request<?, Block> getBlockByNumber(DefaultBlockParameter blockTag) {
        return this.getBlockByNumber(blockTag, true);
    }

    public Request<?, Block> getBlockByNumber(DefaultBlockParameter defaultBlockParameter, boolean isFullTransaction) {
        return new Request("klay_getBlockByNumber", Arrays.asList(defaultBlockParameter, isFullTransaction), this.web3jService, Block.class);
    }

    public Request<?, Block> getBlockByHash(String blockHash) {
        return this.getBlockByHash(blockHash, true);
    }

    public Request<?, Block> getBlockByHash(String blockHash, boolean isFullTransaction) {
        return new Request("klay_getBlockByHash", Arrays.asList(blockHash, isFullTransaction), this.web3jService, Block.class);
    }

    public Request<?, BlockTransactionReceipts> getBlockReceipts(String blockHash) {
        return new Request("klay_getBlockReceipts", Arrays.asList(blockHash), this.web3jService, BlockTransactionReceipts.class);
    }

    public Request<?, Quantity> getBlockTransactionCountByNumber(long blockNumber) {
        DefaultBlockParameterNumber blockParameterNumber = new DefaultBlockParameterNumber(blockNumber);
        return this.getTransactionCountByNumber((DefaultBlockParameter)blockParameterNumber);
    }

    public Request<?, Quantity> getBlockTransactionCountByNumber(DefaultBlockParameter blockTag) {
        return new Request("klay_getBlockTransactionCountByNumber", Arrays.asList(blockTag), this.web3jService, Quantity.class);
    }

    public Request<?, Quantity> getTransactionCountByNumber(long blockNumber) {
        return this.getBlockTransactionCountByNumber(blockNumber);
    }

    public Request<?, Quantity> getTransactionCountByNumber(DefaultBlockParameter blockTag) {
        return this.getBlockTransactionCountByNumber(blockTag);
    }

    public Request<?, Quantity> getBlockTransactionCountByHash(String blockHash) {
        return new Request("klay_getBlockTransactionCountByHash", Arrays.asList(blockHash), this.web3jService, Quantity.class);
    }

    public Request<?, Quantity> getTransactionCountByHash(String blockHash) {
        return this.getBlockTransactionCountByHash(blockHash);
    }

    public Request<?, BlockWithConsensusInfo> getBlockWithConsensusInfoByHash(String blockHash) {
        return new Request("klay_getBlockWithConsensusInfoByHash", Arrays.asList(blockHash), this.web3jService, BlockWithConsensusInfo.class);
    }

    public Request<?, BlockWithConsensusInfo> getBlockWithConsensusInfoByNumber(long blockNumber) {
        DefaultBlockParameterNumber blockParameterNumber = new DefaultBlockParameterNumber(blockNumber);
        return this.getBlockWithConsensusInfoByNumber((DefaultBlockParameter)blockParameterNumber);
    }

    public Request<?, BlockWithConsensusInfo> getBlockWithConsensusInfoByNumber(DefaultBlockParameter blockTag) {
        return new Request("klay_getBlockWithConsensusInfoByNumber", Arrays.asList(blockTag), this.web3jService, BlockWithConsensusInfo.class);
    }

    public Request<?, Addresses> getCommittee() {
        return this.getCommittee((DefaultBlockParameter)DefaultBlockParameterName.LATEST);
    }

    public Request<?, Addresses> getCommittee(long blockNumber) {
        DefaultBlockParameterNumber parameterNumber = new DefaultBlockParameterNumber(blockNumber);
        return this.getCommittee((DefaultBlockParameter)parameterNumber);
    }

    public Request<?, Addresses> getCommittee(DefaultBlockParameter blockTag) {
        return new Request("klay_getCommittee", Arrays.asList(blockTag), this.web3jService, Addresses.class);
    }

    public Request<?, Quantity> getCommitteeSize() {
        return this.getCommitteeSize((DefaultBlockParameter)DefaultBlockParameterName.LATEST);
    }

    public Request<?, Quantity> getCommitteeSize(long blockNumber) {
        DefaultBlockParameterNumber blockParameterNumber = new DefaultBlockParameterNumber(blockNumber);
        return this.getCommitteeSize((DefaultBlockParameter)blockParameterNumber);
    }

    public Request<?, Quantity> getCommitteeSize(DefaultBlockParameter blockTag) {
        return new Request("klay_getCommitteeSize", Arrays.asList(blockTag), this.web3jService, Quantity.class);
    }

    public Request<?, Addresses> getCouncil() {
        return this.getCouncil((DefaultBlockParameter)DefaultBlockParameterName.LATEST);
    }

    public Request<?, Addresses> getCouncil(long blockNumber) {
        DefaultBlockParameterNumber number = new DefaultBlockParameterNumber(blockNumber);
        return this.getCouncil((DefaultBlockParameter)number);
    }

    public Request<?, Addresses> getCouncil(DefaultBlockParameter blockTag) {
        return new Request("klay_getCouncil", Arrays.asList(blockTag), this.web3jService, Addresses.class);
    }

    public Request<?, Quantity> getCouncilSize() {
        return this.getCouncilSize((DefaultBlockParameter)DefaultBlockParameterName.LATEST);
    }

    public Request<?, Quantity> getCouncilSize(long blockNumber) {
        DefaultBlockParameterNumber blockParameterNumber = new DefaultBlockParameterNumber(blockNumber);
        return this.getCouncilSize((DefaultBlockParameter)blockParameterNumber);
    }

    public Request<?, Quantity> getCouncilSize(DefaultBlockParameter blockTag) {
        return new Request("klay_getCouncilSize", Arrays.asList(blockTag), this.web3jService, Quantity.class);
    }

    public Request<?, Bytes> getStorageAt(String address, DefaultBlockParameterNumber position, long blockNumber) {
        DefaultBlockParameterNumber defaultBlockParameterNumber = new DefaultBlockParameterNumber(blockNumber);
        return this.getStorageAt(address, position, blockNumber);
    }

    public Request<?, Bytes> getStorageAt(String address, DefaultBlockParameterNumber position, DefaultBlockParameter blockTag) {
        return new Request("klay_getStorageAt", Arrays.asList(address, position, blockTag.getValue()), this.web3jService, Bytes.class);
    }

    public Request<?, KlaySyncing> isSyncing() {
        return new Request("klay_syncing", Collections.emptyList(), this.web3jService, KlaySyncing.class);
    }

    public Request<?, Quantity> getChainID() {
        return new Request("klay_chainID", Collections.emptyList(), this.web3jService, Quantity.class);
    }

    public Request<?, Bytes> call(CallObject callObject) {
        return this.call(callObject, (DefaultBlockParameter)DefaultBlockParameterName.LATEST);
    }

    public Request<?, Bytes> call(CallObject callObject, Quantity blockNumber) {
        return new Request("klay_call", Arrays.asList(new Object[]{callObject, blockNumber}), this.web3jService, Bytes.class);
    }

    public Request<?, Bytes> call(CallObject callObject, DefaultBlockParameter blockTag) {
        return new Request("klay_call", Arrays.asList(callObject, blockTag), this.web3jService, Bytes.class);
    }

    public Request<?, Quantity> estimateGas(CallObject callObject) {
        return new Request("klay_estimateGas", Arrays.asList(callObject), this.web3jService, Quantity.class);
    }

    public Request<?, Quantity> estimateComputationCost(CallObject callObject) {
        return this.estimateComputationCost(callObject, (DefaultBlockParameter)DefaultBlockParameterName.LATEST);
    }

    public Request<?, Quantity> estimateComputationCost(CallObject callObject, long blockNumber) {
        return this.estimateComputationCost(callObject, (DefaultBlockParameter)new DefaultBlockParameterNumber(blockNumber));
    }

    public Request<?, Quantity> estimateComputationCost(CallObject callObject, DefaultBlockParameter blockTag) {
        return new Request("klay_estimateComputationCost", Arrays.asList(callObject, blockTag), this.web3jService, Quantity.class);
    }

    public Request<?, Transaction> getTransactionByBlockHashAndIndex(String blockHash, long index) {
        DefaultBlockParameterNumber indexNumber = new DefaultBlockParameterNumber(index);
        return new Request("klay_getTransactionByBlockHashAndIndex", Arrays.asList(blockHash, indexNumber), this.web3jService, Transaction.class);
    }

    public Request<?, Transaction> getTransactionByBlockNumberAndIndex(long blockNumber, long index) {
        return this.getTransactionByBlockNumberAndIndex((DefaultBlockParameter)new DefaultBlockParameterNumber(blockNumber), new DefaultBlockParameterNumber(index));
    }

    public Request<?, Transaction> getTransactionByBlockNumberAndIndex(DefaultBlockParameter blockTag, DefaultBlockParameterNumber index) {
        return new Request("klay_getTransactionByBlockNumberAndIndex", Arrays.asList(blockTag, index), this.web3jService, Transaction.class);
    }

    public Request<?, Transaction> getTransactionByHash(String txHash) {
        return new Request("klay_getTransactionByHash", Arrays.asList(txHash), this.web3jService, Transaction.class);
    }

    public Request<?, Transaction> getTransactionBySenderTxHash(String senderTxHash) {
        return new Request("klay_getTransactionBySenderTxHash", Arrays.asList(senderTxHash), this.web3jService, Transaction.class);
    }

    public Request<?, TransactionReceipt> getTransactionReceipt(String transactionHash) {
        return new Request("klay_getTransactionReceipt", Arrays.asList(transactionHash), this.web3jService, TransactionReceipt.class);
    }

    public Request<?, TransactionReceipt> getTransactionReceiptBySenderTxHash(String transactionHash) {
        return new Request("klay_getTransactionReceiptBySenderTxHash", Arrays.asList(transactionHash), this.web3jService, TransactionReceipt.class);
    }

    public Request<?, Bytes32> sendRawTransaction(String signedTransactionData) {
        return new Request("klay_sendRawTransaction", Arrays.asList(signedTransactionData), this.web3jService, Bytes32.class);
    }

    public Request<?, Bytes32> sendRawTransaction(AbstractTransaction transaction) {
        String rawTransaction = transaction.getRLPEncoding();
        return new Request("klay_sendRawTransaction", Arrays.asList(rawTransaction), this.web3jService, Bytes32.class);
    }

    public Request<?, Bytes32> sendTransaction(AbstractTransaction transaction) {
        return new Request("klay_sendTransaction", Arrays.asList(transaction), this.web3jService, Bytes32.class);
    }

    public Request<?, Bytes32> sendTransactionAsFeePayer(AbstractFeeDelegatedTransaction transaction) {
        return new Request("klay_sendTransactionAsFeePayer", Arrays.asList(transaction), this.web3jService, Bytes32.class);
    }

    public Request<?, SignTransaction> signTransaction(AbstractTransaction transaction) {
        if (Utils.isEmptySig(transaction.getSignatures())) {
            transaction.getSignatures().remove(0);
        }
        return new Request("klay_signTransaction", Arrays.asList(transaction), this.web3jService, SignTransaction.class);
    }

    public Request<?, SignTransaction> signTransactionAsFeePayer(AbstractFeeDelegatedTransaction transaction) {
        if (Utils.isEmptySig(transaction.getSignatures())) {
            transaction.getSignatures().remove(0);
        }
        return new Request("klay_signTransactionAsFeePayer", Arrays.asList(transaction), this.web3jService, SignTransaction.class);
    }

    public Request<?, DecodeAnchoringTransaction> getDecodedAnchoringTransaction(String hash) {
        return new Request("klay_getDecodedAnchoringTransactionByHash", Arrays.asList(hash), this.web3jService, DecodeAnchoringTransaction.class);
    }

    public Request<?, Bytes> getClientVersion() {
        return new Request("klay_clientVersion", Collections.emptyList(), this.web3jService, Bytes.class);
    }

    public Request<?, Quantity> getGasPrice() {
        return new Request("klay_gasPrice", Collections.emptyList(), this.web3jService, Quantity.class);
    }

    public Request<?, Quantity> getGasPriceAt() {
        return new Request("klay_gasPriceAt", Arrays.asList(DefaultBlockParameterName.LATEST), this.web3jService, Quantity.class);
    }

    public Request<?, Quantity> getGasPriceAt(long blockNumber) {
        DefaultBlockParameterNumber blockParameterNumber = new DefaultBlockParameterNumber(blockNumber);
        return this.getGasPriceAt((DefaultBlockParameter)blockParameterNumber);
    }

    public Request<?, Quantity> getGasPriceAt(DefaultBlockParameter blockTag) {
        return new Request("klay_gasPriceAt", Arrays.asList(blockTag), this.web3jService, Quantity.class);
    }

    public Request<?, Boolean> isParallelDBWrite() {
        return new Request("klay_isParallelDBWrite", Collections.emptyList(), this.web3jService, Boolean.class);
    }

    public Request<?, Boolean> isSenderTxHashIndexingEnabled() {
        return new Request("klay_isSenderTxHashIndexingEnabled", Collections.emptyList(), this.web3jService, Boolean.class);
    }

    public Request<?, Bytes> getProtocolVersion() {
        return new Request("klay_protocolVersion", Collections.emptyList(), this.web3jService, Bytes.class);
    }

    public Request<?, Bytes20> getRewardbase() {
        return new Request("klay_rewardbase", Collections.emptyList(), this.web3jService, Bytes20.class);
    }

    public Request<?, KlayLogs> getFilterChanges(String filterId) {
        return new Request("klay_getFilterChanges", Arrays.asList(filterId), this.web3jService, KlayLogs.class);
    }

    public Request<?, KlayLogs> getFilterLogs(String filterId) {
        return new Request("klay_getFilterLogs", Arrays.asList(filterId), this.web3jService, KlayLogs.class);
    }

    public Request<?, KlayLogs> getLogs(KlayLogFilter filterOption) {
        return new Request("klay_getLogs", Arrays.asList(filterOption), this.web3jService, KlayLogs.class);
    }

    public Request<?, Quantity> newBlockFilter() {
        return new Request("klay_newBlockFilter", Collections.emptyList(), this.web3jService, Quantity.class);
    }

    public Request<?, Quantity> newFilter(KlayFilter filterOption) {
        return new Request("klay_newFilter", Arrays.asList(filterOption), this.web3jService, Quantity.class);
    }

    public Request<?, Quantity> newPendingTransactionFilter() {
        return new Request("klay_newPendingTransactionFilter", Collections.emptyList(), this.web3jService, Quantity.class);
    }

    public Request<?, Boolean> uninstallFilter(String filterId) {
        return new Request("klay_uninstallFilter", Arrays.asList(filterId), this.web3jService, Boolean.class);
    }

    public Request<?, Bytes> sha3(String data) {
        return new Request("klay_sha3", Arrays.asList(data), this.web3jService, Bytes.class);
    }
}

