/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.methods.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.klaytn.caver.methods.response.KlayLogs;
import com.klaytn.caver.wallet.keyring.SignatureData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.web3j.protocol.core.Response;
import org.web3j.utils.Numeric;

public class TransactionReceipt
extends Response<TransactionReceiptData> {

    public static class SignatureDataListDeserializer
    extends JsonDeserializer<List<SignatureData>> {
        public List<SignatureData> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            Iterator iterator = node.iterator();
            ArrayList<SignatureData> signatureDataList = new ArrayList<SignatureData>();
            while (iterator.hasNext()) {
                JsonNode innerNode = (JsonNode)iterator.next();
                byte[] v = Numeric.hexStringToByteArray((String)innerNode.get("V").asText());
                byte[] r = Numeric.hexStringToByteArray((String)innerNode.get("R").asText());
                byte[] s = Numeric.hexStringToByteArray((String)innerNode.get("S").asText());
                signatureDataList.add(new SignatureData(v, r, s));
            }
            return signatureDataList;
        }
    }

    public static class TransactionReceiptData {
        private String blockHash;
        private String blockNumber;
        private String codeFormat;
        private String contractAddress;
        private String feePayer;
        private List<SignatureData> feePayerSignatures;
        private String feeRatio;
        private String from;
        private String gas;
        private String gasPrice;
        private String gasUsed;
        private boolean humanReadable;
        private String key;
        private String input;
        private List<KlayLogs.Log> logs;
        private String logsBloom;
        private String nonce;
        private String senderTxHash;
        private List<SignatureData> signatures;
        private String status;
        private String to;
        private String transactionIndex;
        private String transactionHash;
        private String txError;
        private String type;
        private String typeInt;
        private String value;

        public TransactionReceiptData() {
        }

        public TransactionReceiptData(String blockHash, String blockNumber, String codeFormat, String contractAddress, String feePayer, List<SignatureData> feePayerSignatures, String feeRatio, String from, String gas, String gasPrice, String gasUsed, boolean humanReadable, String key, String input, List<KlayLogs.Log> logs, String logsBloom, String nonce, String senderTxHash, List<SignatureData> signatures, String status, String to, String transactionIndex, String transactionHash, String txError, String type, String typeInt, String value) {
            this.blockHash = blockHash;
            this.blockNumber = blockNumber;
            this.codeFormat = codeFormat;
            this.contractAddress = contractAddress;
            this.feePayer = feePayer;
            this.feePayerSignatures = feePayerSignatures;
            this.feeRatio = feeRatio;
            this.from = from;
            this.gas = gas;
            this.gasPrice = gasPrice;
            this.gasUsed = gasUsed;
            this.humanReadable = humanReadable;
            this.key = key;
            this.input = input;
            this.logs = logs;
            this.logsBloom = logsBloom;
            this.nonce = nonce;
            this.senderTxHash = senderTxHash;
            this.signatures = signatures;
            this.status = status;
            this.to = to;
            this.transactionIndex = transactionIndex;
            this.transactionHash = transactionHash;
            this.txError = txError;
            this.type = type;
            this.typeInt = typeInt;
            this.value = value;
        }

        public String getBlockHash() {
            return this.blockHash;
        }

        public void setBlockHash(String blockHash) {
            this.blockHash = blockHash;
        }

        public String getBlockNumber() {
            return this.blockNumber;
        }

        public void setBlockNumber(String blockNumber) {
            this.blockNumber = blockNumber;
        }

        public String getCodeFormat() {
            return this.codeFormat;
        }

        public void setCodeFormat(String codeFormat) {
            this.codeFormat = codeFormat;
        }

        public String getContractAddress() {
            return this.contractAddress;
        }

        public void setContractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
        }

        public String getFeePayer() {
            return this.feePayer;
        }

        public void setFeePayer(String feePayer) {
            this.feePayer = feePayer;
        }

        public List<SignatureData> getFeePayerSignatures() {
            return this.feePayerSignatures;
        }

        @JsonDeserialize(using=SignatureDataListDeserializer.class)
        public void setFeePayerSignatures(List<SignatureData> feePayerSignatures) {
            this.feePayerSignatures = feePayerSignatures;
        }

        public String getFeeRatio() {
            return this.feeRatio;
        }

        public void setFeeRatio(String feeRatio) {
            this.feeRatio = feeRatio;
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getGas() {
            return this.gas;
        }

        public void setGas(String gas) {
            this.gas = gas;
        }

        public String getGasPrice() {
            return this.gasPrice;
        }

        public void setGasPrice(String gasPrice) {
            this.gasPrice = gasPrice;
        }

        public String getGasUsed() {
            return this.gasUsed;
        }

        public void setGasUsed(String gasUsed) {
            this.gasUsed = gasUsed;
        }

        public boolean isHumanReadable() {
            return this.humanReadable;
        }

        public void setHumanReadable(boolean humanReadable) {
            this.humanReadable = humanReadable;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getInput() {
            return this.input;
        }

        public void setInput(String input) {
            this.input = input;
        }

        public List<KlayLogs.Log> getLogs() {
            return this.logs;
        }

        public void setLogs(List<KlayLogs.Log> logs) {
            this.logs = logs;
        }

        public String getLogsBloom() {
            return this.logsBloom;
        }

        public void setLogsBloom(String logsBloom) {
            this.logsBloom = logsBloom;
        }

        public String getNonce() {
            return this.nonce;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public String getSenderTxHash() {
            return this.senderTxHash;
        }

        public void setSenderTxHash(String senderTxHash) {
            this.senderTxHash = senderTxHash;
        }

        public List<SignatureData> getSignatures() {
            return this.signatures;
        }

        @JsonDeserialize(using=SignatureDataListDeserializer.class)
        public void setSignatures(List<SignatureData> signatures) {
            this.signatures = signatures;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getTo() {
            return this.to;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public String getTransactionIndex() {
            return this.transactionIndex;
        }

        public void setTransactionIndex(String transactionIndex) {
            this.transactionIndex = transactionIndex;
        }

        public String getTransactionHash() {
            return this.transactionHash;
        }

        public void setTransactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
        }

        public String getTxError() {
            return this.txError;
        }

        public void setTxError(String txError) {
            this.txError = txError;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getTypeInt() {
            return this.typeInt;
        }

        public void setTypeInt(String typeInt) {
            this.typeInt = typeInt;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    static enum TxError {
        RUNTIME_ERROR("0x2", "runtime error occurred in interpreter"),
        MAX_CALL_EXCEED("0x3", "max call depth exceeded"),
        CONTRACT_ADDRESS_COLLISION("0x4", "contract address collision"),
        CONTRACT_OUT_OF_GAS("0x5", "contract creation code storage out of gas"),
        MAX_CODE_SIZE_EXCEED("0x6", "evm: max code size exceeded"),
        OUT_OF_GAS("0x7", "out of gas"),
        WRITE_PROTECTION("0x8", "evm: write protection"),
        EXECUTION_REVERTED("0x9", "evm: execution reverted"),
        OPCODE_COUNT_LIMIT("0xa", "reached the opcode count limit"),
        ACCOUNT_EXIST("0xb", "account already exists"),
        NOT_PROGRAM_ACCOUNT("0xc", "not a program account (e.g., an account having code and storage)"),
        NOT_HUMAN_READABLE_ACCOUNT("0xd", "not a human readable address"),
        FEE_RATIO_OUT_OF_RANGE("0xe", "fee ratio is out of range [1, 99]"),
        ACCOUNTKEYFAIL_NOT_UPDATABLE("0xf", "AccountKeyFail is not updatable"),
        DIFFERENT_ACCOUNTKEY_TYPE("0x10", "different account key type"),
        ACCOUNTKEYNIL_CANNOT_INITIALIZED("0x11", "AccountKeyNil cannot be initialized to an account"),
        PUBLICKEY_NOT_ON_CURVE("0x12", "public key is not on curve"),
        KEY_WEIGHT_ZERO("0x13", "key weight is zero"),
        KEY_NOT_SERIALIZABLE("0x14", "key is not serializable"),
        KEY_DUPLICATED("0x15", "duplicated key"),
        WEIGHTED_SUM_OVERFLOW("0x16", "weighted sum overflow"),
        UNSATISFIABLE_THRESHOLD("0x17", "unsatisfiable threshold. Weighted sum of keys is less than the threshold"),
        ZERO_LENGTH("0x18", "length is zero"),
        TOO_LONG_LENGTH("0x19", "length too long"),
        NESTED_ROLE_BASE_KEY("0x1a", "nested role-based key");

        private String value;
        private String errorMessage;

        private TxError(String value, String errorMessage) {
            this.value = value;
            this.errorMessage = errorMessage;
        }

        public static String getErrorMessage(String value) {
            for (TxError type : TxError.values()) {
                if (!type.value.equals(value)) continue;
                return type.errorMessage;
            }
            return null;
        }
    }
}

