/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.methods.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.klaytn.caver.wallet.keyring.SignatureData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.web3j.protocol.core.Response;
import org.web3j.utils.Numeric;

public class Transaction
extends Response<TransactionData> {

    public static class SignatureDataListDeserializer
    extends JsonDeserializer<List<SignatureData>> {
        public List<SignatureData> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            Iterator iterator = node.iterator();
            ArrayList<SignatureData> signatureDataList = new ArrayList<SignatureData>();
            while (iterator.hasNext()) {
                JsonNode innerNode = (JsonNode)iterator.next();
                byte[] v = Numeric.hexStringToByteArray((String)innerNode.get("V").asText());
                byte[] r = Numeric.hexStringToByteArray((String)innerNode.get("R").asText());
                byte[] s = Numeric.hexStringToByteArray((String)innerNode.get("S").asText());
                signatureDataList.add(new SignatureData(v, r, s));
            }
            return signatureDataList;
        }
    }

    public static class TransactionData {
        private String blockHash;
        private String blockNumber;
        private String codeFormat;
        private String feePayer;
        private List<SignatureData> feePayerSignatures;
        private String feeRatio;
        private String from;
        private String gas;
        private String gasPrice;
        private String hash;
        private boolean humanReadable;
        private String key;
        private String input;
        private String nonce;
        private String senderTxHash;
        private List<SignatureData> signatures;
        private String to;
        private String transactionIndex;
        private String type;
        private String typeInt;
        private String value;

        public TransactionData() {
        }

        public TransactionData(String blockHash, String blockNumber, String codeFormat, String feePayer, List<SignatureData> feePayerSignatures, String feeRatio, String from, String gas, String gasPrice, String hash, boolean humanReadable, String key, String input, String nonce, String senderTxHash, List<SignatureData> signatures, String to, String transactionIndex, String type, String typeInt, String value) {
            this.blockHash = blockHash;
            this.blockNumber = blockNumber;
            this.codeFormat = codeFormat;
            this.feePayer = feePayer;
            this.feePayerSignatures = feePayerSignatures;
            this.feeRatio = feeRatio;
            this.from = from;
            this.gas = gas;
            this.gasPrice = gasPrice;
            this.hash = hash;
            this.humanReadable = humanReadable;
            this.key = key;
            this.input = input;
            this.nonce = nonce;
            this.senderTxHash = senderTxHash;
            this.signatures = signatures;
            this.to = to;
            this.transactionIndex = transactionIndex;
            this.type = type;
            this.typeInt = typeInt;
            this.value = value;
        }

        public String getBlockHash() {
            return this.blockHash;
        }

        public void setBlockHash(String blockHash) {
            this.blockHash = blockHash;
        }

        public String getBlockNumber() {
            return this.blockNumber;
        }

        public void setBlockNumber(String blockNumber) {
            this.blockNumber = blockNumber;
        }

        public String getCodeFormat() {
            return this.codeFormat;
        }

        public void setCodeFormat(String codeFormat) {
            this.codeFormat = codeFormat;
        }

        public String getFeePayer() {
            return this.feePayer;
        }

        public void setFeePayer(String feePayer) {
            this.feePayer = feePayer;
        }

        public List<SignatureData> getFeePayerSignatures() {
            return this.feePayerSignatures;
        }

        @JsonDeserialize(using=SignatureDataListDeserializer.class)
        public void setFeePayerSignatures(List<SignatureData> feePayerSignatures) {
            this.feePayerSignatures = feePayerSignatures;
        }

        public String getFeeRatio() {
            return this.feeRatio;
        }

        public void setFeeRatio(String feeRatio) {
            this.feeRatio = feeRatio;
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getGas() {
            return this.gas;
        }

        public void setGas(String gas) {
            this.gas = gas;
        }

        public String getGasPrice() {
            return this.gasPrice;
        }

        public void setGasPrice(String gasPrice) {
            this.gasPrice = gasPrice;
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public String getInput() {
            return this.input;
        }

        public void setInput(String input) {
            this.input = input;
        }

        public String getNonce() {
            return this.nonce;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public String getSenderTxHash() {
            return this.senderTxHash;
        }

        public void setSenderTxHash(String senderTxHash) {
            this.senderTxHash = senderTxHash;
        }

        public List<SignatureData> getSignatures() {
            return this.signatures;
        }

        @JsonDeserialize(using=SignatureDataListDeserializer.class)
        public void setSignatures(List<SignatureData> signatures) {
            this.signatures = signatures;
        }

        public String getTo() {
            return this.to;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public String getTransactionIndex() {
            return this.transactionIndex;
        }

        public void setTransactionIndex(String transactionIndex) {
            this.transactionIndex = transactionIndex;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getTypeInt() {
            return this.typeInt;
        }

        public void setTypeInt(String typeInt) {
            this.typeInt = typeInt;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isHumanReadable() {
            return this.humanReadable;
        }

        public void setHumanReadable(boolean humanReadable) {
            this.humanReadable = humanReadable;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }
    }
}

