/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.methods.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.klaytn.caver.tx.account.AccountKey;
import com.klaytn.caver.tx.account.AccountKeyRoleBased;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.core.Response;

@Deprecated
public class KlayAccountKey
extends Response<AccountKeyValue> {

    public static class AccountKeyDeserializer
    extends JsonDeserializer<AccountKeyValue> {
        public AccountKeyValue deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            AccountKey.Type keyKey = AccountKey.Type.findByValue((byte)node.get("keyType").intValue());
            JsonNode key = node.get("key");
            return new AccountKeyValue(AccountKeyDecoder.decode(keyKey, key), keyKey.getValue());
        }
    }

    public static class AccountKeyDecoder {
        private static ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();

        public static AccountKey decode(AccountKey.Type keyType, JsonNode key) throws IOException {
            if (keyType == AccountKey.Type.ROLEBASED) {
                Iterator iterator = key.iterator();
                ArrayList<AccountKey> accountKeys = new ArrayList<AccountKey>();
                while (iterator.hasNext()) {
                    JsonNode node = (JsonNode)iterator.next();
                    AccountKey.Type innerKeyType = AccountKey.Type.findByValue((byte)node.get("keyType").intValue());
                    JsonNode innerKey = node.get("key");
                    accountKeys.add(AccountKeyDecoder.decode(innerKeyType, innerKey));
                }
                return AccountKeyRoleBased.create(accountKeys);
            }
            return (AccountKey)objectMapper.readValue(key.toString(), keyType.getClazz());
        }
    }

    @JsonDeserialize(using=AccountKeyDeserializer.class)
    public static class AccountKeyValue {
        private AccountKey key;
        private int keyType;

        public AccountKeyValue() {
        }

        public AccountKeyValue(AccountKey key, int keyType) {
            this.key = key;
            this.keyType = keyType;
        }

        public AccountKey getKey() {
            return this.key;
        }

        public int getKeyType() {
            return this.keyType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AccountKeyValue)) {
                return false;
            }
            AccountKeyValue that = (AccountKeyValue)o;
            if (this.getKey() != null ? !this.getKey().equals(that.getKey()) : that.getKey() != null) {
                return false;
            }
            return this.getKeyType() == that.getKeyType();
        }

        public int hashCode() {
            int result = this.getKey() != null ? this.getKey().hashCode() : 0;
            result = 31 * result + Integer.hashCode(this.getKeyType());
            return result;
        }
    }
}

