/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.methods.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.klaytn.caver.methods.response.AccountEOA;
import com.klaytn.caver.methods.response.AccountSmartContract;
import com.klaytn.caver.methods.response.IAccountType;
import java.io.IOException;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.core.Response;

@Deprecated
public class KlayAccount
extends Response<Account> {

    public static class AccountDeserializer
    extends JsonDeserializer<Account> {
        public Account deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            JsonNode key = node.get("account");
            IAccountType.AccType accType = IAccountType.AccType.getType(node.get("accType").intValue());
            return new Account(AccountDecoder.decode(accType, key), accType.getAccType());
        }
    }

    public static class AccountDecoder {
        private static ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();

        public static IAccountType decode(IAccountType.AccType keyType, JsonNode key) throws IOException {
            if (keyType == IAccountType.AccType.EOA) {
                return (IAccountType)objectMapper.readValue(key.toString(), AccountEOA.class);
            }
            return (IAccountType)objectMapper.readValue(key.toString(), AccountSmartContract.class);
        }
    }

    @JsonDeserialize(using=AccountDeserializer.class)
    public static class Account {
        private IAccountType account;
        private int accType;

        public Account() {
        }

        public Account(IAccountType account, int accType) {
            this.account = account;
            this.accType = accType;
        }

        public IAccountType getAccount() {
            return this.account;
        }

        public int getAccType() {
            return this.accType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Account)) {
                return false;
            }
            Account that = (Account)o;
            if (this.getAccount() != null ? !this.getAccount().equals(that.getAccount()) : that.getAccount() != null) {
                return false;
            }
            return this.getAccType() == that.getAccType();
        }

        public int hashCode() {
            int result = this.getAccount() != null ? this.getAccount().hashCode() : 0;
            result = 31 * result + Integer.hashCode(this.getAccType());
            return result;
        }
    }
}

