/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.methods.response;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.klaytn.caver.methods.response.Transaction;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.core.Response;

public class Block
extends Response<BlockData> {
    @JsonDeserialize(using=ResponseDeserializer.class)
    public void setResult(BlockData result) {
        super.setResult((Object)result);
    }

    static class TransactionsDeserializer
    extends JsonDeserializer<List> {
        TransactionsDeserializer() {
        }

        public List deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ObjectMapper objectMapper = (ObjectMapper)jsonParser.getCodec();
            ArrayNode root = (ArrayNode)objectMapper.readTree(jsonParser);
            if (root.size() == 0) {
                return Collections.emptyList();
            }
            if (root.get(0).isTextual()) {
                return (List)objectMapper.convertValue((Object)root, (TypeReference)new TypeReference<List<String>>(){});
            }
            return (List)objectMapper.convertValue((Object)root, (TypeReference)new TypeReference<List<Transaction.TransactionData>>(){});
        }
    }

    public static class ResponseDeserializer
    extends JsonDeserializer<BlockData> {
        private ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        public BlockData deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.getCurrentToken() != JsonToken.VALUE_NULL) {
                return (BlockData)this.objectReader.readValue(jsonParser, BlockData.class);
            }
            return null;
        }
    }

    public static class BlockData<T> {
        private String number;
        private String hash;
        private String parentHash;
        private String logsBloom;
        private String transactionsRoot;
        private String stateRoot;
        private String receiptsRoot;
        private String reward;
        private String blockScore;
        private String totalBlockScore;
        private String extraData;
        private String size;
        private String gasUsed;
        private String timestamp;
        private String timestampFoS;
        private List transactions;
        private String governanceData;
        private String voteData;

        public BlockData() {
        }

        public BlockData(String number, String hash, String parentHash, String logsBloom, String transactionsRoot, String stateRoot, String receiptsRoot, String reward, String blockScore, String totalBlockScore, String extraData, String size, String gasUsed, String timestamp, String timestampFoS, List transactions, String governanceData, String voteData) {
            this.number = number;
            this.hash = hash;
            this.parentHash = parentHash;
            this.logsBloom = logsBloom;
            this.transactionsRoot = transactionsRoot;
            this.stateRoot = stateRoot;
            this.receiptsRoot = receiptsRoot;
            this.reward = reward;
            this.blockScore = blockScore;
            this.totalBlockScore = totalBlockScore;
            this.extraData = extraData;
            this.size = size;
            this.gasUsed = gasUsed;
            this.timestamp = timestamp;
            this.timestampFoS = timestampFoS;
            this.transactions = transactions;
            this.governanceData = governanceData;
            this.voteData = voteData;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public String getParentHash() {
            return this.parentHash;
        }

        public void setParentHash(String parentHash) {
            this.parentHash = parentHash;
        }

        public String getLogsBloom() {
            return this.logsBloom;
        }

        public void setLogsBloom(String logsBloom) {
            this.logsBloom = logsBloom;
        }

        public String getTransactionsRoot() {
            return this.transactionsRoot;
        }

        public void setTransactionsRoot(String transactionsRoot) {
            this.transactionsRoot = transactionsRoot;
        }

        public String getStateRoot() {
            return this.stateRoot;
        }

        public void setStateRoot(String stateRoot) {
            this.stateRoot = stateRoot;
        }

        public String getReceiptsRoot() {
            return this.receiptsRoot;
        }

        public void setReceiptsRoot(String receiptsRoot) {
            this.receiptsRoot = receiptsRoot;
        }

        public String getExtraData() {
            return this.extraData;
        }

        public void setExtraData(String extraData) {
            this.extraData = extraData;
        }

        public String getSize() {
            return this.size;
        }

        public void setSize(String size) {
            this.size = size;
        }

        public String getGasUsed() {
            return this.gasUsed;
        }

        public void setGasUsed(String gasUsed) {
            this.gasUsed = gasUsed;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public String getTimestampFoS() {
            return this.timestampFoS;
        }

        public void setTimestampFoS(String timestampFoS) {
            this.timestampFoS = timestampFoS;
        }

        public List getTransactions() {
            return this.transactions;
        }

        @JsonSetter(value="transactions")
        @JsonDeserialize(using=TransactionsDeserializer.class)
        public void setTransactions(List transactions) {
            this.transactions = transactions;
        }

        public String getGovernanceData() {
            return this.governanceData;
        }

        public void setGovernanceData(String governanceData) {
            this.governanceData = governanceData;
        }

        public String getVoteData() {
            return this.voteData;
        }

        public void setVoteData(String voteData) {
            this.voteData = voteData;
        }

        public String getReward() {
            return this.reward;
        }

        public void setReward(String reward) {
            this.reward = reward;
        }

        public String getBlockScore() {
            return this.blockScore;
        }

        public void setBlockScore(String blockScore) {
            this.blockScore = blockScore;
        }

        public String getTotalBlockScore() {
            return this.totalBlockScore;
        }

        public void setTotalBlockScore(String totalBlockScore) {
            this.totalBlockScore = totalBlockScore;
        }
    }
}

