/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.methods.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigInteger;
import org.web3j.utils.Numeric;

@Deprecated
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class KlayTransaction {
    private String from;
    private String to;
    private BigInteger gas;
    private BigInteger gasPrice;
    private BigInteger value;
    private String data;
    private BigInteger nonce;

    public KlayTransaction(String from, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data) {
        this.from = from;
        this.to = to;
        this.gas = gasLimit;
        this.gasPrice = gasPrice;
        this.value = value;
        if (data != null) {
            this.data = Numeric.prependHexPrefix((String)data);
        }
        this.nonce = nonce;
    }

    public static KlayTransaction createKlayTransaction(String from, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value) {
        return new KlayTransaction(from, nonce, gasPrice, gasLimit, to, value, null);
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getGas() {
        return KlayTransaction.convert(this.gas);
    }

    public String getGasPrice() {
        return KlayTransaction.convert(this.gasPrice);
    }

    public String getValue() {
        return KlayTransaction.convert(this.value);
    }

    public String getData() {
        return this.data;
    }

    public String getNonce() {
        return KlayTransaction.convert(this.nonce);
    }

    private static String convert(BigInteger value) {
        if (value != null) {
            return Numeric.encodeQuantity((BigInteger)value);
        }
        return null;
    }
}

