/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.kct;

import com.klaytn.caver.Caver;
import com.klaytn.caver.crypto.KlayCredentials;
import com.klaytn.caver.methods.response.KlayLogs;
import com.klaytn.caver.methods.response.KlayTransactionReceipt;
import com.klaytn.caver.tx.SmartContract;
import com.klaytn.caver.tx.manager.TransactionManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Bytes4;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.tx.gas.ContractGasProvider;

@Deprecated
public class KIP17
extends SmartContract {
    private static final String BINARY = "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";
    public static final String FUNC_ADDMINTER = "addMinter";
    public static final String FUNC_ADDPAUSER = "addPauser";
    public static final String FUNC_APPROVE = "approve";
    public static final String FUNC_BALANCEOF = "balanceOf";
    public static final String FUNC_BURN = "burn";
    public static final String FUNC_GETAPPROVED = "getApproved";
    public static final String FUNC_ISAPPROVEDFORALL = "isApprovedForAll";
    public static final String FUNC_ISMINTER = "isMinter";
    public static final String FUNC_ISPAUSER = "isPauser";
    public static final String FUNC_MINT = "mint";
    public static final String FUNC_MINTWITHTOKENURI = "mintWithTokenURI";
    public static final String FUNC_NAME = "name";
    public static final String FUNC_OWNEROF = "ownerOf";
    public static final String FUNC_PAUSE = "pause";
    public static final String FUNC_PAUSED = "paused";
    public static final String FUNC_RENOUNCEMINTER = "renounceMinter";
    public static final String FUNC_RENOUNCEPAUSER = "renouncePauser";
    public static final String FUNC_SAFETRANSFERFROM = "safeTransferFrom";
    public static final String FUNC_SETAPPROVALFORALL = "setApprovalForAll";
    public static final String FUNC_SUPPORTSINTERFACE = "supportsInterface";
    public static final String FUNC_SYMBOL = "symbol";
    public static final String FUNC_TOKENBYINDEX = "tokenByIndex";
    public static final String FUNC_TOKENOFOWNERBYINDEX = "tokenOfOwnerByIndex";
    public static final String FUNC_TOKENURI = "tokenURI";
    public static final String FUNC_TOTALSUPPLY = "totalSupply";
    public static final String FUNC_TRANSFERFROM = "transferFrom";
    public static final String FUNC_UNPAUSE = "unpause";
    public static final Event APPROVAL_EVENT = new Event("Approval", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(true){}));
    public static final Event APPROVALFORALL_EVENT = new Event("ApprovalForAll", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Bool>(){}));
    public static final Event MINTERADDED_EVENT = new Event("MinterAdded", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event MINTERREMOVED_EVENT = new Event("MinterRemoved", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event PAUSED_EVENT = new Event("Paused", Arrays.asList(new TypeReference<Address>(){}));
    public static final Event PAUSERADDED_EVENT = new Event("PauserAdded", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event PAUSERREMOVED_EVENT = new Event("PauserRemoved", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event TRANSFER_EVENT = new Event("Transfer", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(true){}));
    public static final Event UNPAUSED_EVENT = new Event("Unpaused", Arrays.asList(new TypeReference<Address>(){}));
    protected static final HashMap<String, String> _addresses = new HashMap();

    protected KIP17(String contractAddress, Caver caver, KlayCredentials credentials, int chainId, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, caver, credentials, chainId, contractGasProvider);
    }

    protected KIP17(String contractAddress, Caver caver, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, caver, transactionManager, contractGasProvider);
    }

    public List<ApprovalEventResponse> getApprovalEvents(KlayTransactionReceipt.TransactionReceipt transactionReceipt) {
        List<SmartContract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(APPROVAL_EVENT, transactionReceipt);
        ArrayList<ApprovalEventResponse> responses = new ArrayList<ApprovalEventResponse>(valueList.size());
        for (SmartContract.EventValuesWithLog eventValues : valueList) {
            ApprovalEventResponse typedResponse = new ApprovalEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.owner = (String)eventValues.getIndexedValues().get(0).getValue();
            typedResponse.approved = (String)eventValues.getIndexedValues().get(1).getValue();
            typedResponse.tokenId = (BigInteger)eventValues.getIndexedValues().get(2).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public List<ApprovalForAllEventResponse> getApprovalForAllEvents(KlayTransactionReceipt.TransactionReceipt transactionReceipt) {
        List<SmartContract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(APPROVALFORALL_EVENT, transactionReceipt);
        ArrayList<ApprovalForAllEventResponse> responses = new ArrayList<ApprovalForAllEventResponse>(valueList.size());
        for (SmartContract.EventValuesWithLog eventValues : valueList) {
            ApprovalForAllEventResponse typedResponse = new ApprovalForAllEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.owner = (String)eventValues.getIndexedValues().get(0).getValue();
            typedResponse.operator = (String)eventValues.getIndexedValues().get(1).getValue();
            typedResponse.approved = (Boolean)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public List<MinterAddedEventResponse> getMinterAddedEvents(KlayTransactionReceipt.TransactionReceipt transactionReceipt) {
        List<SmartContract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(MINTERADDED_EVENT, transactionReceipt);
        ArrayList<MinterAddedEventResponse> responses = new ArrayList<MinterAddedEventResponse>(valueList.size());
        for (SmartContract.EventValuesWithLog eventValues : valueList) {
            MinterAddedEventResponse typedResponse = new MinterAddedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public List<MinterRemovedEventResponse> getMinterRemovedEvents(KlayTransactionReceipt.TransactionReceipt transactionReceipt) {
        List<SmartContract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(MINTERREMOVED_EVENT, transactionReceipt);
        ArrayList<MinterRemovedEventResponse> responses = new ArrayList<MinterRemovedEventResponse>(valueList.size());
        for (SmartContract.EventValuesWithLog eventValues : valueList) {
            MinterRemovedEventResponse typedResponse = new MinterRemovedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public List<PausedEventResponse> getPausedEvents(KlayTransactionReceipt.TransactionReceipt transactionReceipt) {
        List<SmartContract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(PAUSED_EVENT, transactionReceipt);
        ArrayList<PausedEventResponse> responses = new ArrayList<PausedEventResponse>(valueList.size());
        for (SmartContract.EventValuesWithLog eventValues : valueList) {
            PausedEventResponse typedResponse = new PausedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public List<PauserAddedEventResponse> getPauserAddedEvents(KlayTransactionReceipt.TransactionReceipt transactionReceipt) {
        List<SmartContract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(PAUSERADDED_EVENT, transactionReceipt);
        ArrayList<PauserAddedEventResponse> responses = new ArrayList<PauserAddedEventResponse>(valueList.size());
        for (SmartContract.EventValuesWithLog eventValues : valueList) {
            PauserAddedEventResponse typedResponse = new PauserAddedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public List<PauserRemovedEventResponse> getPauserRemovedEvents(KlayTransactionReceipt.TransactionReceipt transactionReceipt) {
        List<SmartContract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(PAUSERREMOVED_EVENT, transactionReceipt);
        ArrayList<PauserRemovedEventResponse> responses = new ArrayList<PauserRemovedEventResponse>(valueList.size());
        for (SmartContract.EventValuesWithLog eventValues : valueList) {
            PauserRemovedEventResponse typedResponse = new PauserRemovedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public List<TransferEventResponse> getTransferEvents(KlayTransactionReceipt.TransactionReceipt transactionReceipt) {
        List<SmartContract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(TRANSFER_EVENT, transactionReceipt);
        ArrayList<TransferEventResponse> responses = new ArrayList<TransferEventResponse>(valueList.size());
        for (SmartContract.EventValuesWithLog eventValues : valueList) {
            TransferEventResponse typedResponse = new TransferEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String)eventValues.getIndexedValues().get(0).getValue();
            typedResponse.to = (String)eventValues.getIndexedValues().get(1).getValue();
            typedResponse.tokenId = (BigInteger)eventValues.getIndexedValues().get(2).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public List<UnpausedEventResponse> getUnpausedEvents(KlayTransactionReceipt.TransactionReceipt transactionReceipt) {
        List<SmartContract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(UNPAUSED_EVENT, transactionReceipt);
        ArrayList<UnpausedEventResponse> responses = new ArrayList<UnpausedEventResponse>(valueList.size());
        for (SmartContract.EventValuesWithLog eventValues : valueList) {
            UnpausedEventResponse typedResponse = new UnpausedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> approve(String to, BigInteger tokenId) {
        Function function = new Function(FUNC_APPROVE, Arrays.asList(new Address(to), new Uint256(tokenId)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> balanceOf(String owner) {
        Function function = new Function(FUNC_BALANCEOF, Arrays.asList(new Address(owner)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> burn(BigInteger tokenId) {
        Function function = new Function(FUNC_BURN, Arrays.asList(new Uint256(tokenId)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<String> getApproved(BigInteger tokenId) {
        Function function = new Function(FUNC_GETAPPROVED, Arrays.asList(new Uint256(tokenId)), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<Boolean> isApprovedForAll(String owner, String operator) {
        Function function = new Function(FUNC_ISAPPROVEDFORALL, Arrays.asList(new Address(owner), new Address(operator)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<Boolean> isMinter(String account) {
        Function function = new Function(FUNC_ISMINTER, Arrays.asList(new Address(account)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<Boolean> isPauser(String account) {
        Function function = new Function(FUNC_ISPAUSER, Arrays.asList(new Address(account)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> mint(String to, BigInteger tokenId) {
        Function function = new Function(FUNC_MINT, Arrays.asList(new Address(to), new Uint256(tokenId)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> mintWithTokenURI(String to, BigInteger tokenId, String tokenURI) {
        Function function = new Function(FUNC_MINTWITHTOKENURI, Arrays.asList(new Address(to), new Uint256(tokenId), new Utf8String(tokenURI)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<String> name() {
        Function function = new Function(FUNC_NAME, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<String> ownerOf(BigInteger tokenId) {
        Function function = new Function(FUNC_OWNEROF, Arrays.asList(new Uint256(tokenId)), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> pause() {
        Function function = new Function(FUNC_PAUSE, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<Boolean> paused() {
        Function function = new Function(FUNC_PAUSED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> addMinter(String account) {
        Function function = new Function(FUNC_ADDMINTER, Arrays.asList(new Address(account)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> addPauser(String account) {
        Function function = new Function(FUNC_ADDPAUSER, Arrays.asList(new Address(account)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> renounceMinter() {
        Function function = new Function(FUNC_RENOUNCEMINTER, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> renouncePauser() {
        Function function = new Function(FUNC_RENOUNCEPAUSER, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> safeTransferFrom(String from, String to, BigInteger tokenId) {
        Function function = new Function(FUNC_SAFETRANSFERFROM, Arrays.asList(new Address(from), new Address(to), new Uint256(tokenId)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> safeTransferFrom(String from, String to, BigInteger tokenId, byte[] _data) {
        Function function = new Function(FUNC_SAFETRANSFERFROM, Arrays.asList(new Address(from), new Address(to), new Uint256(tokenId), new DynamicBytes(_data)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> setApprovalForAll(String to, Boolean approved) {
        Function function = new Function(FUNC_SETAPPROVALFORALL, Arrays.asList(new Address(to), new Bool(approved)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<Boolean> supportsInterface(byte[] interfaceId) {
        Function function = new Function(FUNC_SUPPORTSINTERFACE, Arrays.asList(new Bytes4(interfaceId)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<String> symbol() {
        Function function = new Function(FUNC_SYMBOL, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<BigInteger> tokenByIndex(BigInteger index) {
        Function function = new Function(FUNC_TOKENBYINDEX, Arrays.asList(new Uint256(index)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<BigInteger> tokenOfOwnerByIndex(String owner, BigInteger index) {
        Function function = new Function(FUNC_TOKENOFOWNERBYINDEX, Arrays.asList(new Address(owner), new Uint256(index)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<String> tokenURI(BigInteger tokenId) {
        Function function = new Function(FUNC_TOKENURI, Arrays.asList(new Uint256(tokenId)), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<BigInteger> totalSupply() {
        Function function = new Function(FUNC_TOTALSUPPLY, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> transferFrom(String from, String to, BigInteger tokenId) {
        Function function = new Function(FUNC_TRANSFERFROM, Arrays.asList(new Address(from), new Address(to), new Uint256(tokenId)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<KlayTransactionReceipt.TransactionReceipt> unpause() {
        Function function = new Function(FUNC_UNPAUSE, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public static KIP17 load(String contractAddress, Caver caver, KlayCredentials credentials, int chainId, ContractGasProvider contractGasProvider) {
        return new KIP17(contractAddress, caver, credentials, chainId, contractGasProvider);
    }

    public static KIP17 load(String contractAddress, Caver caver, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new KIP17(contractAddress, caver, transactionManager, contractGasProvider);
    }

    public static RemoteCall<KIP17> deploy(Caver caver, KlayCredentials credentials, int chainId, ContractGasProvider contractGasProvider, String name, String symbol) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Utf8String(name), new Utf8String(symbol)));
        return KIP17.deployRemoteCall(KIP17.class, caver, credentials, chainId, contractGasProvider, BINARY, encodedConstructor);
    }

    public static RemoteCall<KIP17> deploy(Caver caver, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String name, String symbol) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Utf8String(name), new Utf8String(symbol)));
        return KIP17.deployRemoteCall(KIP17.class, caver, transactionManager, contractGasProvider, BINARY, encodedConstructor);
    }

    @Override
    protected String getStaticDeployedAddress(String networkId) {
        return _addresses.get(networkId);
    }

    public static String getPreviouslyDeployedAddress(String networkId) {
        return _addresses.get(networkId);
    }

    public static class UnpausedEventResponse {
        public KlayLogs.Log log;
        public String account;
    }

    public static class TransferEventResponse {
        public KlayLogs.Log log;
        public String from;
        public String to;
        public BigInteger tokenId;
    }

    public static class PauserRemovedEventResponse {
        public KlayLogs.Log log;
        public String account;
    }

    public static class PauserAddedEventResponse {
        public KlayLogs.Log log;
        public String account;
    }

    public static class PausedEventResponse {
        public KlayLogs.Log log;
        public String account;
    }

    public static class MinterRemovedEventResponse {
        public KlayLogs.Log log;
        public String account;
    }

    public static class MinterAddedEventResponse {
        public KlayLogs.Log log;
        public String account;
    }

    public static class ApprovalForAllEventResponse {
        public KlayLogs.Log log;
        public String owner;
        public String operator;
        public Boolean approved;
    }

    public static class ApprovalEventResponse {
        public KlayLogs.Log log;
        public String owner;
        public String approved;
        public BigInteger tokenId;
    }
}

