/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.ipfs;

import com.klaytn.caver.utils.Utils;
import io.ipfs.api.MerkleNode;
import io.ipfs.api.NamedStreamable;
import io.ipfs.multihash.Multihash;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class IPFS {
    io.ipfs.api.IPFS ipfs;

    public IPFS() {
    }

    public IPFS(String host, int port, boolean ssl) {
        this.setIPFSNode(host, port, ssl);
    }

    public static String toHex(String encodedHash) {
        Multihash multihash = Multihash.fromBase58((String)encodedHash);
        return Utils.addHexPrefix(multihash.toHex());
    }

    public static String fromHex(String hexString) {
        String noPrefixStr = Utils.stripHexPrefix(hexString);
        Multihash multihash = Multihash.fromHex((String)noPrefixStr);
        return multihash.toString();
    }

    public String add(String path) throws IOException {
        NamedStreamable.FileWrapper streamable = new NamedStreamable.FileWrapper(new File(path));
        return this.add((NamedStreamable)streamable);
    }

    public String add(byte[] content) throws IOException {
        NamedStreamable.ByteArrayWrapper streamable = new NamedStreamable.ByteArrayWrapper(content);
        return this.add((NamedStreamable)streamable);
    }

    public byte[] get(String encodedHash) throws IOException {
        Multihash multihash = Multihash.fromBase58((String)encodedHash);
        return this.ipfs.cat(multihash);
    }

    public void setIPFSNode(String host, int port, boolean ssl) {
        this.ipfs = new io.ipfs.api.IPFS(host, port, "/api/v0/", ssl);
    }

    private String add(NamedStreamable streamable) throws IOException {
        List nodeList = this.ipfs.add(streamable);
        return ((MerkleNode)nodeList.get((int)0)).hash.toString();
    }
}

