/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.crypto;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Keys;
import org.web3j.utils.Numeric;
import org.web3j.utils.Strings;

@Deprecated
public class KlayCredentials {
    private final List<ECKeyPair> ecKeyPairForTransactionList;
    private final List<ECKeyPair> ecKeyPairForUpdateList;
    private final List<ECKeyPair> ecKeyPairForFeeFeePayerList;
    private final String address;

    private KlayCredentials(ECKeyPair ecKeyPair, String address) {
        this.ecKeyPairForTransactionList = Collections.unmodifiableList(Arrays.asList(ecKeyPair));
        this.ecKeyPairForUpdateList = Collections.unmodifiableList(Collections.emptyList());
        this.ecKeyPairForFeeFeePayerList = Collections.unmodifiableList(Collections.emptyList());
        this.address = !Strings.isEmpty((String)address) ? Numeric.toHexStringWithPrefixZeroPadded((BigInteger)Numeric.toBigInt((String)address), (int)40) : "";
    }

    private KlayCredentials(List<ECKeyPair> ecKeyPairForTransaction, List<ECKeyPair> ecKeyPairForUpdate, List<ECKeyPair> ecKeyPairForFeePayer, String address) {
        this.ecKeyPairForTransactionList = ecKeyPairForTransaction != null && ecKeyPairForTransaction.size() != 0 ? Collections.unmodifiableList(ecKeyPairForTransaction) : Collections.unmodifiableList(Collections.emptyList());
        this.ecKeyPairForUpdateList = ecKeyPairForUpdate != null && ecKeyPairForUpdate.size() != 0 ? Collections.unmodifiableList(ecKeyPairForUpdate) : Collections.unmodifiableList(Collections.emptyList());
        this.ecKeyPairForFeeFeePayerList = ecKeyPairForFeePayer != null && ecKeyPairForFeePayer.size() != 0 ? Collections.unmodifiableList(ecKeyPairForFeePayer) : Collections.unmodifiableList(Collections.emptyList());
        this.address = !Strings.isEmpty((String)address) ? Numeric.toHexStringWithPrefixZeroPadded((BigInteger)Numeric.toBigInt((String)address), (int)40) : "";
    }

    @Deprecated
    public ECKeyPair getEcKeyPair() {
        if (this.ecKeyPairForTransactionList.size() > 0) {
            return this.ecKeyPairForTransactionList.get(0);
        }
        throw new RuntimeException("Transaction key does not exist.");
    }

    public List<ECKeyPair> getEcKeyPairsForTransactionList() throws RuntimeException {
        if (this.ecKeyPairForTransactionList.size() > 0) {
            return this.ecKeyPairForTransactionList;
        }
        throw new RuntimeException("Transaction key does not exist.");
    }

    public List<ECKeyPair> getEcKeyPairsForUpdateList() throws RuntimeException {
        if (this.ecKeyPairForUpdateList.size() > 0) {
            return this.ecKeyPairForUpdateList;
        }
        if (this.ecKeyPairForTransactionList.size() > 0) {
            return this.ecKeyPairForTransactionList;
        }
        throw new RuntimeException("Update key does not exist.");
    }

    public List<ECKeyPair> getEcKeyPairsForFeePayerList() throws RuntimeException {
        if (this.ecKeyPairForFeeFeePayerList.size() > 0) {
            return this.ecKeyPairForFeeFeePayerList;
        }
        if (this.ecKeyPairForTransactionList.size() > 0) {
            return this.ecKeyPairForTransactionList;
        }
        throw new RuntimeException("Fee key does not exist.");
    }

    public List<List<ECKeyPair>> getRawEcKeyPairs() {
        ArrayList<List<ECKeyPair>> ecKeyPairs = new ArrayList<List<ECKeyPair>>();
        ecKeyPairs.add(this.ecKeyPairForTransactionList);
        ecKeyPairs.add(this.ecKeyPairForUpdateList);
        ecKeyPairs.add(this.ecKeyPairForFeeFeePayerList);
        return ecKeyPairs;
    }

    public String getAddress() {
        return this.address;
    }

    public static KlayCredentials create(String privateKey) {
        ECKeyPair ecKeyPair = ECKeyPair.create((BigInteger)Numeric.toBigInt((String)privateKey));
        String address = Numeric.prependHexPrefix((String)Keys.getAddress((ECKeyPair)ecKeyPair));
        return KlayCredentials.create(ecKeyPair, address);
    }

    public static KlayCredentials create(ECKeyPair ecKeyPair) {
        String address = Numeric.prependHexPrefix((String)Keys.getAddress((ECKeyPair)ecKeyPair));
        return KlayCredentials.create(ecKeyPair, address);
    }

    public static KlayCredentials create(String privateKey, String address) {
        return KlayCredentials.create(ECKeyPair.create((BigInteger)Numeric.toBigInt((String)privateKey)), Numeric.prependHexPrefix((String)address));
    }

    public static KlayCredentials create(ECKeyPair ecKeyPair, String address) {
        return new KlayCredentials(ecKeyPair, address);
    }

    public static KlayCredentials create(List<ECKeyPair> ecKeyPair, String address) {
        return new KlayCredentials(ecKeyPair, null, null, address);
    }

    public static KlayCredentials create(List<ECKeyPair> ecKeyPairForTransaction, List<ECKeyPair> ecKeyPairForUpdate, List<ECKeyPair> ecKeyPairForFeePayer, String address) {
        return new KlayCredentials(ecKeyPairForTransaction, ecKeyPairForUpdate, ecKeyPairForFeePayer, address);
    }

    public static KlayCredentials create(ECKeyPair[] ecKeyPairsArrayForTransaction, ECKeyPair[] ecKeyPairsArrayForUpdate, ECKeyPair[] ecKeyPairArrayForFeePayer, String address) {
        List<ECKeyPair> ecKeyPairsForTransaction = Arrays.asList(ecKeyPairsArrayForTransaction);
        List<ECKeyPair> ecKeyPairsForUpdate = Arrays.asList(ecKeyPairsArrayForUpdate);
        List<ECKeyPair> ecKeyPairsForForFeePayer = Arrays.asList(ecKeyPairArrayForFeePayer);
        return KlayCredentials.create(ecKeyPairsForTransaction, ecKeyPairsForUpdate, ecKeyPairsForForFeePayer, address);
    }

    public static KlayCredentials create(String[] privateKeyArrayForTransaction, String[] privateKeyArrayForUpdate, String[] privateKeyArrayForFeePayer, String address) {
        ArrayList<ECKeyPair> ecKeyPairsForTransaction = new ArrayList<ECKeyPair>();
        ArrayList<ECKeyPair> ecKeyPairsForUpdate = new ArrayList<ECKeyPair>();
        ArrayList<ECKeyPair> ecKeyPairsForForFeePayer = new ArrayList<ECKeyPair>();
        for (String privateKey : privateKeyArrayForTransaction) {
            ecKeyPairsForTransaction.add(ECKeyPair.create((BigInteger)Numeric.toBigInt((String)privateKey)));
        }
        for (String privateKey : privateKeyArrayForUpdate) {
            ecKeyPairsForUpdate.add(ECKeyPair.create((BigInteger)Numeric.toBigInt((String)privateKey)));
        }
        for (String privateKey : privateKeyArrayForFeePayer) {
            ecKeyPairsForForFeePayer.add(ECKeyPair.create((BigInteger)Numeric.toBigInt((String)privateKey)));
        }
        return KlayCredentials.create(ecKeyPairsForTransaction, ecKeyPairsForUpdate, ecKeyPairsForForFeePayer, address);
    }

    public static KlayCredentials createRoleBased(List<List<ECKeyPair>> ecKeyPairListForRoleBased, String address) {
        ArrayList<ECKeyPair> ecKeyPairsForTransaction = new ArrayList<ECKeyPair>();
        ArrayList<ECKeyPair> ecKeyPairsForUpdate = new ArrayList<ECKeyPair>();
        ArrayList<ECKeyPair> ecKeyPairsForForFeePayer = new ArrayList<ECKeyPair>();
        Iterator<List<ECKeyPair>> iterator = ecKeyPairListForRoleBased.iterator();
        if (iterator.hasNext()) {
            for (ECKeyPair ecKeyPair : iterator.next()) {
                ecKeyPairsForTransaction.add(ecKeyPair);
            }
        }
        if (iterator.hasNext()) {
            for (ECKeyPair ecKeyPair : iterator.next()) {
                ecKeyPairsForUpdate.add(ecKeyPair);
            }
        }
        if (iterator.hasNext()) {
            for (ECKeyPair ecKeyPair : iterator.next()) {
                ecKeyPairsForForFeePayer.add(ecKeyPair);
            }
        }
        return KlayCredentials.create(ecKeyPairsForTransaction, ecKeyPairsForUpdate, ecKeyPairsForForFeePayer, address);
    }

    public static KlayCredentials create(String[] privateKeyArrayForTransaction, String address) {
        ArrayList<ECKeyPair> ecKeyPairsForTransaction = new ArrayList<ECKeyPair>();
        for (String privateKey : privateKeyArrayForTransaction) {
            ecKeyPairsForTransaction.add(ECKeyPair.create((BigInteger)Numeric.toBigInt((String)privateKey)));
        }
        return KlayCredentials.create(ecKeyPairsForTransaction, null, null, address);
    }

    public static KlayCredentials createWithKlaytnWalletKey(String klaytnWalletKey) {
        klaytnWalletKey = Numeric.cleanHexPrefix((String)klaytnWalletKey);
        String privateKey = klaytnWalletKey.substring(0, 64);
        String address = klaytnWalletKey.substring(68);
        return KlayCredentials.create(privateKey, address);
    }

    public String getKlaytnWalletKey() {
        if (!this.canExportKlaytnWalletKey()) {
            throw new RuntimeException("The account cannot be exported in KlaytnWalletKey format. Use the WalletFile.createFull(String password, KlayCredentials klayCredentials) or WalletFile.createStandard(String password, KlayCredentials klayCredentials)");
        }
        return Numeric.toHexStringWithPrefixZeroPadded((BigInteger)this.getEcKeyPair().getPrivateKey(), (int)64) + "0x00" + this.getAddress();
    }

    private boolean canExportKlaytnWalletKey() {
        return this.ecKeyPairForTransactionList.size() == 1 && this.ecKeyPairForUpdateList.size() == 0 && this.ecKeyPairForFeeFeePayerList.size() == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KlayCredentials that = (KlayCredentials)o;
        if (!Objects.equals(this.ecKeyPairForTransactionList, that.ecKeyPairForTransactionList)) {
            return false;
        }
        if (!Objects.equals(this.ecKeyPairForUpdateList, that.ecKeyPairForUpdateList)) {
            return false;
        }
        if (!Objects.equals(this.ecKeyPairForFeeFeePayerList, that.ecKeyPairForFeeFeePayerList)) {
            return false;
        }
        return Objects.equals(this.address, that.address);
    }

    public int hashCode() {
        int transactionHashCode = this.ecKeyPairForTransactionList.hashCode();
        int updateHashCode = this.ecKeyPairForUpdateList.hashCode();
        int feeHashCode = this.ecKeyPairForUpdateList.hashCode();
        int addressHashCode = this.address.hashCode();
        int[] arrHashCode = new int[]{transactionHashCode, updateHashCode, feeHashCode, addressHashCode};
        int result = 0;
        for (int hashCode : arrHashCode) {
            result = result * 31 + hashCode;
        }
        return result;
    }
}

