/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.contract;

import java.util.List;

public class ContractIOType {
    String name;
    String type;
    boolean indexed;
    List<ContractIOType> components;

    public ContractIOType() {
    }

    public ContractIOType(String name, String type, boolean indexed) {
        this.name = name;
        this.type = type;
        this.indexed = indexed;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public List<ContractIOType> getComponents() {
        return this.components;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setIndexed(boolean indexed) {
        this.indexed = indexed;
    }

    public void setComponents(List<ContractIOType> components) {
        this.components = components;
    }

    public String getTypeAsString() {
        if (this.getType().contains("tuple")) {
            String typeString = this.getComponentAsString();
            return this.getType().replace("tuple", "tuple" + typeString);
        }
        return this.getType();
    }

    private String getComponentAsString() {
        if (this.getComponents() == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("(");
        for (int i = 0; i < this.getComponents().size(); ++i) {
            ContractIOType ioType = this.components.get(i);
            stringBuilder.append(ioType.getTypeAsString());
            if (i >= this.getComponents().size() - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.append(")").toString();
    }
}

