/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.contract;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.klaytn.caver.Caver;
import com.klaytn.caver.abi.ABI;
import com.klaytn.caver.abi.datatypes.Type;
import com.klaytn.caver.contract.ContractDeployParams;
import com.klaytn.caver.contract.ContractEvent;
import com.klaytn.caver.contract.ContractMethod;
import com.klaytn.caver.contract.EventFilterOptions;
import com.klaytn.caver.contract.SendOptions;
import com.klaytn.caver.methods.request.CallObject;
import com.klaytn.caver.methods.request.KlayLogFilter;
import com.klaytn.caver.methods.response.Bytes32;
import com.klaytn.caver.methods.response.KlayLogs;
import com.klaytn.caver.methods.response.TransactionReceipt;
import com.klaytn.caver.transaction.response.PollingTransactionReceiptProcessor;
import com.klaytn.caver.transaction.response.TransactionReceiptProcessor;
import com.klaytn.caver.transaction.type.SmartContractDeploy;
import com.klaytn.caver.utils.CodeFormat;
import com.klaytn.caver.wallet.IWallet;
import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.methods.response.EthSubscribe;
import org.web3j.protocol.exceptions.TransactionException;
import org.web3j.protocol.websocket.events.LogNotification;

public class Contract {
    Caver caver;
    String abi;
    String contractAddress;
    Map<String, ContractMethod> methods;
    Map<String, ContractEvent> events;
    ContractMethod constructor;
    SendOptions defaultSendOptions;
    IWallet wallet;
    private static final Logger LOGGER = LoggerFactory.getLogger(Contract.class);

    public Contract(Caver caver, String abi) throws IOException {
        this(caver, abi, null);
    }

    public Contract(Caver caver, String abi, String contractAddress) throws IOException {
        this.setAbi(abi);
        this.setCaver(caver);
        this.setContractAddress(contractAddress);
        this.setDefaultSendOptions(new SendOptions());
        this.setWallet(caver.getWallet());
    }

    public Contract deploy(SendOptions sendOptions, String contractBinaryData, Object ... constructorParams) throws TransactionException, IOException, NoSuchMethodException, InstantiationException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        ContractDeployParams deployParams = new ContractDeployParams(contractBinaryData, Arrays.asList(constructorParams));
        return this.deploy(deployParams, sendOptions);
    }

    public Contract deploy(SendOptions sendOptions, TransactionReceiptProcessor receiptProcessor, String contractBinaryData, Object ... constructorParams) throws TransactionException, IOException, NoSuchMethodException, InstantiationException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        ContractDeployParams deployParams = new ContractDeployParams(contractBinaryData, Arrays.asList(constructorParams));
        return this.deploy(deployParams, sendOptions, receiptProcessor);
    }

    public Contract deploy(ContractDeployParams deployParam, SendOptions sendOptions) throws TransactionException, IOException, NoSuchMethodException, InstantiationException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        return this.deploy(deployParam, sendOptions, new PollingTransactionReceiptProcessor(this.caver, 1000L, 15));
    }

    public Contract deploy(ContractDeployParams deployParam, SendOptions sendOptions, TransactionReceiptProcessor processor) throws TransactionException, IOException, NoSuchMethodException, InstantiationException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        String input = ABI.encodeContractDeploy(this.getConstructor(), deployParam.getBytecode(), deployParam.getDeployParams());
        SmartContractDeploy smartContractDeploy = ((SmartContractDeploy.Builder)((SmartContractDeploy.Builder)((SmartContractDeploy.Builder)new SmartContractDeploy.Builder().setKlaytnCall(this.caver.rpc.klay)).setFrom(sendOptions.getFrom())).setInput(input).setCodeFormat(CodeFormat.EVM).setHumanReadable(false).setGas(sendOptions.getGas())).build();
        this.wallet.sign(sendOptions.getFrom(), smartContractDeploy);
        Bytes32 response = (Bytes32)this.caver.rpc.klay.sendRawTransaction(smartContractDeploy.getRawTransaction()).send();
        if (response.hasError()) {
            throw new IOException(response.getError().getMessage());
        }
        TransactionReceipt.TransactionReceiptData receipt = processor.waitForTransactionReceipt((String)response.getResult());
        String contractAddress = receipt.getContractAddress();
        this.setContractAddress(contractAddress);
        return this;
    }

    public Disposable once(String eventName, EventFilterOptions paramsOption, Consumer<LogNotification> callback) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        List<String> topics = null;
        if (eventName.equals("allEvents")) {
            if (paramsOption != null) {
                LOGGER.warn("If eventName has 'allEvent', passed paramOption will be ignored.");
            }
        } else {
            ContractEvent event = this.getEvent(eventName);
            topics = paramsOption.getTopics() == null || paramsOption.getTopics().size() == 0 ? EventFilterOptions.convertsTopic(event, paramsOption) : paramsOption.getTopics();
        }
        options.put("address", this.getContractAddress());
        options.put("topics", topics);
        Request subscribeRequest = new Request("klay_subscribe", Arrays.asList("logs", options), this.caver.rpc.getWeb3jService(), EthSubscribe.class);
        Flowable events = this.caver.rpc.getWeb3jService().subscribe(subscribeRequest, "klay_unsubscribe", LogNotification.class);
        return events.take(1L).subscribe(callback);
    }

    public KlayLogs getPastEvent(String eventName, KlayLogFilter filterOption) throws IOException {
        ContractEvent event = this.getEvent(eventName);
        filterOption.addSingleTopic(ABI.encodeEventSignature(event));
        KlayLogs logs = (KlayLogs)this.caver.rpc.klay.getLogs(filterOption).send();
        return logs;
    }

    public List<Type> call(String methodName, Object ... methodArguments) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return this.call(CallObject.createCallObject(), methodName, methodArguments);
    }

    public List<Type> call(CallObject callObject, String methodName, Object ... methodArguments) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        ContractMethod contractMethod = this.getMethod(methodName);
        return contractMethod.call(Arrays.asList(methodArguments), callObject);
    }

    public List<Type> callWithSolidityType(String methodName, Type ... methodArguments) throws IOException, ClassNotFoundException {
        return this.callWithSolidityType(CallObject.createCallObject(), methodName, methodArguments);
    }

    public List<Type> callWithSolidityType(CallObject callObject, String methodName, Type ... methodArguments) throws IOException, ClassNotFoundException {
        ContractMethod contractMethod = this.getMethod(methodName);
        return contractMethod.callWithSolidityWrapper(Arrays.asList(methodArguments), callObject);
    }

    public TransactionReceipt.TransactionReceiptData send(String methodName, Object ... methodArguments) throws TransactionException, IOException, NoSuchMethodException, InstantiationException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        return this.send(null, methodName, methodArguments);
    }

    public TransactionReceipt.TransactionReceiptData send(SendOptions options, String methodName, Object ... methodArguments) throws TransactionException, IOException, NoSuchMethodException, InstantiationException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        return this.send(options, new PollingTransactionReceiptProcessor(this.caver, 1000L, 15), methodName, methodArguments);
    }

    public TransactionReceipt.TransactionReceiptData send(SendOptions options, TransactionReceiptProcessor receiptProcessor, String methodName, Object ... methodArguments) throws TransactionException, IOException, NoSuchMethodException, InstantiationException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        ContractMethod contractMethod = this.getMethod(methodName);
        return contractMethod.send(Arrays.asList(methodArguments), options, receiptProcessor);
    }

    public TransactionReceipt.TransactionReceiptData sendWithSolidityType(String methodName, Type ... methodArguments) throws IOException, TransactionException {
        return this.sendWithSolidityType(null, methodName, methodArguments);
    }

    public TransactionReceipt.TransactionReceiptData sendWithSolidityType(SendOptions options, String methodName, Type ... methodArguments) throws IOException, TransactionException {
        return this.sendWithSolidityType(options, new PollingTransactionReceiptProcessor(this.caver, 1000L, 15), methodName, methodArguments);
    }

    public TransactionReceipt.TransactionReceiptData sendWithSolidityType(SendOptions options, TransactionReceiptProcessor receiptProcessor, String methodName, Type ... methodArguments) throws IOException, TransactionException {
        ContractMethod contractMethod = this.getMethod(methodName);
        return contractMethod.sendWithSolidityWrapper(Arrays.asList(methodArguments), options, receiptProcessor);
    }

    public String encodeABI(String methodName, Object ... methodArguments) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        ContractMethod method = this.getMethod(methodName);
        return method.encodeABI(Arrays.asList(methodArguments));
    }

    public String encodeABIWithSolidityType(String methodName, Type ... methodArguments) {
        ContractMethod method = this.getMethod(methodName);
        return method.encodeABIWithSolidityWrapper(Arrays.asList(methodArguments));
    }

    public String estimateGas(CallObject callObject, String methodName, Object ... methodArguments) throws NoSuchMethodException, IOException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        ContractMethod method = this.getMethod(methodName);
        return method.estimateGas(Arrays.asList(methodArguments), callObject);
    }

    public String estimateGasWithSolidityType(CallObject callObject, String methodName, Type ... methodArguments) throws IOException {
        ContractMethod method = this.getMethod(methodName);
        return method.estimateGasWithSolidityWrapper(Arrays.asList(methodArguments), callObject);
    }

    public ContractMethod getMethod(String methodName) {
        ContractMethod contractMethod = this.getMethods().get(methodName);
        if (contractMethod == null) {
            throw new NullPointerException(methodName + " method is not exist.");
        }
        return this.getMethods().get(methodName);
    }

    public ContractEvent getEvent(String eventName) {
        ContractEvent contractEvent = this.getEvents().get(eventName);
        if (contractEvent == null) {
            throw new NullPointerException(eventName + " event is not exist.");
        }
        return this.getEvents().get(eventName);
    }

    public Caver getCaver() {
        return this.caver;
    }

    public String getAbi() {
        return this.abi;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public Map<String, ContractMethod> getMethods() {
        return this.methods;
    }

    public Map<String, ContractEvent> getEvents() {
        return this.events;
    }

    public ContractMethod getConstructor() {
        return this.constructor;
    }

    public SendOptions getDefaultSendOptions() {
        return this.defaultSendOptions;
    }

    public IWallet getWallet() {
        return this.wallet;
    }

    void setCaver(Caver caver) {
        this.caver = caver;
        if (this.methods != null && this.methods.size() != 0) {
            this.getMethods().values().forEach(value -> value.setCaver(caver));
        }
    }

    void setAbi(String abi) throws IOException {
        this.abi = abi;
        this.init(this.abi);
    }

    void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
        if (this.methods != null && this.methods.size() != 0) {
            this.getMethods().values().forEach(value -> value.setContractAddress(this.contractAddress));
        }
    }

    void setMethods(Map<String, ContractMethod> methods) {
        this.methods = methods;
    }

    void setEvents(Map<String, ContractEvent> events) {
        this.events = events;
    }

    void setConstructor(ContractMethod constructor) {
        this.constructor = constructor;
    }

    public void setWallet(IWallet wallet) {
        this.wallet = wallet;
        if (this.methods != null && this.methods.size() != 0) {
            this.getMethods().values().forEach(value -> value.setWallet(this.wallet));
        }
    }

    public void setDefaultSendOptions(SendOptions defaultSendOptions) {
        this.defaultSendOptions = defaultSendOptions;
        if (this.methods != null && this.methods.size() != 0) {
            this.getMethods().values().forEach(value -> value.setDefaultSendOptions(this.defaultSendOptions));
        }
    }

    private void init(String abi) throws IOException {
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        this.methods = new HashMap<String, ContractMethod>();
        this.events = new HashMap<String, ContractEvent>();
        JsonNode root = objectMapper.readTree(abi);
        for (JsonNode element : root) {
            ContractMethod method;
            if (element.get("type").asText().equals("function")) {
                ContractMethod newMethod = (ContractMethod)objectMapper.readValue(element.toString(), ContractMethod.class);
                newMethod.setSignature(ABI.encodeFunctionSignature(newMethod));
                ContractMethod existedMethod = this.methods.get(newMethod.getName());
                if (existedMethod != null) {
                    boolean isWarning = existedMethod.getNextContractMethods().stream().anyMatch(contractMethod -> contractMethod.getInputs().size() == newMethod.getInputs().size());
                    if (existedMethod.getInputs().size() == newMethod.getInputs().size() || isWarning) {
                        LOGGER.warn("An overloaded function with the same number of parameters may not be executed normally. Please use *withSolidityWrapper methods in ContractMethod class.");
                    }
                    existedMethod.getNextContractMethods().add(newMethod);
                    continue;
                }
                this.methods.put(newMethod.getName(), newMethod);
                continue;
            }
            if (element.get("type").asText().equals("event")) {
                ContractEvent event = (ContractEvent)objectMapper.readValue(element.toString(), ContractEvent.class);
                event.setSignature(ABI.encodeEventSignature(event));
                this.events.put(event.getName(), event);
                continue;
            }
            if (!element.get("type").asText().equals("constructor")) continue;
            this.constructor = method = (ContractMethod)objectMapper.readValue(element.toString(), ContractMethod.class);
        }
    }
}

