/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.account;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.klaytn.caver.utils.Utils;
import java.io.IOException;
import java.math.BigInteger;
import org.web3j.utils.Numeric;

@JsonDeserialize(using=WeightedPublicKeyDeserializer.class)
@JsonSerialize(using=WeightedPublicKeySerializer.class)
public class WeightedPublicKey {
    private String publicKey;
    BigInteger weight;
    public static final int OFFSET_WEIGHT = 0;
    public static final int OFFSET_PUBLIC_KEY = 1;

    public WeightedPublicKey(String publicKey, BigInteger weight) {
        this.setPublicKey(publicKey);
        this.weight = weight;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        if (!Utils.isValidPublicKey(publicKey)) {
            throw new IllegalArgumentException("Invalid Public key format");
        }
        this.publicKey = publicKey;
    }

    public BigInteger getWeight() {
        return this.weight;
    }

    public void setWeight(BigInteger weight) {
        this.weight = weight;
    }

    public String[] encodeToBytes() {
        if (this.publicKey == null) {
            throw new RuntimeException("public key should be specified for a multisig account");
        }
        if (this.weight == null) {
            throw new RuntimeException("weight should be specified for a multisig account");
        }
        String compressedKey = Utils.compressPublicKey(this.publicKey);
        return new String[]{Numeric.toHexStringWithPrefix((BigInteger)this.weight), compressedKey};
    }

    public static class WeightedPublicKeyDeserializer
    extends JsonDeserializer<WeightedPublicKey> {
        public WeightedPublicKey deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            BigInteger weight = node.get("weight").bigIntegerValue();
            JsonNode key = node.get("key");
            String xPoint_padded = Numeric.toHexStringWithPrefixZeroPadded((BigInteger)Numeric.toBigInt((String)key.get("x").asText()), (int)64);
            String yPoint_padded = Numeric.toHexStringWithPrefixZeroPadded((BigInteger)Numeric.toBigInt((String)key.get("y").asText()), (int)64);
            String publicKey = Numeric.prependHexPrefix((String)xPoint_padded) + Numeric.cleanHexPrefix((String)yPoint_padded);
            return new WeightedPublicKey(publicKey, weight);
        }
    }

    public static class WeightedPublicKeySerializer
    extends JsonSerializer<WeightedPublicKey> {
        public void serialize(WeightedPublicKey weightedPublicKey, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName("weight");
            jsonGenerator.writeNumber(weightedPublicKey.weight);
            String decompressedKey = Utils.decompressPublicKey(weightedPublicKey.publicKey);
            String stripHexKey = Utils.stripHexPrefix(decompressedKey);
            jsonGenerator.writeFieldName("key");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("x", Utils.addHexPrefix(stripHexKey.substring(0, 64)));
            jsonGenerator.writeStringField("y", Utils.addHexPrefix(stripHexKey.substring(64)));
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
        }
    }
}

