/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.account;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.klaytn.caver.account.IAccountKey;
import com.klaytn.caver.account.WeightedMultiSigOptions;
import com.klaytn.caver.account.WeightedPublicKey;
import com.klaytn.caver.utils.BytesUtils;
import com.klaytn.caver.utils.Utils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

@JsonDeserialize(using=AccountKeyWeightedMultiSigDeserializer.class)
@JsonSerialize(using=AccountKeyWeightedMultiSigSerializer.class)
public class AccountKeyWeightedMultiSig
implements IAccountKey {
    private static final String TYPE = "0x04";
    private BigInteger threshold;
    private List<WeightedPublicKey> weightedPublicKeys;

    private AccountKeyWeightedMultiSig(BigInteger threshold, List<WeightedPublicKey> weightedPublicKeys) {
        this.threshold = threshold;
        this.weightedPublicKeys = weightedPublicKeys;
    }

    public static AccountKeyWeightedMultiSig decode(String rlpEncodedKey) {
        return AccountKeyWeightedMultiSig.decode(Numeric.hexStringToByteArray((String)rlpEncodedKey));
    }

    public static AccountKeyWeightedMultiSig decode(byte[] rlpEncodedKey) {
        byte type = Numeric.hexStringToByteArray((String)TYPE)[0];
        if (rlpEncodedKey[0] != type) {
            throw new IllegalArgumentException("Invalid RLP-encoded AccountKeyWeightedMultiSig Tag");
        }
        byte[] encodedAccountKey = Arrays.copyOfRange(rlpEncodedKey, 1, rlpEncodedKey.length);
        RlpList rlpList = RlpDecoder.decode((byte[])encodedAccountKey);
        RlpList values = (RlpList)rlpList.getValues().get(0);
        BigInteger threshold = ((RlpString)values.getValues().get(0)).asPositiveBigInteger();
        ArrayList<WeightedPublicKey> weightedPublicKeys = new ArrayList<WeightedPublicKey>();
        RlpList rlpWeightedPublicKeys = (RlpList)values.getValues().get(1);
        for (RlpType item : rlpWeightedPublicKeys.getValues()) {
            RlpList rlpWeightedPublicKey = (RlpList)item;
            BigInteger weight = ((RlpString)rlpWeightedPublicKey.getValues().get(0)).asPositiveBigInteger();
            String compressedPublicKey = ((RlpString)rlpWeightedPublicKey.getValues().get(1)).asString();
            weightedPublicKeys.add(new WeightedPublicKey(compressedPublicKey, weight));
        }
        return new AccountKeyWeightedMultiSig(threshold, weightedPublicKeys);
    }

    public static AccountKeyWeightedMultiSig fromPublicKeysAndOptions(String[] publicKeyArr, WeightedMultiSigOptions options) {
        if (publicKeyArr.length > 10) {
            throw new IllegalArgumentException("It exceeds maximum public key count.");
        }
        if (publicKeyArr.length != options.getWeights().size()) {
            throw new IllegalArgumentException("The count of public keys is not equal to the length of weight array.");
        }
        ArrayList<WeightedPublicKey> weightedPublicKeyList = new ArrayList<WeightedPublicKey>();
        for (int i = 0; i < publicKeyArr.length; ++i) {
            weightedPublicKeyList.add(new WeightedPublicKey(publicKeyArr[i], options.getWeights().get(i)));
        }
        return new AccountKeyWeightedMultiSig(options.getThreshold(), weightedPublicKeyList);
    }

    @Override
    public String getRLPEncoding() {
        if (this.threshold == null || this.weightedPublicKeys == null) {
            throw new NullPointerException("threshold or weightedPublicKeys must be exists for multisig.");
        }
        if (this.weightedPublicKeys.size() == 0) {
            throw new RuntimeException("weightedPublicKeys must have items for multisig.");
        }
        ArrayList<Object> rlpTypeList = new ArrayList<Object>();
        rlpTypeList.add(RlpString.create((BigInteger)this.threshold));
        ArrayList<RlpList> rlpWeightedPublicKeyList = new ArrayList<RlpList>();
        for (WeightedPublicKey item : this.weightedPublicKeys) {
            if (item.getPublicKey() == null) {
                throw new RuntimeException("public key should be specified for a multisig account");
            }
            if (item.getWeight() == null) {
                throw new RuntimeException("weight should be specified for a multisig account");
            }
            ArrayList<RlpString> rlpWeightedPublicKey = new ArrayList<RlpString>();
            BigInteger weight = item.getWeight();
            String compressedKey = Utils.compressPublicKey(item.getPublicKey());
            rlpWeightedPublicKey.addAll(Arrays.asList(RlpString.create((BigInteger)weight), RlpString.create((byte[])Numeric.hexStringToByteArray((String)compressedKey))));
            rlpWeightedPublicKeyList.add(new RlpList(rlpWeightedPublicKey));
        }
        rlpTypeList.add(new RlpList(rlpWeightedPublicKeyList));
        byte[] encodedWeightedKey = RlpEncoder.encode((RlpType)new RlpList(rlpTypeList));
        byte[] type = Numeric.hexStringToByteArray((String)AccountKeyWeightedMultiSig.getType());
        return Numeric.toHexString((byte[])BytesUtils.concat(type, encodedWeightedKey));
    }

    public BigInteger getThreshold() {
        return this.threshold;
    }

    public List<WeightedPublicKey> getWeightedPublicKeys() {
        return this.weightedPublicKeys;
    }

    public static String getType() {
        return TYPE;
    }

    public static class AccountKeyWeightedMultiSigDeserializer
    extends JsonDeserializer<AccountKeyWeightedMultiSig> {
        private static ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();

        public AccountKeyWeightedMultiSig deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            byte type = (byte)node.get("keyType").intValue();
            JsonNode key = node.get("key");
            BigInteger threshold = key.get("threshold").bigIntegerValue();
            JsonNode keys = key.get("keys");
            Iterator iterator = keys.iterator();
            ArrayList<WeightedPublicKey> weightedPublicKeyList = new ArrayList<WeightedPublicKey>();
            while (iterator.hasNext()) {
                JsonNode jsonNode = (JsonNode)iterator.next();
                WeightedPublicKey weightedPublicKey = (WeightedPublicKey)objectMapper.readValue(jsonNode.toString(), WeightedPublicKey.class);
                weightedPublicKeyList.add(weightedPublicKey);
            }
            return new AccountKeyWeightedMultiSig(threshold, weightedPublicKeyList);
        }
    }

    public static class AccountKeyWeightedMultiSigSerializer
    extends JsonSerializer<AccountKeyWeightedMultiSig> {
        public void serialize(AccountKeyWeightedMultiSig accountKeyWeightedMultiSig, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName("keyType");
            jsonGenerator.writeNumber(Numeric.toBigInt((String)AccountKeyWeightedMultiSig.getType()));
            jsonGenerator.writeObjectFieldStart("key");
            jsonGenerator.writeFieldName("threshold");
            jsonGenerator.writeNumber(accountKeyWeightedMultiSig.getThreshold());
            jsonGenerator.writeArrayFieldStart("keys");
            for (WeightedPublicKey weightedPublicKey : accountKeyWeightedMultiSig.getWeightedPublicKeys()) {
                jsonGenerator.writeObject((Object)weightedPublicKey);
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
        }
    }
}

