/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.account;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.klaytn.caver.account.IAccountKey;
import java.io.IOException;
import java.util.Arrays;
import org.web3j.utils.Numeric;

@JsonSerialize(using=AccountKeyLegacySerializer.class)
public class AccountKeyLegacy
implements IAccountKey {
    private static final byte[] RLP = new byte[]{1, -64};
    private static final String TYPE = "0x01";

    public static AccountKeyLegacy decode(String rlpEncodedKey) {
        return AccountKeyLegacy.decode(Numeric.hexStringToByteArray((String)rlpEncodedKey));
    }

    public static AccountKeyLegacy decode(byte[] rlpEncodedKey) {
        if (!Arrays.equals(RLP, rlpEncodedKey)) {
            throw new RuntimeException("Invalid RLP-encoded account key String");
        }
        return new AccountKeyLegacy();
    }

    @Override
    public String getRLPEncoding() {
        return Numeric.toHexString((byte[])RLP);
    }

    public static String getType() {
        return TYPE;
    }

    public static class AccountKeyLegacySerializer
    extends JsonSerializer<AccountKeyLegacy> {
        public void serialize(AccountKeyLegacy value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeStartObject();
            gen.writeFieldName("keyType");
            gen.writeNumber(Numeric.toBigInt((String)AccountKeyLegacy.getType()));
            gen.writeFieldName("key");
            gen.writeStartObject();
            gen.writeEndObject();
            gen.writeEndObject();
        }
    }
}

