/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.account;

import com.klaytn.caver.account.AccountKeyDecoder;
import com.klaytn.caver.account.AccountKeyFail;
import com.klaytn.caver.account.AccountKeyLegacy;
import com.klaytn.caver.account.AccountKeyPublic;
import com.klaytn.caver.account.AccountKeyRoleBased;
import com.klaytn.caver.account.AccountKeyWeightedMultiSig;
import com.klaytn.caver.account.IAccountKey;
import com.klaytn.caver.account.WeightedMultiSigOptions;
import java.util.List;

public class Account {
    private String address;
    private IAccountKey accountKey;

    public Account(String address, IAccountKey accountKey) {
        this.address = address;
        this.accountKey = accountKey;
    }

    public static Account create(String address, String publicKey) {
        return Account.createWithAccountKeyPublic(address, publicKey);
    }

    public static Account create(String address, String[] publicKeys) {
        return Account.createWithAccountKeyWeightedMultiSig(address, publicKeys);
    }

    public static Account create(String address, String[] publicKeys, WeightedMultiSigOptions options) {
        return Account.createWithAccountKeyWeightedMultiSig(address, publicKeys, options);
    }

    public static Account create(String address, List<String[]> publicKeyList) {
        return Account.createWithAccountKeyRoleBased(address, publicKeyList);
    }

    public static Account create(String address, List<String[]> publicKeyList, List<WeightedMultiSigOptions> optionsList) {
        return Account.createWithAccountKeyRoleBased(address, publicKeyList, optionsList);
    }

    public static Account createFromRLPEncoding(String address, String rlpEncodedKey) {
        IAccountKey accountKey = AccountKeyDecoder.decode(rlpEncodedKey);
        return new Account(address, accountKey);
    }

    public static Account createWithAccountKeyLegacy(String address) {
        AccountKeyLegacy accountKey = new AccountKeyLegacy();
        return new Account(address, accountKey);
    }

    public static Account createWithAccountKeyFail(String address) {
        AccountKeyFail accountKey = new AccountKeyFail();
        return new Account(address, accountKey);
    }

    public static Account createWithAccountKeyPublic(String address, String publicKey) {
        AccountKeyPublic accountKey = AccountKeyPublic.fromPublicKey(publicKey);
        return new Account(address, accountKey);
    }

    public static Account createWithAccountKeyWeightedMultiSig(String address, String[] publicKeys) {
        WeightedMultiSigOptions options = WeightedMultiSigOptions.getDefaultOptionsForWeightedMultiSig(publicKeys);
        return Account.createWithAccountKeyWeightedMultiSig(address, publicKeys, options);
    }

    public static Account createWithAccountKeyWeightedMultiSig(String address, String[] publicKeys, WeightedMultiSigOptions options) {
        if (options == null) {
            throw new NullPointerException("The variable 'options' is undefined. To create an Account instance with AccountKeyWeightedMultiSig, 'options' should be defined.");
        }
        AccountKeyWeightedMultiSig accountKey = AccountKeyWeightedMultiSig.fromPublicKeysAndOptions(publicKeys, options);
        return new Account(address, accountKey);
    }

    public static Account createWithAccountKeyRoleBased(String address, List<String[]> roleBasedPublicKey) {
        List<WeightedMultiSigOptions> optionList = WeightedMultiSigOptions.getDefaultOptionsForRoleBased(roleBasedPublicKey);
        return Account.createWithAccountKeyRoleBased(address, roleBasedPublicKey, optionList);
    }

    public static Account createWithAccountKeyRoleBased(String address, List<String[]> roleBasedPublicKey, List<WeightedMultiSigOptions> optionsList) {
        if (optionsList == null) {
            throw new NullPointerException("The variable 'optionsList' is undefined. To create an Account instance with AccountKeyRoleBased, 'optionsList' should be defined");
        }
        AccountKeyRoleBased accountKey = AccountKeyRoleBased.fromRoleBasedPublicKeysAndOptions(roleBasedPublicKey, optionsList);
        return new Account(address, accountKey);
    }

    public String getRLPEncodingAccountKey() {
        return this.getAccountKey().getRLPEncoding();
    }

    public String getAddress() {
        return this.address;
    }

    public IAccountKey getAccountKey() {
        return this.accountKey;
    }
}

