/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.abi.datatypes.primitive;

import com.klaytn.caver.abi.datatypes.Type;
import java.io.Serializable;
import java.util.Objects;

public abstract class PrimitiveType<T extends Serializable & Comparable<T>>
implements Type<T> {
    private final String type = this.getClass().getSimpleName().toLowerCase();
    private final T value;

    PrimitiveType(T value) {
        this.value = value;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public String getTypeAsString() {
        return this.type;
    }

    public abstract Type toSolidityType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimitiveType that = (PrimitiveType)o;
        return this.type.equals(that.type) && this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.value);
    }
}

