/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.abi.datatypes;

import com.klaytn.caver.abi.datatypes.Type;
import java.math.BigInteger;
import java.util.Objects;

public abstract class NumericType
implements Type<BigInteger> {
    private String type;
    BigInteger value;

    public NumericType(String type, BigInteger value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public String getTypeAsString() {
        return this.type;
    }

    @Override
    public BigInteger getValue() {
        return this.value;
    }

    public abstract int getBitSize();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericType that = (NumericType)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

