/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.abi.datatypes;

import com.klaytn.caver.abi.datatypes.NumericType;
import java.math.BigInteger;

public abstract class FixedPointType
extends NumericType {
    static final int DEFAULT_BIT_LENGTH = 128;
    private final int bitSize;

    public FixedPointType(String typePrefix, int mBitSize, int nBitSize, BigInteger value) {
        super(typePrefix + mBitSize + "x" + nBitSize, value);
        this.bitSize = mBitSize + nBitSize;
        if (!this.valid(mBitSize, nBitSize, value)) {
            throw new UnsupportedOperationException("Bitsize must be 8 bit aligned, and in range 0 < bitSize <= 256");
        }
    }

    @Override
    public int getBitSize() {
        return this.bitSize;
    }

    boolean valid(int mBitSize, int nBitSize, BigInteger value) {
        return this.isValidBitSize(mBitSize, nBitSize) && FixedPointType.isValidBitCount(mBitSize, nBitSize, value);
    }

    private boolean isValidBitSize(int mBitSize, int nBitSize) {
        return mBitSize % 8 == 0 && nBitSize % 8 == 0 && this.bitSize > 0 && this.bitSize <= 256;
    }

    private static boolean isValidBitCount(int mBitSize, int nBitSize, BigInteger value) {
        return value.bitCount() <= mBitSize + nBitSize;
    }

    static BigInteger convert(BigInteger m, BigInteger n) {
        return FixedPointType.convert(128, 128, m, n);
    }

    static BigInteger convert(int mBitSize, int nBitSize, BigInteger m, BigInteger n) {
        BigInteger mPadded = m.shiftLeft(nBitSize);
        int nBitLength = n.bitLength();
        int shift = nBitLength + 3 & 0xFFFFFFFC;
        return mPadded.or(n.shiftLeft(nBitSize - shift));
    }
}

