/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.abi.datatypes;

import com.klaytn.caver.abi.datatypes.AbiTypes;
import com.klaytn.caver.abi.datatypes.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class Array<T extends Type>
implements Type<List<T>> {
    private final Class<T> type;
    protected final List<T> value;

    @Deprecated
    @SafeVarargs
    Array(String type, T ... values) {
        this(type, Arrays.asList(values));
    }

    @Deprecated
    Array(String type, List<T> values) {
        this(AbiTypes.getType(type), values);
    }

    @Deprecated
    Array(String type) {
        this(type, (List<T>)new ArrayList());
    }

    @SafeVarargs
    Array(Class<T> type, T ... values) {
        this(type, Arrays.asList(values));
    }

    Array(Class<T> type, List<T> values) {
        this.checkValid(type, values);
        this.type = type;
        this.value = values;
    }

    @Override
    public int bytes32PaddedLength() {
        int length = 0;
        for (Type t : this.value) {
            int valueLength = t.bytes32PaddedLength();
            length += valueLength;
        }
        return length;
    }

    @Override
    public List<T> getValue() {
        return this.value;
    }

    public Class<T> getComponentType() {
        return this.type;
    }

    @Override
    public abstract String getTypeAsString();

    private void checkValid(Class<T> type, List<T> values) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Array array = (Array)o;
        if (!this.type.equals(array.type)) {
            return false;
        }
        return Objects.equals(this.value, array.value);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

