/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.abi;

import com.klaytn.caver.abi.TypeMappingException;
import com.klaytn.caver.abi.TypeReference;
import com.klaytn.caver.abi.datatypes.DynamicArray;
import com.klaytn.caver.abi.datatypes.DynamicBytes;
import com.klaytn.caver.abi.datatypes.Fixed;
import com.klaytn.caver.abi.datatypes.Int;
import com.klaytn.caver.abi.datatypes.StaticArray;
import com.klaytn.caver.abi.datatypes.StaticStruct;
import com.klaytn.caver.abi.datatypes.StructType;
import com.klaytn.caver.abi.datatypes.Type;
import com.klaytn.caver.abi.datatypes.Ufixed;
import com.klaytn.caver.abi.datatypes.Uint;
import com.klaytn.caver.abi.datatypes.Utf8String;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Utils {
    private Utils() {
    }

    static <T extends Type> String getTypeName(TypeReference<T> typeReference) {
        try {
            java.lang.reflect.Type reflectedType = typeReference.getType();
            if (reflectedType instanceof ParameterizedType) {
                Class type = (Class)((ParameterizedType)reflectedType).getRawType();
                return Utils.getParameterizedTypeName(typeReference, type);
            }
            Class<?> type = Class.forName(reflectedType.getTypeName());
            return Utils.getSimpleTypeName(type);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    static String getSimpleTypeName(Class<?> type) {
        String simpleName = type.getSimpleName().toLowerCase();
        if (type.equals(Uint.class) || type.equals(Int.class) || type.equals(Ufixed.class) || type.equals(Fixed.class)) {
            return simpleName + "256";
        }
        if (type.equals(Utf8String.class)) {
            return "string";
        }
        if (type.equals(DynamicBytes.class)) {
            return "bytes";
        }
        if (StructType.class.isAssignableFrom(type)) {
            return type.getName();
        }
        return simpleName;
    }

    static <T extends Type, U extends Type> String getParameterizedTypeName(TypeReference<T> typeReference, Class<?> type) {
        try {
            if (type.equals(DynamicArray.class)) {
                Class<T> parameterizedType = Utils.getParameterizedTypeFromArray(typeReference);
                String parameterizedTypeName = Utils.getSimpleTypeName(parameterizedType);
                return parameterizedTypeName + "[]";
            }
            if (type.equals(StaticArray.class)) {
                Class<T> parameterizedType = Utils.getParameterizedTypeFromArray(typeReference);
                String parameterizedTypeName = Utils.getSimpleTypeName(parameterizedType);
                return parameterizedTypeName + "[" + ((TypeReference.StaticArrayTypeReference)typeReference).getSize() + "]";
            }
            throw new UnsupportedOperationException("Invalid type provided " + type.getName());
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    static <T extends Type> Class<T> getParameterizedTypeFromArray(TypeReference typeReference) throws ClassNotFoundException {
        java.lang.reflect.Type type = typeReference.getType();
        java.lang.reflect.Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
        String parameterizedTypeName = typeArguments[0].getTypeName();
        return Class.forName(parameterizedTypeName);
    }

    public static List<TypeReference<Type>> convert(List<TypeReference<?>> input) {
        ArrayList<TypeReference<Type>> result = new ArrayList<TypeReference<Type>>(input.size());
        result.addAll(input.stream().map(typeReference -> typeReference).collect(Collectors.toList()));
        return result;
    }

    public static <T, R extends Type<T>, E extends Type<T>> List<E> typeMap(List<List<T>> input, Class<E> outerDestType, Class<R> innerType) {
        ArrayList<Type> result = new ArrayList<Type>();
        try {
            Constructor<E> constructor = outerDestType.getDeclaredConstructor(Class.class, List.class);
            for (List<T> ts : input) {
                Type e = (Type)constructor.newInstance(innerType, Utils.typeMap(ts, innerType));
                result.add(e);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TypeMappingException(e);
        }
        return result;
    }

    public static <T, R extends Type<T>> List<R> typeMap(List<T> input, Class<R> destType) throws TypeMappingException {
        ArrayList<R> result = new ArrayList<R>(input.size());
        if (!input.isEmpty()) {
            try {
                Constructor<R> constructor = destType.getDeclaredConstructor(input.get(0).getClass());
                for (T value : input) {
                    result.add(constructor.newInstance(value));
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new TypeMappingException(e);
            }
        }
        return result;
    }

    static int getStaticArrayElementSize(StaticArray staticArray) {
        int count = 0;
        count = StaticStruct.class.isAssignableFrom(staticArray.getComponentType()) ? (count += staticArray.getValue().size() * Utils.getStaticStructComponentSize((StaticStruct)staticArray.getValue().get(0))) : (StaticArray.class.isAssignableFrom(staticArray.getComponentType()) ? (count += staticArray.getValue().size() * Utils.getStaticArrayElementSize((StaticArray)staticArray.getValue().get(0))) : (count += staticArray.getValue().size()));
        return count;
    }

    static int getStaticArrayElementSize(TypeReference.StaticArrayTypeReference arrayTypeRef) throws ClassNotFoundException {
        int count = 0;
        TypeReference baseTypeRef = arrayTypeRef.getSubTypeReference();
        count = StaticStruct.class.isAssignableFrom(baseTypeRef.getClassType()) ? (count += arrayTypeRef.getSize() * Utils.getStaticStructComponentSize((TypeReference.StructTypeReference)baseTypeRef)) : (StaticArray.class.isAssignableFrom(baseTypeRef.getClassType()) ? (count += arrayTypeRef.getSize() * Utils.getStaticArrayElementSize((TypeReference.StaticArrayTypeReference)baseTypeRef)) : (count += arrayTypeRef.getSize()));
        return count;
    }

    public static int getStaticStructComponentSize(StaticStruct staticStruct) {
        int count = 0;
        for (int i = 0; i < staticStruct.getValue().size(); ++i) {
            Type type = (Type)staticStruct.getValue().get(i);
            if (StaticStruct.class.isAssignableFrom(type.getClass())) {
                count += Utils.getStaticStructComponentSize((StaticStruct)type);
                continue;
            }
            if (StaticArray.class.isAssignableFrom(type.getClass())) {
                count += Utils.getStaticArrayElementSize((StaticArray)type);
                continue;
            }
            ++count;
        }
        return count;
    }

    static int getStaticStructComponentSize(TypeReference.StructTypeReference typeReference) throws ClassNotFoundException {
        int count = 0;
        for (int i = 0; i < typeReference.getTypeList().size(); ++i) {
            TypeReference componentTypeRef = typeReference.getTypeList().get(i);
            if (StaticStruct.class.isAssignableFrom(componentTypeRef.getClassType())) {
                count += Utils.getStaticStructComponentSize((TypeReference.StructTypeReference)componentTypeRef);
                continue;
            }
            if (StaticArray.class.isAssignableFrom(componentTypeRef.getClassType())) {
                TypeReference.StaticArrayTypeReference arrayTypeReference = (TypeReference.StaticArrayTypeReference)componentTypeRef;
                count += Utils.getStaticArrayElementSize(arrayTypeReference);
                continue;
            }
            ++count;
        }
        return count;
    }
}

