/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.abi;

import com.klaytn.caver.abi.FunctionReturnDecoder;
import com.klaytn.caver.abi.TypeDecoder;
import com.klaytn.caver.abi.TypeReference;
import com.klaytn.caver.abi.Utils;
import com.klaytn.caver.abi.datatypes.Array;
import com.klaytn.caver.abi.datatypes.Bytes;
import com.klaytn.caver.abi.datatypes.BytesType;
import com.klaytn.caver.abi.datatypes.DynamicArray;
import com.klaytn.caver.abi.datatypes.DynamicStruct;
import com.klaytn.caver.abi.datatypes.StaticStruct;
import com.klaytn.caver.abi.datatypes.Type;
import com.klaytn.caver.abi.datatypes.Utf8String;
import com.klaytn.caver.abi.datatypes.generated.Bytes32;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.web3j.utils.Numeric;
import org.web3j.utils.Strings;

public class DefaultFunctionReturnDecoder
extends FunctionReturnDecoder {
    @Override
    public List<Type> decodeFunctionResult(String rawInput, List<TypeReference<Type>> outputParameters) {
        String input = Numeric.cleanHexPrefix((String)rawInput);
        if (Strings.isEmpty((String)input)) {
            return Collections.emptyList();
        }
        return DefaultFunctionReturnDecoder.build(input, outputParameters);
    }

    @Override
    public <T extends Type> Type decodeEventParameter(String rawInput, TypeReference<T> typeReference) {
        String input = Numeric.cleanHexPrefix((String)rawInput);
        try {
            Class<T> type = typeReference.getClassType();
            if (Bytes.class.isAssignableFrom(type)) {
                Class<?> bytesClass = Class.forName(type.getName());
                return TypeDecoder.decodeBytes(input, bytesClass);
            }
            if (Array.class.isAssignableFrom(type) || BytesType.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type)) {
                return TypeDecoder.decodeBytes(input, Bytes32.class);
            }
            return TypeDecoder.decode(input, type);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    private static List<Type> build(String input, List<TypeReference<Type>> outputParameters) {
        ArrayList<Type> results = new ArrayList<Type>(outputParameters.size());
        int offset = 0;
        for (TypeReference<Type> typeReference : outputParameters) {
            try {
                Type result;
                int hexStringDataOffset = DefaultFunctionReturnDecoder.getDataOffset(input, offset, typeReference);
                Class<Type> classType = typeReference.getClassType();
                if (DynamicStruct.class.isAssignableFrom(classType)) {
                    result = TypeDecoder.decodeDynamicStruct(input, hexStringDataOffset, typeReference);
                    offset += 64;
                } else if (DynamicArray.class.isAssignableFrom(classType)) {
                    result = TypeDecoder.decodeDynamicArray(input, hexStringDataOffset, typeReference);
                    offset += 64;
                } else if (typeReference instanceof TypeReference.StaticArrayTypeReference) {
                    int length = ((TypeReference.StaticArrayTypeReference)typeReference).getSize();
                    result = TypeDecoder.decodeStaticArray(input, hexStringDataOffset, typeReference, length);
                    offset = TypeDecoder.isDynamic(typeReference) ? (offset += 64) : (offset += Utils.getStaticArrayElementSize((TypeReference.StaticArrayTypeReference)typeReference) * 64);
                } else if (StaticStruct.class.isAssignableFrom(classType)) {
                    result = TypeDecoder.decodeStaticStruct(input, hexStringDataOffset, typeReference);
                    offset += Utils.getStaticStructComponentSize((TypeReference.StructTypeReference)typeReference) * 64;
                } else {
                    result = TypeDecoder.decode(input, hexStringDataOffset, classType);
                    offset += 64;
                }
                results.add(result);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Invalid class reference provided", e);
            }
        }
        return results;
    }

    public static <T extends Type> int getDataOffset(String input, int offset, TypeReference<?> typeReference) throws ClassNotFoundException {
        if (TypeDecoder.isDynamic(typeReference)) {
            return TypeDecoder.decodeUintAsInt(input, offset) << 1;
        }
        return offset;
    }
}

