/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.abi;

import com.klaytn.caver.abi.DefaultFunctionEncoder;
import com.klaytn.caver.abi.EventValues;
import com.klaytn.caver.abi.FunctionReturnDecoder;
import com.klaytn.caver.abi.TypeDecoder;
import com.klaytn.caver.abi.TypeReference;
import com.klaytn.caver.abi.datatypes.Type;
import com.klaytn.caver.contract.ContractEvent;
import com.klaytn.caver.contract.ContractIOType;
import com.klaytn.caver.contract.ContractMethod;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.web3j.crypto.Hash;
import org.web3j.utils.Numeric;

public class ABI {
    public static String encodeFunctionCall(ContractMethod method, List<Object> params) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        String functionSignature = ABI.buildFunctionString(method);
        ArrayList<String> solTypeList = new ArrayList<String>();
        for (ContractIOType contractIOType : method.getInputs()) {
            solTypeList.add(contractIOType.getTypeAsString());
        }
        return ABI.encodeFunctionCall(functionSignature, solTypeList, params);
    }

    public static String encodeFunctionCall(String functionSig, List<String> solTypeList, List<Object> params) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        String methodId = ABI.encodeFunctionSignature(functionSig);
        String encodedParams = ABI.encodeParameters(solTypeList, params);
        return methodId + encodedParams;
    }

    public static String encodeFunctionCallWithSolidityWrapper(ContractMethod method, List<Type> params) {
        String methodId = ABI.encodeFunctionSignature(method);
        String encodedArguments = ABI.encodeParameters(params);
        return methodId + encodedArguments;
    }

    public static String encodeFunctionSignature(ContractMethod method) {
        return ABI.encodeFunctionSignature(ABI.buildFunctionString(method));
    }

    public static String encodeFunctionSignature(String functionName) {
        byte[] input = functionName.getBytes();
        byte[] hash = Hash.sha3((byte[])input);
        return Numeric.toHexString((byte[])hash).substring(0, 10);
    }

    public static String encodeContractDeploy(ContractMethod constructor, String byteCode, List<Object> constructorParams) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String encodedParam = "";
        if (constructor != null) {
            constructor.checkTypeValid(constructorParams);
            encodedParam = ABI.encodeParameters(constructor, constructorParams);
        }
        return byteCode + encodedParam;
    }

    public static String buildFunctionString(ContractMethod method) {
        StringBuilder result = new StringBuilder();
        result.append(method.getName());
        result.append("(");
        String params = method.getInputs().stream().map(ContractIOType::getTypeAsString).collect(Collectors.joining(","));
        result.append(params);
        result.append(")");
        return result.toString().replace("tuple", "");
    }

    public static String encodeEventSignature(ContractEvent event) {
        return ABI.encodeEventSignature(ABI.buildEventString(event));
    }

    public static String encodeEventSignature(String eventName) {
        byte[] input = eventName.getBytes();
        byte[] hash = Hash.sha3((byte[])input);
        return Numeric.toHexString((byte[])hash);
    }

    public static String buildEventString(ContractEvent event) {
        StringBuilder result = new StringBuilder();
        result.append(event.getName());
        result.append("(");
        String params = event.getInputs().stream().map(ContractIOType::getTypeAsString).collect(Collectors.joining(","));
        result.append(params);
        result.append(")");
        return result.toString().replace("tuple", "");
    }

    public static String encodeParameter(String solidityType, Object value) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Type type = TypeDecoder.instantiateType(solidityType, value);
        return ABI.encodeParameter(type);
    }

    public static String encodeParameters(ContractMethod method, List<Object> values) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        ArrayList<String> solTypeList = new ArrayList<String>();
        for (ContractIOType type : method.getInputs()) {
            solTypeList.add(type.getTypeAsString());
        }
        return ABI.encodeParameters(solTypeList, values);
    }

    public static String encodeParameters(List<String> solidityTypes, List<Object> values) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList<Type> typeList = new ArrayList<Type>();
        for (int i = 0; i < solidityTypes.size(); ++i) {
            Type type = TypeDecoder.instantiateType(solidityTypes.get(i), values.get(i));
            typeList.add(type);
        }
        return ABI.encodeParameters(typeList);
    }

    public static String encodeParameter(Type parameter) {
        return ABI.encodeParameters(Arrays.asList(parameter));
    }

    public static String encodeParameters(List<Type> parameters) {
        return new DefaultFunctionEncoder().encodeParameters(parameters);
    }

    public static Type decodeParameter(String solidityType, String encoded) throws ClassNotFoundException {
        return ABI.decodeParameters(Arrays.asList(solidityType), encoded).get(0);
    }

    public static List<Type> decodeParameters(List<String> solidityTypeList, String encoded) throws ClassNotFoundException {
        ArrayList<TypeReference<Type>> params = new ArrayList<TypeReference<Type>>();
        for (String solType : solidityTypeList) {
            params.add(TypeReference.makeTypeReference(solType));
        }
        return FunctionReturnDecoder.decode(encoded, params);
    }

    public static List<Type> decodeParameters(ContractMethod method, String encoded) throws ClassNotFoundException {
        ArrayList<TypeReference<Type>> resultParams = new ArrayList<TypeReference<Type>>();
        for (ContractIOType ioType : method.getOutputs()) {
            resultParams.add(TypeReference.makeTypeReference(ioType.getTypeAsString()));
        }
        return FunctionReturnDecoder.decode(encoded, resultParams);
    }

    public static EventValues decodeLog(List<ContractIOType> inputs, String data, List<String> topics) throws ClassNotFoundException {
        ArrayList<TypeReference> indexedList = new ArrayList<TypeReference>();
        ArrayList<TypeReference<Type>> nonIndexedList = new ArrayList<TypeReference<Type>>();
        for (ContractIOType input : inputs) {
            if (input.isIndexed()) {
                indexedList.add(TypeReference.makeTypeReference(input.getTypeAsString()));
                continue;
            }
            nonIndexedList.add(TypeReference.makeTypeReference(input.getTypeAsString()));
        }
        List<Type> nonIndexedValues = FunctionReturnDecoder.decode(data, nonIndexedList);
        ArrayList<Type> indexedValues = new ArrayList<Type>();
        for (int i = 0; i < indexedList.size(); ++i) {
            Type value = FunctionReturnDecoder.decodeIndexedValue(topics.get(i + 1), (TypeReference)indexedList.get(i));
            indexedValues.add(value);
        }
        return new EventValues(indexedValues, nonIndexedValues);
    }
}

