/*
 * Decompiled with CFR 0.152.
 */
package com.klaxit.hiddensecrets;

import com.android.build.gradle.AppExtension;
import com.klaxit.hiddensecrets.CodeGenerator;
import com.klaxit.hiddensecrets.HiddenSecretsPlugin;
import com.klaxit.hiddensecrets.Utils;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.CharRange;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/klaxit/hiddensecrets/HiddenSecretsPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "Companion", "HiddenSecretsPlugin"})
public class HiddenSecretsPlugin
implements Plugin<Project> {
    private static final String APP_MAIN_FOLDER = "src/main/";
    private static final int DEFAULT_KEY_NAME_LENGTH = 8;
    private static final String KEY_PLACEHOLDER = "YOUR_KEY_GOES_HERE";
    private static final String PACKAGE_PLACEHOLDER = "YOUR_PACKAGE_GOES_HERE";
    private static final String KOTLIN_FILE_NAME = "Secrets.kt";
    @NotNull
    public static final String TASK_GROUP = "Hide secrets";
    @NotNull
    public static final String TASK_UNZIP_HIDDEN_SECRETS = "unzipHiddenSecrets";
    @NotNull
    public static final String TASK_COPY_CPP = "copyCpp";
    @NotNull
    public static final String TASK_COPY_KOTLIN = "copyKotlin";
    @NotNull
    public static final String TASK_HIDE_SECRET = "hideSecret";
    @NotNull
    public static final String TASK_HIDE_SECRET_FROM_PROPERTIES_FILE = "hideSecretFromPropertiesFile";
    @NotNull
    public static final String TASK_OBFUSCATE = "obfuscate";
    @NotNull
    public static final String TASK_PACKAGE_NAME = "packageName";
    @NotNull
    public static final String TASK_FIND_KOTLIN_FILE = "findKotlinFile";
    private static final String PROP_KEY = "key";
    private static final String PROP_KEY_NAME = "keyName";
    private static final String PROP_PACKAGE = "package";
    private static final String PROP_FILE_NAME = "propertiesFileName";
    private static final String ERROR_EMPTY_KEY = "No key provided, use argument '-Pkey=yourKey'";
    private static final String ERROR_EMPTY_PACKAGE = "Empty package name, use argument '-Ppackage=your.package.name'";
    private static final String SAMPLE_FROM_PROPS = "-PpropertiesFileName=credentials.properties";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String tmpFolder = String.format("%s/hidden-secrets-tmp", project.getBuildDir());
        Function0<String> $fun$getAppPackageName$1 = new Function0<String>(project){
            final /* synthetic */ Project $project;

            @Nullable
            public final String invoke() {
                Object object = this.$project.getExtensions().getByName("android");
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.getByName(\"android\")");
                Object androidExtension = object;
                if (androidExtension instanceof AppExtension) {
                    return ((AppExtension)androidExtension).getDefaultConfig().getApplicationId();
                }
                return null;
            }
            {
                this.$project = project;
                super(0);
            }
        };
        Function0<String> $fun$getKeyParam$2 = new Function0<String>(project){
            final /* synthetic */ Project $project;

            @Input
            @NotNull
            public final String invoke() {
                Object object;
                String key = null;
                if (this.$project.hasProperty("key")) {
                    object = this.$project.property("key");
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                } else {
                    throw (Throwable)new InvalidUserDataException("No key provided, use argument '-Pkey=yourKey'");
                }
                key = (String)object;
                return key;
            }
            {
                this.$project = project;
                super(0);
            }
        };
        Function0<String> $fun$getPackageNameParam$3 = new Function0<String>(project, $fun$getAppPackageName$1){
            final /* synthetic */ Project $project;
            final /* synthetic */ apply.1 $getAppPackageName$1;

            @Input
            @NotNull
            public final String invoke() {
                Object packageName = null;
                if (this.$project.hasProperty("package")) {
                    packageName = (String)this.$project.property("package");
                }
                CharSequence charSequence = (CharSequence)packageName;
                boolean bl = false;
                boolean bl2 = false;
                if (charSequence == null || charSequence.length() == 0) {
                    packageName = this.$getAppPackageName$1.invoke();
                }
                charSequence = (CharSequence)packageName;
                bl = false;
                bl2 = false;
                if (charSequence == null || charSequence.length() == 0) {
                    throw (Throwable)new InvalidUserDataException("Empty package name, use argument '-Ppackage=your.package.name'");
                }
                return packageName;
            }
            {
                this.$project = project;
                this.$getAppPackageName$1 = var2_2;
                super(0);
            }
        };
        Function0<File> $fun$getPropertiesFile$4 = new Function0<File>(project){
            final /* synthetic */ Project $project;

            @Input
            @NotNull
            public final File invoke() {
                Object propsPathRaw;
                if (this.$project.hasProperty("propertiesFileName")) {
                    propsPathRaw = this.$project.property("propertiesFileName");
                    if (propsPathRaw == null) {
                        throw (Throwable)new IllegalArgumentException("Cannot find properties (" + propsPathRaw + ")!" + " Use: '-PpropertiesFileName=credentials.properties'");
                    }
                } else {
                    throw (Throwable)new IllegalArgumentException("Properties file is not defined! Use: '-PpropertiesFileName=credentials.properties'");
                }
                return new File(this.$project.getRootDir(), (String)propsPathRaw);
            }
            {
                this.$project = project;
                super(0);
            }
        };
        apply.5 $fun$getPropertiesFromFile$5 = apply.5.INSTANCE;
        Function0<String> $fun$getKeyNameParam$6 = new Function0<String>(project){
            final /* synthetic */ Project $project;

            @Input
            @NotNull
            public final String invoke() {
                char c = 'a';
                CharRange charRange = new CharRange(c, 'z');
                c = 'A';
                List chars = CollectionsKt.plus((Iterable)((Iterable)charRange), (Iterable)((Iterable)new CharRange(c, 'Z')));
                int n = 8;
                boolean bl = false;
                boolean bl2 = false;
                ArrayList<Character> arrayList = new ArrayList<Character>(n);
                boolean bl3 = false;
                int n2 = 0;
                n2 = 0;
                int n3 = n;
                while (n2 < n3) {
                    int n4 = n2++;
                    boolean bl4 = false;
                    int n5 = n4;
                    ArrayList<Character> arrayList2 = arrayList;
                    boolean bl5 = false;
                    Collection collection = chars;
                    boolean bl6 = false;
                    Character c2 = Character.valueOf(((Character)CollectionsKt.random((Collection)collection, (Random)((Random)Random.Default))).charValue());
                    arrayList2.add(c2);
                }
                String keyName = CollectionsKt.joinToString$default((Iterable)arrayList, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
                if (this.$project.hasProperty("keyName")) {
                    Object object = this.$project.property("keyName");
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    keyName = (String)object;
                } else {
                    String string = "Key name has been randomized, chose your own key name by adding argument '-PkeyName=yourName'";
                    bl = false;
                    System.out.println((Object)string);
                }
                String string = "### KEY NAME ###\n" + keyName + '\n';
                bl = false;
                System.out.println((Object)string);
                return keyName;
            }
            {
                this.$project = project;
                super(0);
            }
        };
        Function0<String> $fun$getObfuscatedKey$7 = new Function0<String>($fun$getKeyParam$2, $fun$getPackageNameParam$3){
            final /* synthetic */ apply.2 $getKeyParam$2;
            final /* synthetic */ apply.3 $getPackageNameParam$3;

            @NotNull
            public final String invoke() {
                Object key = this.$getKeyParam$2.invoke();
                String string = "### SECRET ###\n" + (String)key + '\n';
                boolean bl = false;
                System.out.println((Object)string);
                Object packageName = this.$getPackageNameParam$3.invoke();
                String string2 = "### PACKAGE NAME ###\n" + (String)packageName + '\n';
                boolean bl2 = false;
                System.out.println((Object)string2);
                String encodedKey = Utils.INSTANCE.encodeSecret((String)key, (String)packageName);
                String string3 = "### OBFUSCATED SECRET ###\n" + encodedKey;
                boolean bl3 = false;
                System.out.println((Object)string3);
                return encodedKey;
            }
            {
                this.$getKeyParam$2 = var1_1;
                this.$getPackageNameParam$3 = var2_2;
                super(0);
            }
        };
        Function1<String, File> $fun$getCppDestination$8 = new Function1<String, File>(project){
            final /* synthetic */ Project $project;

            @OutputFile
            @NotNull
            public final File invoke(@NotNull String fileName) {
                Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
                File file = this.$project.file((Object)("src/main/" + "cpp/" + fileName));
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(APP_MAIN_FOLDER + \"cpp/$fileName\")");
                return file;
            }
            {
                this.$project = project;
                super(1);
            }
        };
        Function2<String, String, File> $fun$getKotlinDestination$9 = new Function2<String, String, File>(project){
            final /* synthetic */ Project $project;

            @OutputFile
            @NotNull
            public final File invoke(@NotNull String packageName, @NotNull String fileName) {
                Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
                Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
                String path = "src/main/java/";
                Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)packageName, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    path = path + it + '/';
                }
                File file = this.$project.file((Object)path);
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(path)");
                File directory = file;
                if (!directory.exists()) {
                    String string = "Directory " + path + " does not exist in the project, you might have selected a wrong package.";
                    boolean bl = false;
                    System.out.println((Object)string);
                }
                path = path + fileName;
                File file2 = this.$project.file((Object)path);
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.file(path)");
                return file2;
            }
            {
                this.$project = project;
                super(2);
            }
        };
        Function0<File> $fun$tmpKotlinFile$10 = new Function0<File>(project, tmpFolder){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $tmpFolder;

            @NotNull
            public final File invoke() {
                Object object;
                block8: {
                    block7: {
                        File element$iv;
                        block6: {
                            object = this.$project.file((Object)(this.$tmpFolder + "/kotlin/")).listFiles();
                            if (object == null) break block7;
                            File[] $this$first$iv = object;
                            boolean $i$f$first = false;
                            File[] fileArray = $this$first$iv;
                            int n = fileArray.length;
                            for (int i = 0; i < n; ++i) {
                                File it = element$iv = fileArray[i];
                                boolean bl = false;
                                File file = it;
                                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                                if (!Intrinsics.areEqual((Object)file.getName(), (Object)"Secrets.kt")) {
                                    continue;
                                }
                                break block6;
                            }
                            throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
                        }
                        File file = element$iv;
                        object = file;
                        if (file != null) break block8;
                    }
                    throw (Throwable)new IllegalStateException("Did not find temporary template for secrets!");
                }
                return object;
            }
            {
                this.$project = project;
                this.$tmpFolder = string;
                super(0);
            }
        };
        Function0<File> $fun$getKotlinFile$11 = new Function0<File>(project){
            final /* synthetic */ Project $project;

            @Nullable
            public final File invoke() {
                return Utils.INSTANCE.findFileInProject(this.$project, "src/main/", "Secrets.kt");
            }
            {
                this.$project = project;
                super(0);
            }
        };
        Function1<Boolean, Unit> $fun$copyCppFiles$12 = new Function1<Boolean, Unit>(project, tmpFolder, $fun$getCppDestination$8){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $tmpFolder;
            final /* synthetic */ apply.8 $getCppDestination$8;

            public final void invoke(boolean overwrite) {
                File[] fileArray = this.$project.file((Object)(this.$tmpFolder + "/cpp/")).listFiles();
                if (fileArray != null) {
                    File[] $this$forEach$iv = fileArray;
                    boolean $i$f$forEach = false;
                    File[] fileArray2 = $this$forEach$iv;
                    int n = fileArray2.length;
                    for (int i = 0; i < n; ++i) {
                        boolean bl;
                        String string;
                        File element$iv;
                        File it = element$iv = fileArray2[i];
                        boolean bl2 = false;
                        File file = it;
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                        String string2 = file.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                        File destination = this.$getCppDestination$8.invoke(string2);
                        if (!overwrite && destination.exists()) {
                            string = it.getName() + " already exists";
                            bl = false;
                            System.out.println((Object)string);
                            continue;
                        }
                        string = "Copy " + it + ".name to\n" + destination;
                        bl = false;
                        System.out.println((Object)string);
                        FilesKt.copyTo$default((File)it, (File)destination, (boolean)true, (int)0, (int)4, null);
                    }
                }
            }

            public static /* synthetic */ void invoke$default(apply.12 var0, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                var0.invoke(bl);
            }
            {
                this.$project = project;
                this.$tmpFolder = string;
                this.$getCppDestination$8 = var3_3;
                super(1);
            }
        };
        Function1<Boolean, Unit> $fun$copyKotlinFile$13 = new Function1<Boolean, Unit>($fun$getKotlinFile$11, $fun$tmpKotlinFile$10, $fun$getPackageNameParam$3, project, tmpFolder, $fun$getKotlinDestination$9){
            final /* synthetic */ apply.11 $getKotlinFile$11;
            final /* synthetic */ apply.10 $tmpKotlinFile$10;
            final /* synthetic */ apply.3 $getPackageNameParam$3;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $tmpFolder;
            final /* synthetic */ apply.9 $getKotlinDestination$9;

            /*
             * Enabled aggressive block sorting
             */
            public final void invoke(boolean overwrite) {
                Object existingKotlinFile = this.$getKotlinFile$11.invoke();
                if (existingKotlinFile != null) {
                    if (overwrite) {
                        String string = "Overwriting existing Secrets.kt.";
                        boolean bl = false;
                        System.out.println((Object)string);
                        FilesKt.copyTo$default((File)this.$tmpKotlinFile$10.invoke(), (File)existingKotlinFile, (boolean)true, (int)0, (int)4, null);
                        return;
                    }
                    String string = "Secrets.kt already exists";
                    boolean bl = false;
                    System.out.println((Object)string);
                    return;
                }
                Object packageName = this.$getPackageNameParam$3.invoke();
                File[] fileArray = this.$project.file((Object)(this.$tmpFolder + "/kotlin/")).listFiles();
                if (fileArray == null) return;
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                File[] fileArray2 = $this$forEach$iv;
                int n = fileArray2.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean bl;
                    String string;
                    File element$iv;
                    File it = element$iv = fileArray2[n2];
                    boolean bl2 = false;
                    File file = it;
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                    String string2 = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                    File destination = this.$getKotlinDestination$9.invoke((String)packageName, string2);
                    if (destination.exists()) {
                        string = it.getName() + " already exists";
                        bl = false;
                        System.out.println((Object)string);
                    } else {
                        string = "Copy " + it + ".name to\n" + destination;
                        bl = false;
                        System.out.println((Object)string);
                        FilesKt.copyTo$default((File)it, (File)destination, (boolean)true, (int)0, (int)4, null);
                    }
                    ++n2;
                }
            }

            public static /* synthetic */ void invoke$default(apply.13 var0, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                var0.invoke(bl);
            }
            {
                this.$getKotlinFile$11 = var1_1;
                this.$tmpKotlinFile$10 = var2_2;
                this.$getPackageNameParam$3 = var3_3;
                this.$project = project;
                this.$tmpFolder = string;
                this.$getKotlinDestination$9 = var6_6;
                super(1);
            }
        };
        Function3<String, String, String, Unit> $fun$hideSecret$14 = new Function3<String, String, String, Unit>($fun$getKotlinFile$11, $fun$getKotlinDestination$9, $fun$getCppDestination$8){
            final /* synthetic */ apply.11 $getKotlinFile$11;
            final /* synthetic */ apply.9 $getKotlinDestination$9;
            final /* synthetic */ apply.8 $getCppDestination$8;

            public final void invoke(@NotNull String keyName, @NotNull String packageName, @NotNull String obfuscatedKey) {
                File secretsCpp;
                boolean bl;
                CharSequence charSequence;
                String text2;
                Intrinsics.checkNotNullParameter((Object)keyName, (String)"keyName");
                Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
                Intrinsics.checkNotNullParameter((Object)obfuscatedKey, (String)"obfuscatedKey");
                Object secretsKotlin = this.$getKotlinFile$11.invoke();
                if (secretsKotlin == null) {
                    secretsKotlin = this.$getKotlinDestination$9.invoke(packageName, "Secrets.kt");
                }
                if (((File)secretsKotlin).exists()) {
                    Charset charset = Charset.defaultCharset();
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.defaultCharset()");
                    text2 = FilesKt.readText((File)secretsKotlin, (Charset)charset);
                    text2 = StringsKt.replace$default((String)text2, (String)"YOUR_PACKAGE_GOES_HERE", (String)packageName, (boolean)false, (int)4, null);
                    if (StringsKt.contains$default((CharSequence)text2, (CharSequence)keyName, (boolean)false, (int)2, null)) {
                        charSequence = "\u26a0\ufe0f Method already added in Kotlin !";
                        bl = false;
                        System.out.println(charSequence);
                    }
                } else {
                    String text2 = "Missing Kotlin file, please run gradle task : copyKotlin";
                    boolean bl2 = false;
                    throw (Throwable)new IllegalStateException(text2.toString());
                }
                text2 = StringsKt.dropLast((String)text2, (int)1);
                text2 = text2 + CodeGenerator.INSTANCE.getKotlinCode(keyName);
                FilesKt.writeText$default((File)secretsKotlin, (String)text2, null, (int)2, null);
                String kotlinPackage = Utils.INSTANCE.getKotlinFilePackage((File)secretsKotlin);
                charSequence = kotlinPackage;
                bl = false;
                if (charSequence.length() == 0) {
                    charSequence = "Empty package in Secrets.kt";
                    bl = false;
                    System.out.println(charSequence);
                    kotlinPackage = packageName;
                }
                if ((secretsCpp = this.$getCppDestination$8.invoke("secrets.cpp")).exists()) {
                    Charset charset = Charset.defaultCharset();
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.defaultCharset()");
                    String text3 = FilesKt.readText((File)secretsCpp, (Charset)charset);
                    if (StringsKt.contains$default((CharSequence)text3, (CharSequence)obfuscatedKey, (boolean)false, (int)2, null)) {
                        String string = "\u26a0\ufe0f Key already added in C++ !";
                        boolean bl3 = false;
                        System.out.println((Object)string);
                    }
                    String cppKeyName = Utils.INSTANCE.getCppName(keyName);
                    if (StringsKt.contains$default((CharSequence)text3, (CharSequence)"YOUR_KEY_GOES_HERE", (boolean)false, (int)2, null)) {
                        text3 = StringsKt.replace$default((String)text3, (String)"YOUR_PACKAGE_GOES_HERE", (String)Utils.INSTANCE.getCppName(kotlinPackage), (boolean)false, (int)4, null);
                        text3 = StringsKt.replace$default((String)text3, (String)"YOUR_KEY_NAME_GOES_HERE", (String)cppKeyName, (boolean)false, (int)4, null);
                        text3 = StringsKt.replace$default((String)text3, (String)"YOUR_KEY_GOES_HERE", (String)obfuscatedKey, (boolean)false, (int)4, null);
                        FilesKt.writeText$default((File)secretsCpp, (String)text3, null, (int)2, null);
                    } else {
                        text3 = text3 + CodeGenerator.INSTANCE.getCppCode(kotlinPackage, cppKeyName, obfuscatedKey);
                        FilesKt.writeText$default((File)secretsCpp, (String)text3, null, (int)2, null);
                    }
                } else {
                    String string = "Missing C++ file, please run gradle task : copyCpp";
                    boolean bl4 = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                String string = "\u2705 You can now get your secret key by calling : Secrets().get" + keyName + "(packageName)";
                boolean bl5 = false;
                System.out.println((Object)string);
            }
            {
                this.$getKotlinFile$11 = var1_1;
                this.$getKotlinDestination$9 = var2_2;
                this.$getCppDestination$8 = var3_3;
                super(3);
            }
        };
        Task task = project.getTasks().create(TASK_UNZIP_HIDDEN_SECRETS, Copy.class, (Action)new Action<Copy>(project, tmpFolder){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $tmpFolder;

            @TaskAction
            public void execute(@NotNull Copy copy) {
                Intrinsics.checkNotNullParameter((Object)copy, (String)"copy");
                Object[] objectArray = new Object[1];
                ProtectionDomain protectionDomain = this.getClass().getProtectionDomain();
                Intrinsics.checkNotNullExpressionValue((Object)protectionDomain, (String)"javaClass.protectionDomain");
                CodeSource codeSource = protectionDomain.getCodeSource();
                Intrinsics.checkNotNullExpressionValue((Object)codeSource, (String)"javaClass.protectionDomain.codeSource");
                URL uRL = codeSource.getLocation();
                Intrinsics.checkNotNull((Object)uRL);
                objectArray[0] = this.$project.zipTree((Object)uRL.toExternalForm());
                copy.from(objectArray);
                String string = "Unzip jar to " + this.$tmpFolder;
                boolean bl = false;
                System.out.println((Object)string);
                copy.into((Object)this.$tmpFolder);
            }
            {
                this.$project = $captured_local_variable$0;
                this.$tmpFolder = $captured_local_variable$1;
            }
        });
        boolean bl = false;
        boolean bl2 = false;
        Copy $this$apply = (Copy)task;
        boolean bl3 = false;
        Copy copy = $this$apply;
        Intrinsics.checkNotNullExpressionValue((Object)copy, (String)"this");
        copy.setGroup(TASK_GROUP);
        $this$apply.setDescription("Unzip plugin into tmp directory");
        project.task(TASK_COPY_CPP, new Action($fun$copyCppFiles$12){
            final /* synthetic */ apply.12 $copyCppFiles$12;

            public final void execute(@NotNull Task $this$task) {
                Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$receiver");
                $this$task.setGroup("Hide secrets");
                $this$task.setDescription("Copy C++ files to your project");
                $this$task.doLast(new Action(this){
                    final /* synthetic */ apply.17 this$0;

                    public final void execute(@NotNull Task $this$doLast) {
                        Intrinsics.checkNotNullParameter((Object)$this$doLast, (String)"$receiver");
                        apply.12.invoke$default(this.this$0.$copyCppFiles$12, false, 1, null);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$copyCppFiles$12 = var1_1;
            }
        });
        project.task(TASK_COPY_KOTLIN, new Action($fun$copyKotlinFile$13){
            final /* synthetic */ apply.13 $copyKotlinFile$13;

            public final void execute(@NotNull Task $this$task) {
                Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$receiver");
                $this$task.setGroup("Hide secrets");
                $this$task.setDescription("Copy Kotlin file to your project");
                $this$task.doLast(new Action(this){
                    final /* synthetic */ apply.18 this$0;

                    public final void execute(@NotNull Task $this$doLast) {
                        Intrinsics.checkNotNullParameter((Object)$this$doLast, (String)"$receiver");
                        apply.13.invoke$default(this.this$0.$copyKotlinFile$13, false, 1, null);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$copyKotlinFile$13 = var1_1;
            }
        });
        project.task(TASK_OBFUSCATE, new Action($fun$getObfuscatedKey$7){
            final /* synthetic */ apply.7 $getObfuscatedKey$7;

            public final void execute(@NotNull Task $this$task) {
                Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$receiver");
                $this$task.setGroup("Hide secrets");
                $this$task.setDescription("Get an obfuscated key from command line");
                $this$task.doLast(new Action(this){
                    final /* synthetic */ apply.19 this$0;

                    public final void execute(@NotNull Task $this$doLast) {
                        Intrinsics.checkNotNullParameter((Object)$this$doLast, (String)"$receiver");
                        this.this$0.$getObfuscatedKey$7.invoke();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$getObfuscatedKey$7 = var1_1;
            }
        });
        project.task(TASK_HIDE_SECRET, new Action($fun$getKeyParam$2, $fun$copyCppFiles$12, $fun$copyKotlinFile$13, $fun$getKeyNameParam$6, $fun$getPackageNameParam$3, $fun$getObfuscatedKey$7, $fun$hideSecret$14){
            final /* synthetic */ apply.2 $getKeyParam$2;
            final /* synthetic */ apply.12 $copyCppFiles$12;
            final /* synthetic */ apply.13 $copyKotlinFile$13;
            final /* synthetic */ apply.6 $getKeyNameParam$6;
            final /* synthetic */ apply.3 $getPackageNameParam$3;
            final /* synthetic */ apply.7 $getObfuscatedKey$7;
            final /* synthetic */ apply.14 $hideSecret$14;

            public final void execute(@NotNull Task $this$task) {
                Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$receiver");
                $this$task.setGroup("Hide secrets");
                $this$task.setDescription("Obfuscate a key and add it to your Android project");
                $this$task.dependsOn(new Object[]{"unzipHiddenSecrets"});
                $this$task.doLast(new Action(this){
                    final /* synthetic */ apply.20 this$0;

                    public final void execute(@NotNull Task $this$doLast) {
                        Intrinsics.checkNotNullParameter((Object)$this$doLast, (String)"$receiver");
                        this.this$0.$getKeyParam$2.invoke();
                        apply.12.invoke$default(this.this$0.$copyCppFiles$12, false, 1, null);
                        apply.13.invoke$default(this.this$0.$copyKotlinFile$13, false, 1, null);
                        Object keyName = this.this$0.$getKeyNameParam$6.invoke();
                        Object packageName = this.this$0.$getPackageNameParam$3.invoke();
                        Object obfuscatedKey = this.this$0.$getObfuscatedKey$7.invoke();
                        this.this$0.$hideSecret$14.invoke((String)keyName, (String)packageName, (String)obfuscatedKey);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$getKeyParam$2 = var1_1;
                this.$copyCppFiles$12 = var2_2;
                this.$copyKotlinFile$13 = var3_3;
                this.$getKeyNameParam$6 = var4_4;
                this.$getPackageNameParam$3 = var5_5;
                this.$getObfuscatedKey$7 = var6_6;
                this.$hideSecret$14 = var7_7;
            }
        });
        project.task(TASK_HIDE_SECRET_FROM_PROPERTIES_FILE, new Action($fun$copyCppFiles$12, $fun$copyKotlinFile$13, $fun$getPackageNameParam$3, $fun$getPropertiesFile$4, $fun$hideSecret$14){
            final /* synthetic */ apply.12 $copyCppFiles$12;
            final /* synthetic */ apply.13 $copyKotlinFile$13;
            final /* synthetic */ apply.3 $getPackageNameParam$3;
            final /* synthetic */ apply.4 $getPropertiesFile$4;
            final /* synthetic */ apply.14 $hideSecret$14;

            public final void execute(@NotNull Task $this$task) {
                Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$receiver");
                $this$task.setGroup("Hide secrets");
                $this$task.setDescription("Re-generate and obfuscate keys from properties file and add it to your Android project");
                $this$task.dependsOn(new Object[]{"unzipHiddenSecrets"});
                $this$task.doLast(new Action(this){
                    final /* synthetic */ apply.21 this$0;

                    public final void execute(@NotNull Task $this$doLast) {
                        Intrinsics.checkNotNullParameter((Object)$this$doLast, (String)"$receiver");
                        this.this$0.$copyCppFiles$12.invoke(true);
                        this.this$0.$copyKotlinFile$13.invoke(true);
                        Object packageName = this.this$0.$getPackageNameParam$3.invoke();
                        Object propsFile = this.this$0.$getPropertiesFile$4.invoke();
                        Properties props = apply.5.INSTANCE.invoke((File)propsFile);
                        String string = "Generating secrets from props: " + ((File)propsFile).getPath();
                        boolean bl = false;
                        System.out.println((Object)string);
                        Set<Map.Entry<Object, Object>> set = props.entrySet();
                        Intrinsics.checkNotNullExpressionValue(set, (String)"props.entries");
                        Iterable $this$forEach$iv = set;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Map.Entry entry = (Map.Entry)element$iv;
                            boolean bl2 = false;
                            K k = entry.getKey();
                            if (k == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                            }
                            String keyName = (String)k;
                            V v = entry.getValue();
                            if (v == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                            }
                            String obfuscatedKey = Utils.INSTANCE.encodeSecret((String)v, (String)packageName);
                            this.this$0.$hideSecret$14.invoke(keyName, (String)packageName, obfuscatedKey);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$copyCppFiles$12 = var1_1;
                this.$copyKotlinFile$13 = var2_2;
                this.$getPackageNameParam$3 = var3_3;
                this.$getPropertiesFile$4 = var4_4;
                this.$hideSecret$14 = var5_5;
            }
        });
        project.task(TASK_PACKAGE_NAME, new Action($fun$getPackageNameParam$3){
            final /* synthetic */ apply.3 $getPackageNameParam$3;

            public final void execute(@NotNull Task $this$task) {
                Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$receiver");
                $this$task.setGroup("Hide secrets");
                $this$task.setDescription("Print the package name of the app");
                $this$task.doLast(new Action(this){
                    final /* synthetic */ apply.22 this$0;

                    public final void execute(@NotNull Task $this$doLast) {
                        Intrinsics.checkNotNullParameter((Object)$this$doLast, (String)"$receiver");
                        String string = "APP PACKAGE NAME = " + (String)this.this$0.$getPackageNameParam$3.invoke();
                        boolean bl = false;
                        System.out.println((Object)string);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$getPackageNameParam$3 = var1_1;
            }
        });
        project.task(TASK_FIND_KOTLIN_FILE, new Action($fun$getKotlinFile$11){
            final /* synthetic */ apply.11 $getKotlinFile$11;

            public final void execute(@NotNull Task $this$task) {
                Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$receiver");
                $this$task.setGroup("Hide secrets");
                $this$task.setDescription("Find Secrets.kt file in the project");
                $this$task.doLast(new Action(this){
                    final /* synthetic */ apply.23 this$0;

                    public final void execute(@NotNull Task $this$doLast) {
                        Intrinsics.checkNotNullParameter((Object)$this$doLast, (String)"$receiver");
                        this.this$0.$getKotlinFile$11.invoke();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$getKotlinFile$11 = var1_1;
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/klaxit/hiddensecrets/HiddenSecretsPlugin$Companion;", "", "()V", "APP_MAIN_FOLDER", "", "DEFAULT_KEY_NAME_LENGTH", "", "ERROR_EMPTY_KEY", "ERROR_EMPTY_PACKAGE", "KEY_PLACEHOLDER", "KOTLIN_FILE_NAME", "PACKAGE_PLACEHOLDER", "PROP_FILE_NAME", "PROP_KEY", "PROP_KEY_NAME", "PROP_PACKAGE", "SAMPLE_FROM_PROPS", "TASK_COPY_CPP", "TASK_COPY_KOTLIN", "TASK_FIND_KOTLIN_FILE", "TASK_GROUP", "TASK_HIDE_SECRET", "TASK_HIDE_SECRET_FROM_PROPERTIES_FILE", "TASK_OBFUSCATE", "TASK_PACKAGE_NAME", "TASK_UNZIP_HIDDEN_SECRETS", "HiddenSecretsPlugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

