/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendar.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcelable;
import android.util.AttributeSet;
import androidx.annotation.IntRange;
import androidx.annotation.Px;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.kizitonwose.calendar.core.CalendarDay;
import com.kizitonwose.calendar.core.CalendarMonth;
import com.kizitonwose.calendar.core.CalendarYear;
import com.kizitonwose.calendar.core.DayPosition;
import com.kizitonwose.calendar.core.OutDateStyle;
import com.kizitonwose.calendar.data.UtilsKt;
import com.kizitonwose.calendar.view.DaySize;
import com.kizitonwose.calendar.view.LayoutHelper;
import com.kizitonwose.calendar.view.MarginValues;
import com.kizitonwose.calendar.view.MonthDayBinder;
import com.kizitonwose.calendar.view.MonthHeaderFooterBinder;
import com.kizitonwose.calendar.view.MonthHeight;
import com.kizitonwose.calendar.view.R;
import com.kizitonwose.calendar.view.YearCalendarView;
import com.kizitonwose.calendar.view.YearHeaderFooterBinder;
import com.kizitonwose.calendar.view.internal.CalendarPageSnapHelper;
import com.kizitonwose.calendar.view.internal.CalendarPageSnapHelperLegacy;
import com.kizitonwose.calendar.view.internal.ExtensionsKt;
import com.kizitonwose.calendar.view.internal.yearcalendar.YearCalendarAdapter;
import com.kizitonwose.calendar.view.internal.yearcalendar.YearCalendarLayoutManager;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0011*\u0002\u0084\u0001\b\u0016\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\u000bJ#\u0010\u0091\u0001\u001a\u00020(2\u0007\u0010\u0092\u0001\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0007\u0010\u0093\u0001\u001a\u00020\nH\u0002J\t\u0010\u009c\u0001\u001a\u00020(H\u0002J\t\u0010\u009d\u0001\u001a\u00020(H\u0002J\u0011\u0010\u009e\u0001\u001a\u00020(2\b\u0010\u009f\u0001\u001a\u00030\u008d\u0001J\u0011\u0010\u00a0\u0001\u001a\u00020(2\b\u0010\u009f\u0001\u001a\u00030\u008d\u0001J\u0010\u0010\u00a1\u0001\u001a\u00020(2\u0007\u0010T\u001a\u00030\u00a2\u0001J\u0010\u0010\u00a3\u0001\u001a\u00020(2\u0007\u0010T\u001a\u00030\u00a2\u0001J\u0011\u0010\u00a4\u0001\u001a\u00020(2\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001J\u001f\u0010\u00a7\u0001\u001a\u00020(2\b\u0010\u00a8\u0001\u001a\u00030\u00a9\u00012\n\b\u0002\u0010\u00aa\u0001\u001a\u00030\u00ab\u0001H\u0007J\u0011\u0010\u00ac\u0001\u001a\u00020(2\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001J\u001f\u0010\u00ad\u0001\u001a\u00020(2\b\u0010\u00a8\u0001\u001a\u00030\u00a9\u00012\n\b\u0002\u0010\u00aa\u0001\u001a\u00030\u00ab\u0001H\u0007J\u0011\u0010\u00ae\u0001\u001a\u00020(2\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001J\u001f\u0010\u00af\u0001\u001a\u00020(2\b\u0010\u00a8\u0001\u001a\u00030\u00a9\u00012\n\b\u0002\u0010\u00aa\u0001\u001a\u00030\u00ab\u0001H\u0007J/\u0010\u00af\u0001\u001a\u00020(2\b\u0010\u00a8\u0001\u001a\u00030\u00a9\u00012\u0016\u0010\u00aa\u0001\u001a\f\u0012\u0007\b\u0001\u0012\u00030\u00ab\u00010\u00b0\u0001\"\u00030\u00ab\u0001\u00a2\u0006\u0003\u0010\u00b1\u0001J\u0010\u0010\u00b2\u0001\u001a\u00020(2\u0007\u0010T\u001a\u00030\u00a2\u0001J\u0011\u0010\u00b3\u0001\u001a\u00020(2\b\u0010\u009f\u0001\u001a\u00030\u008d\u0001J\u0007\u0010\u00b4\u0001\u001a\u00020(J\t\u0010\u00b5\u0001\u001a\u0004\u0018\u00010'J\t\u0010\u00b6\u0001\u001a\u0004\u0018\u00010'J\t\u0010\u00b7\u0001\u001a\u0004\u0018\u00010QJ\t\u0010\u00b8\u0001\u001a\u0004\u0018\u00010QJ\n\u0010\u00b9\u0001\u001a\u0005\u0018\u00010\u00a6\u0001J\n\u0010\u00ba\u0001\u001a\u0005\u0018\u00010\u00a6\u0001J%\u0010\u00bb\u0001\u001a\u00020(2\b\u0010\u008c\u0001\u001a\u00030\u008d\u00012\b\u0010\u008e\u0001\u001a\u00030\u008d\u00012\b\u0010\u008f\u0001\u001a\u00030\u0090\u0001J-\u0010\u00bc\u0001\u001a\u00020(2\n\b\u0002\u0010\u008c\u0001\u001a\u00030\u008d\u00012\n\b\u0002\u0010\u008e\u0001\u001a\u00030\u008d\u00012\n\b\u0002\u0010\u008f\u0001\u001a\u00030\u0090\u0001H\u0007J\t\u0010\u00bd\u0001\u001a\u00020(H\u0002J\n\u0010\u00be\u0001\u001a\u00030\u008d\u0001H\u0002J\n\u0010\u00bf\u0001\u001a\u00030\u008d\u0001H\u0002J\n\u0010\u00c0\u0001\u001a\u00030\u0090\u0001H\u0002R0\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R0\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R0\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R0\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c2\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R0\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c2\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R.\u0010%\u001a\u0016\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(\u0018\u00010&j\u0004\u0018\u0001`)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R$\u0010.\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R$\u00103\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00100\"\u0004\b5\u00102R$\u00106\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00100\"\u0004\b8\u00102R$\u00109\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u00100\"\u0004\b;\u00102R$\u0010<\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u00100\"\u0004\b>\u00102R(\u0010@\u001a\u0004\u0018\u00010?2\b\u0010\f\u001a\u0004\u0018\u00010?@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR(\u0010E\u001a\u0004\u0018\u00010?2\b\u0010\f\u001a\u0004\u0018\u00010?@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010B\"\u0004\bG\u0010DR&\u0010H\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u00100\"\u0004\bJ\u00102R&\u0010K\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u00100\"\u0004\bM\u00102R&\u0010N\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u00100\"\u0004\bP\u00102RZ\u0010V\u001a\u001d\u0012\u0013\u0012\u00110Q\u00a2\u0006\f\bR\u0012\b\bS\u0012\u0004\b\b(T\u0012\u0004\u0012\u00020U0&2!\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110Q\u00a2\u0006\f\bR\u0012\b\bS\u0012\u0004\b\b(T\u0012\u0004\u0012\u00020U0&@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010+\"\u0004\bW\u0010-R*\u0010X\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bY\u0010Z\u001a\u0004\b[\u00100\"\u0004\b\\\u00102R$\u0010]\u001a\u00020U2\u0006\u0010\f\u001a\u00020U@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010_\"\u0004\b`\u0010aR$\u0010c\u001a\u00020b2\u0006\u0010\f\u001a\u00020b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010e\"\u0004\bf\u0010gR$\u0010i\u001a\u00020h2\u0006\u0010\f\u001a\u00020h@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bj\u0010k\"\u0004\bl\u0010mR$\u0010o\u001a\u00020n2\u0006\u0010\f\u001a\u00020n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bp\u0010q\"\u0004\br\u0010sR$\u0010u\u001a\u00020t2\u0006\u0010\f\u001a\u00020t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bv\u0010w\"\u0004\bx\u0010yR$\u0010z\u001a\u00020t2\u0006\u0010\f\u001a\u00020t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b{\u0010w\"\u0004\b|\u0010yR\u001f\u0010}\u001a\u0004\u0018\u00010~X\u0086\u000e\u00a2\u0006\u0011\n\u0000\u001a\u0005\b\u007f\u0010\u0080\u0001\"\u0006\b\u0081\u0001\u0010\u0082\u0001R\u0013\u0010\u0083\u0001\u001a\u00030\u0084\u0001X\u0082\u0004\u00a2\u0006\u0005\n\u0003\u0010\u0085\u0001R\u0010\u0010\u0086\u0001\u001a\u00030\u0087\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0088\u0001\u001a\u00030\u0089\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u008a\u0001\u001a\u00030\u008b\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u008c\u0001\u001a\u0005\u0018\u00010\u008d\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u008e\u0001\u001a\u0005\u0018\u00010\u008d\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u008f\u0001\u001a\u0005\u0018\u00010\u0090\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0094\u0001\u001a\u00030\u0095\u00018BX\u0082\u0004\u00a2\u0006\b\u001a\u0006\b\u0096\u0001\u0010\u0097\u0001R\u0018\u0010\u0098\u0001\u001a\u00030\u0099\u00018BX\u0082\u0004\u00a2\u0006\b\u001a\u0006\b\u009a\u0001\u0010\u009b\u0001\u00a8\u0006\u00c1\u0001"}, d2={"Lcom/kizitonwose/calendar/view/YearCalendarView;", "Landroidx/recyclerview/widget/RecyclerView;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "value", "Lcom/kizitonwose/calendar/view/MonthDayBinder;", "dayBinder", "getDayBinder", "()Lcom/kizitonwose/calendar/view/MonthDayBinder;", "setDayBinder", "(Lcom/kizitonwose/calendar/view/MonthDayBinder;)V", "Lcom/kizitonwose/calendar/view/MonthHeaderFooterBinder;", "monthHeaderBinder", "getMonthHeaderBinder", "()Lcom/kizitonwose/calendar/view/MonthHeaderFooterBinder;", "setMonthHeaderBinder", "(Lcom/kizitonwose/calendar/view/MonthHeaderFooterBinder;)V", "monthFooterBinder", "getMonthFooterBinder", "setMonthFooterBinder", "Lcom/kizitonwose/calendar/view/YearHeaderFooterBinder;", "yearHeaderBinder", "getYearHeaderBinder", "()Lcom/kizitonwose/calendar/view/YearHeaderFooterBinder;", "setYearHeaderBinder", "(Lcom/kizitonwose/calendar/view/YearHeaderFooterBinder;)V", "yearFooterBinder", "getYearFooterBinder", "setYearFooterBinder", "yearScrollListener", "Lkotlin/Function1;", "Lcom/kizitonwose/calendar/core/CalendarYear;", "", "Lcom/kizitonwose/calendar/view/YearScrollListener;", "getYearScrollListener", "()Lkotlin/jvm/functions/Function1;", "setYearScrollListener", "(Lkotlin/jvm/functions/Function1;)V", "dayViewResource", "getDayViewResource", "()I", "setDayViewResource", "(I)V", "monthHeaderResource", "getMonthHeaderResource", "setMonthHeaderResource", "monthFooterResource", "getMonthFooterResource", "setMonthFooterResource", "yearHeaderResource", "getYearHeaderResource", "setYearHeaderResource", "yearFooterResource", "getYearFooterResource", "setYearFooterResource", "", "monthViewClass", "getMonthViewClass", "()Ljava/lang/String;", "setMonthViewClass", "(Ljava/lang/String;)V", "yearViewClass", "getYearViewClass", "setYearViewClass", "monthVerticalSpacing", "getMonthVerticalSpacing", "setMonthVerticalSpacing", "monthHorizontalSpacing", "getMonthHorizontalSpacing", "setMonthHorizontalSpacing", "monthColumns", "getMonthColumns", "setMonthColumns", "Lcom/kizitonwose/calendar/core/CalendarMonth;", "Lkotlin/ParameterName;", "name", "month", "", "isMonthVisible", "setMonthVisible", "orientation", "getOrientation$annotations", "()V", "getOrientation", "setOrientation", "scrollPaged", "getScrollPaged", "()Z", "setScrollPaged", "(Z)V", "Lcom/kizitonwose/calendar/core/OutDateStyle;", "outDateStyle", "getOutDateStyle", "()Lcom/kizitonwose/calendar/core/OutDateStyle;", "setOutDateStyle", "(Lcom/kizitonwose/calendar/core/OutDateStyle;)V", "Lcom/kizitonwose/calendar/view/DaySize;", "daySize", "getDaySize", "()Lcom/kizitonwose/calendar/view/DaySize;", "setDaySize", "(Lcom/kizitonwose/calendar/view/DaySize;)V", "Lcom/kizitonwose/calendar/view/MonthHeight;", "monthHeight", "getMonthHeight", "()Lcom/kizitonwose/calendar/view/MonthHeight;", "setMonthHeight", "(Lcom/kizitonwose/calendar/view/MonthHeight;)V", "Lcom/kizitonwose/calendar/view/MarginValues;", "yearMargins", "getYearMargins", "()Lcom/kizitonwose/calendar/view/MarginValues;", "setYearMargins", "(Lcom/kizitonwose/calendar/view/MarginValues;)V", "yearBodyMargins", "getYearBodyMargins", "setYearBodyMargins", "layoutHelper", "Lcom/kizitonwose/calendar/view/LayoutHelper;", "getLayoutHelper", "()Lcom/kizitonwose/calendar/view/LayoutHelper;", "setLayoutHelper", "(Lcom/kizitonwose/calendar/view/LayoutHelper;)V", "scrollListenerInternal", "com/kizitonwose/calendar/view/YearCalendarView$scrollListenerInternal$1", "Lcom/kizitonwose/calendar/view/YearCalendarView$scrollListenerInternal$1;", "horizontalSnapHelper", "Lcom/kizitonwose/calendar/view/internal/CalendarPageSnapHelperLegacy;", "verticalSnapHelper", "Lcom/kizitonwose/calendar/view/internal/CalendarPageSnapHelper;", "pageSnapHelper", "Landroidx/recyclerview/widget/PagerSnapHelper;", "startYear", "Ljava/time/Year;", "endYear", "firstDayOfWeek", "Ljava/time/DayOfWeek;", "init", "attributeSet", "defStyleRes", "calendarLayoutManager", "Lcom/kizitonwose/calendar/view/internal/yearcalendar/YearCalendarLayoutManager;", "getCalendarLayoutManager", "()Lcom/kizitonwose/calendar/view/internal/yearcalendar/YearCalendarLayoutManager;", "calendarAdapter", "Lcom/kizitonwose/calendar/view/internal/yearcalendar/YearCalendarAdapter;", "getCalendarAdapter", "()Lcom/kizitonwose/calendar/view/internal/yearcalendar/YearCalendarAdapter;", "invalidateViewHolders", "updateSnapHelper", "scrollToYear", "year", "smoothScrollToYear", "scrollToMonth", "Ljava/time/YearMonth;", "smoothScrollToMonth", "scrollToDay", "day", "Lcom/kizitonwose/calendar/core/CalendarDay;", "scrollToDate", "date", "Ljava/time/LocalDate;", "position", "Lcom/kizitonwose/calendar/core/DayPosition;", "smoothScrollToDay", "smoothScrollToDate", "notifyDayChanged", "notifyDateChanged", "", "(Ljava/time/LocalDate;[Lcom/kizitonwose/calendar/core/DayPosition;)V", "notifyMonthChanged", "notifyYearChanged", "notifyCalendarChanged", "findFirstVisibleYear", "findLastVisibleYear", "findFirstVisibleMonth", "findLastVisibleMonth", "findFirstVisibleDay", "findLastVisibleDay", "setup", "updateYearData", "updateAdapter", "requireStartYear", "requireEndYear", "requireFirstDayOfWeek", "view_release"})
@SourceDebugExtension(value={"SMAP\nYearCalendarView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YearCalendarView.kt\ncom/kizitonwose/calendar/view/YearCalendarView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Context.kt\nandroidx/core/content/ContextKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,719:1\n1#2:720\n58#3,2:721\n11561#4:723\n11896#4,3:724\n37#5,2:727\n*S KotlinDebug\n*F\n+ 1 YearCalendarView.kt\ncom/kizitonwose/calendar/view/YearCalendarView\n*L\n367#1:721,2\n560#1:723\n560#1:724,3\n562#1:727,2\n*E\n"})
public class YearCalendarView
extends RecyclerView {
    @Nullable
    private MonthDayBinder<?> dayBinder;
    @Nullable
    private MonthHeaderFooterBinder<?> monthHeaderBinder;
    @Nullable
    private MonthHeaderFooterBinder<?> monthFooterBinder;
    @Nullable
    private YearHeaderFooterBinder<?> yearHeaderBinder;
    @Nullable
    private YearHeaderFooterBinder<?> yearFooterBinder;
    @Nullable
    private Function1<? super CalendarYear, Unit> yearScrollListener;
    private int dayViewResource;
    private int monthHeaderResource;
    private int monthFooterResource;
    private int yearHeaderResource;
    private int yearFooterResource;
    @Nullable
    private String monthViewClass;
    @Nullable
    private String yearViewClass;
    @Px
    private int monthVerticalSpacing;
    @Px
    private int monthHorizontalSpacing;
    @IntRange(from=1L, to=12L)
    private int monthColumns;
    @NotNull
    private Function1<? super CalendarMonth, Boolean> isMonthVisible;
    private int orientation;
    private boolean scrollPaged;
    @NotNull
    private OutDateStyle outDateStyle;
    @NotNull
    private DaySize daySize;
    @NotNull
    private MonthHeight monthHeight;
    @NotNull
    private MarginValues yearMargins;
    @NotNull
    private MarginValues yearBodyMargins;
    @Nullable
    private LayoutHelper layoutHelper;
    @NotNull
    private final scrollListenerInternal.1 scrollListenerInternal;
    @NotNull
    private final CalendarPageSnapHelperLegacy horizontalSnapHelper;
    @NotNull
    private final CalendarPageSnapHelper verticalSnapHelper;
    @NotNull
    private PagerSnapHelper pageSnapHelper;
    @Nullable
    private Year startYear;
    @Nullable
    private Year endYear;
    @Nullable
    private DayOfWeek firstDayOfWeek;

    @Nullable
    public final MonthDayBinder<?> getDayBinder() {
        return this.dayBinder;
    }

    public final void setDayBinder(@Nullable MonthDayBinder<?> value) {
        this.dayBinder = value;
        this.invalidateViewHolders();
    }

    @Nullable
    public final MonthHeaderFooterBinder<?> getMonthHeaderBinder() {
        return this.monthHeaderBinder;
    }

    public final void setMonthHeaderBinder(@Nullable MonthHeaderFooterBinder<?> value) {
        this.monthHeaderBinder = value;
        this.invalidateViewHolders();
    }

    @Nullable
    public final MonthHeaderFooterBinder<?> getMonthFooterBinder() {
        return this.monthFooterBinder;
    }

    public final void setMonthFooterBinder(@Nullable MonthHeaderFooterBinder<?> value) {
        this.monthFooterBinder = value;
        this.invalidateViewHolders();
    }

    @Nullable
    public final YearHeaderFooterBinder<?> getYearHeaderBinder() {
        return this.yearHeaderBinder;
    }

    public final void setYearHeaderBinder(@Nullable YearHeaderFooterBinder<?> value) {
        this.yearHeaderBinder = value;
        this.invalidateViewHolders();
    }

    @Nullable
    public final YearHeaderFooterBinder<?> getYearFooterBinder() {
        return this.yearFooterBinder;
    }

    public final void setYearFooterBinder(@Nullable YearHeaderFooterBinder<?> value) {
        this.yearFooterBinder = value;
        this.invalidateViewHolders();
    }

    @Nullable
    public final Function1<CalendarYear, Unit> getYearScrollListener() {
        return this.yearScrollListener;
    }

    public final void setYearScrollListener(@Nullable Function1<? super CalendarYear, Unit> function1) {
        this.yearScrollListener = function1;
    }

    public final int getDayViewResource() {
        return this.dayViewResource;
    }

    public final void setDayViewResource(int value) {
        if (this.dayViewResource != value) {
            if (!(value != 0)) {
                boolean bl = false;
                String string = "Invalid 'dayViewResource' value.";
                throw new IllegalArgumentException(string.toString());
            }
            this.dayViewResource = value;
            this.invalidateViewHolders();
        }
    }

    public final int getMonthHeaderResource() {
        return this.monthHeaderResource;
    }

    public final void setMonthHeaderResource(int value) {
        if (this.monthHeaderResource != value) {
            this.monthHeaderResource = value;
            this.invalidateViewHolders();
        }
    }

    public final int getMonthFooterResource() {
        return this.monthFooterResource;
    }

    public final void setMonthFooterResource(int value) {
        if (this.monthFooterResource != value) {
            this.monthFooterResource = value;
            this.invalidateViewHolders();
        }
    }

    public final int getYearHeaderResource() {
        return this.yearHeaderResource;
    }

    public final void setYearHeaderResource(int value) {
        if (this.yearHeaderResource != value) {
            this.yearHeaderResource = value;
            this.invalidateViewHolders();
        }
    }

    public final int getYearFooterResource() {
        return this.yearFooterResource;
    }

    public final void setYearFooterResource(int value) {
        if (this.yearFooterResource != value) {
            this.yearFooterResource = value;
            this.invalidateViewHolders();
        }
    }

    @Nullable
    public final String getMonthViewClass() {
        return this.monthViewClass;
    }

    public final void setMonthViewClass(@Nullable String value) {
        if (!Intrinsics.areEqual((Object)this.monthViewClass, (Object)value)) {
            this.monthViewClass = value;
            this.invalidateViewHolders();
        }
    }

    @Nullable
    public final String getYearViewClass() {
        return this.yearViewClass;
    }

    public final void setYearViewClass(@Nullable String value) {
        if (!Intrinsics.areEqual((Object)this.yearViewClass, (Object)value)) {
            this.yearViewClass = value;
            this.invalidateViewHolders();
        }
    }

    public final int getMonthVerticalSpacing() {
        return this.monthVerticalSpacing;
    }

    public final void setMonthVerticalSpacing(int value) {
        if (this.monthVerticalSpacing != value) {
            this.monthVerticalSpacing = value;
            this.invalidateViewHolders();
        }
    }

    public final int getMonthHorizontalSpacing() {
        return this.monthHorizontalSpacing;
    }

    public final void setMonthHorizontalSpacing(int value) {
        if (this.monthHorizontalSpacing != value) {
            this.monthHorizontalSpacing = value;
            this.invalidateViewHolders();
        }
    }

    public final int getMonthColumns() {
        return this.monthColumns;
    }

    public final void setMonthColumns(int value) {
        if (this.monthColumns != value) {
            if (!(1 <= value ? value < 13 : false)) {
                boolean bl = false;
                String string = "Month columns must be 1..12";
                throw new IllegalArgumentException(string.toString());
            }
            this.monthColumns = value;
            this.invalidateViewHolders();
        }
    }

    @NotNull
    public final Function1<CalendarMonth, Boolean> isMonthVisible() {
        return this.isMonthVisible;
    }

    public final void setMonthVisible(@NotNull Function1<? super CalendarMonth, Boolean> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (!Intrinsics.areEqual(this.isMonthVisible, value)) {
            this.isMonthVisible = value;
            this.invalidateViewHolders();
        }
    }

    public final int getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(int value) {
        if (this.orientation != value) {
            this.orientation = value;
            RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
            YearCalendarLayoutManager yearCalendarLayoutManager = layoutManager instanceof YearCalendarLayoutManager ? (YearCalendarLayoutManager)layoutManager : null;
            if (yearCalendarLayoutManager != null) {
                yearCalendarLayoutManager.setOrientation(value);
            }
            this.updateSnapHelper();
        }
    }

    public static /* synthetic */ void getOrientation$annotations() {
    }

    public final boolean getScrollPaged() {
        return this.scrollPaged;
    }

    public final void setScrollPaged(boolean value) {
        if (this.scrollPaged != value) {
            this.scrollPaged = value;
            this.updateSnapHelper();
        }
    }

    @NotNull
    public final OutDateStyle getOutDateStyle() {
        return this.outDateStyle;
    }

    public final void setOutDateStyle(@NotNull OutDateStyle value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.outDateStyle != value) {
            this.outDateStyle = value;
            if (this.getAdapter() != null) {
                this.updateAdapter();
            }
        }
    }

    @NotNull
    public final DaySize getDaySize() {
        return this.daySize;
    }

    public final void setDaySize(@NotNull DaySize value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (this.daySize != value) {
            this.daySize = value;
            this.invalidateViewHolders();
        }
    }

    @NotNull
    public final MonthHeight getMonthHeight() {
        return this.monthHeight;
    }

    public final void setMonthHeight(@NotNull MonthHeight value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (this.monthHeight != value) {
            this.monthHeight = value;
            this.invalidateViewHolders();
        }
    }

    @NotNull
    public final MarginValues getYearMargins() {
        return this.yearMargins;
    }

    public final void setYearMargins(@NotNull MarginValues value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!Intrinsics.areEqual((Object)this.yearMargins, (Object)value)) {
            this.yearMargins = value;
            this.invalidateViewHolders();
        }
    }

    @NotNull
    public final MarginValues getYearBodyMargins() {
        return this.yearBodyMargins;
    }

    public final void setYearBodyMargins(@NotNull MarginValues value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!Intrinsics.areEqual((Object)this.yearBodyMargins, (Object)value)) {
            this.yearBodyMargins = value;
            this.invalidateViewHolders();
        }
    }

    @Nullable
    public final LayoutHelper getLayoutHelper() {
        return this.layoutHelper;
    }

    public final void setLayoutHelper(@Nullable LayoutHelper layoutHelper) {
        this.layoutHelper = layoutHelper;
    }

    public YearCalendarView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.monthColumns = 3;
        this.isMonthVisible = YearCalendarView::isMonthVisible$lambda$0;
        this.outDateStyle = OutDateStyle.EndOfRow;
        this.daySize = DaySize.Square;
        this.monthHeight = MonthHeight.FollowDaySize;
        this.yearMargins = MarginValues.Companion.getZERO();
        this.yearBodyMargins = MarginValues.Companion.getZERO();
        this.scrollListenerInternal = new RecyclerView.OnScrollListener(this){
            final /* synthetic */ YearCalendarView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
            }

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                if (newState == 0) {
                    YearCalendarView.access$getCalendarAdapter(this.this$0).notifyYearScrollListenerIfNeeded();
                }
            }
        };
        this.horizontalSnapHelper = new CalendarPageSnapHelperLegacy();
        this.verticalSnapHelper = new CalendarPageSnapHelper();
        this.pageSnapHelper = this.horizontalSnapHelper;
    }

    public YearCalendarView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.monthColumns = 3;
        this.isMonthVisible = YearCalendarView::isMonthVisible$lambda$0;
        this.outDateStyle = OutDateStyle.EndOfRow;
        this.daySize = DaySize.Square;
        this.monthHeight = MonthHeight.FollowDaySize;
        this.yearMargins = MarginValues.Companion.getZERO();
        this.yearBodyMargins = MarginValues.Companion.getZERO();
        this.scrollListenerInternal = new /* invalid duplicate definition of identical inner class */;
        this.horizontalSnapHelper = new CalendarPageSnapHelperLegacy();
        this.verticalSnapHelper = new CalendarPageSnapHelper();
        this.pageSnapHelper = this.horizontalSnapHelper;
        this.init(attrs, 0, 0);
    }

    public YearCalendarView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.monthColumns = 3;
        this.isMonthVisible = YearCalendarView::isMonthVisible$lambda$0;
        this.outDateStyle = OutDateStyle.EndOfRow;
        this.daySize = DaySize.Square;
        this.monthHeight = MonthHeight.FollowDaySize;
        this.yearMargins = MarginValues.Companion.getZERO();
        this.yearBodyMargins = MarginValues.Companion.getZERO();
        this.scrollListenerInternal = new /* invalid duplicate definition of identical inner class */;
        this.horizontalSnapHelper = new CalendarPageSnapHelperLegacy();
        this.verticalSnapHelper = new CalendarPageSnapHelper();
        this.pageSnapHelper = this.horizontalSnapHelper;
        this.init(attrs, defStyleAttr, defStyleAttr);
    }

    /*
     * WARNING - void declaration
     */
    private final void init(AttributeSet attributeSet, int defStyleAttr, int defStyleRes) {
        void defStyleRes$iv;
        void defStyleAttr$iv;
        void attrs$iv;
        void set$iv;
        void $this$withStyledAttributes$iv;
        TypedArray typedArray;
        if (this.isInEditMode()) {
            return;
        }
        this.setItemAnimator(null);
        this.setHasFixedSize(true);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Context context2 = context;
        AttributeSet attributeSet2 = attributeSet;
        Intrinsics.checkNotNullExpressionValue((Object)R.styleable.YearCalendarView, (String)"YearCalendarView");
        int[] nArray = R.styleable.YearCalendarView;
        int n = defStyleAttr;
        int n2 = defStyleRes;
        boolean $i$f$withStyledAttributes = false;
        TypedArray $this$init_u24lambda_u240 = typedArray = $this$withStyledAttributes$iv.obtainStyledAttributes((AttributeSet)set$iv, (int[])attrs$iv, (int)defStyleAttr$iv, (int)defStyleRes$iv);
        boolean bl = false;
        this.setDayViewResource($this$init_u24lambda_u240.getResourceId(R.styleable.YearCalendarView_cv_dayViewResource, this.dayViewResource));
        this.setMonthHeaderResource($this$init_u24lambda_u240.getResourceId(R.styleable.YearCalendarView_cv_monthHeaderResource, this.monthHeaderResource));
        this.setMonthFooterResource($this$init_u24lambda_u240.getResourceId(R.styleable.YearCalendarView_cv_monthFooterResource, this.monthFooterResource));
        this.setYearHeaderResource($this$init_u24lambda_u240.getResourceId(R.styleable.YearCalendarView_cv_yearHeaderResource, this.yearHeaderResource));
        this.setYearFooterResource($this$init_u24lambda_u240.getResourceId(R.styleable.YearCalendarView_cv_yearFooterResource, this.yearFooterResource));
        this.setOrientation($this$init_u24lambda_u240.getInt(R.styleable.YearCalendarView_cv_orientation, this.orientation));
        this.setScrollPaged($this$init_u24lambda_u240.getBoolean(R.styleable.YearCalendarView_cv_scrollPaged, this.orientation == 0));
        this.setDaySize((DaySize)((Object)DaySize.getEntries().get($this$init_u24lambda_u240.getInt(R.styleable.YearCalendarView_cv_daySize, this.daySize.ordinal()))));
        this.setMonthHeight((MonthHeight)((Object)MonthHeight.getEntries().get($this$init_u24lambda_u240.getInt(R.styleable.YearCalendarView_cv_monthHeight, this.monthHeight.ordinal()))));
        this.setOutDateStyle((OutDateStyle)OutDateStyle.getEntries().get($this$init_u24lambda_u240.getInt(R.styleable.YearCalendarView_cv_outDateStyle, this.outDateStyle.ordinal())));
        this.setMonthColumns($this$init_u24lambda_u240.getInt(R.styleable.YearCalendarView_cv_monthColumns, this.monthColumns));
        this.setMonthHorizontalSpacing($this$init_u24lambda_u240.getDimensionPixelSize(R.styleable.YearCalendarView_cv_monthHorizontalSpacing, this.monthHorizontalSpacing));
        this.setMonthVerticalSpacing($this$init_u24lambda_u240.getDimensionPixelSize(R.styleable.YearCalendarView_cv_monthVerticalSpacing, this.monthVerticalSpacing));
        this.setMonthViewClass($this$init_u24lambda_u240.getString(R.styleable.YearCalendarView_cv_monthViewClass));
        this.setYearViewClass($this$init_u24lambda_u240.getString(R.styleable.YearCalendarView_cv_yearViewClass));
        typedArray.recycle();
        if (!(this.dayViewResource != 0)) {
            boolean bl2 = false;
            String string = "No value set for `cv_dayViewResource` attribute.";
            throw new IllegalStateException(string.toString());
        }
    }

    private final YearCalendarLayoutManager getCalendarLayoutManager() {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type com.kizitonwose.calendar.view.internal.yearcalendar.YearCalendarLayoutManager");
        return (YearCalendarLayoutManager)layoutManager;
    }

    private final YearCalendarAdapter getCalendarAdapter() {
        RecyclerView.Adapter adapter = this.getAdapter();
        Intrinsics.checkNotNull((Object)adapter, (String)"null cannot be cast to non-null type com.kizitonwose.calendar.view.internal.yearcalendar.YearCalendarAdapter");
        return (YearCalendarAdapter)adapter;
    }

    private final void invalidateViewHolders() {
        if (this.getAdapter() == null || this.getLayoutManager() == null) {
            return;
        }
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        Parcelable state = layoutManager != null ? layoutManager.onSaveInstanceState() : null;
        this.setAdapter(this.getAdapter());
        RecyclerView.LayoutManager layoutManager2 = this.getLayoutManager();
        if (layoutManager2 != null) {
            layoutManager2.onRestoreInstanceState(state);
        }
        this.post(() -> YearCalendarView.invalidateViewHolders$lambda$0(this));
    }

    private final void updateSnapHelper() {
        if (!this.scrollPaged) {
            this.pageSnapHelper.attachToRecyclerView(null);
            return;
        }
        if (this.orientation == 0 && this.pageSnapHelper != this.horizontalSnapHelper || this.orientation == 1 && this.pageSnapHelper != this.verticalSnapHelper) {
            this.pageSnapHelper.attachToRecyclerView(null);
            this.pageSnapHelper = this.orientation == 0 ? (PagerSnapHelper)this.horizontalSnapHelper : (PagerSnapHelper)this.verticalSnapHelper;
        }
        this.pageSnapHelper.attachToRecyclerView((RecyclerView)this);
    }

    public final void scrollToYear(@NotNull Year year) {
        Intrinsics.checkNotNullParameter((Object)year, (String)"year");
        this.getCalendarLayoutManager().scrollToIndex(year);
    }

    public final void smoothScrollToYear(@NotNull Year year) {
        Intrinsics.checkNotNullParameter((Object)year, (String)"year");
        this.getCalendarLayoutManager().smoothScrollToIndex(year);
    }

    public final void scrollToMonth(@NotNull YearMonth month) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        this.getCalendarLayoutManager().scrollToMonth(month);
    }

    public final void smoothScrollToMonth(@NotNull YearMonth month) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        this.getCalendarLayoutManager().smoothScrollToMonth(month);
    }

    public final void scrollToDay(@NotNull CalendarDay day) {
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        this.getCalendarLayoutManager().scrollToDay(day);
    }

    @JvmOverloads
    public final void scrollToDate(@NotNull LocalDate date, @NotNull DayPosition position) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.scrollToDay(new CalendarDay(date, position));
    }

    public static /* synthetic */ void scrollToDate$default(YearCalendarView yearCalendarView, LocalDate localDate, DayPosition dayPosition, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: scrollToDate");
        }
        if ((n & 2) != 0) {
            dayPosition = DayPosition.MonthDate;
        }
        yearCalendarView.scrollToDate(localDate, dayPosition);
    }

    public final void smoothScrollToDay(@NotNull CalendarDay day) {
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        this.getCalendarLayoutManager().smoothScrollToDay(day);
    }

    @JvmOverloads
    public final void smoothScrollToDate(@NotNull LocalDate date, @NotNull DayPosition position) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.smoothScrollToDay(new CalendarDay(date, position));
    }

    public static /* synthetic */ void smoothScrollToDate$default(YearCalendarView yearCalendarView, LocalDate localDate, DayPosition dayPosition, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: smoothScrollToDate");
        }
        if ((n & 2) != 0) {
            dayPosition = DayPosition.MonthDate;
        }
        yearCalendarView.smoothScrollToDate(localDate, dayPosition);
    }

    public final void notifyDayChanged(@NotNull CalendarDay day) {
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        CalendarDay[] calendarDayArray = new CalendarDay[]{day};
        this.getCalendarAdapter().reloadDay(calendarDayArray);
    }

    @JvmOverloads
    public final void notifyDateChanged(@NotNull LocalDate date, @NotNull DayPosition position) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.notifyDayChanged(new CalendarDay(date, position));
    }

    public static /* synthetic */ void notifyDateChanged$default(YearCalendarView yearCalendarView, LocalDate localDate, DayPosition dayPosition, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: notifyDateChanged");
        }
        if ((n & 2) != 0) {
            dayPosition = DayPosition.MonthDate;
        }
        yearCalendarView.notifyDateChanged(localDate, dayPosition);
    }

    /*
     * WARNING - void declaration
     */
    public final void notifyDateChanged(@NotNull LocalDate date, DayPosition ... position) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        DayPosition[] dayPositionArray;
        DayPosition[] dayPositionArray2;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Object[] objectArray = position;
        if (objectArray.length == 0) {
            boolean bl = false;
            dayPositionArray2 = new DayPosition[]{DayPosition.MonthDate};
            dayPositionArray = dayPositionArray2;
        } else {
            dayPositionArray = objectArray;
        }
        objectArray = dayPositionArray;
        boolean $i$f$map = false;
        dayPositionArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DayPosition dayPosition = (DayPosition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CalendarDay(date, (DayPosition)it));
        }
        Set days = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Collection $this$toTypedArray$iv = days;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray = thisCollection$iv.toArray(new CalendarDay[0]);
        this.getCalendarAdapter().reloadDay((CalendarDay[])Arrays.copyOf(objectArray, objectArray.length));
    }

    public final void notifyMonthChanged(@NotNull YearMonth month) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        this.getCalendarAdapter().reloadMonth(month);
    }

    public final void notifyYearChanged(@NotNull Year year) {
        Intrinsics.checkNotNullParameter((Object)year, (String)"year");
        this.getCalendarAdapter().reloadYear(year);
    }

    public final void notifyCalendarChanged() {
        this.getCalendarAdapter().reloadCalendar();
    }

    @Nullable
    public final CalendarYear findFirstVisibleYear() {
        return this.getCalendarAdapter().findFirstVisibleYear();
    }

    @Nullable
    public final CalendarYear findLastVisibleYear() {
        return this.getCalendarAdapter().findLastVisibleYear();
    }

    @Nullable
    public final CalendarMonth findFirstVisibleMonth() {
        return this.getCalendarAdapter().findFirstVisibleMonth();
    }

    @Nullable
    public final CalendarMonth findLastVisibleMonth() {
        return this.getCalendarAdapter().findLastVisibleMonth();
    }

    @Nullable
    public final CalendarDay findFirstVisibleDay() {
        return this.getCalendarAdapter().findFirstVisibleDay();
    }

    @Nullable
    public final CalendarDay findLastVisibleDay() {
        return this.getCalendarAdapter().findLastVisibleDay();
    }

    public final void setup(@NotNull Year startYear, @NotNull Year endYear, @NotNull DayOfWeek firstDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)startYear, (String)"startYear");
        Intrinsics.checkNotNullParameter((Object)endYear, (String)"endYear");
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        UtilsKt.checkRange((Comparable)startYear, (Comparable)endYear);
        this.startYear = startYear;
        this.endYear = endYear;
        this.firstDayOfWeek = firstDayOfWeek;
        this.removeOnScrollListener(this.scrollListenerInternal);
        this.addOnScrollListener(this.scrollListenerInternal);
        this.setLayoutManager((RecyclerView.LayoutManager)new YearCalendarLayoutManager(this));
        this.setAdapter(new YearCalendarAdapter(this, this.outDateStyle, startYear, endYear, firstDayOfWeek));
    }

    @JvmOverloads
    public final void updateYearData(@NotNull Year startYear, @NotNull Year endYear, @NotNull DayOfWeek firstDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)startYear, (String)"startYear");
        Intrinsics.checkNotNullParameter((Object)endYear, (String)"endYear");
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        UtilsKt.checkRange((Comparable)startYear, (Comparable)endYear);
        this.startYear = startYear;
        this.endYear = endYear;
        this.firstDayOfWeek = firstDayOfWeek;
        this.updateAdapter();
    }

    public static /* synthetic */ void updateYearData$default(YearCalendarView yearCalendarView, Year year, Year year2, DayOfWeek dayOfWeek, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateYearData");
        }
        if ((n & 1) != 0) {
            year = yearCalendarView.requireStartYear();
        }
        if ((n & 2) != 0) {
            year2 = yearCalendarView.requireEndYear();
        }
        if ((n & 4) != 0) {
            dayOfWeek = yearCalendarView.requireFirstDayOfWeek();
        }
        yearCalendarView.updateYearData(year, year2, dayOfWeek);
    }

    private final void updateAdapter() {
        this.getCalendarAdapter().updateData$view_release(this.requireStartYear(), this.requireEndYear(), this.outDateStyle, this.requireFirstDayOfWeek());
    }

    private final Year requireStartYear() {
        Year year = this.startYear;
        if (year == null) {
            boolean bl = false;
            String string = ExtensionsKt.missingField("startYear");
            throw new IllegalStateException(string.toString());
        }
        return year;
    }

    private final Year requireEndYear() {
        Year year = this.endYear;
        if (year == null) {
            boolean bl = false;
            String string = ExtensionsKt.missingField("endYear");
            throw new IllegalStateException(string.toString());
        }
        return year;
    }

    private final DayOfWeek requireFirstDayOfWeek() {
        DayOfWeek dayOfWeek = this.firstDayOfWeek;
        if (dayOfWeek == null) {
            boolean bl = false;
            String string = ExtensionsKt.missingField("firstDayOfWeek");
            throw new IllegalStateException(string.toString());
        }
        return dayOfWeek;
    }

    @JvmOverloads
    public final void scrollToDate(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        YearCalendarView.scrollToDate$default(this, date, null, 2, null);
    }

    @JvmOverloads
    public final void smoothScrollToDate(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        YearCalendarView.smoothScrollToDate$default(this, date, null, 2, null);
    }

    @JvmOverloads
    public final void notifyDateChanged(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        YearCalendarView.notifyDateChanged$default(this, date, null, 2, null);
    }

    @JvmOverloads
    public final void updateYearData(@NotNull Year startYear, @NotNull Year endYear) {
        Intrinsics.checkNotNullParameter((Object)startYear, (String)"startYear");
        Intrinsics.checkNotNullParameter((Object)endYear, (String)"endYear");
        YearCalendarView.updateYearData$default(this, startYear, endYear, null, 4, null);
    }

    @JvmOverloads
    public final void updateYearData(@NotNull Year startYear) {
        Intrinsics.checkNotNullParameter((Object)startYear, (String)"startYear");
        YearCalendarView.updateYearData$default(this, startYear, null, null, 6, null);
    }

    @JvmOverloads
    public final void updateYearData() {
        YearCalendarView.updateYearData$default(this, null, null, null, 7, null);
    }

    private static final boolean isMonthVisible$lambda$0(CalendarMonth it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final void invalidateViewHolders$lambda$0(YearCalendarView this$0) {
        this$0.getCalendarAdapter().notifyYearScrollListenerIfNeeded();
    }

    public static final /* synthetic */ YearCalendarAdapter access$getCalendarAdapter(YearCalendarView $this) {
        return $this.getCalendarAdapter();
    }
}

