/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendar.view.internal.yearcalendar;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import com.kizitonwose.calendar.core.CalendarDay;
import com.kizitonwose.calendar.view.LayoutHelper;
import com.kizitonwose.calendar.view.MarginValues;
import com.kizitonwose.calendar.view.YearCalendarView;
import com.kizitonwose.calendar.view.internal.CalendarLayoutManager;
import com.kizitonwose.calendar.view.internal.ItemRootKt;
import com.kizitonwose.calendar.view.internal.yearcalendar.YearCalendarAdapter;
import com.kizitonwose.calendar.view.internal.yearcalendar.YearRootKt;
import java.time.Year;
import java.time.YearMonth;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/kizitonwose/calendar/view/internal/yearcalendar/YearCalendarLayoutManager;", "Lcom/kizitonwose/calendar/view/internal/CalendarLayoutManager;", "Ljava/time/Year;", "Lcom/kizitonwose/calendar/core/CalendarDay;", "calView", "Lcom/kizitonwose/calendar/view/YearCalendarView;", "<init>", "(Lcom/kizitonwose/calendar/view/YearCalendarView;)V", "adapter", "Lcom/kizitonwose/calendar/view/internal/yearcalendar/YearCalendarAdapter;", "getAdapter", "()Lcom/kizitonwose/calendar/view/internal/yearcalendar/YearCalendarAdapter;", "getaItemAdapterPosition", "", "data", "getaDayAdapterPosition", "getDayTag", "getItemMargins", "Lcom/kizitonwose/calendar/view/MarginValues;", "scrollPaged", "", "notifyScrollListenerIfNeeded", "", "getLayoutHelper", "Lcom/kizitonwose/calendar/view/LayoutHelper;", "smoothScrollToMonth", "month", "Ljava/time/YearMonth;", "scrollToMonth", "calculateMonthViewOffsetInParent", "itemView", "Landroid/view/View;", "CalendarSmoothScroller", "view_release"})
public final class YearCalendarLayoutManager
extends CalendarLayoutManager<Year, CalendarDay> {
    @NotNull
    private final YearCalendarView calView;

    public YearCalendarLayoutManager(@NotNull YearCalendarView calView) {
        Intrinsics.checkNotNullParameter((Object)((Object)calView), (String)"calView");
        super(calView, calView.getOrientation());
        this.calView = calView;
    }

    private final YearCalendarAdapter getAdapter() {
        RecyclerView.Adapter adapter = this.calView.getAdapter();
        Intrinsics.checkNotNull((Object)adapter, (String)"null cannot be cast to non-null type com.kizitonwose.calendar.view.internal.yearcalendar.YearCalendarAdapter");
        return (YearCalendarAdapter)adapter;
    }

    @Override
    public int getaItemAdapterPosition(@NotNull Year data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.getAdapter().getAdapterPosition$view_release(data);
    }

    @Override
    public int getaDayAdapterPosition(@NotNull CalendarDay data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.getAdapter().getAdapterPosition$view_release(data);
    }

    @Override
    public int getDayTag(@NotNull CalendarDay data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return ItemRootKt.dayTag(data.getDate());
    }

    @Override
    @NotNull
    public MarginValues getItemMargins() {
        return this.calView.getYearMargins();
    }

    @Override
    public boolean scrollPaged() {
        return this.calView.getScrollPaged();
    }

    @Override
    public void notifyScrollListenerIfNeeded() {
        this.getAdapter().notifyYearScrollListenerIfNeeded();
    }

    @Override
    @Nullable
    public LayoutHelper getLayoutHelper() {
        return this.calView.getLayoutHelper();
    }

    public final void smoothScrollToMonth(@NotNull YearMonth month) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        int indexPosition = this.getAdapter().getAdapterPosition$view_release(month);
        if (indexPosition == -1) {
            return;
        }
        this.startSmoothScroll((RecyclerView.SmoothScroller)new CalendarSmoothScroller(indexPosition, this.scrollPaged() ? null : month));
    }

    public final void scrollToMonth(@NotNull YearMonth month) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        int indexPosition = this.getAdapter().getAdapterPosition$view_release(month);
        if (indexPosition == -1) {
            return;
        }
        this.scrollToPositionWithOffset(indexPosition, 0);
        boolean bl = this.scrollPaged() ? this.calView.post(() -> YearCalendarLayoutManager.scrollToMonth$lambda$0(this)) : this.calView.post(() -> YearCalendarLayoutManager.scrollToMonth$lambda$2(this, indexPosition, month));
    }

    private final int calculateMonthViewOffsetInParent(YearMonth month, View itemView) {
        View view = itemView.findViewWithTag((Object)YearRootKt.monthTag(month));
        if (view == null) {
            return 0;
        }
        View monthView = view;
        Rect rect = new Rect();
        monthView.getDrawingRect(rect);
        Intrinsics.checkNotNull((Object)itemView, (String)"null cannot be cast to non-null type android.view.ViewGroup");
        ((ViewGroup)itemView).offsetDescendantRectToMyCoords(monthView, rect);
        return this.getOrientation() == 1 ? rect.top : rect.left;
    }

    private static final void scrollToMonth$lambda$0(YearCalendarLayoutManager this$0) {
        this$0.notifyScrollListenerIfNeeded();
    }

    private static final void scrollToMonth$lambda$2$lambda$1(YearCalendarLayoutManager this$0) {
        this$0.notifyScrollListenerIfNeeded();
    }

    private static final void scrollToMonth$lambda$2(YearCalendarLayoutManager this$0, int $indexPosition, YearMonth $month) {
        RecyclerView.ViewHolder viewHolder = this$0.calView.findViewHolderForAdapterPosition($indexPosition);
        if (viewHolder == null || (viewHolder = viewHolder.itemView) == null) {
            return;
        }
        RecyclerView.ViewHolder itemView = viewHolder;
        int offset = this$0.calculateMonthViewOffsetInParent($month, (View)itemView);
        this$0.scrollToPositionWithOffset($indexPosition, -offset);
        this$0.calView.post(() -> YearCalendarLayoutManager.scrollToMonth$lambda$2$lambda$1(this$0));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u0003H\u0014J\b\u0010\u000b\u001a\u00020\u0003H\u0014J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/kizitonwose/calendar/view/internal/yearcalendar/YearCalendarLayoutManager$CalendarSmoothScroller;", "Landroidx/recyclerview/widget/LinearSmoothScroller;", "position", "", "month", "Ljava/time/YearMonth;", "<init>", "(Lcom/kizitonwose/calendar/view/internal/yearcalendar/YearCalendarLayoutManager;ILjava/time/YearMonth;)V", "getMonth", "()Ljava/time/YearMonth;", "getVerticalSnapPreference", "getHorizontalSnapPreference", "calculateDyToMakeVisible", "view", "Landroid/view/View;", "snapPreference", "calculateDxToMakeVisible", "view_release"})
    private final class CalendarSmoothScroller
    extends LinearSmoothScroller {
        @Nullable
        private final YearMonth month;

        public CalendarSmoothScroller(@Nullable int position, YearMonth month) {
            super(YearCalendarLayoutManager.this.calView.getContext());
            this.month = month;
            this.setTargetPosition(position);
        }

        @Nullable
        public final YearMonth getMonth() {
            return this.month;
        }

        protected int getVerticalSnapPreference() {
            return -1;
        }

        protected int getHorizontalSnapPreference() {
            return -1;
        }

        public int calculateDyToMakeVisible(@NotNull View view, int snapPreference) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            int dy = super.calculateDyToMakeVisible(view, snapPreference);
            if (this.month == null) {
                return dy;
            }
            int offset = YearCalendarLayoutManager.this.calculateMonthViewOffsetInParent(this.month, view);
            return dy - offset;
        }

        public int calculateDxToMakeVisible(@NotNull View view, int snapPreference) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            int dx = super.calculateDxToMakeVisible(view, snapPreference);
            if (this.month == null) {
                return dx;
            }
            int offset = YearCalendarLayoutManager.this.calculateMonthViewOffsetInParent(this.month, view);
            return dx - offset;
        }
    }
}

