/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendar.view.internal.weekcalendar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.kizitonwose.calendar.core.Week;
import com.kizitonwose.calendar.core.WeekDay;
import com.kizitonwose.calendar.data.DataStore;
import com.kizitonwose.calendar.data.WeekDataKt;
import com.kizitonwose.calendar.data.WeekDateRange;
import com.kizitonwose.calendar.view.Binder;
import com.kizitonwose.calendar.view.DaySize;
import com.kizitonwose.calendar.view.MarginValues;
import com.kizitonwose.calendar.view.WeekCalendarView;
import com.kizitonwose.calendar.view.WeekDayBinder;
import com.kizitonwose.calendar.view.internal.ExtensionsKt;
import com.kizitonwose.calendar.view.internal.ItemContent;
import com.kizitonwose.calendar.view.internal.ItemRootKt;
import com.kizitonwose.calendar.view.internal.WeekHolder;
import com.kizitonwose.calendar.view.internal.weekcalendar.WeekCalendarLayoutManager;
import com.kizitonwose.calendar.view.internal.weekcalendar.WeekViewHolder;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0014H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0014H\u0016J\b\u0010#\u001a\u00020\u0014H\u0016J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0014H\u0016J&\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u00142\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0016J\u0018\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0014H\u0016J\u000e\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u0006J\u000e\u0010/\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u0006J\u0006\u00100\u001a\u00020\u001cJ\u0006\u00102\u001a\u00020\u001cJ\u0015\u00103\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b4J\b\u00109\u001a\u0004\u0018\u00010\u0017J\b\u0010:\u001a\u0004\u0018\u00010\u0017J\b\u0010;\u001a\u0004\u0018\u00010<J\b\u0010=\u001a\u0004\u0018\u00010<J\b\u0010>\u001a\u00020\u0014H\u0002J\b\u0010?\u001a\u00020\u0014H\u0002J\u0012\u0010@\u001a\u0004\u0018\u00010<2\u0006\u0010A\u001a\u00020\u0019H\u0002J%\u0010B\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0001\u00a2\u0006\u0002\bCR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u0010\u00101\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\u0002068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108\u00a8\u0006D"}, d2={"Lcom/kizitonwose/calendar/view/internal/weekcalendar/WeekCalendarAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/kizitonwose/calendar/view/internal/weekcalendar/WeekViewHolder;", "calView", "Lcom/kizitonwose/calendar/view/WeekCalendarView;", "startDate", "Ljava/time/LocalDate;", "endDate", "firstDayOfWeek", "Ljava/time/DayOfWeek;", "<init>", "(Lcom/kizitonwose/calendar/view/WeekCalendarView;Ljava/time/LocalDate;Ljava/time/LocalDate;Ljava/time/DayOfWeek;)V", "adjustedData", "Lcom/kizitonwose/calendar/data/WeekDateRange;", "startDateAdjusted", "getStartDateAdjusted", "()Ljava/time/LocalDate;", "endDateAdjusted", "getEndDateAdjusted", "itemCount", "", "dataStore", "Lcom/kizitonwose/calendar/data/DataStore;", "Lcom/kizitonwose/calendar/core/Week;", "isAttached", "", "()Z", "onAttachedToRecyclerView", "", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "getItem", "position", "getItemId", "", "getItemCount", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onBindViewHolder", "holder", "payloads", "", "", "reloadDay", "date", "reloadWeek", "reloadCalendar", "visibleWeek", "notifyWeekScrollListenerIfNeeded", "getAdapterPosition", "getAdapterPosition$view_release", "layoutManager", "Lcom/kizitonwose/calendar/view/internal/weekcalendar/WeekCalendarLayoutManager;", "getLayoutManager", "()Lcom/kizitonwose/calendar/view/internal/weekcalendar/WeekCalendarLayoutManager;", "findFirstVisibleWeek", "findLastVisibleWeek", "findFirstVisibleDay", "Lcom/kizitonwose/calendar/core/WeekDay;", "findLastVisibleDay", "findFirstVisibleWeekPosition", "findLastVisibleWeekPosition", "findVisibleDay", "isFirst", "updateData", "updateData$view_release", "view_release"})
@SourceDebugExtension(value={"SMAP\nWeekCalendarAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WeekCalendarAdapter.kt\ncom/kizitonwose/calendar/view/internal/weekcalendar/WeekCalendarAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n1869#2,2:194\n230#2,2:196\n295#2,2:199\n1#3:198\n*S KotlinDebug\n*F\n+ 1 WeekCalendarAdapter.kt\ncom/kizitonwose/calendar/view/internal/weekcalendar/WeekCalendarAdapter\n*L\n87#1:194,2\n100#1:196,2\n170#1:199,2\n*E\n"})
public final class WeekCalendarAdapter
extends RecyclerView.Adapter<WeekViewHolder> {
    @NotNull
    private final WeekCalendarView calView;
    @NotNull
    private LocalDate startDate;
    @NotNull
    private LocalDate endDate;
    @NotNull
    private DayOfWeek firstDayOfWeek;
    @NotNull
    private WeekDateRange adjustedData;
    private int itemCount;
    @NotNull
    private final DataStore<Week> dataStore;
    @Nullable
    private Week visibleWeek;

    public WeekCalendarAdapter(@NotNull WeekCalendarView calView, @NotNull LocalDate startDate, @NotNull LocalDate endDate, @NotNull DayOfWeek firstDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)((Object)calView), (String)"calView");
        Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
        Intrinsics.checkNotNullParameter((Object)endDate, (String)"endDate");
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        this.calView = calView;
        this.startDate = startDate;
        this.endDate = endDate;
        this.firstDayOfWeek = firstDayOfWeek;
        this.adjustedData = WeekDataKt.getWeekCalendarAdjustedRange((LocalDate)this.startDate, (LocalDate)this.endDate, (DayOfWeek)this.firstDayOfWeek);
        this.itemCount = WeekDataKt.getWeekIndicesCount((LocalDate)this.adjustedData.getStartDateAdjusted(), (LocalDate)this.adjustedData.getEndDateAdjusted());
        this.dataStore = new DataStore(null, arg_0 -> WeekCalendarAdapter.dataStore$lambda$0(this, arg_0), 1, null);
        this.setHasStableIds(true);
    }

    private final LocalDate getStartDateAdjusted() {
        return this.adjustedData.getStartDateAdjusted();
    }

    private final LocalDate getEndDateAdjusted() {
        return this.adjustedData.getEndDateAdjusted();
    }

    private final boolean isAttached() {
        return this.calView.getAdapter() == this;
    }

    public void onAttachedToRecyclerView(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        this.calView.post(() -> WeekCalendarAdapter.onAttachedToRecyclerView$lambda$1(this));
    }

    private final Week getItem(int position) {
        return (Week)this.dataStore.get((Object)position);
    }

    public long getItemId(int position) {
        return ((WeekDay)CollectionsKt.first((List)this.getItem(position).getDays())).getDate().hashCode();
    }

    public int getItemCount() {
        return this.itemCount;
    }

    @NotNull
    public WeekViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        MarginValues marginValues = this.calView.getWeekMargins();
        DaySize daySize = this.calView.getDaySize();
        Context context = this.calView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        int n = this.calView.getDayViewResource();
        int n2 = this.calView.getWeekHeaderResource();
        int n3 = this.calView.getWeekFooterResource();
        String string = this.calView.getWeekViewClass();
        WeekDayBinder<?> weekDayBinder = this.calView.getDayBinder();
        Intrinsics.checkNotNull(weekDayBinder, (String)"null cannot be cast to non-null type com.kizitonwose.calendar.view.WeekDayBinder<*>");
        ItemContent content = ItemRootKt.setupItemRoot(marginValues, daySize, context, n, n2, n3, 1, string, (Binder)weekDayBinder);
        return new WeekViewHolder(content.getItemView(), content.getHeaderView(), content.getFooterView(), (WeekHolder)CollectionsKt.first(content.getWeekHolders()), this.calView.getWeekHeaderBinder(), this.calView.getWeekFooterBinder());
    }

    public void onBindViewHolder(@NotNull WeekViewHolder holder, int position, @NotNull List<? extends Object> payloads) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Intrinsics.checkNotNullParameter(payloads, (String)"payloads");
        if (payloads.isEmpty()) {
            super.onBindViewHolder((RecyclerView.ViewHolder)holder, position, payloads);
        } else {
            Iterable $this$forEach$iv = payloads;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type com.kizitonwose.calendar.core.WeekDay");
                holder.reloadDay((WeekDay)it);
            }
        }
    }

    public void onBindViewHolder(@NotNull WeekViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        holder.bindWeek(this.getItem(position));
    }

    /*
     * WARNING - void declaration
     */
    public final void reloadDay(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        int position = this.getAdapterPosition$view_release(date);
        if (position != -1) {
            Object element$iv2;
            WeekCalendarAdapter weekCalendarAdapter;
            int n;
            block2: {
                void $this$first$iv;
                Iterable iterable = ((Week)this.dataStore.get((Object)position)).getDays();
                n = position;
                weekCalendarAdapter = this;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    WeekDay it = (WeekDay)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getDate(), (Object)date)) continue;
                    break block2;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object t = element$iv2;
            weekCalendarAdapter.notifyItemChanged(n, t);
        }
    }

    public final void reloadWeek(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.notifyItemChanged(this.getAdapterPosition$view_release(date));
    }

    public final void reloadCalendar() {
        this.notifyItemRangeChanged(0, this.itemCount);
    }

    public final void notifyWeekScrollListenerIfNeeded() {
        block4: {
            Week visibleWeek;
            if (!this.isAttached()) {
                return;
            }
            if (this.calView.isAnimating()) {
                RecyclerView.ItemAnimator itemAnimator = this.calView.getItemAnimator();
                if (itemAnimator != null) {
                    itemAnimator.isRunning(() -> WeekCalendarAdapter.notifyWeekScrollListenerIfNeeded$lambda$4(this));
                }
                return;
            }
            int visibleItemPos = this.findFirstVisibleWeekPosition();
            if (visibleItemPos == -1 || Intrinsics.areEqual((Object)(visibleWeek = (Week)this.dataStore.get((Object)visibleItemPos)), (Object)this.visibleWeek)) break block4;
            this.visibleWeek = visibleWeek;
            Function1<Week, Unit> function1 = this.calView.getWeekScrollListener();
            if (function1 != null) {
                function1.invoke((Object)visibleWeek);
            }
        }
    }

    public final int getAdapterPosition$view_release(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return WeekDataKt.getWeekIndex((LocalDate)this.getStartDateAdjusted(), (LocalDate)date);
    }

    private final WeekCalendarLayoutManager getLayoutManager() {
        RecyclerView.LayoutManager layoutManager = this.calView.getLayoutManager();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type com.kizitonwose.calendar.view.internal.weekcalendar.WeekCalendarLayoutManager");
        return (WeekCalendarLayoutManager)layoutManager;
    }

    @Nullable
    public final Week findFirstVisibleWeek() {
        int index = this.findFirstVisibleWeekPosition();
        return index == -1 ? null : (Week)this.dataStore.get((Object)index);
    }

    @Nullable
    public final Week findLastVisibleWeek() {
        int index = this.findLastVisibleWeekPosition();
        return index == -1 ? null : (Week)this.dataStore.get((Object)index);
    }

    @Nullable
    public final WeekDay findFirstVisibleDay() {
        return this.findVisibleDay(true);
    }

    @Nullable
    public final WeekDay findLastVisibleDay() {
        return this.findVisibleDay(false);
    }

    private final int findFirstVisibleWeekPosition() {
        return this.getLayoutManager().findFirstVisibleItemPosition();
    }

    private final int findLastVisibleWeekPosition() {
        return this.getLayoutManager().findLastVisibleItemPosition();
    }

    /*
     * WARNING - void declaration
     */
    private final WeekDay findVisibleDay(boolean isFirst) {
        Object v2;
        block4: {
            void $this$firstOrNull$iv;
            int visibleIndex;
            int n = visibleIndex = isFirst ? this.findFirstVisibleWeekPosition() : this.findLastVisibleWeekPosition();
            if (visibleIndex == -1) {
                return null;
            }
            View view = this.getLayoutManager().findViewByPosition(visibleIndex);
            if (view == null) {
                return null;
            }
            View visibleItemView = view;
            Rect weekRect = new Rect();
            if (!visibleItemView.getGlobalVisibleRect(weekRect) || weekRect.isEmpty()) {
                return null;
            }
            Rect dayRect = new Rect();
            List $this$findVisibleDay_u24lambda_u245 = ((Week)this.dataStore.get((Object)visibleIndex)).getDays();
            boolean bl = false;
            Iterable iterable = isFirst ? $this$findVisibleDay_u24lambda_u245 : CollectionsKt.reversed((Iterable)$this$findVisibleDay_u24lambda_u245);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                View dayView;
                WeekDay it = (WeekDay)element$iv;
                boolean bl2 = false;
                if (!(visibleItemView.findViewWithTag((Object)ItemRootKt.dayTag(it.getDate())) == null ? false : dayView.getGlobalVisibleRect(dayRect) && ExtensionsKt.intersects(dayRect, weekRect))) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        return v2;
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public final void updateData$view_release(@NotNull LocalDate startDate, @NotNull LocalDate endDate, @NotNull DayOfWeek firstDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
        Intrinsics.checkNotNullParameter((Object)endDate, (String)"endDate");
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        this.startDate = startDate;
        this.endDate = endDate;
        this.firstDayOfWeek = firstDayOfWeek;
        this.adjustedData = WeekDataKt.getWeekCalendarAdjustedRange((LocalDate)startDate, (LocalDate)endDate, (DayOfWeek)firstDayOfWeek);
        this.itemCount = WeekDataKt.getWeekIndicesCount((LocalDate)this.getStartDateAdjusted(), (LocalDate)this.getEndDateAdjusted());
        this.dataStore.clear();
        this.notifyDataSetChanged();
    }

    private static final Week dataStore$lambda$0(WeekCalendarAdapter this$0, int offset) {
        return WeekDataKt.getWeekCalendarData((LocalDate)this$0.getStartDateAdjusted(), (int)offset, (LocalDate)this$0.startDate, (LocalDate)this$0.endDate).getWeek();
    }

    private static final void onAttachedToRecyclerView$lambda$1(WeekCalendarAdapter this$0) {
        this$0.notifyWeekScrollListenerIfNeeded();
    }

    private static final void notifyWeekScrollListenerIfNeeded$lambda$4(WeekCalendarAdapter this$0) {
        this$0.notifyWeekScrollListenerIfNeeded();
    }
}

