/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendar.view.internal.yearcalendar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.kizitonwose.calendar.core.CalendarDay;
import com.kizitonwose.calendar.core.CalendarMonth;
import com.kizitonwose.calendar.core.CalendarYear;
import com.kizitonwose.calendar.core.OutDateStyle;
import com.kizitonwose.calendar.data.DataStore;
import com.kizitonwose.calendar.data.YearDataKt;
import com.kizitonwose.calendar.view.DaySize;
import com.kizitonwose.calendar.view.MarginValues;
import com.kizitonwose.calendar.view.MonthDayBinder;
import com.kizitonwose.calendar.view.MonthHeaderFooterBinder;
import com.kizitonwose.calendar.view.MonthHeight;
import com.kizitonwose.calendar.view.ViewContainer;
import com.kizitonwose.calendar.view.YearCalendarView;
import com.kizitonwose.calendar.view.YearHeaderFooterBinder;
import com.kizitonwose.calendar.view.internal.ExtensionsKt;
import com.kizitonwose.calendar.view.internal.ItemRootKt;
import com.kizitonwose.calendar.view.internal.yearcalendar.YearCalendarLayoutManager;
import com.kizitonwose.calendar.view.internal.yearcalendar.YearItemContent;
import com.kizitonwose.calendar.view.internal.yearcalendar.YearMonthHolder;
import com.kizitonwose.calendar.view.internal.yearcalendar.YearRootKt;
import com.kizitonwose.calendar.view.internal.yearcalendar.YearViewHolder;
import java.time.DayOfWeek;
import java.time.Year;
import java.time.YearMonth;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u000fH\u0016J\b\u0010\u001e\u001a\u00020\u000fH\u0016J\u0018\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000fH\u0016J&\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u000f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0016J\u0018\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u000fH\u0016J\u001f\u0010(\u001a\u00020\u00172\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0*\"\u00020+\u00a2\u0006\u0002\u0010,J\u000e\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u00020\bJ\u0006\u00102\u001a\u00020\u0017J\u0006\u00104\u001a\u00020\u0017J\u0015\u00105\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b6J\u0015\u00105\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020/H\u0000\u00a2\u0006\u0002\b6J\u0015\u00105\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020+H\u0000\u00a2\u0006\u0002\b6J\b\u0010;\u001a\u0004\u0018\u00010\u0012J\b\u0010<\u001a\u0004\u0018\u00010\u0012J\b\u0010=\u001a\u0004\u0018\u00010>J\b\u0010?\u001a\u0004\u0018\u00010>J\b\u0010@\u001a\u0004\u0018\u00010+J\b\u0010A\u001a\u0004\u0018\u00010+J\b\u0010B\u001a\u00020\u000fH\u0002J\b\u0010C\u001a\u00020\u000fH\u0002J\u0012\u0010D\u001a\u0004\u0018\u00010+2\u0006\u0010E\u001a\u00020\u0014H\u0002J(\u0010F\u001a\u0004\u0018\u00010+*\u0014\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020I0G2\u0006\u0010E\u001a\u00020\u0014H\u0002J\u0012\u0010J\u001a\u0004\u0018\u00010>2\u0006\u0010E\u001a\u00020\u0014H\u0002J.\u0010K\u001a\u0016\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020I\u0018\u00010G2\u0006\u0010E\u001a\u00020\u00142\b\b\u0002\u0010L\u001a\u00020\u000fH\u0002J-\u0010M\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\bNR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0010\u00103\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\u0002088BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:\u00a8\u0006O"}, d2={"Lcom/kizitonwose/calendar/view/internal/yearcalendar/YearCalendarAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/kizitonwose/calendar/view/internal/yearcalendar/YearViewHolder;", "calView", "Lcom/kizitonwose/calendar/view/YearCalendarView;", "outDateStyle", "Lcom/kizitonwose/calendar/core/OutDateStyle;", "startYear", "Ljava/time/Year;", "endYear", "firstDayOfWeek", "Ljava/time/DayOfWeek;", "<init>", "(Lcom/kizitonwose/calendar/view/YearCalendarView;Lcom/kizitonwose/calendar/core/OutDateStyle;Ljava/time/Year;Ljava/time/Year;Ljava/time/DayOfWeek;)V", "itemCount", "", "dataStore", "Lcom/kizitonwose/calendar/data/DataStore;", "Lcom/kizitonwose/calendar/core/CalendarYear;", "isAttached", "", "()Z", "onAttachedToRecyclerView", "", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "getItem", "position", "getItemId", "", "getItemCount", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onBindViewHolder", "holder", "payloads", "", "", "reloadDay", "day", "", "Lcom/kizitonwose/calendar/core/CalendarDay;", "([Lcom/kizitonwose/calendar/core/CalendarDay;)V", "reloadMonth", "month", "Ljava/time/YearMonth;", "reloadYear", "year", "reloadCalendar", "visibleYear", "notifyYearScrollListenerIfNeeded", "getAdapterPosition", "getAdapterPosition$view_release", "layoutManager", "Lcom/kizitonwose/calendar/view/internal/yearcalendar/YearCalendarLayoutManager;", "getLayoutManager", "()Lcom/kizitonwose/calendar/view/internal/yearcalendar/YearCalendarLayoutManager;", "findFirstVisibleYear", "findLastVisibleYear", "findFirstVisibleMonth", "Lcom/kizitonwose/calendar/core/CalendarMonth;", "findLastVisibleMonth", "findFirstVisibleDay", "findLastVisibleDay", "findFirstVisibleYearPosition", "findLastVisibleYearPosition", "findVisibleDay", "isFirst", "visibleDay", "Lkotlin/Triple;", "Landroid/view/View;", "Landroid/graphics/Rect;", "findVisibleMonth", "visibleMonthInfo", "yearIncrement", "updateData", "updateData$view_release", "view_release"})
@SourceDebugExtension(value={"SMAP\nYearCalendarAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YearCalendarAdapter.kt\ncom/kizitonwose/calendar/view/internal/yearcalendar/YearCalendarAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,291:1\n1863#2,2:292\n295#2,2:297\n13402#3,2:294\n1#4:296\n*S KotlinDebug\n*F\n+ 1 YearCalendarAdapter.kt\ncom/kizitonwose/calendar/view/internal/yearcalendar/YearCalendarAdapter\n*L\n98#1:292,2\n225#1:297,2\n113#1:294,2\n*E\n"})
public final class YearCalendarAdapter
extends RecyclerView.Adapter<YearViewHolder> {
    @NotNull
    private final YearCalendarView calView;
    @NotNull
    private OutDateStyle outDateStyle;
    @NotNull
    private Year startYear;
    @NotNull
    private Year endYear;
    @NotNull
    private DayOfWeek firstDayOfWeek;
    private int itemCount;
    @NotNull
    private final DataStore<CalendarYear> dataStore;
    @Nullable
    private CalendarYear visibleYear;

    public YearCalendarAdapter(@NotNull YearCalendarView calView, @NotNull OutDateStyle outDateStyle, @NotNull Year startYear, @NotNull Year endYear, @NotNull DayOfWeek firstDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)((Object)calView), (String)"calView");
        Intrinsics.checkNotNullParameter((Object)outDateStyle, (String)"outDateStyle");
        Intrinsics.checkNotNullParameter((Object)startYear, (String)"startYear");
        Intrinsics.checkNotNullParameter((Object)endYear, (String)"endYear");
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        this.calView = calView;
        this.outDateStyle = outDateStyle;
        this.startYear = startYear;
        this.endYear = endYear;
        this.firstDayOfWeek = firstDayOfWeek;
        this.itemCount = YearDataKt.getYearIndicesCount((Year)this.startYear, (Year)this.endYear);
        this.dataStore = new DataStore(null, arg_0 -> YearCalendarAdapter.dataStore$lambda$0(this, arg_0), 1, null);
        this.setHasStableIds(true);
    }

    private final boolean isAttached() {
        return this.calView.getAdapter() == this;
    }

    public void onAttachedToRecyclerView(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        this.calView.post(() -> YearCalendarAdapter.onAttachedToRecyclerView$lambda$1(this));
    }

    private final CalendarYear getItem(int position) {
        return (CalendarYear)this.dataStore.get((Object)position);
    }

    public long getItemId(int position) {
        return this.getItem(position).getYear().getValue();
    }

    public int getItemCount() {
        return this.itemCount;
    }

    @NotNull
    public YearViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Context context = this.calView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Context context2 = context;
        DaySize daySize = this.calView.getDaySize();
        MonthHeight monthHeight = this.calView.getMonthHeight();
        int n = this.calView.getDayViewResource();
        MonthDayBinder<ViewContainer> monthDayBinder = this.calView.getDayBinder();
        Intrinsics.checkNotNull(monthDayBinder, (String)"null cannot be cast to non-null type com.kizitonwose.calendar.view.MonthDayBinder<com.kizitonwose.calendar.view.ViewContainer>");
        MonthDayBinder<ViewContainer> monthDayBinder2 = monthDayBinder;
        int n2 = this.calView.getMonthColumns();
        int n3 = this.calView.getMonthHorizontalSpacing();
        int n4 = this.calView.getMonthVerticalSpacing();
        MarginValues marginValues = this.calView.getYearMargins();
        MarginValues marginValues2 = this.calView.getYearBodyMargins();
        int n5 = this.calView.getMonthHeaderResource();
        int n6 = this.calView.getMonthFooterResource();
        String string = this.calView.getMonthViewClass();
        MonthHeaderFooterBinder<ViewContainer> monthHeaderFooterBinder = this.calView.getMonthHeaderBinder();
        MonthHeaderFooterBinder<ViewContainer> monthHeaderFooterBinder2 = this.calView.getMonthFooterBinder();
        String string2 = this.calView.getYearViewClass();
        int n7 = this.calView.getYearHeaderResource();
        int n8 = this.calView.getYearFooterResource();
        YearItemContent content = YearRootKt.setupYearItemRoot(n2, n3, n4, marginValues, marginValues2, daySize, monthHeight, context2, n, monthDayBinder2, n5, n6, string, monthHeaderFooterBinder, monthHeaderFooterBinder2, string2, n7, n8);
        context2 = content.getItemView();
        daySize = content.getHeaderView();
        monthHeight = content.getFooterView();
        List<Pair<LinearLayout, List<YearMonthHolder>>> list = content.getMonthRowHolders();
        monthDayBinder2 = this.calView.isMonthVisible();
        YearHeaderFooterBinder<ViewContainer> yearHeaderFooterBinder = this.calView.getYearHeaderBinder();
        YearHeaderFooterBinder<ViewContainer> yearHeaderFooterBinder2 = this.calView.getYearFooterBinder();
        return new YearViewHolder((ViewGroup)context2, (View)daySize, (View)monthHeight, (List<? extends Pair<? extends LinearLayout, ? extends List<YearMonthHolder>>>)list, yearHeaderFooterBinder, yearHeaderFooterBinder2, (Function1<? super CalendarMonth, Boolean>)monthDayBinder2);
    }

    public void onBindViewHolder(@NotNull YearViewHolder holder, int position, @NotNull List<? extends Object> payloads) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Intrinsics.checkNotNullParameter(payloads, (String)"payloads");
        if (payloads.isEmpty()) {
            super.onBindViewHolder((RecyclerView.ViewHolder)holder, position, payloads);
        } else {
            Iterable $this$forEach$iv = payloads;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                Object t = it;
                if (t instanceof CalendarDay) {
                    holder.reloadDay((CalendarDay)it);
                    continue;
                }
                if (!(t instanceof YearMonth)) continue;
                holder.reloadMonth((YearMonth)it);
            }
        }
    }

    public void onBindViewHolder(@NotNull YearViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        holder.bindYear(this.getItem(position));
    }

    public final void reloadDay(CalendarDay ... day) {
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        CalendarDay[] $this$forEach$iv = day;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            CalendarDay element$iv;
            CalendarDay day2 = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            int position = this.getAdapterPosition$view_release(day2);
            if (position == -1) continue;
            this.notifyItemChanged(position, day2);
        }
    }

    public final void reloadMonth(@NotNull YearMonth month) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        int position = this.getAdapterPosition$view_release(month);
        if (position != -1) {
            this.notifyItemChanged(position, month);
        }
    }

    public final void reloadYear(@NotNull Year year) {
        Intrinsics.checkNotNullParameter((Object)year, (String)"year");
        this.notifyItemChanged(this.getAdapterPosition$view_release(year));
    }

    public final void reloadCalendar() {
        this.notifyItemRangeChanged(0, this.itemCount);
    }

    public final void notifyYearScrollListenerIfNeeded() {
        CalendarYear visibleYear;
        if (!this.isAttached()) {
            return;
        }
        if (this.calView.isAnimating()) {
            RecyclerView.ItemAnimator itemAnimator = this.calView.getItemAnimator();
            if (itemAnimator != null) {
                itemAnimator.isRunning(() -> YearCalendarAdapter.notifyYearScrollListenerIfNeeded$lambda$4(this));
            }
            return;
        }
        int visibleItemPos = this.findFirstVisibleYearPosition();
        if (visibleItemPos != -1 && !Intrinsics.areEqual((Object)(visibleYear = (CalendarYear)this.dataStore.get((Object)visibleItemPos)), (Object)this.visibleYear)) {
            this.visibleYear = visibleYear;
            Function1<CalendarYear, Unit> function1 = this.calView.getYearScrollListener();
            if (function1 != null) {
                function1.invoke((Object)visibleYear);
            }
            if (this.calView.getScrollPaged() && this.calView.getLayoutParams().height == -2) {
                RecyclerView.ViewHolder viewHolder = this.calView.findViewHolderForAdapterPosition(visibleItemPos);
                if (viewHolder == null) {
                    return;
                }
                RecyclerView.ViewHolder visibleVH = viewHolder;
                visibleVH.itemView.requestLayout();
            }
        }
    }

    public final int getAdapterPosition$view_release(@NotNull Year year) {
        Intrinsics.checkNotNullParameter((Object)year, (String)"year");
        return YearDataKt.getYearIndex((Year)this.startYear, (Year)year);
    }

    public final int getAdapterPosition$view_release(@NotNull YearMonth month) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        Year year = Year.of(month.getYear());
        Intrinsics.checkNotNullExpressionValue((Object)year, (String)"of(...)");
        return this.getAdapterPosition$view_release(year);
    }

    public final int getAdapterPosition$view_release(@NotNull CalendarDay day) {
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        return this.getAdapterPosition$view_release(com.kizitonwose.calendar.data.ExtensionsKt.getPositionYearMonth((CalendarDay)day));
    }

    private final YearCalendarLayoutManager getLayoutManager() {
        RecyclerView.LayoutManager layoutManager = this.calView.getLayoutManager();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type com.kizitonwose.calendar.view.internal.yearcalendar.YearCalendarLayoutManager");
        return (YearCalendarLayoutManager)layoutManager;
    }

    @Nullable
    public final CalendarYear findFirstVisibleYear() {
        int index = this.findFirstVisibleYearPosition();
        return index == -1 ? null : (CalendarYear)this.dataStore.get((Object)index);
    }

    @Nullable
    public final CalendarYear findLastVisibleYear() {
        int index = this.findLastVisibleYearPosition();
        return index == -1 ? null : (CalendarYear)this.dataStore.get((Object)index);
    }

    @Nullable
    public final CalendarMonth findFirstVisibleMonth() {
        return this.findVisibleMonth(true);
    }

    @Nullable
    public final CalendarMonth findLastVisibleMonth() {
        return this.findVisibleMonth(false);
    }

    @Nullable
    public final CalendarDay findFirstVisibleDay() {
        return this.findVisibleDay(true);
    }

    @Nullable
    public final CalendarDay findLastVisibleDay() {
        return this.findVisibleDay(false);
    }

    private final int findFirstVisibleYearPosition() {
        return this.getLayoutManager().findFirstVisibleItemPosition();
    }

    private final int findLastVisibleYearPosition() {
        return this.getLayoutManager().findLastVisibleItemPosition();
    }

    private final CalendarDay findVisibleDay(boolean isFirst) {
        Object object = YearCalendarAdapter.visibleMonthInfo$default(this, isFirst, 0, 2, null);
        if (object == null || (object = this.visibleDay((Triple<CalendarMonth, ? extends View, Rect>)object, isFirst)) == null) {
            Triple<CalendarMonth, View, Rect> triple = this.visibleMonthInfo(isFirst, -1);
            object = triple != null ? this.visibleDay(triple, isFirst) : null;
            if (object == null) {
                Triple<CalendarMonth, View, Rect> triple2 = this.visibleMonthInfo(isFirst, 1);
                object = triple2 != null ? this.visibleDay(triple2, isFirst) : null;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final CalendarDay visibleDay(Triple<CalendarMonth, ? extends View, Rect> $this$visibleDay, boolean isFirst) {
        Object v0;
        block1: {
            void $this$firstOrNull$iv;
            CalendarMonth visibleMonth = (CalendarMonth)$this$visibleDay.component1();
            View visibleMonthView = (View)$this$visibleDay.component2();
            Rect visibleMonthRect = (Rect)$this$visibleDay.component3();
            Rect dayRect = new Rect();
            List $this$visibleDay_u24lambda_u245 = CollectionsKt.flatten((Iterable)visibleMonth.getWeekDays());
            boolean bl = false;
            Iterable iterable = isFirst ? $this$visibleDay_u24lambda_u245 : CollectionsKt.reversed((Iterable)$this$visibleDay_u24lambda_u245);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                View dayView;
                CalendarDay it = (CalendarDay)element$iv;
                boolean bl2 = false;
                if (!(visibleMonthView.findViewWithTag((Object)ItemRootKt.dayTag(it.getDate())) == null ? false : dayView.getGlobalVisibleRect(dayRect) && ExtensionsKt.intersects(dayRect, visibleMonthRect))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final CalendarMonth findVisibleMonth(boolean isFirst) {
        Object object = YearCalendarAdapter.visibleMonthInfo$default(this, isFirst, 0, 2, null);
        if (object == null || (object = (CalendarMonth)object.getFirst()) == null) {
            Triple<CalendarMonth, View, Rect> triple = this.visibleMonthInfo(isFirst, -1);
            if (triple != null) {
                object = (CalendarMonth)triple.getFirst();
            } else {
                Triple<CalendarMonth, View, Rect> triple2 = this.visibleMonthInfo(isFirst, 1);
                object = triple2 != null ? (CalendarMonth)triple2.getFirst() : null;
            }
        }
        return object;
    }

    private final Triple<CalendarMonth, View, Rect> visibleMonthInfo(boolean isFirst, int yearIncrement) {
        Triple triple;
        block4: {
            int visibleIndex;
            int n = visibleIndex = isFirst ? this.findFirstVisibleYearPosition() : this.findLastVisibleYearPosition();
            if (visibleIndex == -1) {
                return null;
            }
            View view = this.getLayoutManager().findViewByPosition(visibleIndex += yearIncrement);
            if (view == null) {
                return null;
            }
            View visibleItemView = view;
            Rect yearRect = new Rect();
            if (!visibleItemView.getGlobalVisibleRect(yearRect) || yearRect.isEmpty()) {
                return null;
            }
            Rect monthRect = new Rect();
            List $this$visibleMonthInfo_u24lambda_u247 = ((CalendarYear)this.dataStore.get((Object)visibleIndex)).getMonths();
            boolean bl = false;
            for (CalendarMonth it : (Iterable)(isFirst ? $this$visibleMonthInfo_u24lambda_u247 : CollectionsKt.reversed((Iterable)$this$visibleMonthInfo_u24lambda_u247))) {
                View monthView;
                boolean bl2 = false;
                Triple triple2 = visibleItemView.findViewWithTag((Object)YearRootKt.monthTag(it.getYearMonth())) == null ? null : (monthView.getGlobalVisibleRect(monthRect) && ExtensionsKt.intersects(monthRect, yearRect) ? new Triple((Object)it, (Object)monthView, (Object)monthRect) : null);
                if (triple2 == null) continue;
                triple = triple2;
                break block4;
            }
            triple = null;
        }
        return triple;
    }

    static /* synthetic */ Triple visibleMonthInfo$default(YearCalendarAdapter yearCalendarAdapter, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return yearCalendarAdapter.visibleMonthInfo(bl, n);
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public final void updateData$view_release(@NotNull Year startYear, @NotNull Year endYear, @NotNull OutDateStyle outDateStyle, @NotNull DayOfWeek firstDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)startYear, (String)"startYear");
        Intrinsics.checkNotNullParameter((Object)endYear, (String)"endYear");
        Intrinsics.checkNotNullParameter((Object)outDateStyle, (String)"outDateStyle");
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        this.startYear = startYear;
        this.endYear = endYear;
        this.outDateStyle = outDateStyle;
        this.firstDayOfWeek = firstDayOfWeek;
        this.itemCount = YearDataKt.getYearIndicesCount((Year)startYear, (Year)endYear);
        this.dataStore.clear();
        this.notifyDataSetChanged();
    }

    private static final CalendarYear dataStore$lambda$0(YearCalendarAdapter this$0, int offset) {
        return YearDataKt.getCalendarYearData((Year)this$0.startYear, (int)offset, (DayOfWeek)this$0.firstDayOfWeek, (OutDateStyle)this$0.outDateStyle);
    }

    private static final void onAttachedToRecyclerView$lambda$1(YearCalendarAdapter this$0) {
        this$0.notifyYearScrollListenerIfNeeded();
    }

    private static final void notifyYearScrollListenerIfNeeded$lambda$4(YearCalendarAdapter this$0) {
        this$0.notifyYearScrollListenerIfNeeded();
    }
}

