/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendar.view.internal;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import com.kizitonwose.calendar.view.MarginValues;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0001 B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000f\u001a\u00020\u0010H&J\b\u0010\u0011\u001a\u00020\u0012H&J\b\u0010\u0013\u001a\u00020\u0014H&J\u0013\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00028\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/kizitonwose/calendar/view/internal/CalendarLayoutManager;", "IndexData", "DayData", "Landroidx/recyclerview/widget/LinearLayoutManager;", "calView", "Landroidx/recyclerview/widget/RecyclerView;", "orientation", "", "<init>", "(Landroidx/recyclerview/widget/RecyclerView;I)V", "getaItemAdapterPosition", "data", "(Ljava/lang/Object;)I", "getaDayAdapterPosition", "getDayTag", "getItemMargins", "Lcom/kizitonwose/calendar/view/MarginValues;", "scrollPaged", "", "notifyScrollListenerIfNeeded", "", "scrollToIndex", "indexData", "(Ljava/lang/Object;)V", "smoothScrollToIndex", "smoothScrollToDay", "day", "scrollToDay", "calculateDayViewOffsetInParent", "itemView", "Landroid/view/View;", "(Ljava/lang/Object;Landroid/view/View;)I", "CalendarSmoothScroller", "view_release"})
public abstract class CalendarLayoutManager<IndexData, DayData>
extends LinearLayoutManager {
    @NotNull
    private final RecyclerView calView;

    public CalendarLayoutManager(@NotNull RecyclerView calView, int orientation) {
        Intrinsics.checkNotNullParameter((Object)calView, (String)"calView");
        super(calView.getContext(), orientation, false);
        this.calView = calView;
    }

    public abstract int getaItemAdapterPosition(IndexData var1);

    public abstract int getaDayAdapterPosition(DayData var1);

    public abstract int getDayTag(DayData var1);

    @NotNull
    public abstract MarginValues getItemMargins();

    public abstract boolean scrollPaged();

    public abstract void notifyScrollListenerIfNeeded();

    public final void scrollToIndex(IndexData indexData) {
        int position = this.getaItemAdapterPosition(indexData);
        if (position == -1) {
            return;
        }
        this.scrollToPositionWithOffset(position, 0);
        this.calView.post(() -> CalendarLayoutManager.scrollToIndex$lambda$0(this));
    }

    public final void smoothScrollToIndex(IndexData indexData) {
        int position = this.getaItemAdapterPosition(indexData);
        if (position == -1) {
            return;
        }
        this.startSmoothScroll((RecyclerView.SmoothScroller)new CalendarSmoothScroller(position, null));
    }

    public final void smoothScrollToDay(DayData day) {
        int indexPosition = this.getaDayAdapterPosition(day);
        if (indexPosition == -1) {
            return;
        }
        this.startSmoothScroll((RecyclerView.SmoothScroller)new CalendarSmoothScroller(indexPosition, this.scrollPaged() ? null : (Object)day));
    }

    public final void scrollToDay(DayData day) {
        int indexPosition = this.getaDayAdapterPosition(day);
        if (indexPosition == -1) {
            return;
        }
        this.scrollToPositionWithOffset(indexPosition, 0);
        boolean bl = this.scrollPaged() ? this.calView.post(() -> CalendarLayoutManager.scrollToDay$lambda$1(this)) : this.calView.post(() -> CalendarLayoutManager.scrollToDay$lambda$3(this, indexPosition, day));
    }

    private final int calculateDayViewOffsetInParent(DayData day, View itemView) {
        View view = itemView.findViewWithTag((Object)this.getDayTag(day));
        if (view == null) {
            return 0;
        }
        View dayView = view;
        Rect rect = new Rect();
        dayView.getDrawingRect(rect);
        Intrinsics.checkNotNull((Object)itemView, (String)"null cannot be cast to non-null type android.view.ViewGroup");
        ((ViewGroup)itemView).offsetDescendantRectToMyCoords(dayView, rect);
        MarginValues margins = this.getItemMargins();
        return this.getOrientation() == 1 ? rect.top + margins.getTop() : rect.left + margins.getStart();
    }

    private static final void scrollToIndex$lambda$0(CalendarLayoutManager this$0) {
        this$0.notifyScrollListenerIfNeeded();
    }

    private static final void scrollToDay$lambda$1(CalendarLayoutManager this$0) {
        this$0.notifyScrollListenerIfNeeded();
    }

    private static final void scrollToDay$lambda$3$lambda$2(CalendarLayoutManager this$0) {
        this$0.notifyScrollListenerIfNeeded();
    }

    private static final void scrollToDay$lambda$3(CalendarLayoutManager this$0, int $indexPosition, Object $day) {
        RecyclerView.ViewHolder viewHolder = this$0.calView.findViewHolderForAdapterPosition($indexPosition);
        if (viewHolder == null || (viewHolder = viewHolder.itemView) == null) {
            return;
        }
        RecyclerView.ViewHolder itemView = viewHolder;
        int offset = this$0.calculateDayViewOffsetInParent($day, (View)itemView);
        this$0.scrollToPositionWithOffset($indexPosition, -offset);
        this$0.calView.post(() -> CalendarLayoutManager.scrollToDay$lambda$3$lambda$2(this$0));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u0003H\u0014J\b\u0010\u000b\u001a\u00020\u0003H\u0014J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016R\u0015\u0010\u0004\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/kizitonwose/calendar/view/internal/CalendarLayoutManager$CalendarSmoothScroller;", "Landroidx/recyclerview/widget/LinearSmoothScroller;", "position", "", "day", "<init>", "(Lcom/kizitonwose/calendar/view/internal/CalendarLayoutManager;ILjava/lang/Object;)V", "getDay", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getVerticalSnapPreference", "getHorizontalSnapPreference", "calculateDyToMakeVisible", "view", "Landroid/view/View;", "snapPreference", "calculateDxToMakeVisible", "view_release"})
    private final class CalendarSmoothScroller
    extends LinearSmoothScroller {
        @Nullable
        private final DayData day;

        public CalendarSmoothScroller(@Nullable int position, DayData day) {
            super(CalendarLayoutManager.this.calView.getContext());
            this.day = day;
            this.setTargetPosition(position);
        }

        @Nullable
        public final DayData getDay() {
            return this.day;
        }

        protected int getVerticalSnapPreference() {
            return -1;
        }

        protected int getHorizontalSnapPreference() {
            return -1;
        }

        public int calculateDyToMakeVisible(@NotNull View view, int snapPreference) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            int dy = super.calculateDyToMakeVisible(view, snapPreference);
            if (this.day == null) {
                return dy;
            }
            int offset = CalendarLayoutManager.this.calculateDayViewOffsetInParent(this.day, view);
            return dy - offset;
        }

        public int calculateDxToMakeVisible(@NotNull View view, int snapPreference) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            int dx = super.calculateDxToMakeVisible(view, snapPreference);
            if (this.day == null) {
                return dx;
            }
            int offset = CalendarLayoutManager.this.calculateDayViewOffsetInParent(this.day, view);
            return dx - offset;
        }
    }
}

