/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendar.view.internal.monthcalendar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.kizitonwose.calendar.core.CalendarDay;
import com.kizitonwose.calendar.core.CalendarMonth;
import com.kizitonwose.calendar.core.OutDateStyle;
import com.kizitonwose.calendar.data.DataStore;
import com.kizitonwose.calendar.data.MonthDataKt;
import com.kizitonwose.calendar.view.Binder;
import com.kizitonwose.calendar.view.CalendarView;
import com.kizitonwose.calendar.view.DaySize;
import com.kizitonwose.calendar.view.MarginValues;
import com.kizitonwose.calendar.view.MonthDayBinder;
import com.kizitonwose.calendar.view.internal.ItemContent;
import com.kizitonwose.calendar.view.internal.UtilsKt;
import com.kizitonwose.calendar.view.internal.monthcalendar.MonthCalendarAdapterKt;
import com.kizitonwose.calendar.view.internal.monthcalendar.MonthCalendarLayoutManager;
import com.kizitonwose.calendar.view.internal.monthcalendar.MonthViewHolder;
import java.time.DayOfWeek;
import java.time.YearMonth;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\b\u0010\u001c\u001a\u0004\u0018\u00010\u000fJ\b\u0010\u001d\u001a\u00020\u0014H\u0002J\b\u0010\u001e\u001a\u0004\u0018\u00010\u001bJ\b\u0010\u001f\u001a\u0004\u0018\u00010\u000fJ\b\u0010 \u001a\u00020\u0014H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\"\u001a\u00020\u0011H\u0002J\u0015\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b%J\u0015\u0010#\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b%J\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u0014H\u0002J\b\u0010)\u001a\u00020\u0014H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010(\u001a\u00020\u0014H\u0016J\u0006\u0010,\u001a\u00020-J\u0010\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u000200H\u0016J\u0018\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u0014H\u0016J&\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u00142\f\u00103\u001a\b\u0012\u0004\u0012\u00020504H\u0016J\u0018\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0014H\u0016J\u0006\u0010:\u001a\u00020-J\u001f\u0010;\u001a\u00020-2\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0<\"\u00020\u001b\u00a2\u0006\u0002\u0010=J\u000e\u0010>\u001a\u00020-2\u0006\u0010&\u001a\u00020\bJ-\u0010?\u001a\u00020-2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b@R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/kizitonwose/calendar/view/internal/monthcalendar/MonthCalendarAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/kizitonwose/calendar/view/internal/monthcalendar/MonthViewHolder;", "calView", "Lcom/kizitonwose/calendar/view/CalendarView;", "outDateStyle", "Lcom/kizitonwose/calendar/core/OutDateStyle;", "startMonth", "Ljava/time/YearMonth;", "endMonth", "firstDayOfWeek", "Ljava/time/DayOfWeek;", "(Lcom/kizitonwose/calendar/view/CalendarView;Lcom/kizitonwose/calendar/core/OutDateStyle;Ljava/time/YearMonth;Ljava/time/YearMonth;Ljava/time/DayOfWeek;)V", "dataStore", "Lcom/kizitonwose/calendar/data/DataStore;", "Lcom/kizitonwose/calendar/core/CalendarMonth;", "isAttached", "", "()Z", "itemCount", "", "layoutManager", "Lcom/kizitonwose/calendar/view/internal/monthcalendar/MonthCalendarLayoutManager;", "getLayoutManager", "()Lcom/kizitonwose/calendar/view/internal/monthcalendar/MonthCalendarLayoutManager;", "visibleMonth", "findFirstVisibleDay", "Lcom/kizitonwose/calendar/core/CalendarDay;", "findFirstVisibleMonth", "findFirstVisibleMonthPosition", "findLastVisibleDay", "findLastVisibleMonth", "findLastVisibleMonthPosition", "findVisibleDay", "isFirst", "getAdapterPosition", "day", "getAdapterPosition$view_release", "month", "getItem", "position", "getItemCount", "getItemId", "", "notifyMonthScrollListenerIfNeeded", "", "onAttachedToRecyclerView", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "onBindViewHolder", "holder", "payloads", "", "", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "reloadCalendar", "reloadDay", "", "([Lcom/kizitonwose/calendar/core/CalendarDay;)V", "reloadMonth", "updateData", "updateData$view_release", "view_release"})
@SourceDebugExtension(value={"SMAP\nMonthCalendarAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonthCalendarAdapter.kt\ncom/kizitonwose/calendar/view/internal/monthcalendar/MonthCalendarAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n1855#2,2:232\n288#2,2:237\n13309#3,2:234\n1#4:236\n*S KotlinDebug\n*F\n+ 1 MonthCalendarAdapter.kt\ncom/kizitonwose/calendar/view/internal/monthcalendar/MonthCalendarAdapter\n*L\n87#1:232,2\n199#1:237,2\n98#1:234,2\n*E\n"})
public final class MonthCalendarAdapter
extends RecyclerView.Adapter<MonthViewHolder> {
    @NotNull
    private final CalendarView calView;
    @NotNull
    private OutDateStyle outDateStyle;
    @NotNull
    private YearMonth startMonth;
    @NotNull
    private YearMonth endMonth;
    @NotNull
    private DayOfWeek firstDayOfWeek;
    private int itemCount;
    @NotNull
    private final DataStore<CalendarMonth> dataStore;
    @Nullable
    private CalendarMonth visibleMonth;

    public MonthCalendarAdapter(@NotNull CalendarView calView, @NotNull OutDateStyle outDateStyle, @NotNull YearMonth startMonth, @NotNull YearMonth endMonth, @NotNull DayOfWeek firstDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)((Object)calView), (String)"calView");
        Intrinsics.checkNotNullParameter((Object)outDateStyle, (String)"outDateStyle");
        Intrinsics.checkNotNullParameter((Object)startMonth, (String)"startMonth");
        Intrinsics.checkNotNullParameter((Object)endMonth, (String)"endMonth");
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        this.calView = calView;
        this.outDateStyle = outDateStyle;
        this.startMonth = startMonth;
        this.endMonth = endMonth;
        this.firstDayOfWeek = firstDayOfWeek;
        this.itemCount = MonthDataKt.getMonthIndicesCount((YearMonth)this.startMonth, (YearMonth)this.endMonth);
        this.dataStore = new DataStore(null, (Function1)new Function1<Integer, CalendarMonth>(this){
            final /* synthetic */ MonthCalendarAdapter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CalendarMonth invoke(int offset) {
                return MonthDataKt.getCalendarMonthData((YearMonth)MonthCalendarAdapter.access$getStartMonth$p(this.this$0), (int)offset, (DayOfWeek)MonthCalendarAdapter.access$getFirstDayOfWeek$p(this.this$0), (OutDateStyle)MonthCalendarAdapter.access$getOutDateStyle$p(this.this$0)).getCalendarMonth();
            }
        }, 1, null);
        this.setHasStableIds(true);
    }

    private final boolean isAttached() {
        return this.calView.getAdapter() == this;
    }

    public void onAttachedToRecyclerView(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        this.calView.post(() -> MonthCalendarAdapter.onAttachedToRecyclerView$lambda$0(this));
    }

    private final CalendarMonth getItem(int position) {
        return (CalendarMonth)this.dataStore.get((Object)position);
    }

    public long getItemId(int position) {
        return this.getItem(position).getYearMonth().hashCode();
    }

    public int getItemCount() {
        return this.itemCount;
    }

    @NotNull
    public MonthViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        MarginValues marginValues = this.calView.getMonthMargins();
        DaySize daySize = this.calView.getDaySize();
        Context context = this.calView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        int n = this.calView.getDayViewResource();
        int n2 = this.calView.getMonthHeaderResource();
        int n3 = this.calView.getMonthFooterResource();
        String string = this.calView.getMonthViewClass();
        MonthDayBinder<?> monthDayBinder = this.calView.getDayBinder();
        Intrinsics.checkNotNull(monthDayBinder, (String)"null cannot be cast to non-null type com.kizitonwose.calendar.view.MonthDayBinder<*>");
        ItemContent content = UtilsKt.setupItemRoot(marginValues, daySize, context, n, n2, n3, 6, string, (Binder)monthDayBinder);
        return new MonthViewHolder(content.getItemView(), content.getHeaderView(), content.getFooterView(), content.getWeekHolders(), this.calView.getMonthHeaderBinder(), this.calView.getMonthFooterBinder());
    }

    public void onBindViewHolder(@NotNull MonthViewHolder holder, int position, @NotNull List<? extends Object> payloads) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Intrinsics.checkNotNullParameter(payloads, (String)"payloads");
        if (payloads.isEmpty()) {
            super.onBindViewHolder((RecyclerView.ViewHolder)holder, position, payloads);
        } else {
            Iterable $this$forEach$iv = payloads;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type com.kizitonwose.calendar.core.CalendarDay");
                holder.reloadDay((CalendarDay)it);
            }
        }
    }

    public void onBindViewHolder(@NotNull MonthViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        holder.bindMonth(this.getItem(position));
    }

    public final void reloadDay(CalendarDay ... day) {
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        CalendarDay[] $this$forEach$iv = day;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            CalendarDay element$iv;
            CalendarDay day2 = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            int position = this.getAdapterPosition$view_release(day2);
            if (position == -1) continue;
            this.notifyItemChanged(position, day2);
        }
    }

    public final void reloadMonth(@NotNull YearMonth month) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        this.notifyItemChanged(this.getAdapterPosition$view_release(month));
    }

    public final void reloadCalendar() {
        this.notifyItemRangeChanged(0, this.itemCount);
    }

    public final void notifyMonthScrollListenerIfNeeded() {
        CalendarMonth visibleMonth;
        if (!this.isAttached()) {
            return;
        }
        if (this.calView.isAnimating()) {
            RecyclerView.ItemAnimator itemAnimator = this.calView.getItemAnimator();
            if (itemAnimator != null) {
                itemAnimator.isRunning(() -> MonthCalendarAdapter.notifyMonthScrollListenerIfNeeded$lambda$3(this));
            }
            return;
        }
        int visibleItemPos = this.findFirstVisibleMonthPosition();
        if (visibleItemPos != -1 && !Intrinsics.areEqual((Object)(visibleMonth = (CalendarMonth)this.dataStore.get((Object)visibleItemPos)), (Object)this.visibleMonth)) {
            this.visibleMonth = visibleMonth;
            Function1<CalendarMonth, Unit> function1 = this.calView.getMonthScrollListener();
            if (function1 != null) {
                function1.invoke((Object)visibleMonth);
            }
            if (this.calView.getScrollPaged() && this.calView.getLayoutParams().height == -2) {
                RecyclerView.ViewHolder viewHolder = this.calView.findViewHolderForAdapterPosition(visibleItemPos);
                if (viewHolder == null) {
                    return;
                }
                RecyclerView.ViewHolder visibleVH = viewHolder;
                visibleVH.itemView.requestLayout();
            }
        }
    }

    public final int getAdapterPosition$view_release(@NotNull YearMonth month) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        return MonthDataKt.getMonthIndex((YearMonth)this.startMonth, (YearMonth)month);
    }

    public final int getAdapterPosition$view_release(@NotNull CalendarDay day) {
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        return this.getAdapterPosition$view_release(MonthCalendarAdapterKt.getPositionYearMonth(day));
    }

    private final MonthCalendarLayoutManager getLayoutManager() {
        RecyclerView.LayoutManager layoutManager = this.calView.getLayoutManager();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type com.kizitonwose.calendar.view.internal.monthcalendar.MonthCalendarLayoutManager");
        return (MonthCalendarLayoutManager)layoutManager;
    }

    @Nullable
    public final CalendarMonth findFirstVisibleMonth() {
        int index = this.findFirstVisibleMonthPosition();
        return index == -1 ? null : (CalendarMonth)this.dataStore.get((Object)index);
    }

    @Nullable
    public final CalendarMonth findLastVisibleMonth() {
        int index = this.findLastVisibleMonthPosition();
        return index == -1 ? null : (CalendarMonth)this.dataStore.get((Object)index);
    }

    @Nullable
    public final CalendarDay findFirstVisibleDay() {
        return this.findVisibleDay(true);
    }

    @Nullable
    public final CalendarDay findLastVisibleDay() {
        return this.findVisibleDay(false);
    }

    private final int findFirstVisibleMonthPosition() {
        return this.getLayoutManager().findFirstVisibleItemPosition();
    }

    private final int findLastVisibleMonthPosition() {
        return this.getLayoutManager().findLastVisibleItemPosition();
    }

    /*
     * WARNING - void declaration
     */
    private final CalendarDay findVisibleDay(boolean isFirst) {
        Object v3;
        block5: {
            void $this$firstOrNull$iv;
            int visibleIndex;
            int n = visibleIndex = isFirst ? this.findFirstVisibleMonthPosition() : this.findLastVisibleMonthPosition();
            if (visibleIndex == -1) {
                return null;
            }
            View view = this.getLayoutManager().findViewByPosition(visibleIndex);
            if (view == null) {
                return null;
            }
            View visibleItemView = view;
            Rect monthRect = new Rect();
            visibleItemView.getGlobalVisibleRect(monthRect);
            Rect dayRect = new Rect();
            List $this$findVisibleDay_u24lambda_u244 = CollectionsKt.flatten((Iterable)((CalendarMonth)this.dataStore.get((Object)visibleIndex)).getWeekDays());
            boolean bl = false;
            Iterable iterable = isFirst ? $this$findVisibleDay_u24lambda_u244 : CollectionsKt.reversed((Iterable)$this$findVisibleDay_u24lambda_u244);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl2;
                CalendarDay it = (CalendarDay)element$iv;
                boolean bl3 = false;
                View view2 = visibleItemView.findViewWithTag((Object)UtilsKt.dayTag(it.getDate()));
                if (view2 == null) {
                    bl2 = false;
                } else {
                    View dayView = view2;
                    dayView.getGlobalVisibleRect(dayRect);
                    bl2 = dayRect.intersect(monthRect);
                }
                if (!bl2) continue;
                v3 = element$iv;
                break block5;
            }
            v3 = null;
        }
        return v3;
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public final void updateData$view_release(@NotNull YearMonth startMonth, @NotNull YearMonth endMonth, @NotNull OutDateStyle outDateStyle, @NotNull DayOfWeek firstDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)startMonth, (String)"startMonth");
        Intrinsics.checkNotNullParameter((Object)endMonth, (String)"endMonth");
        Intrinsics.checkNotNullParameter((Object)outDateStyle, (String)"outDateStyle");
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        this.startMonth = startMonth;
        this.endMonth = endMonth;
        this.outDateStyle = outDateStyle;
        this.firstDayOfWeek = firstDayOfWeek;
        this.itemCount = MonthDataKt.getMonthIndicesCount((YearMonth)startMonth, (YearMonth)endMonth);
        this.dataStore.clear();
        this.notifyDataSetChanged();
    }

    private static final void onAttachedToRecyclerView$lambda$0(MonthCalendarAdapter this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.notifyMonthScrollListenerIfNeeded();
    }

    private static final void notifyMonthScrollListenerIfNeeded$lambda$3(MonthCalendarAdapter this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.notifyMonthScrollListenerIfNeeded();
    }

    public static final /* synthetic */ YearMonth access$getStartMonth$p(MonthCalendarAdapter $this) {
        return $this.startMonth;
    }

    public static final /* synthetic */ DayOfWeek access$getFirstDayOfWeek$p(MonthCalendarAdapter $this) {
        return $this.firstDayOfWeek;
    }

    public static final /* synthetic */ OutDateStyle access$getOutDateStyle$p(MonthCalendarAdapter $this) {
        return $this.outDateStyle;
    }
}

