/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendar.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcelable;
import android.util.AttributeSet;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.kizitonwose.calendar.core.CalendarDay;
import com.kizitonwose.calendar.core.CalendarMonth;
import com.kizitonwose.calendar.core.DayPosition;
import com.kizitonwose.calendar.core.OutDateStyle;
import com.kizitonwose.calendar.data.UtilsKt;
import com.kizitonwose.calendar.view.CalendarView;
import com.kizitonwose.calendar.view.DaySize;
import com.kizitonwose.calendar.view.MarginValues;
import com.kizitonwose.calendar.view.MonthDayBinder;
import com.kizitonwose.calendar.view.MonthHeaderFooterBinder;
import com.kizitonwose.calendar.view.R;
import com.kizitonwose.calendar.view.internal.CalendarPageSnapHelper;
import com.kizitonwose.calendar.view.internal.CalendarPageSnapHelperLegacy;
import com.kizitonwose.calendar.view.internal.monthcalendar.MonthCalendarAdapter;
import com.kizitonwose.calendar.view.internal.monthcalendar.MonthCalendarLayoutManager;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c7\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0013*\u0001]\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010h\u001a\u0004\u0018\u00010iJ\b\u0010j\u001a\u0004\u0018\u00010BJ\b\u0010k\u001a\u0004\u0018\u00010iJ\b\u0010l\u001a\u0004\u0018\u00010BJ\u0014\u0010m\u001a\u00060nj\u0002`o2\u0006\u0010p\u001a\u00020IH\u0002J \u0010q\u001a\u00020C2\u0006\u0010r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010s\u001a\u00020\tH\u0002J\b\u0010t\u001a\u00020CH\u0002J\u0006\u0010u\u001a\u00020CJ\u001a\u0010v\u001a\u00020C2\u0006\u0010w\u001a\u00020x2\b\b\u0002\u0010y\u001a\u00020zH\u0007J'\u0010v\u001a\u00020C2\u0006\u0010w\u001a\u00020x2\u0012\u0010y\u001a\n\u0012\u0006\b\u0001\u0012\u00020z0{\"\u00020z\u00a2\u0006\u0002\u0010|J\u000e\u0010}\u001a\u00020C2\u0006\u0010~\u001a\u00020iJ\u000f\u0010\u007f\u001a\u00020C2\u0007\u0010\u0080\u0001\u001a\u00020&J\t\u0010\u0081\u0001\u001a\u00020&H\u0002J\t\u0010\u0082\u0001\u001a\u00020(H\u0002J\t\u0010\u0083\u0001\u001a\u00020&H\u0002J\u001b\u0010\u0084\u0001\u001a\u00020C2\u0006\u0010w\u001a\u00020x2\b\b\u0002\u0010y\u001a\u00020zH\u0007J\u000f\u0010\u0085\u0001\u001a\u00020C2\u0006\u0010~\u001a\u00020iJ\u0010\u0010\u0086\u0001\u001a\u00020C2\u0007\u0010\u0080\u0001\u001a\u00020&J\u001f\u0010\u0087\u0001\u001a\u00020C2\u0006\u0010e\u001a\u00020&2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u001b\u0010\u0088\u0001\u001a\u00020C2\u0006\u0010w\u001a\u00020x2\b\b\u0002\u0010y\u001a\u00020zH\u0007J\u000f\u0010\u0089\u0001\u001a\u00020C2\u0006\u0010~\u001a\u00020iJ\u0010\u0010\u008a\u0001\u001a\u00020C2\u0007\u0010\u0080\u0001\u001a\u00020&J\t\u0010\u008b\u0001\u001a\u00020CH\u0002J'\u0010\u008c\u0001\u001a\u00020C2\b\b\u0002\u0010e\u001a\u00020&2\b\b\u0002\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020(H\u0007J\t\u0010\u008d\u0001\u001a\u00020CH\u0002R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R0\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u001a@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010 \u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010,\u001a\b\u0012\u0002\b\u0003\u0018\u00010+2\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010+@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R$\u00101\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\"\"\u0004\b3\u0010$R0\u00104\u001a\b\u0012\u0002\b\u0003\u0018\u00010+2\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010+@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010.\"\u0004\b6\u00100R$\u00107\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\"\"\u0004\b9\u0010$R$\u0010;\u001a\u00020:2\u0006\u0010\u0013\u001a\u00020:@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R.\u0010@\u001a\u0016\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020C\u0018\u00010Aj\u0004\u0018\u0001`DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR(\u0010J\u001a\u0004\u0018\u00010I2\b\u0010\u0013\u001a\u0004\u0018\u00010I@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR*\u0010O\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bP\u0010Q\u001a\u0004\bR\u0010\"\"\u0004\bS\u0010$R$\u0010U\u001a\u00020T2\u0006\u0010\u0013\u001a\u00020T@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010W\"\u0004\bX\u0010YR\u000e\u0010Z\u001a\u00020[X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\\\u001a\u00020]X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010^R$\u0010`\u001a\u00020_2\u0006\u0010\u0013\u001a\u00020_@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010b\"\u0004\bc\u0010dR\u0010\u0010e\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010f\u001a\u00020gX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008e\u0001"}, d2={"Lcom/kizitonwose/calendar/view/CalendarView;", "Landroidx/recyclerview/widget/RecyclerView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "calendarAdapter", "Lcom/kizitonwose/calendar/view/internal/monthcalendar/MonthCalendarAdapter;", "getCalendarAdapter", "()Lcom/kizitonwose/calendar/view/internal/monthcalendar/MonthCalendarAdapter;", "calendarLayoutManager", "Lcom/kizitonwose/calendar/view/internal/monthcalendar/MonthCalendarLayoutManager;", "getCalendarLayoutManager", "()Lcom/kizitonwose/calendar/view/internal/monthcalendar/MonthCalendarLayoutManager;", "value", "Lcom/kizitonwose/calendar/view/MonthDayBinder;", "dayBinder", "getDayBinder", "()Lcom/kizitonwose/calendar/view/MonthDayBinder;", "setDayBinder", "(Lcom/kizitonwose/calendar/view/MonthDayBinder;)V", "Lcom/kizitonwose/calendar/view/DaySize;", "daySize", "getDaySize", "()Lcom/kizitonwose/calendar/view/DaySize;", "setDaySize", "(Lcom/kizitonwose/calendar/view/DaySize;)V", "dayViewResource", "getDayViewResource", "()I", "setDayViewResource", "(I)V", "endMonth", "Ljava/time/YearMonth;", "firstDayOfWeek", "Ljava/time/DayOfWeek;", "horizontalSnapHelper", "Lcom/kizitonwose/calendar/view/internal/CalendarPageSnapHelperLegacy;", "Lcom/kizitonwose/calendar/view/MonthHeaderFooterBinder;", "monthFooterBinder", "getMonthFooterBinder", "()Lcom/kizitonwose/calendar/view/MonthHeaderFooterBinder;", "setMonthFooterBinder", "(Lcom/kizitonwose/calendar/view/MonthHeaderFooterBinder;)V", "monthFooterResource", "getMonthFooterResource", "setMonthFooterResource", "monthHeaderBinder", "getMonthHeaderBinder", "setMonthHeaderBinder", "monthHeaderResource", "getMonthHeaderResource", "setMonthHeaderResource", "Lcom/kizitonwose/calendar/view/MarginValues;", "monthMargins", "getMonthMargins", "()Lcom/kizitonwose/calendar/view/MarginValues;", "setMonthMargins", "(Lcom/kizitonwose/calendar/view/MarginValues;)V", "monthScrollListener", "Lkotlin/Function1;", "Lcom/kizitonwose/calendar/core/CalendarMonth;", "", "Lcom/kizitonwose/calendar/view/MonthScrollListener;", "getMonthScrollListener", "()Lkotlin/jvm/functions/Function1;", "setMonthScrollListener", "(Lkotlin/jvm/functions/Function1;)V", "", "monthViewClass", "getMonthViewClass", "()Ljava/lang/String;", "setMonthViewClass", "(Ljava/lang/String;)V", "orientation", "getOrientation$annotations", "()V", "getOrientation", "setOrientation", "Lcom/kizitonwose/calendar/core/OutDateStyle;", "outDateStyle", "getOutDateStyle", "()Lcom/kizitonwose/calendar/core/OutDateStyle;", "setOutDateStyle", "(Lcom/kizitonwose/calendar/core/OutDateStyle;)V", "pageSnapHelper", "Landroidx/recyclerview/widget/PagerSnapHelper;", "scrollListenerInternal", "com/kizitonwose/calendar/view/CalendarView$scrollListenerInternal$1", "Lcom/kizitonwose/calendar/view/CalendarView$scrollListenerInternal$1;", "", "scrollPaged", "getScrollPaged", "()Z", "setScrollPaged", "(Z)V", "startMonth", "verticalSnapHelper", "Lcom/kizitonwose/calendar/view/internal/CalendarPageSnapHelper;", "findFirstVisibleDay", "Lcom/kizitonwose/calendar/core/CalendarDay;", "findFirstVisibleMonth", "findLastVisibleDay", "findLastVisibleMonth", "getFieldException", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "field", "init", "attributeSet", "defStyleRes", "invalidateViewHolders", "notifyCalendarChanged", "notifyDateChanged", "date", "Ljava/time/LocalDate;", "position", "Lcom/kizitonwose/calendar/core/DayPosition;", "", "(Ljava/time/LocalDate;[Lcom/kizitonwose/calendar/core/DayPosition;)V", "notifyDayChanged", "day", "notifyMonthChanged", "month", "requireEndMonth", "requireFirstDayOfWeek", "requireStartMonth", "scrollToDate", "scrollToDay", "scrollToMonth", "setup", "smoothScrollToDate", "smoothScrollToDay", "smoothScrollToMonth", "updateAdapter", "updateMonthData", "updateSnapHelper", "view_release"})
@SourceDebugExtension(value={"SMAP\nCalendarView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CalendarView.kt\ncom/kizitonwose/calendar/view/CalendarView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Context.kt\nandroidx/core/content/ContextKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,493:1\n1#2:494\n59#3,2:495\n11065#4:497\n11400#4,3:498\n37#5,2:501\n*S KotlinDebug\n*F\n+ 1 CalendarView.kt\ncom/kizitonwose/calendar/view/CalendarView\n*L\n208#1:495,2\n366#1:497\n366#1:498,3\n368#1:501,2\n*E\n"})
public class CalendarView
extends RecyclerView {
    @Nullable
    private MonthDayBinder<?> dayBinder;
    @Nullable
    private MonthHeaderFooterBinder<?> monthHeaderBinder;
    @Nullable
    private MonthHeaderFooterBinder<?> monthFooterBinder;
    @Nullable
    private Function1<? super CalendarMonth, Unit> monthScrollListener;
    private int dayViewResource;
    private int monthHeaderResource;
    private int monthFooterResource;
    @Nullable
    private String monthViewClass;
    private int orientation;
    private boolean scrollPaged;
    @NotNull
    private OutDateStyle outDateStyle;
    @NotNull
    private DaySize daySize;
    @NotNull
    private MarginValues monthMargins;
    @NotNull
    private final scrollListenerInternal.1 scrollListenerInternal;
    @NotNull
    private final CalendarPageSnapHelperLegacy horizontalSnapHelper;
    @NotNull
    private final CalendarPageSnapHelper verticalSnapHelper;
    @NotNull
    private PagerSnapHelper pageSnapHelper;
    @Nullable
    private YearMonth startMonth;
    @Nullable
    private YearMonth endMonth;
    @Nullable
    private DayOfWeek firstDayOfWeek;

    @Nullable
    public final MonthDayBinder<?> getDayBinder() {
        return this.dayBinder;
    }

    public final void setDayBinder(@Nullable MonthDayBinder<?> value) {
        this.dayBinder = value;
        this.invalidateViewHolders();
    }

    @Nullable
    public final MonthHeaderFooterBinder<?> getMonthHeaderBinder() {
        return this.monthHeaderBinder;
    }

    public final void setMonthHeaderBinder(@Nullable MonthHeaderFooterBinder<?> value) {
        this.monthHeaderBinder = value;
        this.invalidateViewHolders();
    }

    @Nullable
    public final MonthHeaderFooterBinder<?> getMonthFooterBinder() {
        return this.monthFooterBinder;
    }

    public final void setMonthFooterBinder(@Nullable MonthHeaderFooterBinder<?> value) {
        this.monthFooterBinder = value;
        this.invalidateViewHolders();
    }

    @Nullable
    public final Function1<CalendarMonth, Unit> getMonthScrollListener() {
        return this.monthScrollListener;
    }

    public final void setMonthScrollListener(@Nullable Function1<? super CalendarMonth, Unit> function1) {
        this.monthScrollListener = function1;
    }

    public final int getDayViewResource() {
        return this.dayViewResource;
    }

    public final void setDayViewResource(int value) {
        if (this.dayViewResource != value) {
            if (!(value != 0)) {
                boolean bl = false;
                String string = "Invalid 'dayViewResource' value.";
                throw new IllegalStateException(string.toString());
            }
            this.dayViewResource = value;
            this.invalidateViewHolders();
        }
    }

    public final int getMonthHeaderResource() {
        return this.monthHeaderResource;
    }

    public final void setMonthHeaderResource(int value) {
        if (this.monthHeaderResource != value) {
            this.monthHeaderResource = value;
            this.invalidateViewHolders();
        }
    }

    public final int getMonthFooterResource() {
        return this.monthFooterResource;
    }

    public final void setMonthFooterResource(int value) {
        if (this.monthFooterResource != value) {
            this.monthFooterResource = value;
            this.invalidateViewHolders();
        }
    }

    @Nullable
    public final String getMonthViewClass() {
        return this.monthViewClass;
    }

    public final void setMonthViewClass(@Nullable String value) {
        if (!Intrinsics.areEqual((Object)this.monthViewClass, (Object)value)) {
            this.monthViewClass = value;
            this.invalidateViewHolders();
        }
    }

    public final int getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(int value) {
        if (this.orientation != value) {
            this.orientation = value;
            RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
            MonthCalendarLayoutManager monthCalendarLayoutManager = layoutManager instanceof MonthCalendarLayoutManager ? (MonthCalendarLayoutManager)layoutManager : null;
            if (monthCalendarLayoutManager != null) {
                monthCalendarLayoutManager.setOrientation(value);
            }
            this.updateSnapHelper();
        }
    }

    public static /* synthetic */ void getOrientation$annotations() {
    }

    public final boolean getScrollPaged() {
        return this.scrollPaged;
    }

    public final void setScrollPaged(boolean value) {
        if (this.scrollPaged != value) {
            this.scrollPaged = value;
            this.updateSnapHelper();
        }
    }

    @NotNull
    public final OutDateStyle getOutDateStyle() {
        return this.outDateStyle;
    }

    public final void setOutDateStyle(@NotNull OutDateStyle value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.outDateStyle != value) {
            this.outDateStyle = value;
            if (this.getAdapter() != null) {
                this.updateAdapter();
            }
        }
    }

    @NotNull
    public final DaySize getDaySize() {
        return this.daySize;
    }

    public final void setDaySize(@NotNull DaySize value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (this.daySize != value) {
            this.daySize = value;
            this.invalidateViewHolders();
        }
    }

    @NotNull
    public final MarginValues getMonthMargins() {
        return this.monthMargins;
    }

    public final void setMonthMargins(@NotNull MarginValues value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!Intrinsics.areEqual((Object)this.monthMargins, (Object)value)) {
            this.monthMargins = value;
            this.invalidateViewHolders();
        }
    }

    public CalendarView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.outDateStyle = OutDateStyle.EndOfRow;
        this.daySize = DaySize.Square;
        this.monthMargins = new MarginValues(0, 0, 0, 0, 15, null);
        this.scrollListenerInternal = new RecyclerView.OnScrollListener(this){
            final /* synthetic */ CalendarView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
            }

            public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
                Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                if (newState == 0) {
                    CalendarView.access$getCalendarAdapter(this.this$0).notifyMonthScrollListenerIfNeeded();
                }
            }
        };
        this.horizontalSnapHelper = new CalendarPageSnapHelperLegacy();
        this.verticalSnapHelper = new CalendarPageSnapHelper();
        this.pageSnapHelper = this.horizontalSnapHelper;
    }

    public CalendarView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.outDateStyle = OutDateStyle.EndOfRow;
        this.daySize = DaySize.Square;
        this.monthMargins = new MarginValues(0, 0, 0, 0, 15, null);
        this.scrollListenerInternal = new /* invalid duplicate definition of identical inner class */;
        this.horizontalSnapHelper = new CalendarPageSnapHelperLegacy();
        this.verticalSnapHelper = new CalendarPageSnapHelper();
        this.pageSnapHelper = this.horizontalSnapHelper;
        this.init(attrs, 0, 0);
    }

    public CalendarView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.outDateStyle = OutDateStyle.EndOfRow;
        this.daySize = DaySize.Square;
        this.monthMargins = new MarginValues(0, 0, 0, 0, 15, null);
        this.scrollListenerInternal = new /* invalid duplicate definition of identical inner class */;
        this.horizontalSnapHelper = new CalendarPageSnapHelperLegacy();
        this.verticalSnapHelper = new CalendarPageSnapHelper();
        this.pageSnapHelper = this.horizontalSnapHelper;
        this.init(attrs, defStyleAttr, defStyleAttr);
    }

    /*
     * WARNING - void declaration
     */
    private final void init(AttributeSet attributeSet, int defStyleAttr, int defStyleRes) {
        void attrs$iv;
        void $this$withStyledAttributes$iv;
        TypedArray typedArray;
        if (this.isInEditMode()) {
            return;
        }
        this.setItemAnimator(null);
        this.setHasFixedSize(true);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Context context2 = context;
        Intrinsics.checkNotNullExpressionValue((Object)R.styleable.CalendarView, (String)"CalendarView");
        int[] nArray = R.styleable.CalendarView;
        boolean $i$f$withStyledAttributes = false;
        TypedArray $this$init_u24lambda_u241 = typedArray = $this$withStyledAttributes$iv.obtainStyledAttributes(attributeSet, (int[])attrs$iv, defStyleAttr, defStyleRes);
        boolean bl = false;
        this.setDayViewResource($this$init_u24lambda_u241.getResourceId(R.styleable.CalendarView_cv_dayViewResource, this.dayViewResource));
        this.setMonthHeaderResource($this$init_u24lambda_u241.getResourceId(R.styleable.CalendarView_cv_monthHeaderResource, this.monthHeaderResource));
        this.setMonthFooterResource($this$init_u24lambda_u241.getResourceId(R.styleable.CalendarView_cv_monthFooterResource, this.monthFooterResource));
        this.setOrientation($this$init_u24lambda_u241.getInt(R.styleable.CalendarView_cv_orientation, this.orientation));
        this.setScrollPaged($this$init_u24lambda_u241.getBoolean(R.styleable.CalendarView_cv_scrollPaged, this.orientation == 0));
        this.setDaySize((DaySize)((Object)DaySize.getEntries().get($this$init_u24lambda_u241.getInt(R.styleable.CalendarView_cv_daySize, this.daySize.ordinal()))));
        this.setOutDateStyle((OutDateStyle)EntriesMappings.entries$0.get($this$init_u24lambda_u241.getInt(R.styleable.CalendarView_cv_outDateStyle, this.outDateStyle.ordinal())));
        this.setMonthViewClass($this$init_u24lambda_u241.getString(R.styleable.CalendarView_cv_monthViewClass));
        typedArray.recycle();
        if (!(this.dayViewResource != 0)) {
            boolean bl2 = false;
            String string = "No value set for `cv_dayViewResource` attribute.";
            throw new IllegalStateException(string.toString());
        }
    }

    private final MonthCalendarLayoutManager getCalendarLayoutManager() {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type com.kizitonwose.calendar.view.internal.monthcalendar.MonthCalendarLayoutManager");
        return (MonthCalendarLayoutManager)layoutManager;
    }

    private final MonthCalendarAdapter getCalendarAdapter() {
        RecyclerView.Adapter adapter = this.getAdapter();
        Intrinsics.checkNotNull((Object)adapter, (String)"null cannot be cast to non-null type com.kizitonwose.calendar.view.internal.monthcalendar.MonthCalendarAdapter");
        return (MonthCalendarAdapter)adapter;
    }

    private final void invalidateViewHolders() {
        if (this.getAdapter() == null || this.getLayoutManager() == null) {
            return;
        }
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        Parcelable state = layoutManager != null ? layoutManager.onSaveInstanceState() : null;
        this.setAdapter(this.getAdapter());
        RecyclerView.LayoutManager layoutManager2 = this.getLayoutManager();
        if (layoutManager2 != null) {
            layoutManager2.onRestoreInstanceState(state);
        }
        this.post(() -> CalendarView.invalidateViewHolders$lambda$3(this));
    }

    private final void updateSnapHelper() {
        if (!this.scrollPaged) {
            this.pageSnapHelper.attachToRecyclerView(null);
            return;
        }
        if (this.orientation == 0 && this.pageSnapHelper != this.horizontalSnapHelper || this.orientation == 1 && this.pageSnapHelper != this.verticalSnapHelper) {
            this.pageSnapHelper.attachToRecyclerView(null);
            this.pageSnapHelper = this.orientation == 0 ? (PagerSnapHelper)this.horizontalSnapHelper : (PagerSnapHelper)this.verticalSnapHelper;
        }
        this.pageSnapHelper.attachToRecyclerView((RecyclerView)this);
    }

    public final void scrollToMonth(@NotNull YearMonth month) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        this.getCalendarLayoutManager().scrollToIndex(month);
    }

    public final void smoothScrollToMonth(@NotNull YearMonth month) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        this.getCalendarLayoutManager().smoothScrollToIndex(month);
    }

    public final void scrollToDay(@NotNull CalendarDay day) {
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        this.getCalendarLayoutManager().scrollToDay(day);
    }

    @JvmOverloads
    public final void scrollToDate(@NotNull LocalDate date, @NotNull DayPosition position) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.scrollToDay(new CalendarDay(date, position));
    }

    public static /* synthetic */ void scrollToDate$default(CalendarView calendarView, LocalDate localDate, DayPosition dayPosition, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: scrollToDate");
        }
        if ((n & 2) != 0) {
            dayPosition = DayPosition.MonthDate;
        }
        calendarView.scrollToDate(localDate, dayPosition);
    }

    public final void smoothScrollToDay(@NotNull CalendarDay day) {
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        this.getCalendarLayoutManager().smoothScrollToDay(day);
    }

    @JvmOverloads
    public final void smoothScrollToDate(@NotNull LocalDate date, @NotNull DayPosition position) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.smoothScrollToDay(new CalendarDay(date, position));
    }

    public static /* synthetic */ void smoothScrollToDate$default(CalendarView calendarView, LocalDate localDate, DayPosition dayPosition, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: smoothScrollToDate");
        }
        if ((n & 2) != 0) {
            dayPosition = DayPosition.MonthDate;
        }
        calendarView.smoothScrollToDate(localDate, dayPosition);
    }

    public final void notifyDayChanged(@NotNull CalendarDay day) {
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        CalendarDay[] calendarDayArray = new CalendarDay[]{day};
        this.getCalendarAdapter().reloadDay(calendarDayArray);
    }

    @JvmOverloads
    public final void notifyDateChanged(@NotNull LocalDate date, @NotNull DayPosition position) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.notifyDayChanged(new CalendarDay(date, position));
    }

    public static /* synthetic */ void notifyDateChanged$default(CalendarView calendarView, LocalDate localDate, DayPosition dayPosition, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: notifyDateChanged");
        }
        if ((n & 2) != 0) {
            dayPosition = DayPosition.MonthDate;
        }
        calendarView.notifyDateChanged(localDate, dayPosition);
    }

    /*
     * WARNING - void declaration
     */
    public final void notifyDateChanged(@NotNull LocalDate date, DayPosition ... position) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        DayPosition[] dayPositionArray;
        DayPosition[] dayPositionArray2;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Object[] objectArray = position;
        if (objectArray.length == 0) {
            boolean bl = false;
            dayPositionArray2 = new DayPosition[]{DayPosition.MonthDate};
            dayPositionArray = dayPositionArray2;
        } else {
            dayPositionArray = objectArray;
        }
        objectArray = dayPositionArray;
        boolean $i$f$map = false;
        dayPositionArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DayPosition dayPosition = (DayPosition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CalendarDay(date, (DayPosition)it));
        }
        Set days = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Collection $this$toTypedArray$iv = days;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray = thisCollection$iv.toArray(new CalendarDay[0]);
        this.getCalendarAdapter().reloadDay((CalendarDay[])Arrays.copyOf(objectArray, objectArray.length));
    }

    public final void notifyMonthChanged(@NotNull YearMonth month) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        this.getCalendarAdapter().reloadMonth(month);
    }

    public final void notifyCalendarChanged() {
        this.getCalendarAdapter().reloadCalendar();
    }

    @Nullable
    public final CalendarMonth findFirstVisibleMonth() {
        return this.getCalendarAdapter().findFirstVisibleMonth();
    }

    @Nullable
    public final CalendarMonth findLastVisibleMonth() {
        return this.getCalendarAdapter().findLastVisibleMonth();
    }

    @Nullable
    public final CalendarDay findFirstVisibleDay() {
        return this.getCalendarAdapter().findFirstVisibleDay();
    }

    @Nullable
    public final CalendarDay findLastVisibleDay() {
        return this.getCalendarAdapter().findLastVisibleDay();
    }

    public final void setup(@NotNull YearMonth startMonth, @NotNull YearMonth endMonth, @NotNull DayOfWeek firstDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)startMonth, (String)"startMonth");
        Intrinsics.checkNotNullParameter((Object)endMonth, (String)"endMonth");
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        UtilsKt.checkDateRange((YearMonth)startMonth, (YearMonth)endMonth);
        this.startMonth = startMonth;
        this.endMonth = endMonth;
        this.firstDayOfWeek = firstDayOfWeek;
        this.removeOnScrollListener(this.scrollListenerInternal);
        this.addOnScrollListener(this.scrollListenerInternal);
        this.setLayoutManager((RecyclerView.LayoutManager)new MonthCalendarLayoutManager(this));
        this.setAdapter(new MonthCalendarAdapter(this, this.outDateStyle, startMonth, endMonth, firstDayOfWeek));
    }

    @JvmOverloads
    public final void updateMonthData(@NotNull YearMonth startMonth, @NotNull YearMonth endMonth, @NotNull DayOfWeek firstDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)startMonth, (String)"startMonth");
        Intrinsics.checkNotNullParameter((Object)endMonth, (String)"endMonth");
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        UtilsKt.checkDateRange((YearMonth)startMonth, (YearMonth)endMonth);
        this.startMonth = startMonth;
        this.endMonth = endMonth;
        this.firstDayOfWeek = firstDayOfWeek;
        this.updateAdapter();
    }

    public static /* synthetic */ void updateMonthData$default(CalendarView calendarView, YearMonth yearMonth, YearMonth yearMonth2, DayOfWeek dayOfWeek, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateMonthData");
        }
        if ((n & 1) != 0) {
            yearMonth = calendarView.requireStartMonth();
        }
        if ((n & 2) != 0) {
            yearMonth2 = calendarView.requireEndMonth();
        }
        if ((n & 4) != 0) {
            dayOfWeek = calendarView.requireFirstDayOfWeek();
        }
        calendarView.updateMonthData(yearMonth, yearMonth2, dayOfWeek);
    }

    private final void updateAdapter() {
        this.getCalendarAdapter().updateData$view_release(this.requireStartMonth(), this.requireEndMonth(), this.outDateStyle, this.requireFirstDayOfWeek());
    }

    private final YearMonth requireStartMonth() {
        YearMonth yearMonth = this.startMonth;
        if (yearMonth == null) {
            throw this.getFieldException("startMonth");
        }
        return yearMonth;
    }

    private final YearMonth requireEndMonth() {
        YearMonth yearMonth = this.endMonth;
        if (yearMonth == null) {
            throw this.getFieldException("endMonth");
        }
        return yearMonth;
    }

    private final DayOfWeek requireFirstDayOfWeek() {
        DayOfWeek dayOfWeek = this.firstDayOfWeek;
        if (dayOfWeek == null) {
            throw this.getFieldException("firstDayOfWeek");
        }
        return dayOfWeek;
    }

    private final IllegalStateException getFieldException(String field) {
        return new IllegalStateException("`" + field + "` is not set. Have you called `setup()`?");
    }

    @JvmOverloads
    public final void scrollToDate(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        CalendarView.scrollToDate$default(this, date, null, 2, null);
    }

    @JvmOverloads
    public final void smoothScrollToDate(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        CalendarView.smoothScrollToDate$default(this, date, null, 2, null);
    }

    @JvmOverloads
    public final void notifyDateChanged(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        CalendarView.notifyDateChanged$default(this, date, null, 2, null);
    }

    @JvmOverloads
    public final void updateMonthData(@NotNull YearMonth startMonth, @NotNull YearMonth endMonth) {
        Intrinsics.checkNotNullParameter((Object)startMonth, (String)"startMonth");
        Intrinsics.checkNotNullParameter((Object)endMonth, (String)"endMonth");
        CalendarView.updateMonthData$default(this, startMonth, endMonth, null, 4, null);
    }

    @JvmOverloads
    public final void updateMonthData(@NotNull YearMonth startMonth) {
        Intrinsics.checkNotNullParameter((Object)startMonth, (String)"startMonth");
        CalendarView.updateMonthData$default(this, startMonth, null, null, 6, null);
    }

    @JvmOverloads
    public final void updateMonthData() {
        CalendarView.updateMonthData$default(this, null, null, null, 7, null);
    }

    private static final void invalidateViewHolders$lambda$3(CalendarView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.getCalendarAdapter().notifyMonthScrollListenerIfNeeded();
    }

    public static final /* synthetic */ MonthCalendarAdapter access$getCalendarAdapter(CalendarView $this) {
        return $this.getCalendarAdapter();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<OutDateStyle> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])OutDateStyle.values()));
        }
    }
}

