/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendar.view.internal;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import com.kizitonwose.calendar.view.MarginValues;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b \u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0001\u001fB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00028\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H&J\u0015\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0015\u001a\u00020\u0016H&J\b\u0010\u0017\u001a\u00020\u0018H&J\u0013\u0010\u0019\u001a\u00020\u00162\u0006\u0010\n\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001d\u001a\u00020\u00162\u0006\u0010\n\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/kizitonwose/calendar/view/internal/CalendarLayoutManager;", "IndexData", "DayData", "Landroidx/recyclerview/widget/LinearLayoutManager;", "calView", "Landroidx/recyclerview/widget/RecyclerView;", "orientation", "", "(Landroidx/recyclerview/widget/RecyclerView;I)V", "calculateDayViewOffsetInParent", "day", "itemView", "Landroid/view/View;", "(Ljava/lang/Object;Landroid/view/View;)I", "getDayTag", "data", "(Ljava/lang/Object;)I", "getItemMargins", "Lcom/kizitonwose/calendar/view/MarginValues;", "getaDayAdapterPosition", "getaItemAdapterPosition", "notifyScrollListenerIfNeeded", "", "scrollPaged", "", "scrollToDay", "(Ljava/lang/Object;)V", "scrollToIndex", "indexData", "smoothScrollToDay", "smoothScrollToIndex", "CalendarSmoothScroller", "view_release"})
public abstract class CalendarLayoutManager<IndexData, DayData>
extends LinearLayoutManager {
    @NotNull
    private final RecyclerView calView;

    public CalendarLayoutManager(@NotNull RecyclerView calView, int orientation) {
        Intrinsics.checkNotNullParameter((Object)calView, (String)"calView");
        super(calView.getContext(), orientation, false);
        this.calView = calView;
    }

    public abstract int getaItemAdapterPosition(IndexData var1);

    public abstract int getaDayAdapterPosition(DayData var1);

    public abstract int getDayTag(DayData var1);

    @NotNull
    public abstract MarginValues getItemMargins();

    public abstract boolean scrollPaged();

    public abstract void notifyScrollListenerIfNeeded();

    public final void scrollToIndex(IndexData indexData) {
        int position = this.getaItemAdapterPosition(indexData);
        if (position == -1) {
            return;
        }
        this.scrollToPositionWithOffset(position, 0);
        this.calView.post(() -> CalendarLayoutManager.scrollToIndex$lambda$0(this));
    }

    public final void smoothScrollToIndex(IndexData indexData) {
        int position = this.getaItemAdapterPosition(indexData);
        if (position == -1) {
            return;
        }
        this.startSmoothScroll((RecyclerView.SmoothScroller)new CalendarSmoothScroller(position, null));
    }

    public final void smoothScrollToDay(DayData day) {
        int indexPosition = this.getaDayAdapterPosition(day);
        if (indexPosition == -1) {
            return;
        }
        this.startSmoothScroll((RecyclerView.SmoothScroller)new CalendarSmoothScroller(indexPosition, this.scrollPaged() ? null : (Object)day));
    }

    public final void scrollToDay(DayData day) {
        int indexPosition = this.getaDayAdapterPosition(day);
        if (indexPosition == -1) {
            return;
        }
        this.scrollToPositionWithOffset(indexPosition, 0);
        if (this.scrollPaged()) {
            this.calView.post(() -> CalendarLayoutManager.scrollToDay$lambda$1(this));
        } else {
            this.calView.post(() -> CalendarLayoutManager.scrollToDay$lambda$3(this, indexPosition, day));
        }
    }

    private final int calculateDayViewOffsetInParent(DayData day, View itemView) {
        View view = itemView.findViewWithTag((Object)this.getDayTag(day));
        if (view == null) {
            return 0;
        }
        View dayView = view;
        Rect rect = new Rect();
        dayView.getDrawingRect(rect);
        Intrinsics.checkNotNull((Object)itemView, (String)"null cannot be cast to non-null type android.view.ViewGroup");
        ((ViewGroup)itemView).offsetDescendantRectToMyCoords(dayView, rect);
        boolean isVertical = this.getOrientation() == 1;
        MarginValues margins = this.getItemMargins();
        return isVertical ? rect.top + margins.getTop() : rect.left + margins.getStart();
    }

    private static final void scrollToIndex$lambda$0(CalendarLayoutManager this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.notifyScrollListenerIfNeeded();
    }

    private static final void scrollToDay$lambda$1(CalendarLayoutManager this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.notifyScrollListenerIfNeeded();
    }

    private static final void scrollToDay$lambda$3$lambda$2(CalendarLayoutManager this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.notifyScrollListenerIfNeeded();
    }

    private static final void scrollToDay$lambda$3(CalendarLayoutManager this$0, int $indexPosition, Object $day) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        RecyclerView.ViewHolder viewHolder = this$0.calView.findViewHolderForAdapterPosition($indexPosition);
        if (viewHolder == null || (viewHolder = viewHolder.itemView) == null) {
            return;
        }
        RecyclerView.ViewHolder itemView = viewHolder;
        int offset = this$0.calculateDayViewOffsetInParent($day, (View)itemView);
        this$0.scrollToPositionWithOffset($indexPosition, -offset);
        this$0.calView.post(() -> CalendarLayoutManager.scrollToDay$lambda$3$lambda$2(this$0));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0014J\b\u0010\u000f\u001a\u00020\u0003H\u0014R\u0015\u0010\u0004\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/kizitonwose/calendar/view/internal/CalendarLayoutManager$CalendarSmoothScroller;", "Landroidx/recyclerview/widget/LinearSmoothScroller;", "position", "", "day", "(Lcom/kizitonwose/calendar/view/internal/CalendarLayoutManager;ILjava/lang/Object;)V", "getDay", "()Ljava/lang/Object;", "Ljava/lang/Object;", "calculateDxToMakeVisible", "view", "Landroid/view/View;", "snapPreference", "calculateDyToMakeVisible", "getHorizontalSnapPreference", "getVerticalSnapPreference", "view_release"})
    private final class CalendarSmoothScroller
    extends LinearSmoothScroller {
        @Nullable
        private final DayData day;

        public CalendarSmoothScroller(@Nullable int position, DayData day) {
            super(CalendarLayoutManager.this.calView.getContext());
            this.day = day;
            this.setTargetPosition(position);
        }

        @Nullable
        public final DayData getDay() {
            return this.day;
        }

        protected int getVerticalSnapPreference() {
            return -1;
        }

        protected int getHorizontalSnapPreference() {
            return -1;
        }

        public int calculateDyToMakeVisible(@NotNull View view, int snapPreference) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            int dy = super.calculateDyToMakeVisible(view, snapPreference);
            if (this.day == null) {
                return dy;
            }
            int offset = CalendarLayoutManager.this.calculateDayViewOffsetInParent(this.day, view);
            return dy - offset;
        }

        public int calculateDxToMakeVisible(@NotNull View view, int snapPreference) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            int dx = super.calculateDxToMakeVisible(view, snapPreference);
            if (this.day == null) {
                return dx;
            }
            int offset = CalendarLayoutManager.this.calculateDayViewOffsetInParent(this.day, view);
            return dx - offset;
        }
    }
}

