/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendar.view.internal.weekcalendar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.kizitonwose.calendar.core.Week;
import com.kizitonwose.calendar.core.WeekDay;
import com.kizitonwose.calendar.data.DataStore;
import com.kizitonwose.calendar.data.WeekDataKt;
import com.kizitonwose.calendar.data.WeekDateRange;
import com.kizitonwose.calendar.view.Binder;
import com.kizitonwose.calendar.view.DaySize;
import com.kizitonwose.calendar.view.MarginValues;
import com.kizitonwose.calendar.view.WeekCalendarView;
import com.kizitonwose.calendar.view.WeekDayBinder;
import com.kizitonwose.calendar.view.internal.ItemContent;
import com.kizitonwose.calendar.view.internal.UtilsKt;
import com.kizitonwose.calendar.view.internal.WeekHolder;
import com.kizitonwose.calendar.view.internal.weekcalendar.WeekCalendarLayoutManager;
import com.kizitonwose.calendar.view.internal.weekcalendar.WeekViewHolder;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001f\u001a\u0004\u0018\u00010 J\b\u0010!\u001a\u0004\u0018\u00010\u000fJ\b\u0010\"\u001a\u00020\u0017H\u0002J\b\u0010#\u001a\u0004\u0018\u00010 J\b\u0010$\u001a\u0004\u0018\u00010\u000fJ\b\u0010%\u001a\u00020\u0017H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010 2\u0006\u0010'\u001a\u00020\u0014H\u0002J\u0015\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b*J\u0010\u0010+\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020\u0017H\u0002J\b\u0010-\u001a\u00020\u0017H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020\u0017H\u0016J\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u0002012\u0006\u00103\u001a\u000204H\u0016J\u0018\u00105\u001a\u0002012\u0006\u00106\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u0017H\u0016J&\u00105\u001a\u0002012\u0006\u00106\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u00172\f\u00107\u001a\b\u0012\u0004\u0012\u00020908H\u0016J\u0018\u0010:\u001a\u00020\u00022\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0017H\u0016J\u0006\u0010>\u001a\u000201J\u000e\u0010?\u001a\u0002012\u0006\u0010)\u001a\u00020\u0006J\u000e\u0010@\u001a\u0002012\u0006\u0010)\u001a\u00020\u0006J%\u0010A\u001a\u0002012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0001\u00a2\u0006\u0002\bBR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0012R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/kizitonwose/calendar/view/internal/weekcalendar/WeekCalendarAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/kizitonwose/calendar/view/internal/weekcalendar/WeekViewHolder;", "calView", "Lcom/kizitonwose/calendar/view/WeekCalendarView;", "startDate", "Ljava/time/LocalDate;", "endDate", "firstDayOfWeek", "Ljava/time/DayOfWeek;", "(Lcom/kizitonwose/calendar/view/WeekCalendarView;Ljava/time/LocalDate;Ljava/time/LocalDate;Ljava/time/DayOfWeek;)V", "adjustedData", "Lcom/kizitonwose/calendar/data/WeekDateRange;", "dataStore", "Lcom/kizitonwose/calendar/data/DataStore;", "Lcom/kizitonwose/calendar/core/Week;", "endDateAdjusted", "getEndDateAdjusted", "()Ljava/time/LocalDate;", "isAttached", "", "()Z", "itemCount", "", "layoutManager", "Lcom/kizitonwose/calendar/view/internal/weekcalendar/WeekCalendarLayoutManager;", "getLayoutManager", "()Lcom/kizitonwose/calendar/view/internal/weekcalendar/WeekCalendarLayoutManager;", "startDateAdjusted", "getStartDateAdjusted", "visibleWeek", "findFirstVisibleDay", "Lcom/kizitonwose/calendar/core/WeekDay;", "findFirstVisibleWeek", "findFirstVisibleWeekPosition", "findLastVisibleDay", "findLastVisibleWeek", "findLastVisibleWeekPosition", "findVisibleDay", "isFirst", "getAdapterPosition", "date", "getAdapterPosition$view_release", "getItem", "position", "getItemCount", "getItemId", "", "notifyWeekScrollListenerIfNeeded", "", "onAttachedToRecyclerView", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "onBindViewHolder", "holder", "payloads", "", "", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "reloadCalendar", "reloadDay", "reloadWeek", "updateData", "updateData$view_release", "view_release"})
public final class WeekCalendarAdapter
extends RecyclerView.Adapter<WeekViewHolder> {
    @NotNull
    private final WeekCalendarView calView;
    @NotNull
    private LocalDate startDate;
    @NotNull
    private LocalDate endDate;
    @NotNull
    private DayOfWeek firstDayOfWeek;
    @NotNull
    private WeekDateRange adjustedData;
    private int itemCount;
    @NotNull
    private final DataStore<Week> dataStore;
    @Nullable
    private Week visibleWeek;

    public WeekCalendarAdapter(@NotNull WeekCalendarView calView, @NotNull LocalDate startDate, @NotNull LocalDate endDate, @NotNull DayOfWeek firstDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)((Object)calView), (String)"calView");
        Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
        Intrinsics.checkNotNullParameter((Object)endDate, (String)"endDate");
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        this.calView = calView;
        this.startDate = startDate;
        this.endDate = endDate;
        this.firstDayOfWeek = firstDayOfWeek;
        this.adjustedData = WeekDataKt.getWeekCalendarAdjustedRange((LocalDate)this.startDate, (LocalDate)this.endDate, (DayOfWeek)this.firstDayOfWeek);
        this.itemCount = WeekDataKt.getWeekIndicesCount((LocalDate)this.adjustedData.getStartDateAdjusted(), (LocalDate)this.adjustedData.getEndDateAdjusted());
        this.dataStore = new DataStore((Function1)new Function1<Integer, Week>(this){
            final /* synthetic */ WeekCalendarAdapter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Week invoke(int offset) {
                return WeekDataKt.getWeekCalendarData((LocalDate)WeekCalendarAdapter.access$getStartDateAdjusted(this.this$0), (int)offset, (LocalDate)WeekCalendarAdapter.access$getStartDate$p(this.this$0), (LocalDate)WeekCalendarAdapter.access$getEndDate$p(this.this$0)).getWeek();
            }
        });
        this.setHasStableIds(true);
    }

    private final LocalDate getStartDateAdjusted() {
        return this.adjustedData.getStartDateAdjusted();
    }

    private final LocalDate getEndDateAdjusted() {
        return this.adjustedData.getEndDateAdjusted();
    }

    private final boolean isAttached() {
        return this.calView.getAdapter() == this;
    }

    public void onAttachedToRecyclerView(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        this.calView.post(() -> WeekCalendarAdapter.onAttachedToRecyclerView$lambda$0(this));
    }

    private final Week getItem(int position) {
        return (Week)this.dataStore.get((Object)position);
    }

    public long getItemId(int position) {
        return ((WeekDay)CollectionsKt.first((List)this.getItem(position).getDays())).getDate().hashCode();
    }

    public int getItemCount() {
        return this.itemCount;
    }

    @NotNull
    public WeekViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        MarginValues marginValues = this.calView.getWeekMargins();
        DaySize daySize = this.calView.getDaySize();
        Context context = this.calView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"calView.context");
        int n = this.calView.getDayViewResource();
        int n2 = this.calView.getWeekHeaderResource();
        int n3 = this.calView.getWeekFooterResource();
        String string = this.calView.getWeekViewClass();
        WeekDayBinder<?> weekDayBinder = this.calView.getDayBinder();
        Intrinsics.checkNotNull(weekDayBinder, (String)"null cannot be cast to non-null type com.kizitonwose.calendar.view.WeekDayBinder<*>");
        ItemContent content = UtilsKt.setupItemRoot(marginValues, daySize, context, n, n2, n3, 1, string, (Binder)weekDayBinder);
        return new WeekViewHolder(content.getItemView(), content.getHeaderView(), content.getFooterView(), (WeekHolder)CollectionsKt.first(content.getWeekHolders()), this.calView.getWeekHeaderBinder(), this.calView.getWeekFooterBinder());
    }

    public void onBindViewHolder(@NotNull WeekViewHolder holder, int position, @NotNull List<? extends Object> payloads) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Intrinsics.checkNotNullParameter(payloads, (String)"payloads");
        if (payloads.isEmpty()) {
            super.onBindViewHolder((RecyclerView.ViewHolder)holder, position, payloads);
        } else {
            Iterable $this$forEach$iv = payloads;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type com.kizitonwose.calendar.core.WeekDay");
                holder.reloadDay((WeekDay)it);
            }
        }
    }

    public void onBindViewHolder(@NotNull WeekViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        holder.bindWeek(this.getItem(position));
    }

    /*
     * WARNING - void declaration
     */
    public final void reloadDay(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        int position = this.getAdapterPosition$view_release(date);
        if (position != -1) {
            Object element$iv2;
            WeekCalendarAdapter weekCalendarAdapter;
            int n;
            block2: {
                void $this$first$iv;
                Iterable iterable = ((Week)this.dataStore.get((Object)position)).getDays();
                n = position;
                weekCalendarAdapter = this;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    WeekDay it = (WeekDay)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getDate(), (Object)date)) continue;
                    break block2;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object t = element$iv2;
            weekCalendarAdapter.notifyItemChanged(n, t);
        }
    }

    public final void reloadWeek(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.notifyItemChanged(this.getAdapterPosition$view_release(date));
    }

    public final void reloadCalendar() {
        this.notifyItemRangeChanged(0, this.itemCount);
    }

    public final void notifyWeekScrollListenerIfNeeded() {
        block4: {
            Week visibleWeek;
            if (!this.isAttached()) {
                return;
            }
            if (this.calView.isAnimating()) {
                RecyclerView.ItemAnimator itemAnimator = this.calView.getItemAnimator();
                if (itemAnimator != null) {
                    itemAnimator.isRunning(() -> WeekCalendarAdapter.notifyWeekScrollListenerIfNeeded$lambda$3(this));
                }
                return;
            }
            int visibleItemPos = this.findFirstVisibleWeekPosition();
            if (visibleItemPos == -1 || Intrinsics.areEqual((Object)(visibleWeek = (Week)this.dataStore.get((Object)visibleItemPos)), (Object)this.visibleWeek)) break block4;
            this.visibleWeek = visibleWeek;
            Function1<Week, Unit> function1 = this.calView.getWeekScrollListener();
            if (function1 != null) {
                function1.invoke((Object)visibleWeek);
            }
        }
    }

    public final int getAdapterPosition$view_release(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return WeekDataKt.getWeekIndex((LocalDate)this.getStartDateAdjusted(), (LocalDate)date);
    }

    private final WeekCalendarLayoutManager getLayoutManager() {
        RecyclerView.LayoutManager layoutManager = this.calView.getLayoutManager();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type com.kizitonwose.calendar.view.internal.weekcalendar.WeekCalendarLayoutManager");
        return (WeekCalendarLayoutManager)layoutManager;
    }

    @Nullable
    public final Week findFirstVisibleWeek() {
        int index = this.findFirstVisibleWeekPosition();
        return index == -1 ? null : (Week)this.dataStore.get((Object)index);
    }

    @Nullable
    public final Week findLastVisibleWeek() {
        int index = this.findLastVisibleWeekPosition();
        return index == -1 ? null : (Week)this.dataStore.get((Object)index);
    }

    @Nullable
    public final WeekDay findFirstVisibleDay() {
        return this.findVisibleDay(true);
    }

    @Nullable
    public final WeekDay findLastVisibleDay() {
        return this.findVisibleDay(false);
    }

    private final int findFirstVisibleWeekPosition() {
        return this.getLayoutManager().findFirstVisibleItemPosition();
    }

    private final int findLastVisibleWeekPosition() {
        return this.getLayoutManager().findLastVisibleItemPosition();
    }

    /*
     * WARNING - void declaration
     */
    private final WeekDay findVisibleDay(boolean isFirst) {
        Object v3;
        block5: {
            void $this$firstOrNull$iv;
            int visibleIndex;
            int n = visibleIndex = isFirst ? this.findFirstVisibleWeekPosition() : this.findLastVisibleWeekPosition();
            if (visibleIndex == -1) {
                return null;
            }
            View view = this.getLayoutManager().findViewByPosition(visibleIndex);
            if (view == null) {
                return null;
            }
            View visibleItemView = view;
            Rect weekRect = new Rect();
            visibleItemView.getGlobalVisibleRect(weekRect);
            Rect dayRect = new Rect();
            List $this$findVisibleDay_u24lambda_u244 = ((Week)this.dataStore.get((Object)visibleIndex)).getDays();
            boolean bl = false;
            Iterable iterable = isFirst ? $this$findVisibleDay_u24lambda_u244 : CollectionsKt.reversed((Iterable)$this$findVisibleDay_u24lambda_u244);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl2;
                WeekDay it = (WeekDay)element$iv;
                boolean bl3 = false;
                View view2 = visibleItemView.findViewWithTag((Object)UtilsKt.dayTag(it.getDate()));
                if (view2 == null) {
                    bl2 = false;
                } else {
                    View dayView = view2;
                    dayView.getGlobalVisibleRect(dayRect);
                    bl2 = dayRect.intersect(weekRect);
                }
                if (!bl2) continue;
                v3 = element$iv;
                break block5;
            }
            v3 = null;
        }
        return v3;
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public final void updateData$view_release(@NotNull LocalDate startDate, @NotNull LocalDate endDate, @NotNull DayOfWeek firstDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
        Intrinsics.checkNotNullParameter((Object)endDate, (String)"endDate");
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        this.startDate = startDate;
        this.endDate = endDate;
        this.firstDayOfWeek = firstDayOfWeek;
        this.adjustedData = WeekDataKt.getWeekCalendarAdjustedRange((LocalDate)startDate, (LocalDate)endDate, (DayOfWeek)firstDayOfWeek);
        this.itemCount = WeekDataKt.getWeekIndicesCount((LocalDate)this.getStartDateAdjusted(), (LocalDate)this.getEndDateAdjusted());
        this.dataStore.clear();
        this.notifyDataSetChanged();
    }

    private static final void onAttachedToRecyclerView$lambda$0(WeekCalendarAdapter this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.notifyWeekScrollListenerIfNeeded();
    }

    private static final void notifyWeekScrollListenerIfNeeded$lambda$3(WeekCalendarAdapter this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.notifyWeekScrollListenerIfNeeded();
    }

    public static final /* synthetic */ LocalDate access$getStartDateAdjusted(WeekCalendarAdapter $this) {
        return $this.getStartDateAdjusted();
    }

    public static final /* synthetic */ LocalDate access$getStartDate$p(WeekCalendarAdapter $this) {
        return $this.startDate;
    }

    public static final /* synthetic */ LocalDate access$getEndDate$p(WeekCalendarAdapter $this) {
        return $this.endDate;
    }
}

