/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendar.data;

import com.kizitonwose.calendar.data.ExtensionsKt;
import com.kizitonwose.calendar.data.WeekData;
import com.kizitonwose.calendar.data.WeekDateRange;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003\u001a\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003\u001a\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003\u00a8\u0006\u0012"}, d2={"getWeekCalendarAdjustedRange", "Lcom/kizitonwose/calendar/data/WeekDateRange;", "startDate", "Ljava/time/LocalDate;", "endDate", "firstDayOfWeek", "Ljava/time/DayOfWeek;", "getWeekCalendarData", "Lcom/kizitonwose/calendar/data/WeekData;", "startDateAdjusted", "offset", "", "desiredStartDate", "desiredEndDate", "getWeekIndex", "date", "getWeekIndicesCount", "endDateAdjusted", "data_release"})
public final class WeekDataKt {
    @NotNull
    public static final WeekDateRange getWeekCalendarAdjustedRange(@NotNull LocalDate startDate, @NotNull LocalDate endDate, @NotNull DayOfWeek firstDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
        Intrinsics.checkNotNullParameter((Object)endDate, (String)"endDate");
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        DayOfWeek dayOfWeek = startDate.getDayOfWeek();
        Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"startDate.dayOfWeek");
        int inDays = ExtensionsKt.daysUntil(firstDayOfWeek, dayOfWeek);
        LocalDate startDateAdjusted = startDate.minusDays(inDays);
        int weeksBetween = (int)ChronoUnit.WEEKS.between(startDateAdjusted, endDate);
        LocalDate endDateAdjusted = startDateAdjusted.plusWeeks(weeksBetween).plusDays(6L);
        Intrinsics.checkNotNullExpressionValue((Object)startDateAdjusted, (String)"startDateAdjusted");
        Intrinsics.checkNotNullExpressionValue((Object)endDateAdjusted, (String)"endDateAdjusted");
        return new WeekDateRange(startDateAdjusted, endDateAdjusted);
    }

    @NotNull
    public static final WeekData getWeekCalendarData(@NotNull LocalDate startDateAdjusted, int offset, @NotNull LocalDate desiredStartDate, @NotNull LocalDate desiredEndDate) {
        Intrinsics.checkNotNullParameter((Object)startDateAdjusted, (String)"startDateAdjusted");
        Intrinsics.checkNotNullParameter((Object)desiredStartDate, (String)"desiredStartDate");
        Intrinsics.checkNotNullParameter((Object)desiredEndDate, (String)"desiredEndDate");
        LocalDate firstDayInWeek = startDateAdjusted.plusWeeks(offset);
        Intrinsics.checkNotNullExpressionValue((Object)firstDayInWeek, (String)"firstDayInWeek");
        return new WeekData(firstDayInWeek, desiredStartDate, desiredEndDate);
    }

    public static final int getWeekIndex(@NotNull LocalDate startDateAdjusted, @NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)startDateAdjusted, (String)"startDateAdjusted");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return (int)ChronoUnit.WEEKS.between(startDateAdjusted, date);
    }

    public static final int getWeekIndicesCount(@NotNull LocalDate startDateAdjusted, @NotNull LocalDate endDateAdjusted) {
        Intrinsics.checkNotNullParameter((Object)startDateAdjusted, (String)"startDateAdjusted");
        Intrinsics.checkNotNullParameter((Object)endDateAdjusted, (String)"endDateAdjusted");
        return WeekDataKt.getWeekIndex(startDateAdjusted, endDateAdjusted) + 1;
    }
}

