/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendar.data;

import com.kizitonwose.calendar.core.CalendarDay;
import com.kizitonwose.calendar.core.CalendarMonth;
import com.kizitonwose.calendar.core.DayPosition;
import com.kizitonwose.calendar.core.ExtensionsKt;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005H\u0002J\t\u0010!\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/kizitonwose/calendar/data/MonthData;", "", "month", "Ljava/time/YearMonth;", "inDays", "", "outDays", "(Ljava/time/YearMonth;II)V", "calendarMonth", "Lcom/kizitonwose/calendar/core/CalendarMonth;", "getCalendarMonth", "()Lcom/kizitonwose/calendar/core/CalendarMonth;", "firstDay", "Ljava/time/LocalDate;", "kotlin.jvm.PlatformType", "getInDays", "()I", "getMonth", "()Ljava/time/YearMonth;", "getOutDays", "rows", "", "totalDays", "component1", "component2", "component3", "copy", "equals", "", "other", "getDay", "Lcom/kizitonwose/calendar/core/CalendarDay;", "dayOffset", "hashCode", "toString", "", "data_release"})
public final class MonthData {
    @NotNull
    private final YearMonth month;
    private final int inDays;
    private final int outDays;
    private final int totalDays;
    private final LocalDate firstDay;
    @NotNull
    private final List<List<Integer>> rows;
    @NotNull
    private final CalendarMonth calendarMonth;

    /*
     * WARNING - void declaration
     */
    public MonthData(@NotNull YearMonth month, int inDays, int outDays) {
        Collection<List> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        this.month = month;
        this.inDays = inDays;
        this.outDays = outDays;
        this.totalDays = this.inDays + this.month.lengthOfMonth() + this.outDays;
        this.firstDay = ExtensionsKt.atStartOfMonth((YearMonth)this.month).minusDays(this.inDays);
        this.rows = CollectionsKt.chunked((Iterable)((Iterable)RangesKt.until((int)0, (int)this.totalDays)), (int)7);
        Iterable iterable = this.rows;
        YearMonth yearMonth = this.month;
        MonthData monthData = this;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void week;
            List list = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = (Iterable)week;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void dayOffset;
                int n = ((Number)item$iv$iv2).intValue();
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(this.getDay((int)dayOffset));
            }
            collection.add((List)destination$iv$iv2);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        YearMonth yearMonth2 = yearMonth;
        monthData.calendarMonth = new CalendarMonth(yearMonth2, list);
    }

    @NotNull
    public final YearMonth getMonth() {
        return this.month;
    }

    public final int getInDays() {
        return this.inDays;
    }

    public final int getOutDays() {
        return this.outDays;
    }

    @NotNull
    public final CalendarMonth getCalendarMonth() {
        return this.calendarMonth;
    }

    private final CalendarDay getDay(int dayOffset) {
        DayPosition dayPosition;
        LocalDate date = this.firstDay.plusDays(dayOffset);
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"date");
        YearMonth yearMonth = ExtensionsKt.getYearMonth((LocalDate)date);
        if (Intrinsics.areEqual((Object)yearMonth, (Object)this.month)) {
            dayPosition = DayPosition.MonthDate;
        } else if (Intrinsics.areEqual((Object)yearMonth, (Object)this.month.minusMonths(1L))) {
            dayPosition = DayPosition.InDate;
        } else if (Intrinsics.areEqual((Object)yearMonth, (Object)this.month.plusMonths(1L))) {
            dayPosition = DayPosition.OutDate;
        } else {
            throw new IllegalArgumentException("Invalid date: " + date + " in month: " + this.month);
        }
        DayPosition position = dayPosition;
        return new CalendarDay(date, position);
    }

    @NotNull
    public final YearMonth component1() {
        return this.month;
    }

    public final int component2() {
        return this.inDays;
    }

    public final int component3() {
        return this.outDays;
    }

    @NotNull
    public final MonthData copy(@NotNull YearMonth month, int inDays, int outDays) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        return new MonthData(month, inDays, outDays);
    }

    public static /* synthetic */ MonthData copy$default(MonthData monthData, YearMonth yearMonth, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            yearMonth = monthData.month;
        }
        if ((n3 & 2) != 0) {
            n = monthData.inDays;
        }
        if ((n3 & 4) != 0) {
            n2 = monthData.outDays;
        }
        return monthData.copy(yearMonth, n, n2);
    }

    @NotNull
    public String toString() {
        return "MonthData(month=" + this.month + ", inDays=" + this.inDays + ", outDays=" + this.outDays + ')';
    }

    public int hashCode() {
        int result = this.month.hashCode();
        result = result * 31 + Integer.hashCode(this.inDays);
        result = result * 31 + Integer.hashCode(this.outDays);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MonthData)) {
            return false;
        }
        MonthData monthData = (MonthData)other;
        if (!Intrinsics.areEqual((Object)this.month, (Object)monthData.month)) {
            return false;
        }
        if (this.inDays != monthData.inDays) {
            return false;
        }
        return this.outDays == monthData.outDays;
    }
}

