/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendar.core;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.WeekFields;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u0007\u001a\u0012\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\"\u0015\u0010\n\u001a\u00020\t*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0015\u0010\r\u001a\u00020\t*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0015\u0010\u0010\u001a\u00020\t*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0012"}, d2={"daysOfWeek", "", "Ljava/time/DayOfWeek;", "firstDayOfWeek", "firstDayOfWeekFromLocale", "locale", "Ljava/util/Locale;", "atStartOfMonth", "Ljava/time/LocalDate;", "Ljava/time/YearMonth;", "yearMonth", "getYearMonth", "(Ljava/time/LocalDate;)Ljava/time/YearMonth;", "nextMonth", "getNextMonth", "(Ljava/time/YearMonth;)Ljava/time/YearMonth;", "previousMonth", "getPreviousMonth", "core"})
public final class ExtensionsKt {
    @JvmOverloads
    @NotNull
    public static final List<DayOfWeek> daysOfWeek(@NotNull DayOfWeek firstDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        int pivot = 7 - firstDayOfWeek.ordinal();
        EnumEntries<DayOfWeek> daysOfWeek = EntriesMappings.entries$0;
        return CollectionsKt.plus((Collection)CollectionsKt.takeLast((List)((List)daysOfWeek), (int)pivot), (Iterable)CollectionsKt.dropLast((List)((List)daysOfWeek), (int)pivot));
    }

    public static /* synthetic */ List daysOfWeek$default(DayOfWeek dayOfWeek, int n, Object object) {
        if ((n & 1) != 0) {
            dayOfWeek = ExtensionsKt.firstDayOfWeekFromLocale$default(null, 1, null);
        }
        return ExtensionsKt.daysOfWeek(dayOfWeek);
    }

    @JvmOverloads
    @NotNull
    public static final DayOfWeek firstDayOfWeekFromLocale(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        DayOfWeek dayOfWeek = WeekFields.of(locale).getFirstDayOfWeek();
        Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"getFirstDayOfWeek(...)");
        return dayOfWeek;
    }

    public static /* synthetic */ DayOfWeek firstDayOfWeekFromLocale$default(Locale locale, int n, Object object) {
        if ((n & 1) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            locale = locale2;
        }
        return ExtensionsKt.firstDayOfWeekFromLocale(locale);
    }

    @NotNull
    public static final LocalDate atStartOfMonth(@NotNull YearMonth $this$atStartOfMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$atStartOfMonth, (String)"<this>");
        LocalDate localDate = $this$atStartOfMonth.atDay(1);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"atDay(...)");
        return localDate;
    }

    @NotNull
    public static final YearMonth getYearMonth(@NotNull LocalDate $this$yearMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$yearMonth, (String)"<this>");
        YearMonth yearMonth = YearMonth.of($this$yearMonth.getYear(), $this$yearMonth.getMonth());
        Intrinsics.checkNotNullExpressionValue((Object)yearMonth, (String)"of(...)");
        return yearMonth;
    }

    @NotNull
    public static final YearMonth getNextMonth(@NotNull YearMonth $this$nextMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$nextMonth, (String)"<this>");
        YearMonth yearMonth = $this$nextMonth.plusMonths(1L);
        Intrinsics.checkNotNullExpressionValue((Object)yearMonth, (String)"plusMonths(...)");
        return yearMonth;
    }

    @NotNull
    public static final YearMonth getPreviousMonth(@NotNull YearMonth $this$previousMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$previousMonth, (String)"<this>");
        YearMonth yearMonth = $this$previousMonth.minusMonths(1L);
        Intrinsics.checkNotNullExpressionValue((Object)yearMonth, (String)"minusMonths(...)");
        return yearMonth;
    }

    @JvmOverloads
    @NotNull
    public static final List<DayOfWeek> daysOfWeek() {
        return ExtensionsKt.daysOfWeek$default(null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public static final DayOfWeek firstDayOfWeekFromLocale() {
        return ExtensionsKt.firstDayOfWeekFromLocale$default(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<DayOfWeek> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])DayOfWeek.values());
        }
    }
}

