/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendar.core;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.WeekFields;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\r\u001a\u00020\fH\u0007\u001a\u0006\u0010\u000e\u001a\u00020\f\u001a\n\u0010\u000f\u001a\u00020\u0007*\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\"\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"nextMonth", "Ljava/time/YearMonth;", "getNextMonth", "(Ljava/time/YearMonth;)Ljava/time/YearMonth;", "previousMonth", "getPreviousMonth", "yearMonth", "Ljava/time/LocalDate;", "getYearMonth", "(Ljava/time/LocalDate;)Ljava/time/YearMonth;", "daysOfWeek", "", "Ljava/time/DayOfWeek;", "firstDayOfWeek", "firstDayOfWeekFromLocale", "atStartOfMonth", "core"})
public final class ExtensionsKt {
    @JvmOverloads
    @NotNull
    public static final List<DayOfWeek> daysOfWeek(@NotNull DayOfWeek firstDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        int pivot = 7 - firstDayOfWeek.ordinal();
        EnumEntries<DayOfWeek> daysOfWeek = EntriesMappings.entries$0;
        return CollectionsKt.plus((Collection)CollectionsKt.takeLast((List)((List)daysOfWeek), (int)pivot), (Iterable)CollectionsKt.dropLast((List)((List)daysOfWeek), (int)pivot));
    }

    public static /* synthetic */ List daysOfWeek$default(DayOfWeek dayOfWeek, int n, Object object) {
        if ((n & 1) != 0) {
            dayOfWeek = ExtensionsKt.firstDayOfWeekFromLocale();
        }
        return ExtensionsKt.daysOfWeek(dayOfWeek);
    }

    @NotNull
    public static final DayOfWeek firstDayOfWeekFromLocale() {
        DayOfWeek dayOfWeek = WeekFields.of(Locale.getDefault()).getFirstDayOfWeek();
        Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"getFirstDayOfWeek(...)");
        return dayOfWeek;
    }

    @NotNull
    public static final LocalDate atStartOfMonth(@NotNull YearMonth $this$atStartOfMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$atStartOfMonth, (String)"<this>");
        LocalDate localDate = $this$atStartOfMonth.atDay(1);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"atDay(...)");
        return localDate;
    }

    @NotNull
    public static final YearMonth getYearMonth(@NotNull LocalDate $this$yearMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$yearMonth, (String)"<this>");
        YearMonth yearMonth = YearMonth.of($this$yearMonth.getYear(), $this$yearMonth.getMonth());
        Intrinsics.checkNotNullExpressionValue((Object)yearMonth, (String)"of(...)");
        return yearMonth;
    }

    @NotNull
    public static final YearMonth getNextMonth(@NotNull YearMonth $this$nextMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$nextMonth, (String)"<this>");
        YearMonth yearMonth = $this$nextMonth.plusMonths(1L);
        Intrinsics.checkNotNullExpressionValue((Object)yearMonth, (String)"plusMonths(...)");
        return yearMonth;
    }

    @NotNull
    public static final YearMonth getPreviousMonth(@NotNull YearMonth $this$previousMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$previousMonth, (String)"<this>");
        YearMonth yearMonth = $this$previousMonth.minusMonths(1L);
        Intrinsics.checkNotNullExpressionValue((Object)yearMonth, (String)"minusMonths(...)");
        return yearMonth;
    }

    @JvmOverloads
    @NotNull
    public static final List<DayOfWeek> daysOfWeek() {
        return ExtensionsKt.daysOfWeek$default(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<DayOfWeek> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])DayOfWeek.values());
        }
    }
}

