/*
 * Decompiled with CFR 0.152.
 */
package com.kirillr.strictmodehelper;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.StrictMode;
import android.os.strictmode.Violation;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Locale;
import java.util.concurrent.Executor;

public final class StrictModeCompat {
    private static final String TAG = "StrictModeCompat";
    private static final String FEATURE_NOT_SUPPORTED_MSG = "%s:%s is not supported";

    private StrictModeCompat() {
    }

    @NonNull
    public static StrictMode.ThreadPolicy allowThreadDiskReads() {
        return StrictMode.allowThreadDiskReads();
    }

    @NonNull
    public static StrictMode.ThreadPolicy allowThreadDiskWrites() {
        return StrictMode.allowThreadDiskWrites();
    }

    public static void enableDefaults() {
        StrictMode.enableDefaults();
    }

    @NonNull
    public static StrictMode.ThreadPolicy getThreadPolicy() {
        return StrictMode.getThreadPolicy();
    }

    @NonNull
    public static StrictMode.VmPolicy getVmPolicy() {
        return StrictMode.getVmPolicy();
    }

    public static void noteSlowCall(@NonNull String name) {
        StrictMode.noteSlowCall((String)name);
    }

    public static void noteSlowCall(@NonNull String message, Object ... args) {
        StrictMode.noteSlowCall((String)String.format(message, args));
    }

    public static void noteSlowCall(@Nullable Locale locale, @NonNull String message, Object ... args) {
        if (locale == null) {
            StrictMode.noteSlowCall((String)String.format(message, args));
        } else {
            StrictMode.noteSlowCall((String)String.format(locale, message, args));
        }
    }

    public static void setThreadPolicy(@NonNull StrictMode.ThreadPolicy policy) {
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)policy);
    }

    public static void setVmPolicy(@NonNull StrictMode.VmPolicy policy) {
        StrictMode.setVmPolicy((StrictMode.VmPolicy)policy);
    }

    public static void setPolicies(@NonNull StrictMode.ThreadPolicy threadPolicy, @NonNull StrictMode.VmPolicy vmPolicy) {
        StrictModeCompat.setThreadPolicy(threadPolicy);
        StrictModeCompat.setVmPolicy(vmPolicy);
    }

    private static void logUnsupportedFeature(@NonNull String category, @NonNull String feature) {
        Log.d((String)TAG, (String)String.format(Locale.US, FEATURE_NOT_SUPPORTED_MSG, category, feature));
    }

    public static interface OnThreadViolationListener {
        @TargetApi(value=26)
        public void onThreadViolation(@NonNull Violation var1);
    }

    public static interface OnVmViolationListener {
        @TargetApi(value=26)
        public void onVmViolation(@NonNull Violation var1);
    }

    public static final class VmPolicy {
        private VmPolicy() {
        }

        @TargetApi(value=10000)
        private static class V29BuilderImpl
        extends V26BuilderImpl {
            V29BuilderImpl() {
            }

            V29BuilderImpl(@NonNull StrictMode.VmPolicy policy) {
                super(policy);
            }

            @Override
            public void detectImplicitDirectBoot() {
                this.builder.detectImplicitDirectBoot();
            }

            @Override
            public void detectCredentialProtectedWhileLocked() {
                this.builder.detectCredentialProtectedWhileLocked();
            }
        }

        @TargetApi(value=28)
        private static class V28BuilderImpl
        extends V26BuilderImpl {
            V28BuilderImpl() {
            }

            V28BuilderImpl(@NonNull StrictMode.VmPolicy policy) {
                super(policy);
            }

            @Override
            public void detectNonSdkApiUsage() {
                this.builder.detectNonSdkApiUsage();
            }

            @Override
            public void permitNonSdkApiUsage() {
                this.builder.permitNonSdkApiUsage();
            }

            @Override
            public void penaltyListener(@NonNull Executor executor, final @NonNull OnVmViolationListener listener) {
                this.builder.penaltyListener(executor, new StrictMode.OnVmViolationListener(){

                    @TargetApi(value=26)
                    public void onVmViolation(Violation violation) {
                        listener.onVmViolation(violation);
                    }
                });
            }
        }

        @TargetApi(value=26)
        private static class V26BuilderImpl
        extends V24BuilderImpl {
            V26BuilderImpl() {
            }

            V26BuilderImpl(@NonNull StrictMode.VmPolicy policy) {
                super(policy);
            }

            @Override
            public void detectUntaggedSockets() {
                this.builder.detectUntaggedSockets();
            }

            @Override
            public void detectContentUriWithoutPermission() {
                this.builder.detectContentUriWithoutPermission();
            }
        }

        @TargetApi(value=24)
        private static class V24BuilderImpl
        extends V23BuilderImpl {
            V24BuilderImpl() {
            }

            V24BuilderImpl(@NonNull StrictMode.VmPolicy policy) {
                super(policy);
            }

            @Override
            public void penaltyDeathOnFileUriExposure() {
                this.builder.penaltyDeathOnFileUriExposure();
            }
        }

        @TargetApi(value=23)
        private static class V23BuilderImpl
        extends V18BuilderImpl {
            V23BuilderImpl() {
            }

            V23BuilderImpl(@NonNull StrictMode.VmPolicy policy) {
                super(policy);
            }

            @Override
            public void detectCleartextNetwork() {
                this.builder.detectCleartextNetwork();
            }

            @Override
            public void penaltyDeathOnCleartextNetwork() {
                this.builder.penaltyDeathOnCleartextNetwork();
            }
        }

        @TargetApi(value=18)
        private static class V18BuilderImpl
        extends V16BuilderImpl {
            V18BuilderImpl() {
            }

            V18BuilderImpl(@NonNull StrictMode.VmPolicy policy) {
                super(policy);
            }

            @Override
            public void detectFileUriExposure() {
                this.builder.detectFileUriExposure();
            }
        }

        @TargetApi(value=16)
        private static class V16BuilderImpl
        extends BaseBuilderImpl {
            V16BuilderImpl() {
            }

            V16BuilderImpl(@NonNull StrictMode.VmPolicy policy) {
                super(policy);
            }

            @Override
            public void detectLeakedRegistrationObjects() {
                this.builder.detectLeakedRegistrationObjects();
            }
        }

        private static class BaseBuilderImpl
        implements BuilderImpl {
            @NonNull
            final StrictMode.VmPolicy.Builder builder;

            BaseBuilderImpl() {
                this.builder = new StrictMode.VmPolicy.Builder();
            }

            BaseBuilderImpl(@NonNull StrictMode.VmPolicy policy) {
                this.builder = new StrictMode.VmPolicy.Builder(policy);
            }

            @Override
            public StrictMode.VmPolicy build() {
                return this.builder.build();
            }

            @Override
            public void detectAll() {
                this.builder.detectAll();
            }

            @Override
            public void detectCleartextNetwork() {
                StrictModeCompat.logUnsupportedFeature("VmPolicy", "Cleartext network");
            }

            @Override
            public void detectFileUriExposure() {
                StrictModeCompat.logUnsupportedFeature("VmPolicy", "File uri exposure");
            }

            @Override
            public void detectLeakedSqlLiteObjects() {
                this.builder.detectLeakedSqlLiteObjects();
            }

            @Override
            public void detectLeakedRegistrationObjects() {
                StrictModeCompat.logUnsupportedFeature("VmPolicy", "Leaked registration objects");
            }

            @Override
            public void penaltyDeath() {
                this.builder.penaltyDeath();
            }

            @Override
            public void penaltyDeathOnCleartextNetwork() {
                StrictModeCompat.logUnsupportedFeature("VmPolicy", "Cleartext network");
            }

            @Override
            public void penaltyDeathOnFileUriExposure() {
                StrictModeCompat.logUnsupportedFeature("VmPolicy", "Penalty death on file uri exposure");
            }

            @Override
            public void penaltyDropBox() {
                this.builder.penaltyDropBox();
            }

            @Override
            public void penaltyLog() {
                this.builder.penaltyLog();
            }

            @Override
            public void detectActivityLeaks() {
                this.builder.detectActivityLeaks();
            }

            @Override
            public void detectLeakedClosableObjects() {
                this.builder.detectLeakedClosableObjects();
            }

            @Override
            public void setClassInstanceLimit(@NonNull Class<?> klass, @IntRange(from=0L) int instanceLimit) {
                this.builder.setClassInstanceLimit(klass, instanceLimit);
            }

            @Override
            public void detectContentUriWithoutPermission() {
                StrictModeCompat.logUnsupportedFeature("VmPolicy", "Content uri without permission");
            }

            @Override
            public void detectUntaggedSockets() {
                StrictModeCompat.logUnsupportedFeature("VmPolicy", "Untagged sockets");
            }

            @Override
            public void detectNonSdkApiUsage() {
                StrictModeCompat.logUnsupportedFeature("VmPolicy", "Non SDK api usage");
            }

            @Override
            public void penaltyListener(@NonNull Executor executor, @NonNull OnVmViolationListener listener) {
                StrictModeCompat.logUnsupportedFeature("VmPolicy", "Penalty listener");
            }

            @Override
            public void permitNonSdkApiUsage() {
                StrictModeCompat.logUnsupportedFeature("VmPolicy", "Non SDK api usage");
            }

            @Override
            public void detectImplicitDirectBoot() {
                StrictModeCompat.logUnsupportedFeature("VmPolicy", "Implicit Direct Boot");
            }

            @Override
            public void detectCredentialProtectedWhileLocked() {
                StrictModeCompat.logUnsupportedFeature("VmPolicy", "Credential Protected While Locked");
            }
        }

        private static interface BuilderImpl {
            public static final String CATEGORY = "VmPolicy";

            public StrictMode.VmPolicy build();

            public void detectActivityLeaks();

            public void detectAll();

            public void detectCleartextNetwork();

            public void detectFileUriExposure();

            public void detectLeakedClosableObjects();

            public void detectLeakedRegistrationObjects();

            public void detectLeakedSqlLiteObjects();

            public void penaltyDeath();

            public void penaltyDeathOnCleartextNetwork();

            public void penaltyDeathOnFileUriExposure();

            public void penaltyDropBox();

            public void penaltyLog();

            public void setClassInstanceLimit(@NonNull Class<?> var1, @IntRange(from=0L) int var2);

            public void detectContentUriWithoutPermission();

            public void detectUntaggedSockets();

            public void detectNonSdkApiUsage();

            public void penaltyListener(@NonNull Executor var1, @NonNull OnVmViolationListener var2);

            public void permitNonSdkApiUsage();

            public void detectImplicitDirectBoot();

            public void detectCredentialProtectedWhileLocked();
        }

        public static final class Builder {
            @NonNull
            private final BuilderImpl mBuilder;

            public Builder() {
                this.mBuilder = Build.VERSION.SDK_INT >= 10000 ? new V29BuilderImpl() : (Build.VERSION.SDK_INT >= 28 ? new V28BuilderImpl() : (Build.VERSION.SDK_INT >= 26 ? new V26BuilderImpl() : (Build.VERSION.SDK_INT >= 24 ? new V24BuilderImpl() : (Build.VERSION.SDK_INT >= 23 ? new V23BuilderImpl() : (Build.VERSION.SDK_INT >= 18 ? new V18BuilderImpl() : (Build.VERSION.SDK_INT >= 16 ? new V16BuilderImpl() : new BaseBuilderImpl()))))));
            }

            public Builder(@NonNull StrictMode.VmPolicy policy) {
                this.mBuilder = Build.VERSION.SDK_INT >= 10000 ? new V28BuilderImpl(policy) : (Build.VERSION.SDK_INT >= 28 ? new V28BuilderImpl(policy) : (Build.VERSION.SDK_INT >= 26 ? new V26BuilderImpl(policy) : (Build.VERSION.SDK_INT >= 24 ? new V24BuilderImpl(policy) : (Build.VERSION.SDK_INT >= 23 ? new V23BuilderImpl(policy) : (Build.VERSION.SDK_INT >= 18 ? new V18BuilderImpl(policy) : (Build.VERSION.SDK_INT >= 16 ? new V16BuilderImpl(policy) : new BaseBuilderImpl(policy)))))));
            }

            public StrictMode.VmPolicy build() {
                return this.mBuilder.build();
            }

            public Builder detectActivityLeaks() {
                this.mBuilder.detectActivityLeaks();
                return this;
            }

            public Builder detectAll() {
                this.mBuilder.detectAll();
                return this;
            }

            public Builder detectCleartextNetwork() {
                this.mBuilder.detectCleartextNetwork();
                return this;
            }

            public Builder detectFileUriExposure() {
                this.mBuilder.detectFileUriExposure();
                return this;
            }

            public Builder detectLeakedClosableObjects() {
                this.mBuilder.detectLeakedClosableObjects();
                return this;
            }

            public Builder detectLeakedRegistrationObjects() {
                this.mBuilder.detectLeakedRegistrationObjects();
                return this;
            }

            public Builder detectLeakedSqlLiteObjects() {
                this.mBuilder.detectLeakedSqlLiteObjects();
                return this;
            }

            public Builder penaltyDeath() {
                this.mBuilder.penaltyDeath();
                return this;
            }

            public Builder penaltyDeathOnCleartextNetwork() {
                this.mBuilder.penaltyDeathOnCleartextNetwork();
                return this;
            }

            public Builder penaltyDeathOnFileUriExposure() {
                this.mBuilder.penaltyDeathOnFileUriExposure();
                return this;
            }

            public Builder penaltyDropBox() {
                this.mBuilder.penaltyDropBox();
                return this;
            }

            public Builder penaltyLog() {
                this.mBuilder.penaltyLog();
                return this;
            }

            public Builder setClassInstanceLimit(@NonNull Class<?> klass, @IntRange(from=0L) int instanceLimit) {
                this.mBuilder.setClassInstanceLimit(klass, instanceLimit);
                return this;
            }

            public Builder detectContentUriWithoutPermission() {
                this.mBuilder.detectContentUriWithoutPermission();
                return this;
            }

            public Builder detectUntaggedSockets() {
                this.mBuilder.detectUntaggedSockets();
                return this;
            }

            public Builder detectNonSdkApiUsage() {
                this.mBuilder.detectNonSdkApiUsage();
                return this;
            }

            public Builder penaltyListener(@NonNull Executor executor, @NonNull OnVmViolationListener listener) {
                this.mBuilder.penaltyListener(executor, listener);
                return this;
            }

            public Builder permitNonSdkApiUsage() {
                this.mBuilder.permitNonSdkApiUsage();
                return this;
            }

            public Builder detectImplicitDirectBoot() {
                this.mBuilder.detectImplicitDirectBoot();
                return this;
            }

            public Builder detectCredentialProtectedWhileLocked() {
                this.mBuilder.detectCredentialProtectedWhileLocked();
                return this;
            }
        }
    }

    public static final class ThreadPolicy {
        private ThreadPolicy() {
        }

        @TargetApi(value=28)
        private static class V28BuilderImpl
        extends V26BuilderImpl {
            V28BuilderImpl() {
            }

            V28BuilderImpl(@NonNull StrictMode.ThreadPolicy policy) {
                super(policy);
            }

            @Override
            public void penaltyListener(@NonNull Executor executor, final @NonNull OnThreadViolationListener listener) {
                this.builder.penaltyListener(executor, new StrictMode.OnThreadViolationListener(){

                    @TargetApi(value=26)
                    public void onThreadViolation(@NonNull Violation violation) {
                        listener.onThreadViolation(violation);
                    }
                });
            }
        }

        @TargetApi(value=26)
        private static class V26BuilderImpl
        extends V23BuilderImpl {
            V26BuilderImpl() {
            }

            V26BuilderImpl(@NonNull StrictMode.ThreadPolicy policy) {
                super(policy);
            }

            @Override
            public void detectUnbufferedIo() {
                this.builder.detectUnbufferedIo();
            }

            @Override
            public void permitUnbufferedIo() {
                this.builder.permitUnbufferedIo();
            }
        }

        @TargetApi(value=23)
        private static class V23BuilderImpl
        extends BaseBuilderImpl {
            V23BuilderImpl() {
            }

            V23BuilderImpl(@NonNull StrictMode.ThreadPolicy policy) {
                super(policy);
            }

            @Override
            public void detectResourceMismatches() {
                this.builder.detectResourceMismatches();
            }

            @Override
            public void permitResourceMismatches() {
                this.builder.permitResourceMismatches();
            }
        }

        private static class BaseBuilderImpl
        implements BuilderImpl {
            @NonNull
            final StrictMode.ThreadPolicy.Builder builder;

            BaseBuilderImpl() {
                this.builder = new StrictMode.ThreadPolicy.Builder();
            }

            BaseBuilderImpl(@NonNull StrictMode.ThreadPolicy policy) {
                this.builder = new StrictMode.ThreadPolicy.Builder(policy);
            }

            @Override
            public void detectCustomSlowCalls() {
                this.builder.detectCustomSlowCalls();
            }

            @Override
            public void penaltyDeathOnNetwork() {
                this.builder.penaltyDeathOnNetwork();
            }

            @Override
            public void penaltyFlashScreen() {
                this.builder.penaltyFlashScreen();
            }

            @Override
            public void permitCustomSlowCalls() {
                this.builder.permitCustomSlowCalls();
            }

            @Override
            public StrictMode.ThreadPolicy build() {
                return this.builder.build();
            }

            @Override
            public void detectAll() {
                this.builder.detectAll();
            }

            @Override
            public void detectDiskReads() {
                this.builder.detectDiskReads();
            }

            @Override
            public void detectDiskWrites() {
                this.builder.detectDiskWrites();
            }

            @Override
            public void detectNetwork() {
                this.builder.detectNetwork();
            }

            @Override
            public void penaltyDeath() {
                this.builder.penaltyDeath();
            }

            @Override
            public void penaltyDialog() {
                this.builder.penaltyDialog();
            }

            @Override
            public void penaltyDropBox() {
                this.builder.penaltyDropBox();
            }

            @Override
            public void penaltyLog() {
                this.builder.penaltyLog();
            }

            @Override
            public void permitAll() {
                this.builder.permitAll();
            }

            @Override
            public void permitDiskReads() {
                this.builder.permitDiskReads();
            }

            @Override
            public void permitDiskWrites() {
                this.builder.permitDiskWrites();
            }

            @Override
            public void permitNetwork() {
                this.builder.permitNetwork();
            }

            @Override
            public void detectResourceMismatches() {
                StrictModeCompat.logUnsupportedFeature("ThreadPolicy", "Resource mismatches");
            }

            @Override
            public void permitResourceMismatches() {
                StrictModeCompat.logUnsupportedFeature("ThreadPolicy", "Resource mismatches");
            }

            @Override
            public void detectUnbufferedIo() {
                StrictModeCompat.logUnsupportedFeature("ThreadPolicy", "Unbuffered IO");
            }

            @Override
            public void permitUnbufferedIo() {
                StrictModeCompat.logUnsupportedFeature("ThreadPolicy", "Unbuffered IO");
            }

            @Override
            public void penaltyListener(@NonNull Executor executor, @NonNull OnThreadViolationListener listener) {
                StrictModeCompat.logUnsupportedFeature("ThreadPolicy", "Penalty listener");
            }
        }

        private static interface BuilderImpl {
            public static final String CATEGORY = "ThreadPolicy";

            public StrictMode.ThreadPolicy build();

            public void detectAll();

            public void detectCustomSlowCalls();

            public void detectDiskReads();

            public void detectDiskWrites();

            public void detectNetwork();

            public void penaltyDeath();

            public void penaltyDeathOnNetwork();

            public void penaltyDialog();

            public void penaltyDropBox();

            public void penaltyFlashScreen();

            public void penaltyLog();

            public void permitAll();

            public void permitCustomSlowCalls();

            public void permitDiskReads();

            public void permitDiskWrites();

            public void permitNetwork();

            public void detectResourceMismatches();

            public void permitResourceMismatches();

            public void detectUnbufferedIo();

            public void permitUnbufferedIo();

            public void penaltyListener(@NonNull Executor var1, @NonNull OnThreadViolationListener var2);
        }

        public static final class Builder {
            @NonNull
            private final BuilderImpl mBuilder;

            public Builder() {
                this.mBuilder = Build.VERSION.SDK_INT >= 28 ? new V28BuilderImpl() : (Build.VERSION.SDK_INT >= 26 ? new V26BuilderImpl() : (Build.VERSION.SDK_INT >= 23 ? new V23BuilderImpl() : new BaseBuilderImpl()));
            }

            public Builder(@NonNull StrictMode.ThreadPolicy policy) {
                this.mBuilder = Build.VERSION.SDK_INT >= 28 ? new V28BuilderImpl(policy) : (Build.VERSION.SDK_INT >= 26 ? new V26BuilderImpl(policy) : (Build.VERSION.SDK_INT >= 23 ? new V23BuilderImpl(policy) : new BaseBuilderImpl(policy)));
            }

            public StrictMode.ThreadPolicy build() {
                return this.mBuilder.build();
            }

            public Builder detectAll() {
                this.mBuilder.detectAll();
                return this;
            }

            public Builder detectCustomSlowCalls() {
                this.mBuilder.detectCustomSlowCalls();
                return this;
            }

            public Builder detectDiskReads() {
                this.mBuilder.detectDiskReads();
                return this;
            }

            public Builder detectDiskWrites() {
                this.mBuilder.detectDiskWrites();
                return this;
            }

            public Builder detectNetwork() {
                this.mBuilder.detectNetwork();
                return this;
            }

            public Builder detectResourceMismatches() {
                this.mBuilder.detectResourceMismatches();
                return this;
            }

            public Builder penaltyDeath() {
                this.mBuilder.penaltyDeath();
                return this;
            }

            public Builder penaltyDeathOnNetwork() {
                this.mBuilder.penaltyDeathOnNetwork();
                return this;
            }

            public Builder penaltyDialog() {
                this.mBuilder.penaltyDialog();
                return this;
            }

            public Builder penaltyDropBox() {
                this.mBuilder.penaltyDropBox();
                return this;
            }

            public Builder penaltyFlashScreen() {
                this.mBuilder.penaltyFlashScreen();
                return this;
            }

            public Builder penaltyLog() {
                this.mBuilder.penaltyLog();
                return this;
            }

            public Builder permitAll() {
                this.mBuilder.permitAll();
                return this;
            }

            public Builder permitCustomSlowCalls() {
                this.mBuilder.permitCustomSlowCalls();
                return this;
            }

            public Builder permitDiskReads() {
                this.mBuilder.permitDiskReads();
                return this;
            }

            public Builder permitDiskWrites() {
                this.mBuilder.permitDiskWrites();
                return this;
            }

            public Builder permitNetwork() {
                this.mBuilder.permitNetwork();
                return this;
            }

            public Builder permitResourceMismatches() {
                this.mBuilder.permitResourceMismatches();
                return this;
            }

            public Builder detectUnbufferedIo() {
                this.mBuilder.detectUnbufferedIo();
                return this;
            }

            public Builder permitUnbufferedIo() {
                this.mBuilder.permitUnbufferedIo();
                return this;
            }

            public Builder penaltyListener(@NonNull Executor executor, @NonNull OnThreadViolationListener listener) {
                this.mBuilder.penaltyListener(executor, listener);
                return this;
            }
        }
    }
}

