/*
 * Decompiled with CFR 0.152.
 */
package com.kirgor.enklib.compile;

import com.kirgor.enklib.compile.MemoryJavaFileManager;
import com.kirgor.enklib.compile.MemoryJavaFileObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileUtils {
    public static Class compileClass(String name, String code, List<Class> classPath) throws Exception {
        Boolean success;
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        MemoryJavaFileManager fileManager = new MemoryJavaFileManager(compiler.getStandardFileManager(null, null, null));
        ArrayList<MemoryJavaFileObject> javaFileObjects = new ArrayList<MemoryJavaFileObject>();
        javaFileObjects.add(new MemoryJavaFileObject(name, code));
        File tempDir = new File(System.getProperty("java.io.tmpdir"), name);
        ArrayList<String> options = new ArrayList<String>();
        if (classPath.size() > 0) {
            options.add("-classpath");
            options.add(tempDir.getAbsolutePath());
            for (Class c : classPath) {
                String classRelativePath = c.getName().replace('.', '/') + ".class";
                URL classInputLocation = c.getResource('/' + classRelativePath);
                File outputFile = new File(tempDir, classRelativePath);
                outputFile.getParentFile().mkdirs();
                InputStream input = classInputLocation.openStream();
                FileOutputStream output = new FileOutputStream(outputFile);
                IOUtils.copy((InputStream)input, (OutputStream)output);
                input.close();
                output.close();
            }
        }
        if ((success = compiler.getTask(null, fileManager, diagnostics, options, null, javaFileObjects).call()).booleanValue()) {
            return fileManager.getClassLoader(null).loadClass(name);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
            stringBuilder.append(diagnostic.getMessage(null)).append("\n");
        }
        throw new Exception(stringBuilder.toString());
    }
}

