/*
 * Decompiled with CFR 0.152.
 */
package easyfilepickerdialog.kingfisher.com.library.view;

import android.content.Context;
import easyfilepickerdialog.kingfisher.com.library.view.FilePickerDialogFragment;
import java.lang.ref.WeakReference;
import permissions.dispatcher.GrantableRequest;
import permissions.dispatcher.PermissionUtils;

final class FilePickerDialogFragmentPermissionsDispatcher {
    private static final int REQUEST_LOADFOLDER = 0;
    private static final String[] PERMISSION_LOADFOLDER = new String[]{"android.permission.READ_EXTERNAL_STORAGE"};
    private static GrantableRequest PENDING_LOADFOLDER;

    private FilePickerDialogFragmentPermissionsDispatcher() {
    }

    static void loadFolderWithCheck(FilePickerDialogFragment target, String path) {
        if (PermissionUtils.hasSelfPermissions((Context)target.getActivity(), (String[])PERMISSION_LOADFOLDER)) {
            target.loadFolder(path);
        } else {
            PENDING_LOADFOLDER = new LoadFolderPermissionRequest(target, path);
            target.requestPermissions(PERMISSION_LOADFOLDER, 0);
        }
    }

    static void onRequestPermissionsResult(FilePickerDialogFragment target, int requestCode, int[] grantResults) {
        switch (requestCode) {
            case 0: {
                if (PermissionUtils.verifyPermissions((int[])grantResults)) {
                    if (PENDING_LOADFOLDER != null) {
                        PENDING_LOADFOLDER.grant();
                    }
                } else {
                    target.onPermissionDenied();
                }
                PENDING_LOADFOLDER = null;
                break;
            }
        }
    }

    private static final class LoadFolderPermissionRequest
    implements GrantableRequest {
        private final WeakReference<FilePickerDialogFragment> weakTarget;
        private final String path;

        private LoadFolderPermissionRequest(FilePickerDialogFragment target, String path) {
            this.weakTarget = new WeakReference<FilePickerDialogFragment>(target);
            this.path = path;
        }

        public void proceed() {
            FilePickerDialogFragment target = (FilePickerDialogFragment)this.weakTarget.get();
            if (target == null) {
                return;
            }
            target.requestPermissions(PERMISSION_LOADFOLDER, 0);
        }

        public void cancel() {
            FilePickerDialogFragment target = (FilePickerDialogFragment)this.weakTarget.get();
            if (target == null) {
                return;
            }
            target.onPermissionDenied();
        }

        public void grant() {
            FilePickerDialogFragment target = (FilePickerDialogFragment)this.weakTarget.get();
            if (target == null) {
                return;
            }
            target.loadFolder(this.path);
        }
    }
}

