/*
 * Decompiled with CFR 0.152.
 */
package easyfilepickerdialog.kingfisher.com.library.view;

import android.content.Context;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.TextView;
import android.widget.Toast;
import easyfilepickerdialog.kingfisher.com.library.R;
import easyfilepickerdialog.kingfisher.com.library.adapter.BaseViewHolder;
import easyfilepickerdialog.kingfisher.com.library.adapter.FileAdapter;
import easyfilepickerdialog.kingfisher.com.library.model.DialogConfig;
import easyfilepickerdialog.kingfisher.com.library.presenter.FilePickerPresenter;
import easyfilepickerdialog.kingfisher.com.library.view.BaseNoFrameDialogFragment;
import easyfilepickerdialog.kingfisher.com.library.view.FilePickerDialogFragmentPermissionsDispatcher;
import easyfilepickerdialog.kingfisher.com.library.view.FilePickerView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import permissions.dispatcher.NeedsPermission;
import permissions.dispatcher.OnPermissionDenied;
import permissions.dispatcher.RuntimePermissions;

@RuntimePermissions
public class FilePickerDialogFragment
extends BaseNoFrameDialogFragment
implements FilePickerView,
BaseViewHolder.OnViewHolderClickListener,
View.OnClickListener {
    private static final String TAG = "FilePickerDialog";
    RecyclerView recyclerview;
    TextView tvTitle;
    Toolbar toolbar;
    FileAdapter fileAdapter;
    FilePickerPresenter filePickerPresenter;
    OnFilesSelectedListener onFilesSelectedListener;
    DialogConfig dialogConfig;

    private static FilePickerDialogFragment newInstance(Builder builder) {
        FilePickerDialogFragment filePickerDialogFragment = new FilePickerDialogFragment();
        filePickerDialogFragment.onFilesSelectedListener = builder.onFilesSelectedListener;
        filePickerDialogFragment.dialogConfig = builder.dialogConfig;
        return filePickerDialogFragment;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.dialog_audio_picker, container, false);
        this.recyclerview = (RecyclerView)view.findViewById(R.id.recyclerview);
        this.tvTitle = (TextView)view.findViewById(R.id.tvTitle);
        Toolbar toolbar = (Toolbar)view.findViewById(R.id.toolbar);
        if (this.fileAdapter == null) {
            this.fileAdapter = new FileAdapter(new ArrayList<File>(), this.dialogConfig, this);
        }
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext(), 1, false);
        this.recyclerview.setHasFixedSize(true);
        this.recyclerview.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.recyclerview.setAdapter((RecyclerView.Adapter)this.fileAdapter);
        toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FilePickerDialogFragment.this.dismiss();
            }
        });
        view.findViewById(R.id.btnDone).setOnClickListener((View.OnClickListener)this);
        this.setRetainInstance(true);
        if (this.filePickerPresenter == null) {
            this.filePickerPresenter = new FilePickerPresenter(this);
            this.filePickerPresenter.setDialogConfig(this.dialogConfig);
            String initPath = null;
            initPath = this.dialogConfig != null && !TextUtils.isEmpty((CharSequence)this.dialogConfig.getInitialDirectory()) ? this.dialogConfig.getInitialDirectory() : Environment.getExternalStorageDirectory().getAbsolutePath();
            FilePickerDialogFragmentPermissionsDispatcher.loadFolderWithCheck(this, initPath);
        }
        return view;
    }

    @NeedsPermission(value={"android.permission.READ_EXTERNAL_STORAGE"})
    void loadFolder(String path) {
        this.filePickerPresenter.loadFolder(path);
    }

    @OnPermissionDenied(value={"android.permission.READ_EXTERNAL_STORAGE"})
    void onPermissionDenied() {
        Toast.makeText((Context)this.getContext(), (CharSequence)"Cannot load sdcard if you do not accept the required permission!", (int)0).show();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        FilePickerDialogFragmentPermissionsDispatcher.onRequestPermissionsResult(this, requestCode, grantResults);
    }

    @Override
    public void showFolderContent(String path, List<File> files) {
        this.fileAdapter.clear();
        this.fileAdapter.addItem(files);
        this.fileAdapter.clearCheckedList();
        this.tvTitle.setText((CharSequence)path);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnDone) {
            if (this.onFilesSelectedListener != null) {
                this.onFilesSelectedListener.onFileSelected(this.fileAdapter.getCheckedFiles());
            }
            this.dismiss();
        }
    }

    @Override
    public void onItemClick(int position) {
        if (position == 0) {
            this.filePickerPresenter.loadUpFolder();
        } else {
            FilePickerDialogFragmentPermissionsDispatcher.loadFolderWithCheck(this, ((File)this.fileAdapter.getItem(position)).getAbsolutePath());
        }
    }

    @Override
    void setupDialogPosition() {
        WindowManager.LayoutParams p = this.getDialog().getWindow().getAttributes();
        p.width = -1;
        p.height = -1;
        this.getDialog().getWindow().setAttributes(p);
    }

    public static final class Builder {
        private OnFilesSelectedListener onFilesSelectedListener;
        private DialogConfig dialogConfig;

        public Builder onFilesSelected(OnFilesSelectedListener onFilesSelectedListener) {
            this.onFilesSelectedListener = onFilesSelectedListener;
            return this;
        }

        public Builder configs(DialogConfig dialogConfig) {
            this.dialogConfig = dialogConfig;
            return this;
        }

        public FilePickerDialogFragment build() {
            return FilePickerDialogFragment.newInstance(this);
        }
    }

    public static interface OnFilesSelectedListener {
        public void onFileSelected(List<File> var1);
    }
}

