/*
 * Decompiled with CFR 0.152.
 */
package easyfilepickerdialog.kingfisher.com.library.presenter;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import easyfilepickerdialog.kingfisher.com.library.model.DialogConfig;
import easyfilepickerdialog.kingfisher.com.library.model.SupportFile;
import easyfilepickerdialog.kingfisher.com.library.view.FilePickerView;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class FilePickerPresenter {
    private FilePickerView dialogAudioPickerView;
    private String folderPath;
    private DialogConfig dialogConfig;

    public FilePickerPresenter(FilePickerView dialogAudioPickerView) {
        this.dialogAudioPickerView = dialogAudioPickerView;
    }

    public void setDialogConfig(DialogConfig dialogConfig) {
        this.dialogConfig = dialogConfig;
    }

    public void loadFolder(String folderPath) {
        File file = new File(folderPath);
        if (file.exists() && file.isDirectory()) {
            this.folderPath = folderPath;
            ArrayList<File> list = new ArrayList<File>();
            for (File fileInFolder : file.listFiles()) {
                if (!fileInFolder.isDirectory() && !this.isFileInFilterList(fileInFolder)) continue;
                list.add(fileInFolder);
            }
            Collections.sort(list, new Comparator<File>(){

                @Override
                public int compare(File file, File t1) {
                    if (file.isDirectory() && !t1.isDirectory()) {
                        return -1;
                    }
                    if (!file.isDirectory() && t1.isDirectory()) {
                        return 1;
                    }
                    return file.getName().compareTo(t1.getName());
                }
            });
            list.add(0, new File("Up"));
            this.dialogAudioPickerView.showFolderContent(folderPath, list);
        }
    }

    public void loadUpFolder() {
        File file;
        if (this.folderPath != null && (file = new File(this.folderPath)).exists() && file.getParentFile() != null) {
            this.loadFolder(file.getParentFile().getAbsolutePath());
        }
    }

    private boolean isFileInFilterList(File file) {
        if (this.dialogConfig == null || this.dialogConfig.getSupportFiles() == null || this.dialogConfig.getSupportFiles().isEmpty()) {
            return true;
        }
        String ext = FilePickerPresenter.getExtension(file);
        if (!TextUtils.isEmpty((CharSequence)ext)) {
            for (SupportFile supportFile : this.dialogConfig.getSupportFiles()) {
                if (!supportFile.getExt().equals(ext)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getExtension(@NonNull File file) {
        String path = file.getPath();
        int i = path.lastIndexOf(".");
        if (i < 0) {
            return null;
        }
        return path.substring(i);
    }
}

