/*
 * Decompiled with CFR 0.152.
 */
package easyfilepickerdialog.kingfisher.com.library.model;

import easyfilepickerdialog.kingfisher.com.library.model.SupportFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DialogConfig {
    public static final boolean DEFAULT_DISABLE_MULTIPLE_FILE_SELECT = false;
    public static final boolean DEFAULT_DISABLE_FOLDER_SELECT = false;
    private List<SupportFile> supportFiles;
    private boolean enableMultipleSelect = false;
    private boolean enableFolderSelect = false;
    private String initialDirectory;

    public List<SupportFile> getSupportFiles() {
        return this.supportFiles;
    }

    public boolean isEnableMultipleSelect() {
        return this.enableMultipleSelect;
    }

    public boolean isEnableFolderSelect() {
        return this.enableFolderSelect;
    }

    public String getInitialDirectory() {
        return this.initialDirectory;
    }

    private DialogConfig(Builder builder) {
        this.supportFiles = builder.supportFiles;
        this.enableMultipleSelect = builder.multipleSelect;
        this.enableFolderSelect = builder.folderSelect;
        this.initialDirectory = builder.initDirectory;
    }

    public static final class Builder {
        private List<SupportFile> supportFiles;
        private boolean multipleSelect;
        private boolean folderSelect;
        private String initDirectory;

        public Builder supportFiles(List<SupportFile> supportFiles) {
            if (this.supportFiles == null) {
                this.supportFiles = new ArrayList<SupportFile>();
            }
            this.supportFiles.addAll(supportFiles);
            return this;
        }

        public Builder supportFiles(SupportFile ... supportFiles) {
            if (this.supportFiles == null) {
                this.supportFiles = new ArrayList<SupportFile>();
            }
            Collections.addAll(this.supportFiles, supportFiles);
            return this;
        }

        public Builder enableMultipleSelect(boolean multipleSelect) {
            this.multipleSelect = multipleSelect;
            return this;
        }

        public Builder enableFolderSelect(boolean enableFolderSelect) {
            this.folderSelect = enableFolderSelect;
            return this;
        }

        public Builder initialDirectory(String initDirectory) {
            this.initDirectory = initDirectory;
            return this;
        }

        public DialogConfig build() {
            return new DialogConfig(this);
        }
    }
}

