/*
 * Decompiled with CFR 0.152.
 */
package easyfilepickerdialog.kingfisher.com.library.adapter;

import android.text.TextUtils;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;
import easyfilepickerdialog.kingfisher.com.library.R;
import easyfilepickerdialog.kingfisher.com.library.adapter.BaseRecyclerArrayAdapter;
import easyfilepickerdialog.kingfisher.com.library.adapter.BaseViewHolder;
import easyfilepickerdialog.kingfisher.com.library.model.DialogConfig;
import easyfilepickerdialog.kingfisher.com.library.model.SupportFile;
import easyfilepickerdialog.kingfisher.com.library.presenter.FilePickerPresenter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FileAdapter
extends BaseRecyclerArrayAdapter<File> {
    private BaseViewHolder.OnViewHolderClickListener onViewHolderClickListener;
    private List<Integer> checkedPositions = new ArrayList<Integer>();
    private DialogConfig dialogConfig;
    private HashMap<String, Integer> mapFileIcons;

    public FileAdapter(List<File> list, DialogConfig dialogConfig, BaseViewHolder.OnViewHolderClickListener onViewHolderClickListener) {
        super(list, R.layout.item_file_picker);
        this.onViewHolderClickListener = onViewHolderClickListener;
        this.dialogConfig = dialogConfig;
        if (dialogConfig != null && dialogConfig.getSupportFiles() != null && !dialogConfig.getSupportFiles().isEmpty()) {
            this.mapFileIcons = new HashMap();
            for (SupportFile supportFile : dialogConfig.getSupportFiles()) {
                this.mapFileIcons.put(supportFile.getExt(), supportFile.getResId());
            }
        }
    }

    private int getIconResource(File file) {
        if (this.mapFileIcons != null) {
            String ext = FilePickerPresenter.getExtension(file);
            return !TextUtils.isEmpty((CharSequence)ext) ? this.mapFileIcons.get(ext) : 0;
        }
        return 0;
    }

    private boolean isMultipleSelectEnable() {
        return this.dialogConfig != null ? this.dialogConfig.isEnableMultipleSelect() : false;
    }

    private boolean isFolderSelectEnable() {
        return this.dialogConfig != null ? this.dialogConfig.isEnableFolderSelect() : false;
    }

    @Override
    public BaseViewHolder<File> getViewHolder(View view) {
        return new ViewHolder(view, this.onViewHolderClickListener);
    }

    public List<File> getCheckedFiles() {
        ArrayList<File> list = new ArrayList<File>();
        for (Integer integer : this.checkedPositions) {
            list.add((File)this.getItem(integer));
        }
        return list;
    }

    public void clearCheckedList() {
        this.checkedPositions.clear();
    }

    class ViewHolder
    extends BaseViewHolder<File> {
        TextView tvName;
        ImageView imageView;
        CheckBox checkBox;
        boolean isBinding;

        public ViewHolder(View itemView, BaseViewHolder.OnViewHolderClickListener onViewHolderClickListener) {
            super(itemView, onViewHolderClickListener);
            this.isBinding = false;
            this.tvName = (TextView)itemView.findViewById(R.id.tvName);
            this.imageView = (ImageView)itemView.findViewById(R.id.ivImage);
            this.checkBox = (CheckBox)itemView.findViewById(R.id.checkbox);
        }

        @Override
        public void setData(File data, final int pos) {
            this.isBinding = true;
            if (pos == 0) {
                this.tvName.setText((CharSequence)"Up...");
            } else {
                this.tvName.setText((CharSequence)data.getName());
            }
            if (data.isDirectory() || pos == 0) {
                this.imageView.setBackgroundResource(R.drawable.ic_folder);
            } else {
                this.checkBox.setVisibility(0);
                int resource = FileAdapter.this.getIconResource(data);
                if (resource == 0) {
                    resource = R.drawable.ic_file;
                }
                this.imageView.setBackgroundResource(resource);
            }
            if (FileAdapter.this.isFolderSelectEnable()) {
                this.checkBox.setVisibility(pos != 0 ? 0 : 8);
            } else {
                this.checkBox.setVisibility(pos != 0 && !data.isDirectory() ? 0 : 8);
            }
            this.checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton compoundButton, boolean isChecked) {
                    if (isChecked) {
                        if (!FileAdapter.this.isMultipleSelectEnable()) {
                            FileAdapter.this.checkedPositions.clear();
                            if (!ViewHolder.this.isBinding) {
                                FileAdapter.this.notifyDataSetChanged();
                            }
                        }
                        if (!FileAdapter.this.checkedPositions.contains(pos)) {
                            FileAdapter.this.checkedPositions.add(pos);
                        }
                    } else {
                        FileAdapter.this.checkedPositions.remove((Object)pos);
                    }
                }
            });
            this.checkBox.setChecked(FileAdapter.this.checkedPositions.contains(pos));
            this.isBinding = false;
        }
    }
}

